/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.paimon.spark.SparkTypeUtils;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;
import org.apache.spark.sql.types.StructType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class SparkTypeTest {
    public static final RowType ALL_TYPES = RowType.builder((boolean)true, (AtomicInteger)new AtomicInteger(1)).field("id", DataTypes.INT().notNull()).field("name", (DataType)DataTypes.STRING()).field("salary", DataTypes.DOUBLE().notNull()).field("locations", (DataType)DataTypes.MAP((DataType)DataTypes.STRING().notNull(), (DataType)DataTypes.ROW((DataField[])new DataField[]{DataTypes.FIELD((int)0, (String)"posX", (DataType)DataTypes.DOUBLE().notNull(), (String)"X field"), DataTypes.FIELD((int)1, (String)"posY", (DataType)DataTypes.DOUBLE().notNull(), (String)"Y field")}))).field("strArray", DataTypes.ARRAY((DataType)DataTypes.STRING()).nullable()).field("intArray", DataTypes.ARRAY((DataType)DataTypes.INT()).nullable()).field("boolean", DataTypes.BOOLEAN().nullable()).field("tinyint", (DataType)DataTypes.TINYINT()).field("smallint", (DataType)DataTypes.SMALLINT()).field("bigint", (DataType)DataTypes.BIGINT()).field("bytes", (DataType)DataTypes.BYTES()).field("timestamp", (DataType)DataTypes.TIMESTAMP()).field("date", (DataType)DataTypes.DATE()).field("decimal", (DataType)DataTypes.DECIMAL((int)2, (int)2)).field("decimal2", (DataType)DataTypes.DECIMAL((int)38, (int)2)).field("decimal3", (DataType)DataTypes.DECIMAL((int)10, (int)1)).build();

    @Test
    public void testAllTypes() {
        String nestedRowMapType = "StructField(locations,MapType(StringType,StructType(StructField(posX,DoubleType,true),StructField(posY,DoubleType,true)),true),true)";
        String expected = "StructType(StructField(id,IntegerType,true),StructField(name,StringType,true),StructField(salary,DoubleType,true)," + nestedRowMapType + ",StructField(strArray,ArrayType(StringType,true),true),StructField(intArray,ArrayType(IntegerType,true),true),StructField(boolean,BooleanType,true),StructField(tinyint,ByteType,true),StructField(smallint,ShortType,true),StructField(bigint,LongType,true),StructField(bytes,BinaryType,true),StructField(timestamp,TimestampType,true),StructField(date,DateType,true),StructField(decimal,DecimalType(2,2),true),StructField(decimal2,DecimalType(38,2),true),StructField(decimal3,DecimalType(10,1),true))";
        StructType sparkType = SparkTypeUtils.fromPaimonRowType((RowType)ALL_TYPES);
        Assertions.assertThat((String)sparkType.toString().replace(", ", ",")).isEqualTo(expected);
    }
}

