/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.procedure;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.concurrent.TimeUnit;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.spark.PaimonSparkTestBase;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.utils.DateTimeUtils;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001]1AAA\u0002\u0001\u001d!)1\u0003\u0001C\u0001)\tq\"+Z7pm\u0016|%\u000f\u001d5b]\u001aKG.Z:Qe>\u001cW\rZ;sKR+7\u000f\u001e\u0006\u0003\t\u0015\t\u0011\u0002\u001d:pG\u0016$WO]3\u000b\u0005\u00199\u0011!B:qCJ\\'B\u0001\u0005\n\u0003\u0019\u0001\u0018-[7p]*\u0011!bC\u0001\u0007CB\f7\r[3\u000b\u00031\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\b\u0011\u0005A\tR\"A\u0003\n\u0005I)!a\u0005)bS6|gn\u00159be.$Vm\u001d;CCN,\u0017A\u0002\u001fj]&$h\bF\u0001\u0016!\t1\u0002!D\u0001\u0004\u0001")
public class RemoveOrphanFilesProcedureTest
extends PaimonSparkTestBase {
    public RemoveOrphanFilesProcedureTest() {
        this.test("Paimon procedure: remove orphan files", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (id STRING, name STRING)\n                 |USING PAIMON\n                 |TBLPROPERTIES ('primary-key'='id')\n                 |")).stripMargin());
            this.spark().sql("INSERT INTO T VALUES ('1', 'a'), ('2', 'b')");
            FileStoreTable table = this.loadTable("T");
            FileIO fileIO = table.fileIO();
            Path tablePath = table.location();
            Path orphanFile1 = new Path(tablePath, "bucket-0/orphan_file1");
            Path orphanFile2 = new Path(tablePath, "bucket-0/orphan_file2");
            fileIO.writeFileUtf8(orphanFile1, "a");
            Thread.sleep(2000L);
            fileIO.writeFileUtf8(orphanFile2, "b");
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Deleted=0"}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("CALL sys.remove_orphan_files(table => 'T')"), (Seq)Nil$.MODULE$.$colon$colon((Object)row));
            long orphanFile2ModTime = fileIO.getFileStatus(orphanFile2).getModificationTime();
            String older_than1 = DateTimeUtils.formatLocalDateTime((LocalDateTime)DateTimeUtils.toLocalDateTime((long)(orphanFile2ModTime - TimeUnit.SECONDS.toMillis(1L))), (int)3);
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Deleted=1"}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql(new StringBuilder(60).append("CALL sys.remove_orphan_files(table => 'T', older_than => '").append(older_than1).append("')").toString()), (Seq)Nil$.MODULE$.$colon$colon((Object)row2));
            String older_than2 = DateTimeUtils.formatLocalDateTime((LocalDateTime)DateTimeUtils.toLocalDateTime((long)System.currentTimeMillis()), (int)3);
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Deleted=1"}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql(new StringBuilder(60).append("CALL sys.remove_orphan_files(table => 'T', older_than => '").append(older_than2).append("')").toString()), (Seq)Nil$.MODULE$.$colon$colon((Object)row3));
        }, new Position("RemoveOrphanFilesProcedureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 31));
    }
}

