/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.sql;

import java.io.Serializable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.spark.PaimonSparkTestBase;
import org.apache.paimon.spark.catalyst.analysis.Update$;
import org.apache.paimon.spark.sql.UpdateTableTestBase$;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.spark.sql.Dataset;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001]1QAA\u0002\u0002\u00029AQa\u0005\u0001\u0005\u0002Q\u00111#\u00169eCR,G+\u00192mKR+7\u000f\u001e\"bg\u0016T!\u0001B\u0003\u0002\u0007M\fHN\u0003\u0002\u0007\u000f\u0005)1\u000f]1sW*\u0011\u0001\"C\u0001\u0007a\u0006LWn\u001c8\u000b\u0005)Y\u0011AB1qC\u000eDWMC\u0001\r\u0003\ry'oZ\u0002\u0001'\t\u0001q\u0002\u0005\u0002\u0011#5\tQ!\u0003\u0002\u0013\u000b\t\u0019\u0002+Y5n_:\u001c\u0006/\u0019:l)\u0016\u001cHOQ1tK\u00061A(\u001b8jiz\"\u0012!\u0006\t\u0003-\u0001i\u0011a\u0001")
public abstract class UpdateTableTestBase
extends PaimonSparkTestBase {
    public UpdateTableTestBase() {
        this.test("Paimon Update: append-only table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (id INT, name STRING, dt STRING)\n                 |")).stripMargin());
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                |INSERT INTO T\n                |VALUES (1, 'a', '2024'), (2, 'b', '2024'), (3, 'c', '2025'), (4, 'd', '2025')\n                |")).stripMargin());
            this.spark().sql("UPDATE T SET name = 'a_new' WHERE id = 1");
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(UpdateTableTestBase.class.getClassLoader());
            public final class Org_apache_paimon_spark_sql_UpdateTableTestBase$$typecreator6$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_paimon_spark_sql_UpdateTableTestBase$$typecreator6$1(UpdateTableTestBase $outer) {
                }
            }
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("SELECT * FROM T ORDER BY id"), this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a_new", (Object)"2024"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)"b", (Object)"2024"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)"c", (Object)"2025"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)4), (Object)"d", (Object)"2025"), (List)Nil$.MODULE$)))), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_paimon_spark_sql_UpdateTableTestBase$$typecreator6$1(null)))).toDF());
            SnapshotManager snapshotManager = this.loadTable("T").snapshotManager();
            Long lastSnapshotId = snapshotManager.latestSnapshotId();
            this.spark().sql("UPDATE T SET name = concat(name, '2') WHERE id % 2 == 0");
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(UpdateTableTestBase.class.getClassLoader());
            public final class Org_apache_paimon_spark_sql_UpdateTableTestBase$$typecreator16$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_paimon_spark_sql_UpdateTableTestBase$$typecreator16$1(UpdateTableTestBase $outer) {
                }
            }
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("SELECT * FROM T ORDER BY id"), this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a_new", (Object)"2024"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)"b2", (Object)"2024"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)"c", (Object)"2025"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)4), (Object)"d2", (Object)"2025"), (List)Nil$.MODULE$)))), this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_paimon_spark_sql_UpdateTableTestBase$$typecreator16$1(null)))).toDF());
            Assertions.assertThat((long)(Predef$.MODULE$.Long2long(lastSnapshotId) + 1L)).isEqualTo((Object)snapshotManager.latestSnapshotId());
            lastSnapshotId = snapshotManager.latestSnapshotId();
            this.spark().sql("UPDATE T SET name = 'empty_commit' WHERE id > 100");
            JavaUniverse $u3 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(UpdateTableTestBase.class.getClassLoader());
            public final class Org_apache_paimon_spark_sql_UpdateTableTestBase$$typecreator26$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_paimon_spark_sql_UpdateTableTestBase$$typecreator26$1(UpdateTableTestBase $outer) {
                }
            }
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("SELECT * FROM T ORDER BY id"), this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a_new", (Object)"2024"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)"b2", (Object)"2024"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)"c", (Object)"2025"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)4), (Object)"d2", (Object)"2025"), (List)Nil$.MODULE$)))), this.testImplicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_paimon_spark_sql_UpdateTableTestBase$$typecreator26$1(null)))).toDF());
            return (AbstractLongAssert)Assertions.assertThat((Long)lastSnapshotId).isEqualTo((Object)snapshotManager.latestSnapshotId());
        }, new Position("UpdateTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 31));
        this.test("Paimon Update: append-only table with partition", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (id INT, name STRING, dt STRING) PARTITIONED BY (dt)\n                 |")).stripMargin());
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                |INSERT INTO T\n                |VALUES (1, 'a', '2024'), (2, 'b', '2024'), (3, 'c', '2025'), (4, 'd', '2025')\n                |")).stripMargin());
            this.spark().sql("UPDATE T SET name = concat(name, '2') WHERE dt <= '2024'");
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(UpdateTableTestBase.class.getClassLoader());
            public final class Org_apache_paimon_spark_sql_UpdateTableTestBase$$typecreator36$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_paimon_spark_sql_UpdateTableTestBase$$typecreator36$1(UpdateTableTestBase $outer) {
                }
            }
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("SELECT * FROM T ORDER BY id"), this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a2", (Object)"2024"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)"b2", (Object)"2024"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)"c", (Object)"2025"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)4), (Object)"d", (Object)"2025"), (List)Nil$.MODULE$)))), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_paimon_spark_sql_UpdateTableTestBase$$typecreator36$1(null)))).toDF());
            this.spark().sql("UPDATE T SET name = concat(name, '3') WHERE dt = '2025' and id % 2 == 1");
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(UpdateTableTestBase.class.getClassLoader());
            public final class Org_apache_paimon_spark_sql_UpdateTableTestBase$$typecreator46$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_paimon_spark_sql_UpdateTableTestBase$$typecreator46$1(UpdateTableTestBase $outer) {
                }
            }
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("SELECT * FROM T ORDER BY id"), this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a2", (Object)"2024"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)"b2", (Object)"2024"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)"c3", (Object)"2025"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)4), (Object)"d", (Object)"2025"), (List)Nil$.MODULE$)))), this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_paimon_spark_sql_UpdateTableTestBase$$typecreator46$1(null)))).toDF());
            this.spark().sql("UPDATE T SET name = concat(name, '4') WHERE id % 2 == 0");
            JavaUniverse $u3 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(UpdateTableTestBase.class.getClassLoader());
            public final class Org_apache_paimon_spark_sql_UpdateTableTestBase$$typecreator56$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_paimon_spark_sql_UpdateTableTestBase$$typecreator56$1(UpdateTableTestBase $outer) {
                }
            }
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("SELECT * FROM T ORDER BY id"), this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a2", (Object)"2024"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)"b24", (Object)"2024"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)"c3", (Object)"2025"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)4), (Object)"d4", (Object)"2025"), (List)Nil$.MODULE$)))), this.testImplicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_paimon_spark_sql_UpdateTableTestBase$$typecreator56$1(null)))).toDF());
        }, new Position("UpdateTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
        this.test("Paimon Update: append-only table, condition contains subquery", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (id INT, name STRING, dt STRING) PARTITIONED BY (dt)\n                 |")).stripMargin());
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                |INSERT INTO T\n                |VALUES (1, 'a', '2024'), (2, 'b', '2024'), (3, 'c', '2025'), (4, 'd', '2025')\n                |")).stripMargin());
            this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4, 6})), this.testImplicits().newIntEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"})).createOrReplaceTempView("source");
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                |UPDATE T\n                |SET name = concat(substring(name, 0, 1), '2')\n                |WHERE id < (SELECT MIN(key) FROM source)")).stripMargin());
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(UpdateTableTestBase.class.getClassLoader());
            public final class Org_apache_paimon_spark_sql_UpdateTableTestBase$$typecreator66$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_paimon_spark_sql_UpdateTableTestBase$$typecreator66$1(UpdateTableTestBase $outer) {
                }
            }
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("SELECT * FROM T ORDER BY id"), this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a2", (Object)"2024"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)"b", (Object)"2024"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)"c", (Object)"2025"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)4), (Object)"d", (Object)"2025"), (List)Nil$.MODULE$)))), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_paimon_spark_sql_UpdateTableTestBase$$typecreator66$1(null)))).toDF());
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                |UPDATE T\n                |SET name = concat(substring(name, 0, 1), '3')\n                |WHERE EXiSTS (SELECT * FROM source WHERE key > 5)")).stripMargin());
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(UpdateTableTestBase.class.getClassLoader());
            public final class Org_apache_paimon_spark_sql_UpdateTableTestBase$$typecreator76$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_paimon_spark_sql_UpdateTableTestBase$$typecreator76$1(UpdateTableTestBase $outer) {
                }
            }
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("SELECT * FROM T ORDER BY id"), this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a3", (Object)"2024"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)"b3", (Object)"2024"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)"c3", (Object)"2025"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)4), (Object)"d3", (Object)"2025"), (List)Nil$.MODULE$)))), this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_paimon_spark_sql_UpdateTableTestBase$$typecreator76$1(null)))).toDF());
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                |UPDATE T\n                |SET name = concat(substring(name, 0, 1), '4')\n                |WHERE NOT EXiSTS (SELECT * FROM source WHERE key > 5)")).stripMargin());
            JavaUniverse $u3 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(UpdateTableTestBase.class.getClassLoader());
            public final class Org_apache_paimon_spark_sql_UpdateTableTestBase$$typecreator86$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_paimon_spark_sql_UpdateTableTestBase$$typecreator86$1(UpdateTableTestBase $outer) {
                }
            }
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("SELECT * FROM T ORDER BY id"), this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a3", (Object)"2024"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)"b3", (Object)"2024"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)"c3", (Object)"2025"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)4), (Object)"d3", (Object)"2025"), (List)Nil$.MODULE$)))), this.testImplicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_paimon_spark_sql_UpdateTableTestBase$$typecreator86$1(null)))).toDF());
        }, new Position("UpdateTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])CoreOptions.MergeEngine.values())).foreach((Function1 & Serializable & scala.Serializable)mergeEngine -> {
            this.test(new StringBuilder(30).append("test update with merge engine ").append(mergeEngine).toString(), (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
                AbstractAssert abstractAssert;
                String options = "first-row".equals(mergeEngine.toString()) ? new StringBuilder(74).append("'primary-key' = 'id', 'merge-engine' = '").append(mergeEngine).append("', 'changelog-producer' = 'lookup'").toString() : new StringBuilder(41).append("'primary-key' = 'id', 'merge-engine' = '").append(mergeEngine).append("'").toString();
                $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(138).append("\n                       |CREATE TABLE T (id INT, name STRING, dt STRING)\n                       |TBLPROPERTIES (").append(options).append(")\n                       |").toString())).stripMargin());
                $this.spark().sql("INSERT INTO T VALUES (1, 'a', '11'), (2, 'b', '22')");
                if (Update$.MODULE$.supportedMergeEngine().contains((Object)mergeEngine)) {
                    $this.spark().sql("UPDATE T SET name = 'a_new' WHERE id = 1");
                    java.util.List rows = $this.spark().sql("SELECT * FROM T ORDER BY id").collectAsList();
                    abstractAssert = Assertions.assertThat((String)rows.toString()).isEqualTo("[[1,a_new,11], [2,b,22]]");
                } else {
                    abstractAssert = Assertions.assertThatThrownBy(() -> $this.spark().sql("UPDATE T SET name = 'a_new' WHERE id = 1")).isInstanceOf(UnsupportedOperationException.class);
                }
                return abstractAssert;
            }, new Position("UpdateTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
            return BoxedUnit.UNIT;
        });
        this.test("test update with primary key", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (id INT, name STRING, dt STRING)\n                 |TBLPROPERTIES ('primary-key' = 'id', 'merge-engine' = 'deduplicate')\n                 |")).stripMargin());
            this.spark().sql("INSERT INTO T VALUES (1, 'a', '11'), (2, 'b', '22'), (3, 'c', '33')");
            return Assertions.assertThatThrownBy(() -> this.spark().sql("UPDATE T SET id = 11 WHERE name = 'a'")).hasMessageContaining("Can't update the primary key column.");
        }, new Position("UpdateTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
        this.test("test update with no where", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (id INT, name STRING, dt STRING)\n                 |TBLPROPERTIES ('primary-key' = 'id, dt', 'merge-engine' = 'deduplicate')\n                 |PARTITIONED BY (id)\n                 |")).stripMargin());
            this.spark().sql("INSERT INTO T VALUES (1, 'a', '11'), (2, 'b', '22'), (3, 'c', '33')");
            this.spark().sql("UPDATE T SET name = 'a_new'");
            java.util.List rows = this.spark().sql("SELECT * FROM T ORDER BY id").collectAsList();
            return Assertions.assertThat((String)rows.toString()).isEqualTo("[[1,a_new,11], [2,a_new,22], [3,a_new,33]]");
        }, new Position("UpdateTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
        this.test("test update with alias", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (id INT, name STRING, dt STRING)\n                 |TBLPROPERTIES ('primary-key' = 'id, dt', 'merge-engine' = 'deduplicate')\n                 |PARTITIONED BY (id)\n                 |")).stripMargin());
            this.spark().sql("INSERT INTO T VALUES (1, 'a', '11'), (2, 'b', '22'), (3, 'c', '33')");
            this.spark().sql("UPDATE T AS t SET t.name = 'a_new' where id = 1");
            java.util.List rows = this.spark().sql("SELECT * FROM T ORDER BY id").collectAsList();
            return Assertions.assertThat((String)rows.toString()).isEqualTo("[[1,a_new,11], [2,b,22], [3,c,33]]");
        }, new Position("UpdateTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
        this.test("test update with alias assignment", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (id INT, c1 INT, c2 INT)\n                 |TBLPROPERTIES ('primary-key' = 'id', 'merge-engine' = 'deduplicate')\n                 |")).stripMargin());
            this.spark().sql("INSERT INTO T VALUES (1, 1, 11), (2, 2, 22), (3, 3, 33)");
            this.spark().sql("UPDATE T set c1 = c1 + 1, c2 = c2 + 1 where id = 1");
            java.util.List rows = this.spark().sql("SELECT * FROM T ORDER BY id").collectAsList();
            return Assertions.assertThat((String)rows.toString()).isEqualTo("[[1,2,12], [2,2,22], [3,3,33]]");
        }, new Position("UpdateTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
        this.test("test update with in condition and not in condition", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (id INT, name STRING, dt STRING)\n                 |TBLPROPERTIES ('primary-key' = 'id, dt', 'merge-engine' = 'deduplicate')\n                 |PARTITIONED BY (dt)\n                 |")).stripMargin());
            this.spark().sql("INSERT INTO T VALUES (1, 'a', '11'), (2, 'b', '22'), (3, 'c', '33')");
            this.spark().sql("UPDATE T set name = 'in_new' WHERE id IN (1)");
            java.util.List rows1 = this.spark().sql("SELECT * FROM T ORDER BY id").collectAsList();
            Assertions.assertThat((String)rows1.toString()).isEqualTo("[[1,in_new,11], [2,b,22], [3,c,33]]");
            this.spark().sql("UPDATE T set name = 'not_in_new' WHERE id NOT IN (2)");
            java.util.List rows2 = this.spark().sql("SELECT * FROM T ORDER BY id").collectAsList();
            return Assertions.assertThat((String)rows2.toString()).isEqualTo("[[1,not_in_new,11], [2,b,22], [3,not_in_new,33]]");
        }, new Position("UpdateTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
        this.test("test update with in subquery", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (id INT, name STRING, dt STRING)\n                 |TBLPROPERTIES ('primary-key' = 'id, dt', 'merge-engine' = 'deduplicate')\n                 |PARTITIONED BY (dt)\n                 |")).stripMargin());
            this.spark().sql("INSERT INTO T VALUES (1, 'a', '11'), (2, 'b', '22'), (3, 'c', '33')");
            Dataset df = this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), this.testImplicits().newIntEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}));
            df.createOrReplaceTempView("updated_ids");
            this.spark().sql("UPDATE T set name = 'in_new' WHERE id IN (SELECT * FROM updated_ids)");
            java.util.List rows = this.spark().sql("SELECT * FROM T ORDER BY id").collectAsList();
            return Assertions.assertThat((String)rows.toString()).isEqualTo("[[1,in_new,11], [2,in_new,22], [3,c,33]]");
        }, new Position("UpdateTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
        this.test("test update with self subquery", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (id INT, name STRING, dt STRING)\n                 |TBLPROPERTIES ('primary-key' = 'id, dt', 'merge-engine' = 'deduplicate')\n                 |PARTITIONED BY (dt)\n                 |")).stripMargin());
            this.spark().sql("INSERT INTO T VALUES (1, 'a', '11'), (2, 'b', '22'), (3, 'c', '33')");
            this.spark().sql("UPDATE T set name = 'in_new' WHERE id IN (SELECT id + 1 FROM T)");
            java.util.List rows = this.spark().sql("SELECT * FROM T ORDER BY id").collectAsList();
            return Assertions.assertThat((String)rows.toString()).isEqualTo("[[1,a,11], [2,in_new,22], [3,in_new,33]]");
        }, new Position("UpdateTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
        this.test("test update with various column references", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (id INT, c1 INT, c2 INT, dt STRING)\n                 |TBLPROPERTIES ('primary-key' = 'id, dt', 'merge-engine' = 'deduplicate')\n                 |PARTITIONED BY (dt)\n                 |")).stripMargin());
            this.spark().sql("INSERT INTO T VALUES (1, 1, 10, '11'), (2, 2, 20, '22'), (3, 3, 300, '33')");
            this.spark().sql("UPDATE T SET c1 = c2 + 1, c2 = 1000");
            java.util.List rows = this.spark().sql("SELECT * FROM T ORDER BY id").collectAsList();
            return Assertions.assertThat((String)rows.toString()).isEqualTo("[[1,11,1000,11], [2,21,1000,22], [3,301,1000,33]]");
        }, new Position("UpdateTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266));
        this.test("test update with struct column", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (id INT, s STRUCT<c1: INT, c2: STRING>, dt STRING)\n                 |TBLPROPERTIES ('primary-key' = 'id, dt', 'merge-engine' = 'deduplicate')\n                 |PARTITIONED BY (dt)\n                 |")).stripMargin());
            this.spark().sql("INSERT INTO T VALUES (1, struct(1, 'a'), '11'), (2, struct(2, 'b'), '22'), (3, struct(3, 'c'), '33')");
            this.spark().sql("UPDATE T SET s.c2 = 'a_new' WHERE s.c1 = 1");
            java.util.List rows = this.spark().sql("SELECT * FROM T ORDER BY id").collectAsList();
            return Assertions.assertThat((String)rows.toString()).isEqualTo("[[1,[1,a_new],11], [2,[2,b],22], [3,[3,c],33]]");
        }, new Position("UpdateTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 280));
        this.test("test update with map column", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (id INT, m MAP<INT, STRING>, dt STRING)\n                 |TBLPROPERTIES ('primary-key' = 'id, dt', 'merge-engine' = 'deduplicate')\n                 |PARTITIONED BY (dt)\n                 |")).stripMargin());
            this.spark().sql("INSERT INTO T VALUES (1, map(1, 'a'), '11'), (2, map(2, 'b'), '22'), (3, map(3, 'c'), '33')");
            Assertions.assertThatThrownBy(() -> this.spark().sql("UPDATE T SET m.key = 11 WHERE id = 1")).hasMessageContaining("Unsupported update expression");
            this.spark().sql("UPDATE T SET m = map(11, 'a_new') WHERE id = 1");
            java.util.List rows = this.spark().sql("SELECT * FROM T ORDER BY id").collectAsList();
            return Assertions.assertThat((String)rows.toString()).isEqualTo("[[1,Map(11 -> a_new),11], [2,Map(2 -> b),22], [3,Map(3 -> c),33]]");
        }, new Position("UpdateTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 295));
        this.test("test update with conflicted column", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (id INT, s STRUCT<c1: INT, c2: STRING>, dt STRING)\n                 |TBLPROPERTIES ('primary-key' = 'id, dt', 'merge-engine' = 'deduplicate')\n                 |PARTITIONED BY (dt)\n                 |")).stripMargin());
            this.spark().sql("INSERT INTO T VALUES (1, struct(1, 'a'), '11'), (2, struct(2, 'b'), '22'), (3, struct(3, 'c'), '33')");
            return Assertions.assertThatThrownBy(() -> this.spark().sql("UPDATE T SET s.c2 = 'a_new', s = struct(11, 'a_new') WHERE s.c1 = 1")).hasMessageContaining("Conflicting update/insert on attrs: s.c2, s");
        }, new Position("UpdateTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
    }
}

