/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.predicate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.paimon.predicate.FieldRef;
import org.apache.paimon.predicate.FunctionVisitor;

public class OnlyPartitionKeyEqualVisitor
implements FunctionVisitor<Boolean> {
    private final List<String> partitionKeys;
    private final Map<String, String> partitions;

    public OnlyPartitionKeyEqualVisitor(List<String> partitionKeys) {
        this.partitionKeys = partitionKeys;
        this.partitions = new HashMap<String, String>();
    }

    public Map<String, String> partitions() {
        return this.partitions;
    }

    @Override
    public Boolean visitIsNotNull(FieldRef fieldRef) {
        return false;
    }

    @Override
    public Boolean visitIsNull(FieldRef fieldRef) {
        return false;
    }

    @Override
    public Boolean visitStartsWith(FieldRef fieldRef, Object literal) {
        return false;
    }

    @Override
    public Boolean visitLessThan(FieldRef fieldRef, Object literal) {
        return false;
    }

    @Override
    public Boolean visitGreaterOrEqual(FieldRef fieldRef, Object literal) {
        return false;
    }

    @Override
    public Boolean visitNotEqual(FieldRef fieldRef, Object literal) {
        return false;
    }

    @Override
    public Boolean visitLessOrEqual(FieldRef fieldRef, Object literal) {
        return false;
    }

    @Override
    public Boolean visitEqual(FieldRef fieldRef, Object literal) {
        boolean contains = this.partitionKeys.contains(fieldRef.name());
        if (contains) {
            this.partitions.put(fieldRef.name(), literal.toString());
            return true;
        }
        return false;
    }

    @Override
    public Boolean visitGreaterThan(FieldRef fieldRef, Object literal) {
        return false;
    }

    @Override
    public Boolean visitIn(FieldRef fieldRef, List<Object> literals) {
        return false;
    }

    @Override
    public Boolean visitNotIn(FieldRef fieldRef, List<Object> literals) {
        return false;
    }

    @Override
    public Boolean visitAnd(List<Boolean> children) {
        return (Boolean)children.stream().reduce((first, second) -> first != false && second != false).get();
    }

    @Override
    public Boolean visitOr(List<Boolean> children) {
        return false;
    }
}

