/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.compression;

import org.apache.paimon.compression.BufferDecompressionException;

public class CompressorUtils {
    public static final int HEADER_LENGTH = 8;

    public static void writeIntLE(int i, byte[] buf, int offset) {
        buf[offset++] = (byte)i;
        buf[offset++] = (byte)(i >>> 8);
        buf[offset++] = (byte)(i >>> 16);
        buf[offset] = (byte)(i >>> 24);
    }

    public static int readIntLE(byte[] buf, int i) {
        return buf[i] & 0xFF | (buf[i + 1] & 0xFF) << 8 | (buf[i + 2] & 0xFF) << 16 | (buf[i + 3] & 0xFF) << 24;
    }

    public static void validateLength(int compressedLen, int originalLen) throws BufferDecompressionException {
        if (originalLen < 0 || compressedLen < 0 || originalLen == 0 && compressedLen != 0 || originalLen != 0 && compressedLen == 0) {
            throw new BufferDecompressionException("Input is corrupted, invalid length.");
        }
    }
}

