/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.KeyValue;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.fileindex.FileIndexOptions;
import org.apache.paimon.format.FormatWriterFactory;
import org.apache.paimon.format.SimpleColStats;
import org.apache.paimon.format.SimpleStatsExtractor;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.io.KeyValueDataFileWriter;
import org.apache.paimon.manifest.FileSource;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Pair;

public class KeyValueThinDataFileWriterImpl
extends KeyValueDataFileWriter {
    private final int[] keyStatMapping;

    public KeyValueThinDataFileWriterImpl(FileIO fileIO, FormatWriterFactory factory2, Path path, Function<KeyValue, InternalRow> converter, RowType keyType, RowType valueType, @Nullable SimpleStatsExtractor simpleStatsExtractor, long schemaId, int level, String compression, CoreOptions options, FileSource fileSource, FileIndexOptions fileIndexOptions) {
        super(fileIO, factory2, path, converter, keyType, valueType, KeyValue.schema(RowType.of(), valueType), simpleStatsExtractor, schemaId, level, compression, options, fileSource, fileIndexOptions);
        int i;
        HashMap<Integer, Integer> idToIndex = new HashMap<Integer, Integer>(valueType.getFieldCount());
        for (i = 0; i < valueType.getFieldCount(); ++i) {
            idToIndex.put(valueType.getFields().get(i).id(), i);
        }
        this.keyStatMapping = new int[keyType.getFieldCount()];
        for (i = 0; i < keyType.getFieldCount(); ++i) {
            this.keyStatMapping[i] = (Integer)idToIndex.get(keyType.getFields().get(i).id() - 0x3FFFFFFF);
        }
    }

    @Override
    Pair<SimpleColStats[], SimpleColStats[]> fetchKeyValueStats(SimpleColStats[] rowStats) {
        int numKeyFields = this.keyType.getFieldCount();
        SimpleColStats[] valFieldStats = Arrays.copyOfRange(rowStats, 2, rowStats.length);
        SimpleColStats[] keyStats = new SimpleColStats[numKeyFields];
        for (int i = 0; i < this.keyStatMapping.length; ++i) {
            keyStats[i] = valFieldStats[this.keyStatMapping[i]];
        }
        return Pair.of(keyStats, valFieldStats);
    }
}

