/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.memory;

import java.nio.ByteBuffer;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.memory.MemorySegment;

@Public
public class Buffer {
    private final MemorySegment segment;
    private int size;

    public Buffer(MemorySegment segment, int size) {
        this.segment = segment;
        this.size = size;
    }

    public static Buffer create(MemorySegment segment) {
        return Buffer.create(segment, 0);
    }

    public static Buffer create(MemorySegment segment, int size) {
        return new Buffer(segment, size);
    }

    public MemorySegment getMemorySegment() {
        return this.segment;
    }

    public int getSize() {
        return this.size;
    }

    public int getMaxCapacity() {
        return this.segment.size();
    }

    public ByteBuffer getNioBuffer(int index, int length) {
        return this.segment.wrap(index, length).slice();
    }

    public void setSize(int size) {
        this.size = size;
    }
}

