/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.catalog;

import org.apache.paimon.spark.catalog.functions.PaimonFunctions;
import org.apache.spark.sql.catalyst.analysis.NoSuchFunctionException;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.connector.catalog.FunctionCatalog;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.SupportsNamespaces;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;

public interface SupportFunction
extends FunctionCatalog,
SupportsNamespaces {
    public static boolean isFunctionNamespace(String[] namespace) {
        return namespace.length == 0 || SupportFunction.isSystemNamespace(namespace);
    }

    public static boolean isSystemNamespace(String[] namespace) {
        return namespace.length == 1 && namespace[0].equalsIgnoreCase("sys");
    }

    default public Identifier[] listFunctions(String[] namespace) throws NoSuchNamespaceException {
        if (SupportFunction.isFunctionNamespace(namespace)) {
            return (Identifier[])PaimonFunctions.names().stream().map(name -> Identifier.of((String[])namespace, (String)name)).toArray(Identifier[]::new);
        }
        if (this.namespaceExists(namespace)) {
            return new Identifier[0];
        }
        throw new NoSuchNamespaceException(namespace);
    }

    default public UnboundFunction loadFunction(Identifier ident) throws NoSuchFunctionException {
        UnboundFunction func;
        if (SupportFunction.isFunctionNamespace(ident.namespace()) && (func = PaimonFunctions.load(ident.name())) != null) {
            return func;
        }
        throw new NoSuchFunctionException(ident);
    }
}

