/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.commands;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.codegen.CodeGenUtils;
import org.apache.paimon.codegen.Projection;
import org.apache.paimon.crosspartition.IndexBootstrap;
import org.apache.paimon.crosspartition.KeyPartOrRow;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.serializer.InternalRowSerializer;
import org.apache.paimon.data.serializer.InternalSerializers;
import org.apache.paimon.deletionvectors.DeletionVector;
import org.apache.paimon.deletionvectors.append.AppendDeletionFileMaintainer;
import org.apache.paimon.index.BucketAssigner;
import org.apache.paimon.index.IndexFileHandler;
import org.apache.paimon.index.SimpleHashBucketAssigner;
import org.apache.paimon.io.CompactIncrement;
import org.apache.paimon.io.DataIncrement;
import org.apache.paimon.io.IndexIncrement;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.manifest.IndexManifestEntry;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.spark.SparkRow;
import org.apache.paimon.spark.SparkTableWrite;
import org.apache.paimon.spark.SparkTypeUtils;
import org.apache.paimon.spark.commands.BucketProcessor;
import org.apache.paimon.spark.commands.CommonBucketProcessor;
import org.apache.paimon.spark.commands.DynamicBucketProcessor;
import org.apache.paimon.spark.commands.EncoderSerDeGroup;
import org.apache.paimon.spark.commands.GlobalDynamicBucketProcessor;
import org.apache.paimon.spark.commands.PaimonSparkWriter$;
import org.apache.paimon.spark.commands.PaimonSparkWriter$ModPartitioner$;
import org.apache.paimon.spark.commands.SparkDeletionVectors;
import org.apache.paimon.spark.schema.SparkSystemColumns$;
import org.apache.paimon.spark.util.SparkRowUtils$;
import org.apache.paimon.table.BucketMode;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.sink.BatchTableCommit;
import org.apache.paimon.table.sink.BatchWriteBuilder;
import org.apache.paimon.table.sink.CommitMessage;
import org.apache.paimon.table.sink.CommitMessageImpl;
import org.apache.paimon.table.sink.CommitMessageSerializer;
import org.apache.paimon.table.sink.RowPartitionKeyExtractor;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.CloseableIterator;
import org.apache.paimon.utils.SerializationUtils;
import org.apache.spark.Partitioner;
import org.apache.spark.TaskContext$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\u001dh\u0001\u0002\u001e<\u0001\u001aC\u0001b\u0015\u0001\u0003\u0016\u0004%\t\u0001\u0016\u0005\t5\u0002\u0011\t\u0012)A\u0005+\")1\f\u0001C\u00019\"A\u0001\r\u0001EC\u0002\u0013%\u0011\r\u0003\u0005i\u0001!\u0015\r\u0011\"\u0003j\u0011!\u0001\b\u0001#b\u0001\n\u0013\t\b\u0002C;\u0001\u0011\u000b\u0007I\u0011\u0002<\t\u0013\u0005\r\u0001A1A\u0005\u0002\u0005\u0015\u0001\u0002CA\u0007\u0001\u0001\u0006I!a\u0002\t\u000f\u0005=\u0001\u0001\"\u0001\u0002\u0012!9\u00111\u0003\u0001\u0005\u0002\u0005U\u0001bBA.\u0001\u0011\u0005\u0011Q\f\u0005\b\u0003c\u0002A\u0011AA:\u0011\u001d\t9\t\u0001C\u0001\u0003\u0013Cq!!&\u0001\t\u0013\t9\nC\u0004\u0002V\u0002!I!a6\t\u000f\u0005-\b\u0001\"\u0003\u0002n\"9\u00111\u001f\u0001\u0005\n\u0005UhABA\u007f\u0001\u0011\u000by\u0010\u0003\u0006\u0003\nM\u0011)\u001a!C\u0001\u0005\u0017A!B!\u0004\u0014\u0005#\u0005\u000b\u0011BAe\u0011\u0019Y6\u0003\"\u0001\u0003\u0010!9!qC\n\u0005B\t-\u0001b\u0002B\r'\u0011\u0005#1\u0004\u0005\n\u0005O\u0019\u0012\u0011!C\u0001\u0005SA\u0011B!\f\u0014#\u0003%\tAa\f\t\u0013\t\u00153#!A\u0005B\t\u001d\u0003\"\u0003B-'\u0005\u0005I\u0011\u0001B\u0006\u0011%\u0011YfEA\u0001\n\u0003\u0011i\u0006C\u0005\u0003dM\t\t\u0011\"\u0011\u0003f!I!1O\n\u0002\u0002\u0013\u0005!Q\u000f\u0005\n\u0005\u007f\u001a\u0012\u0011!C!\u0005\u0003C\u0011Ba!\u0014\u0003\u0003%\tE!\"\t\u0013\t\u001d5#!A\u0005B\t%u!\u0003BG\u0001\u0005\u0005\t\u0012\u0002BH\r%\ti\u0010AA\u0001\u0012\u0013\u0011\t\n\u0003\u0004\\I\u0011\u0005!q\u0014\u0005\n\u0005\u0007#\u0013\u0011!C#\u0005\u000bC\u0011B!)%\u0003\u0003%\tIa)\t\u0013\t\u001dF%!A\u0005\u0002\n%\u0006\"\u0003B\u0014\u0001\u0005\u0005I\u0011\u0001B[\u0011%\u0011i\u0003AI\u0001\n\u0003\u0011I\fC\u0005\u0003F\u0001\t\t\u0011\"\u0011\u0003H!I!\u0011\f\u0001\u0002\u0002\u0013\u0005!1\u0002\u0005\n\u00057\u0002\u0011\u0011!C\u0001\u0005{C\u0011Ba\u0019\u0001\u0003\u0003%\tE!\u001a\t\u0013\tM\u0004!!A\u0005\u0002\t\u0005\u0007\"\u0003B@\u0001\u0005\u0005I\u0011\tBA\u0011%\u0011\u0019\tAA\u0001\n\u0003\u0012)\tC\u0005\u0003\b\u0002\t\t\u0011\"\u0011\u0003F\u001eI!\u0011Z\u001e\u0002\u0002#\u0005!1\u001a\u0004\tum\n\t\u0011#\u0001\u0003N\"11\f\u000eC\u0001\u0005#D\u0011Ba!5\u0003\u0003%)E!\"\t\u0013\t\u0005F'!A\u0005\u0002\nM\u0007\"\u0003BTi\u0005\u0005I\u0011\u0011Bl\u0011%\u0011i\u000eNA\u0001\n\u0013\u0011yNA\tQC&lwN\\*qCJ\\wK]5uKJT!\u0001P\u001f\u0002\u0011\r|W.\\1oINT!AP \u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0001\u000b\u0015A\u00029bS6|gN\u0003\u0002C\u0007\u00061\u0011\r]1dQ\u0016T\u0011\u0001R\u0001\u0004_J<7\u0001A\n\u0005\u0001\u001dk\u0005\u000b\u0005\u0002I\u00176\t\u0011JC\u0001K\u0003\u0015\u00198-\u00197b\u0013\ta\u0015J\u0001\u0004B]f\u0014VM\u001a\t\u0003\u0011:K!aT%\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0001*U\u0005\u0003%&\u0013AbU3sS\u0006d\u0017N_1cY\u0016\fQ\u0001^1cY\u0016,\u0012!\u0016\t\u0003-bk\u0011a\u0016\u0006\u0003'~J!!W,\u0003\u001d\u0019KG.Z*u_J,G+\u00192mK\u00061A/\u00192mK\u0002\na\u0001P5oSRtDCA/`!\tq\u0006!D\u0001<\u0011\u0015\u00196\u00011\u0001V\u0003-!\u0018M\u00197f'\u000eDW-\\1\u0016\u0003\t\u0004\"a\u00194\u000e\u0003\u0011T!!Z \u0002\rM\u001c\u0007.Z7b\u0013\t9GMA\u0006UC\ndWmU2iK6\f\u0017a\u0002:poRK\b/Z\u000b\u0002UB\u00111N\\\u0007\u0002Y*\u0011QnP\u0001\u0006if\u0004Xm]\u0005\u0003_2\u0014qAU8x)f\u0004X-\u0001\u0006ck\u000e\\W\r^'pI\u0016,\u0012A\u001d\t\u0003-NL!\u0001^,\u0003\u0015\t+8m[3u\u001b>$W-\u0001\u0006tKJL\u0017\r\\5{KJ,\u0012a\u001e\t\u0003qnl\u0011!\u001f\u0006\u0003u^\u000bAa]5oW&\u0011A0\u001f\u0002\u0018\u0007>lW.\u001b;NKN\u001c\u0018mZ3TKJL\u0017\r\\5{KJD#a\u0002@\u0011\u0005!{\u0018bAA\u0001\u0013\nIAO]1og&,g\u000e^\u0001\roJLG/\u001a\"vS2$WM]\u000b\u0003\u0003\u000f\u00012\u0001_A\u0005\u0013\r\tY!\u001f\u0002\u0012\u0005\u0006$8\r[,sSR,')^5mI\u0016\u0014\u0018!D<sSR,')^5mI\u0016\u0014\b%A\u0005xe&$Xm\u00148msR\tQ,A\u0003xe&$X\r\u0006\u0003\u0002\u0018\u0005U\u0002CBA\r\u0003S\tyC\u0004\u0003\u0002\u001c\u0005\u0015b\u0002BA\u000f\u0003Gi!!a\b\u000b\u0007\u0005\u0005R)\u0001\u0004=e>|GOP\u0005\u0002\u0015&\u0019\u0011qE%\u0002\u000fA\f7m[1hK&!\u00111FA\u0017\u0005\r\u0019V-\u001d\u0006\u0004\u0003OI\u0005c\u0001=\u00022%\u0019\u00111G=\u0003\u001b\r{W.\\5u\u001b\u0016\u001c8/Y4f\u0011\u001d\t9d\u0003a\u0001\u0003s\tA\u0001Z1uCB!\u00111HA+\u001d\u0011\ti$!\u0015\u000f\t\u0005}\u00121\n\b\u0005\u0003\u0003\nIE\u0004\u0003\u0002D\u0005\u001dc\u0002BA\u000f\u0003\u000bJ\u0011\u0001R\u0005\u0003\u0005\u000eK!AP!\n\t\u00055\u0013qJ\u0001\u0004gFd'B\u0001 B\u0013\u0011\t9#a\u0015\u000b\t\u00055\u0013qJ\u0005\u0005\u0003/\nIFA\u0005ECR\fgI]1nK*!\u0011qEA*\u0003Y\u0001XM]:jgR$U\r\\3uS>tg+Z2u_J\u001cH\u0003BA\f\u0003?Bq!!\u0019\r\u0001\u0004\t\u0019'A\beK2,G/[8o-\u0016\u001cGo\u001c:t!\u0019\t)'a\u001a\u0002l5\u0011\u00111K\u0005\u0005\u0003S\n\u0019FA\u0004ECR\f7/\u001a;\u0011\u0007y\u000bi'C\u0002\u0002pm\u0012Ac\u00159be.$U\r\\3uS>tg+Z2u_J\u001c\u0018\u0001\u000b2vS2$7i\\7nSRlUm]:bO\u00164%o\\7J]\u0012,\u00070T1oS\u001a,7\u000f^#oiJLH\u0003BA\f\u0003kBq!a\u001e\u000e\u0001\u0004\tI(\u0001\u000bj]\u0012,\u00070T1oS\u001a,7\u000f^#oiJLWm\u001d\t\u0007\u00033\tI#a\u001f\u0011\t\u0005u\u00141Q\u0007\u0003\u0003\u007fR1!!!@\u0003!i\u0017M\\5gKN$\u0018\u0002BAC\u0003\u007f\u0012!#\u00138eKbl\u0015M\\5gKN$XI\u001c;ss\u000611m\\7nSR$B!a#\u0002\u0012B\u0019\u0001*!$\n\u0007\u0005=\u0015J\u0001\u0003V]&$\bbBAJ\u001d\u0001\u0007\u0011qC\u0001\u000fG>lW.\u001b;NKN\u001c\u0018mZ3t\u0003\u0001\u0012wn\u001c;tiJ\f\u0007/\u00118e%\u0016\u0004\u0018M\u001d;ji&|gNQ=LKfD\u0015m\u001d5\u0015\u0015\u0005e\u00151YAc\u0003\u001f\f\u0019\u000e\u0005\u0004\u0002\u001c\u0006\u0005\u0016QU\u0007\u0003\u0003;SA!a(\u0002P\u0005\u0019!\u000f\u001a3\n\t\u0005\r\u0016Q\u0014\u0002\u0004%\u0012#\u0005c\u0002%\u0002(\u0006-\u0016qW\u0005\u0004\u0003SK%A\u0002+va2,'\u0007\u0005\u0003\u0002.\u0006MVBAAX\u0015\r\t\tlP\u0001\u000fGJ|7o\u001d9beRLG/[8o\u0013\u0011\t),a,\u0003\u0019-+\u0017\u0010U1si>\u0013(k\\<\u0011\u000b!\u000bI,!0\n\u0007\u0005m\u0016JA\u0003BeJ\f\u0017\u0010E\u0002I\u0003\u007fK1!!1J\u0005\u0011\u0011\u0015\u0010^3\t\u000f\u0005]r\u00021\u0001\u0002:!9\u0011qY\bA\u0002\u0005%\u0017a\u00039be\u0006dG.\u001a7jg6\u00042\u0001SAf\u0013\r\ti-\u0013\u0002\u0004\u0013:$\bbBAi\u001f\u0001\u0007\u0011\u0011Z\u0001\u000ee><8*\u001b8e\u0007>d\u0017\n\u001a=\t\u000b!|\u0001\u0019\u00016\u0002;I,\u0007/\u0019:uSRLwN\u001c\"z\u0017\u0016L\b+\u0019:uSRLwN\u001c%bg\"$\"\"!\u000f\u0002Z\u0006\r\u0018Q]At\u0011\u001d\tY\u000e\u0005a\u0001\u0003;\fAb\u001d9be.\u001cVm]:j_:\u0004B!!\u001a\u0002`&!\u0011\u0011]A*\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0011\u001d\t9\u0004\u0005a\u0001\u0003sAq!a2\u0011\u0001\u0004\tI\rC\u0004\u0002jB\u0001\r!!3\u0002\u00199,X.Q:tS\u001etWM]:\u0002AI,\u0007/\u0019:uSRLwN\u001c\"z!\u0006\u0014H/\u001b;j_:\u001c\u0018I\u001c3Ck\u000e\\W\r\u001e\u000b\u0005\u0003s\ty\u000fC\u0004\u0002rF\u0001\r!!\u000f\u0002\u0005\u00114\u0017\u0001\u00073fg\u0016\u0014\u0018.\u00197ju\u0016\u001cu.\\7ji6+7o]1hKR1\u0011qFA|\u0003sDQ!\u001e\nA\u0002]Dq!a?\u0013\u0001\u0004\t9,A\u0003csR,7O\u0001\bN_\u0012\u0004\u0016M\u001d;ji&|g.\u001a:\u0014\u000bM\u0011\t!\u0014)\u0011\t\t\r!QA\u0007\u0003\u0003\u001fJAAa\u0002\u0002P\tY\u0001+\u0019:uSRLwN\\3s\u0003)\u0001\u0018M\u001d;ji&|gn]\u000b\u0003\u0003\u0013\f1\u0002]1si&$\u0018n\u001c8tAQ!!\u0011\u0003B\u000b!\r\u0011\u0019bE\u0007\u0002\u0001!9!\u0011\u0002\fA\u0002\u0005%\u0017!\u00048v[B\u000b'\u000f^5uS>t7/\u0001\u0007hKR\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0003\u0002J\nu\u0001b\u0002B\u00101\u0001\u0007!\u0011E\u0001\u0004W\u0016L\bc\u0001%\u0003$%\u0019!QE%\u0003\u0007\u0005s\u00170\u0001\u0003d_BLH\u0003\u0002B\t\u0005WA\u0011B!\u0003\u001a!\u0003\u0005\r!!3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!\u0011\u0007\u0016\u0005\u0003\u0013\u0014\u0019d\u000b\u0002\u00036A!!q\u0007B!\u001b\t\u0011ID\u0003\u0003\u0003<\tu\u0012!C;oG\",7m[3e\u0015\r\u0011y$S\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\"\u0005s\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!\u0011\n\t\u0005\u0005\u0017\u0012)&\u0004\u0002\u0003N)!!q\nB)\u0003\u0011a\u0017M\\4\u000b\u0005\tM\u0013\u0001\u00026bm\u0006LAAa\u0016\u0003N\t11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003\"\t}\u0003\"\u0003B1;\u0005\u0005\t\u0019AAe\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!q\r\t\u0007\u0005S\u0012yG!\t\u000e\u0005\t-$b\u0001B7\u0013\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\tE$1\u000e\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0003x\tu\u0004c\u0001%\u0003z%\u0019!1P%\u0003\u000f\t{w\u000e\\3b]\"I!\u0011M\u0010\u0002\u0002\u0003\u0007!\u0011E\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011\u0011Z\u0001\ti>\u001cFO]5oOR\u0011!\u0011J\u0001\u0007KF,\u0018\r\\:\u0015\t\t]$1\u0012\u0005\n\u0005C\u0012\u0013\u0011!a\u0001\u0005C\ta\"T8e!\u0006\u0014H/\u001b;j_:,'\u000fE\u0002\u0003\u0014\u0011\u001aB\u0001\nBJ!BA!Q\u0013BN\u0003\u0013\u0014\t\"\u0004\u0002\u0003\u0018*\u0019!\u0011T%\u0002\u000fI,h\u000e^5nK&!!Q\u0014BL\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\u000b\u0003\u0005\u001f\u000bQ!\u00199qYf$BA!\u0005\u0003&\"9!\u0011B\u0014A\u0002\u0005%\u0017aB;oCB\u0004H.\u001f\u000b\u0005\u0005W\u0013\t\fE\u0003I\u0005[\u000bI-C\u0002\u00030&\u0013aa\u00149uS>t\u0007\"\u0003BZQ\u0005\u0005\t\u0019\u0001B\t\u0003\rAH\u0005\r\u000b\u0004;\n]\u0006bB**!\u0003\u0005\r!V\u000b\u0003\u0005wS3!\u0016B\u001a)\u0011\u0011\tCa0\t\u0013\t\u0005T&!AA\u0002\u0005%G\u0003\u0002B<\u0005\u0007D\u0011B!\u00190\u0003\u0003\u0005\rA!\t\u0015\t\t]$q\u0019\u0005\n\u0005C\u0012\u0014\u0011!a\u0001\u0005C\t\u0011\u0003U1j[>t7\u000b]1sW^\u0013\u0018\u000e^3s!\tqFg\u0005\u00035\u0005\u001f\u0004\u0006C\u0002BK\u00057+V\f\u0006\u0002\u0003LR\u0019QL!6\t\u000bM;\u0004\u0019A+\u0015\t\te'1\u001c\t\u0005\u0011\n5V\u000b\u0003\u0005\u00034b\n\t\u00111\u0001^\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t\u0005\b\u0003\u0002B&\u0005GLAA!:\u0003N\t1qJ\u00196fGR\u0004")
public class PaimonSparkWriter
implements Product,
scala.Serializable {
    private TableSchema tableSchema;
    private RowType rowType;
    private BucketMode bucketMode;
    private transient CommitMessageSerializer serializer;
    private volatile PaimonSparkWriter$ModPartitioner$ ModPartitioner$module;
    private final FileStoreTable table;
    private final BatchWriteBuilder writeBuilder;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<FileStoreTable> unapply(PaimonSparkWriter paimonSparkWriter) {
        return PaimonSparkWriter$.MODULE$.unapply(paimonSparkWriter);
    }

    public static PaimonSparkWriter apply(FileStoreTable fileStoreTable) {
        return PaimonSparkWriter$.MODULE$.apply(fileStoreTable);
    }

    public static <A> Function1<FileStoreTable, A> andThen(Function1<PaimonSparkWriter, A> function1) {
        return PaimonSparkWriter$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, PaimonSparkWriter> compose(Function1<A, FileStoreTable> function1) {
        return PaimonSparkWriter$.MODULE$.compose(function1);
    }

    private PaimonSparkWriter$ModPartitioner$ ModPartitioner() {
        if (this.ModPartitioner$module == null) {
            this.ModPartitioner$lzycompute$1();
        }
        return this.ModPartitioner$module;
    }

    public FileStoreTable table() {
        return this.table;
    }

    private TableSchema tableSchema$lzycompute() {
        PaimonSparkWriter paimonSparkWriter = this;
        synchronized (paimonSparkWriter) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.tableSchema = this.table().schema();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.tableSchema;
    }

    private TableSchema tableSchema() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.tableSchema$lzycompute() : this.tableSchema;
    }

    private RowType rowType$lzycompute() {
        PaimonSparkWriter paimonSparkWriter = this;
        synchronized (paimonSparkWriter) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.rowType = this.table().rowType();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.rowType;
    }

    private RowType rowType() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.rowType$lzycompute() : this.rowType;
    }

    private BucketMode bucketMode$lzycompute() {
        PaimonSparkWriter paimonSparkWriter = this;
        synchronized (paimonSparkWriter) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.bucketMode = this.table().bucketMode();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.bucketMode;
    }

    private BucketMode bucketMode() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.bucketMode$lzycompute() : this.bucketMode;
    }

    private CommitMessageSerializer serializer$lzycompute() {
        PaimonSparkWriter paimonSparkWriter = this;
        synchronized (paimonSparkWriter) {
            if (!this.bitmap$trans$0) {
                this.serializer = new CommitMessageSerializer();
                this.bitmap$trans$0 = true;
            }
        }
        return this.serializer;
    }

    private CommitMessageSerializer serializer() {
        return !this.bitmap$trans$0 ? this.serializer$lzycompute() : this.serializer;
    }

    public BatchWriteBuilder writeBuilder() {
        return this.writeBuilder;
    }

    public PaimonSparkWriter writeOnly() {
        return new PaimonSparkWriter((FileStoreTable)this.table().copy((Map)Collections.singletonMap(CoreOptions.WRITE_ONLY.key(), "true")));
    }

    public Seq<CommitMessage> write(Dataset<Row> data) {
        Dataset dataset;
        SparkSession sparkSession = data.sparkSession();
        BucketMode bucketMode = this.bucketMode();
        Dataset dataset2 = ((Object)((Object)BucketMode.CROSS_PARTITION)).equals((Object)bucketMode) && !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])data.schema().fieldNames())).contains((Object)SparkSystemColumns$.MODULE$.ROW_KIND_COL()) ? data.withColumn(SparkSystemColumns$.MODULE$.ROW_KIND_COL(), functions$.MODULE$.lit((Object)BoxesRunTime.boxToByte((byte)RowKind.INSERT.toByteValue()))).withColumn(SparkSystemColumns$.MODULE$.BUCKET_COL(), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)-1))) : data.withColumn(SparkSystemColumns$.MODULE$.BUCKET_COL(), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)-1)));
        Dataset withInitBucketCol = dataset2;
        int rowKindColIdx = SparkRowUtils$.MODULE$.getFieldIndex(withInitBucketCol.schema(), SparkSystemColumns$.MODULE$.ROW_KIND_COL());
        int bucketColIdx = SparkRowUtils$.MODULE$.getFieldIndex(withInitBucketCol.schema(), SparkSystemColumns$.MODULE$.BUCKET_COL());
        EncoderSerDeGroup encoderGroupWithBucketCol = new EncoderSerDeGroup(withInitBucketCol.schema());
        BucketMode bucketMode2 = this.bucketMode();
        if (((Object)((Object)BucketMode.CROSS_PARTITION)).equals((Object)bucketMode2)) {
            RowType rowType = (RowType)SparkTypeUtils.toPaimonType((DataType)withInitBucketCol.schema());
            int assignerParallelism = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)this.table().coreOptions().dynamicBucketAssignerParallelism()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$1))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> PaimonSparkWriter.sparkParallelism$1(sparkSession)));
            RDD<Tuple2<KeyPartOrRow, byte[]>> bootstrapped = this.bootstrapAndRepartitionByKeyHash((Dataset<Row>)withInitBucketCol, assignerParallelism, rowKindColIdx, rowType);
            GlobalDynamicBucketProcessor globalDynamicBucketProcessor = new GlobalDynamicBucketProcessor(this.table(), rowType, Predef$.MODULE$.int2Integer(assignerParallelism), encoderGroupWithBucketCol);
            Dataset<Row> repartitioned = this.repartitionByPartitionsAndBucket((Dataset<Row>)sparkSession.createDataFrame(bootstrapped.mapPartitions((Function1 & Serializable & scala.Serializable)rowIterator -> globalDynamicBucketProcessor.processPartition((Iterator<Tuple2<KeyPartOrRow, byte[]>>)rowIterator), bootstrapped.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Row.class)), withInitBucketCol.schema()));
            dataset = this.writeWithBucket$1(repartitioned, bucketColIdx, sparkSession, rowKindColIdx);
        } else if (((Object)((Object)BucketMode.HASH_DYNAMIC)).equals((Object)bucketMode2)) {
            int assignerParallelism = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)this.table().coreOptions().dynamicBucketAssignerParallelism()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$2))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> PaimonSparkWriter.sparkParallelism$1(sparkSession)));
            int numAssigners = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)this.table().coreOptions().dynamicBucketInitialBuckets()).map((Function1 & Serializable & scala.Serializable)initialBuckets -> BoxesRunTime.boxToInteger((int)PaimonSparkWriter.$anonfun$write$13(assignerParallelism, initialBuckets))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> assignerParallelism));
            dataset = this.table().snapshotManager().latestSnapshot() == null ? this.writeWithBucketAssigner$1(this.partitionByKey$1(sparkSession, withInitBucketCol, assignerParallelism, numAssigners), (Function0 & Serializable & scala.Serializable)() -> {
                RowPartitionKeyExtractor extractor = new RowPartitionKeyExtractor(this.table().schema());
                SimpleHashBucketAssigner assigner = new SimpleHashBucketAssigner(numAssigners, TaskContext$.MODULE$.getPartitionId(), this.table().coreOptions().dynamicBucketTargetRowNum());
                return (Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToInteger((int)PaimonSparkWriter.$anonfun$write$16(this, assigner, extractor, row));
            }, sparkSession, rowKindColIdx) : this.writeWithBucketProcessor$1(this.partitionByKey$1(sparkSession, withInitBucketCol, assignerParallelism, numAssigners), new DynamicBucketProcessor(this.table(), bucketColIdx, assignerParallelism, numAssigners, encoderGroupWithBucketCol), encoderGroupWithBucketCol, bucketColIdx, sparkSession, rowKindColIdx);
        } else if (((Object)((Object)BucketMode.BUCKET_UNAWARE)).equals((Object)bucketMode2)) {
            dataset = this.writeWithoutBucket$1(data, sparkSession, rowKindColIdx);
        } else if (((Object)((Object)BucketMode.HASH_FIXED)).equals((Object)bucketMode2)) {
            dataset = this.writeWithBucketProcessor$1(withInitBucketCol, new CommonBucketProcessor(this.table(), bucketColIdx, encoderGroupWithBucketCol), encoderGroupWithBucketCol, bucketColIdx, sparkSession, rowKindColIdx);
        } else {
            throw new UnsupportedOperationException(new StringBuilder(28).append("Spark doesn't support ").append((Object)this.bucketMode()).append(" mode.").toString());
        }
        Dataset written = dataset;
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])written.collect())).map((Function1 & Serializable & scala.Serializable)x$3 -> this.deserializeCommitMessage(this.serializer(), (byte[])x$3), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(CommitMessage.class))))).toSeq();
    }

    public Seq<CommitMessage> persistDeletionVectors(Dataset<SparkDeletionVectors> deletionVectors) {
        SparkSession sparkSession = deletionVectors.sparkSession();
        Long snapshotId = this.table().snapshotManager().latestSnapshotId();
        Dataset serializedCommits = deletionVectors.groupByKey((Function1 & Serializable & scala.Serializable)x$4 -> x$4.partitionAndBucket(), sparkSession.implicits().newStringEncoder()).mapGroups((Function2 & Serializable & scala.Serializable)(x$5, iter) -> {
            IndexFileHandler indexHandler = this.table().store().newIndexFileHandler();
            ObjectRef dvIndexFileMaintainer = ObjectRef.create(null);
            while (iter.hasNext()) {
                SparkDeletionVectors sdv = (SparkDeletionVectors)iter.next();
                if ((AppendDeletionFileMaintainer)dvIndexFileMaintainer.elem == null) {
                    BinaryRow partition = SerializationUtils.deserializeBinaryRow(sdv.partition());
                    BucketMode bucketMode = this.bucketMode();
                    BucketMode bucketMode2 = BucketMode.BUCKET_UNAWARE;
                    Object object = !(bucketMode != null ? !((Object)((Object)bucketMode)).equals((Object)bucketMode2) : bucketMode2 != null) ? AppendDeletionFileMaintainer.forUnawareAppend(indexHandler, snapshotId, partition) : (dvIndexFileMaintainer.elem = AppendDeletionFileMaintainer.forBucketedAppend(indexHandler, snapshotId, partition, sdv.bucket()));
                }
                if ((AppendDeletionFileMaintainer)dvIndexFileMaintainer.elem == null) {
                    throw new RuntimeException("can't create the dv maintainer.");
                }
                sdv.dataFileAndDeletionVector().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    PaimonSparkWriter.$anonfun$persistDeletionVectors$3(dvIndexFileMaintainer, x0$1);
                    return BoxedUnit.UNIT;
                });
            }
            java.util.List<IndexManifestEntry> indexEntries = ((AppendDeletionFileMaintainer)dvIndexFileMaintainer.elem).persist();
            Tuple2 tuple2 = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(indexEntries).asScala()).partition((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)PaimonSparkWriter.$anonfun$persistDeletionVectors$4(x$6)));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Buffer added = (Buffer)tuple2._1();
            Buffer deleted = (Buffer)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)added, (Object)deleted);
            Tuple2 tuple23 = tuple22;
            Buffer added2 = (Buffer)tuple23._1();
            Buffer deleted2 = (Buffer)tuple23._2();
            CommitMessageImpl commitMessage = new CommitMessageImpl(((AppendDeletionFileMaintainer)dvIndexFileMaintainer.elem).getPartition(), ((AppendDeletionFileMaintainer)dvIndexFileMaintainer.elem).getBucket(), DataIncrement.emptyIncrement(), CompactIncrement.emptyIncrement(), new IndexIncrement((java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)added2.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.indexFile(), Buffer$.MODULE$.canBuildFrom())).asJava(), (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)deleted2.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.indexFile(), Buffer$.MODULE$.canBuildFrom())).asJava()));
            CommitMessageSerializer serializer = new CommitMessageSerializer();
            return serializer.serialize(commitMessage);
        }, sparkSession.implicits().newByteArrayEncoder());
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])serializedCommits.collect())).map((Function1 & Serializable & scala.Serializable)x$10 -> this.deserializeCommitMessage(this.serializer(), (byte[])x$10), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public Seq<CommitMessage> buildCommitMessageFromIndexManifestEntry(Seq<IndexManifestEntry> indexManifestEntries) {
        return ((TraversableOnce)indexManifestEntries.groupBy((Function1 & Serializable & scala.Serializable)entry -> new Tuple2((Object)entry.partition(), (Object)BoxesRunTime.boxToInteger((int)entry.bucket()))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Tuple2 tuple22 = (Tuple2)tuple2._1();
            Seq entries = (Seq)tuple2._2();
            if (tuple22 == null) throw new MatchError((Object)tuple2);
            BinaryRow partition = (BinaryRow)tuple22._1();
            int bucket = tuple22._2$mcI$sp();
            Tuple2 tuple23 = entries.partition((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)PaimonSparkWriter.$anonfun$buildCommitMessageFromIndexManifestEntry$3(x$11)));
            if (tuple23 == null) throw new MatchError((Object)tuple23);
            Seq added = (Seq)tuple23._1();
            Seq removed = (Seq)tuple23._2();
            Tuple2 tuple24 = new Tuple2((Object)added, (Object)removed);
            Tuple2 tuple25 = tuple24;
            Seq added2 = (Seq)tuple25._1();
            Seq removed2 = (Seq)tuple25._2();
            return new CommitMessageImpl(partition, bucket, DataIncrement.emptyIncrement(), CompactIncrement.emptyIncrement(), new IndexIncrement((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)added2.map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.indexFile(), Seq$.MODULE$.canBuildFrom())).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)removed2.map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.indexFile(), Seq$.MODULE$.canBuildFrom())).asJava()));
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    public void commit(Seq<CommitMessage> commitMessages) {
        try (BatchTableCommit tableCommit = this.writeBuilder().newCommit();){
            try {
                tableCommit.commit((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)commitMessages.toList()).asJava());
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    private RDD<Tuple2<KeyPartOrRow, byte[]>> bootstrapAndRepartitionByKeyHash(Dataset<Row> data, int parallelism, int rowKindColIdx, RowType rowType) {
        int numSparkPartitions = data.rdd().getNumPartitions();
        java.util.List<String> primaryKeys = this.table().schema().primaryKeys();
        RowType bootstrapType = IndexBootstrap.bootstrapType(this.table().schema());
        return RDD$.MODULE$.rddToPairRDDFunctions(data.rdd().mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            int sparkPartitionId = TaskContext$.MODULE$.getPartitionId();
            Projection keyPartProject = CodeGenUtils.newProjection(bootstrapType, primaryKeys);
            Projection rowProject = CodeGenUtils.newProjection(rowType, primaryKeys);
            InternalRowSerializer bootstrapSer = InternalSerializers.create(bootstrapType);
            InternalRowSerializer rowSer = InternalSerializers.create(rowType);
            CloseableIterator<InternalRow> bootstrapIterator = new IndexBootstrap(this.table()).bootstrap(numSparkPartitions, sparkPartitionId).toCloseableIterator();
            TaskContext$.MODULE$.get().addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$15 -> {
                bootstrapIterator.close();
                return BoxedUnit.UNIT;
            });
            return ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(bootstrapIterator).asScala()).map((Function1 & Serializable & scala.Serializable)row -> {
                byte[] bytes = SerializationUtils.serializeBinaryRow(bootstrapSer.toBinaryRow((InternalRow)row));
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)Math.abs(keyPartProject.apply((InternalRow)row).hashCode())), (Object)new Tuple2((Object)KeyPartOrRow.KEY_PART, (Object)bytes));
            }).$plus$plus((Function0 & Serializable & scala.Serializable)() -> iter.map((Function1 & Serializable & scala.Serializable)r -> {
                SparkRow sparkRow = new SparkRow(rowType, (Row)r, SparkRowUtils$.MODULE$.getRowKind((Row)r, rowKindColIdx));
                byte[] bytes = SerializationUtils.serializeBinaryRow(rowSer.toBinaryRow(sparkRow));
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)Math.abs(rowProject.apply(sparkRow).hashCode())), (Object)new Tuple2((Object)KeyPartOrRow.ROW, (Object)bytes));
            }));
        }, data.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).partitionBy((Partitioner)new ModPartitioner(this, parallelism)).map((Function1 & Serializable & scala.Serializable)x$16 -> (Tuple2)x$16._2(), ClassTag$.MODULE$.apply(Tuple2.class));
    }

    private Dataset<Row> repartitionByKeyPartitionHash(SparkSession sparkSession, Dataset<Row> data, int parallelism, int numAssigners) {
        return sparkSession.createDataFrame(RDD$.MODULE$.rddToPairRDDFunctions(data.rdd().mapPartitions((Function1 & Serializable & scala.Serializable)iterator -> {
            RowPartitionKeyExtractor rowPartitionKeyExtractor = new RowPartitionKeyExtractor(this.tableSchema());
            return iterator.map((Function1 & Serializable & scala.Serializable)row -> {
                SparkRow sparkRow = new SparkRow(this.rowType(), (Row)row);
                int partitionHash = rowPartitionKeyExtractor.partition(sparkRow).hashCode();
                int keyHash = rowPartitionKeyExtractor.trimmedPrimaryKey(sparkRow).hashCode();
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)BucketAssigner.computeHashKey(partitionHash, keyHash, parallelism, numAssigners)), row);
            });
        }, data.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Row.class), (Ordering)Ordering.Int$.MODULE$).partitionBy((Partitioner)new ModPartitioner(this, parallelism)).map((Function1 & Serializable & scala.Serializable)x$17 -> (Row)x$17._2(), ClassTag$.MODULE$.apply(Row.class)), data.schema());
    }

    private Dataset<Row> repartitionByPartitionsAndBucket(Dataset<Row> df) {
        Seq partitionCols = ((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.tableSchema().partitionKeys()).asScala()).map((Function1 & Serializable & scala.Serializable)colName -> functions$.MODULE$.col(colName), Buffer$.MODULE$.canBuildFrom())).toSeq();
        return df.repartition((Seq)partitionCols.$plus$plus((GenTraversableOnce)new .colon.colon((Object)functions$.MODULE$.col(SparkSystemColumns$.MODULE$.BUCKET_COL()), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom()));
    }

    private CommitMessage deserializeCommitMessage(CommitMessageSerializer serializer, byte[] bytes) {
        CommitMessage commitMessage;
        try {
            commitMessage = serializer.deserialize(serializer.getVersion(), bytes);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to deserialize CommitMessage's object", e);
        }
        return commitMessage;
    }

    public PaimonSparkWriter copy(FileStoreTable table) {
        return new PaimonSparkWriter(table);
    }

    public FileStoreTable copy$default$1() {
        return this.table();
    }

    public String productPrefix() {
        return "PaimonSparkWriter";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return this.table();
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof PaimonSparkWriter;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof PaimonSparkWriter)) return false;
        boolean bl = true;
        if (!bl) return false;
        PaimonSparkWriter paimonSparkWriter = (PaimonSparkWriter)x$1;
        FileStoreTable fileStoreTable = this.table();
        FileStoreTable fileStoreTable2 = paimonSparkWriter.table();
        if (fileStoreTable == null) {
            if (fileStoreTable2 != null) {
                return false;
            }
        } else if (!fileStoreTable.equals(fileStoreTable2)) return false;
        if (!paimonSparkWriter.canEqual(this)) return false;
        return true;
    }

    private final void ModPartitioner$lzycompute$1() {
        PaimonSparkWriter paimonSparkWriter = this;
        synchronized (paimonSparkWriter) {
            if (this.ModPartitioner$module == null) {
                this.ModPartitioner$module = new PaimonSparkWriter$ModPartitioner$(this);
            }
        }
    }

    private final SparkTableWrite newWrite$1(int rowKindColIdx$1) {
        return new SparkTableWrite(this.writeBuilder(), this.rowType(), rowKindColIdx$1);
    }

    private static final int sparkParallelism$1(SparkSession sparkSession$1) {
        int defaultParallelism = sparkSession$1.sparkContext().defaultParallelism();
        int numShufflePartitions = sparkSession$1.sessionState().conf().numShufflePartitions();
        return Math.max(defaultParallelism, numShufflePartitions);
    }

    private final Dataset writeWithoutBucket$1(Dataset dataFrame, SparkSession sparkSession$1, int rowKindColIdx$1) {
        return dataFrame.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            Iterator<byte[]> iterator;
            try (SparkTableWrite write = this.newWrite$1(rowKindColIdx$1);){
                iter.foreach((Function1 & Serializable & scala.Serializable)row -> {
                    write.write(row);
                    return BoxedUnit.UNIT;
                });
                iterator = write.finish();
            }
            return iterator;
        }, sparkSession$1.implicits().newByteArrayEncoder());
    }

    private final Dataset writeWithBucket$1(Dataset dataFrame, int bucketColIdx$1, SparkSession sparkSession$1, int rowKindColIdx$1) {
        return dataFrame.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            Iterator<byte[]> iterator;
            try (SparkTableWrite write = this.newWrite$1(rowKindColIdx$1);){
                iter.foreach((Function1 & Serializable & scala.Serializable)row -> {
                    write.write(row, row.getInt(bucketColIdx$1));
                    return BoxedUnit.UNIT;
                });
                iterator = write.finish();
            }
            return iterator;
        }, sparkSession$1.implicits().newByteArrayEncoder());
    }

    private final Dataset writeWithBucketProcessor$1(Dataset dataFrame, BucketProcessor processor, EncoderSerDeGroup encoderGroupWithBucketCol$1, int bucketColIdx$1, SparkSession sparkSession$1, int rowKindColIdx$1) {
        Dataset<Row> repartitioned = this.repartitionByPartitionsAndBucket((Dataset<Row>)dataFrame.mapPartitions((Function1 & Serializable & scala.Serializable)rowIterator -> processor.processPartition(rowIterator), encoderGroupWithBucketCol$1.encoder()).toDF());
        return this.writeWithBucket$1(repartitioned, bucketColIdx$1, sparkSession$1, rowKindColIdx$1);
    }

    private final Dataset writeWithBucketAssigner$1(Dataset dataFrame, Function0 funcFactory, SparkSession sparkSession$1, int rowKindColIdx$1) {
        return dataFrame.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            Iterator<byte[]> iterator;
            Function1 assigner = (Function1)funcFactory.apply();
            try (SparkTableWrite write = this.newWrite$1(rowKindColIdx$1);){
                iter.foreach((Function1 & Serializable & scala.Serializable)row -> {
                    write.write(row, BoxesRunTime.unboxToInt((Object)assigner.apply((Object)row)));
                    return BoxedUnit.UNIT;
                });
                iterator = write.finish();
            }
            return iterator;
        }, sparkSession$1.implicits().newByteArrayEncoder());
    }

    public static final /* synthetic */ int $anonfun$write$13(int assignerParallelism$1, Integer initialBuckets) {
        return Math.min(Predef$.MODULE$.Integer2int(initialBuckets), assignerParallelism$1);
    }

    private final Dataset partitionByKey$1(SparkSession sparkSession$1, Dataset withInitBucketCol$1, int assignerParallelism$1, int numAssigners$1) {
        return this.repartitionByKeyPartitionHash(sparkSession$1, (Dataset<Row>)withInitBucketCol$1, assignerParallelism$1, numAssigners$1);
    }

    public static final /* synthetic */ int $anonfun$write$16(PaimonSparkWriter $this, SimpleHashBucketAssigner assigner$2, RowPartitionKeyExtractor extractor$1, Row row) {
        SparkRow sparkRow = new SparkRow($this.rowType(), row);
        return assigner$2.assign(extractor$1.partition(sparkRow), extractor$1.trimmedPrimaryKey(sparkRow).hashCode());
    }

    public static final /* synthetic */ void $anonfun$persistDeletionVectors$3(ObjectRef dvIndexFileMaintainer$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String dataFileName = (String)tuple2._1();
        byte[] dv = (byte[])tuple2._2();
        ((AppendDeletionFileMaintainer)dvIndexFileMaintainer$1.elem).notifyNewDeletionVector(dataFileName, DeletionVector.deserializeFromBytes(dv));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$persistDeletionVectors$4(IndexManifestEntry x$6) {
        FileKind fileKind = x$6.kind();
        FileKind fileKind2 = FileKind.ADD;
        return !(fileKind != null ? !((Object)((Object)fileKind)).equals((Object)fileKind2) : fileKind2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$buildCommitMessageFromIndexManifestEntry$3(IndexManifestEntry x$11) {
        FileKind fileKind = x$11.kind();
        FileKind fileKind2 = FileKind.ADD;
        return !(fileKind != null ? !((Object)((Object)fileKind)).equals((Object)fileKind2) : fileKind2 != null);
    }

    public PaimonSparkWriter(FileStoreTable table) {
        this.table = table;
        Product.$init$((Product)this);
        this.writeBuilder = table.newBatchWriteBuilder();
    }

    private class ModPartitioner
    extends Partitioner
    implements Product {
        private final int partitions;
        public final /* synthetic */ PaimonSparkWriter $outer;

        public int partitions() {
            return this.partitions;
        }

        public int numPartitions() {
            return this.partitions();
        }

        public int getPartition(Object key) {
            return BoxesRunTime.unboxToInt((Object)key) % this.numPartitions();
        }

        public ModPartitioner copy(int partitions) {
            return new ModPartitioner(this.org$apache$paimon$spark$commands$PaimonSparkWriter$ModPartitioner$$$outer(), partitions);
        }

        public int copy$default$1() {
            return this.partitions();
        }

        public String productPrefix() {
            return "ModPartitioner";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return BoxesRunTime.boxToInteger((int)this.partitions());
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ModPartitioner;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.partitions());
            return Statics.finalizeHash((int)n, (int)1);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ModPartitioner)) return false;
            if (((ModPartitioner)((Object)object)).org$apache$paimon$spark$commands$PaimonSparkWriter$ModPartitioner$$$outer() != this.org$apache$paimon$spark$commands$PaimonSparkWriter$ModPartitioner$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ModPartitioner modPartitioner = (ModPartitioner)((Object)x$1);
            if (this.partitions() != modPartitioner.partitions()) return false;
            if (!modPartitioner.canEqual((Object)this)) return false;
            return true;
        }

        public /* synthetic */ PaimonSparkWriter org$apache$paimon$spark$commands$PaimonSparkWriter$ModPartitioner$$$outer() {
            return this.$outer;
        }

        public ModPartitioner(PaimonSparkWriter $outer, int partitions) {
            this.partitions = partitions;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

