/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;

public class ProjectedArray
implements InternalArray {
    private final int[] indexMapping;
    private InternalArray array;

    private ProjectedArray(int[] indexMapping) {
        this.indexMapping = indexMapping;
    }

    public ProjectedArray replaceArray(InternalArray array) {
        this.array = array;
        return this;
    }

    @Override
    public int size() {
        return this.indexMapping.length;
    }

    @Override
    public boolean isNullAt(int pos) {
        if (this.indexMapping[pos] < 0) {
            return true;
        }
        return this.array.isNullAt(this.indexMapping[pos]);
    }

    @Override
    public boolean getBoolean(int pos) {
        return this.array.getBoolean(this.indexMapping[pos]);
    }

    @Override
    public byte getByte(int pos) {
        return this.array.getByte(this.indexMapping[pos]);
    }

    @Override
    public short getShort(int pos) {
        return this.array.getShort(this.indexMapping[pos]);
    }

    @Override
    public int getInt(int pos) {
        return this.array.getInt(this.indexMapping[pos]);
    }

    @Override
    public long getLong(int pos) {
        return this.array.getLong(this.indexMapping[pos]);
    }

    @Override
    public float getFloat(int pos) {
        return this.array.getFloat(this.indexMapping[pos]);
    }

    @Override
    public double getDouble(int pos) {
        return this.array.getDouble(this.indexMapping[pos]);
    }

    @Override
    public BinaryString getString(int pos) {
        return this.array.getString(this.indexMapping[pos]);
    }

    @Override
    public Decimal getDecimal(int pos, int precision, int scale) {
        return this.array.getDecimal(this.indexMapping[pos], precision, scale);
    }

    @Override
    public Timestamp getTimestamp(int pos, int precision) {
        return this.array.getTimestamp(this.indexMapping[pos], precision);
    }

    @Override
    public byte[] getBinary(int pos) {
        return this.array.getBinary(this.indexMapping[pos]);
    }

    @Override
    public InternalArray getArray(int pos) {
        return this.array.getArray(this.indexMapping[pos]);
    }

    @Override
    public InternalMap getMap(int pos) {
        return this.array.getMap(this.indexMapping[pos]);
    }

    @Override
    public InternalRow getRow(int pos, int numFields) {
        return this.array.getRow(this.indexMapping[pos], numFields);
    }

    public boolean equals(Object o) {
        throw new UnsupportedOperationException("Projected row data cannot be compared");
    }

    public int hashCode() {
        throw new UnsupportedOperationException("Projected row data cannot be hashed");
    }

    public String toString() {
        throw new UnsupportedOperationException("Projected row data cannot be toString");
    }

    public static ProjectedArray from(int[] projection) {
        return new ProjectedArray(projection);
    }

    @Override
    public boolean[] toBooleanArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] toByteArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public short[] toShortArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] toIntArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long[] toLongArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public float[] toFloatArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double[] toDoubleArray() {
        throw new UnsupportedOperationException();
    }
}

