/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.paimon.Snapshot;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.manifest.ManifestFileMeta;
import org.apache.paimon.manifest.ManifestList;
import org.apache.paimon.partition.PartitionPredicate;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.stats.SimpleStats;
import org.apache.paimon.table.source.ScanMode;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.SnapshotManager;

@ThreadSafe
public class ManifestsReader {
    private final RowType partitionType;
    private final String partitionDefaultValue;
    private final SnapshotManager snapshotManager;
    private final ManifestList.Factory manifestListFactory;
    private boolean onlyReadRealBuckets = false;
    @Nullable
    private Integer specifiedBucket = null;
    @Nullable
    private Integer specifiedLevel = null;
    @Nullable
    private PartitionPredicate partitionFilter = null;

    public ManifestsReader(RowType partitionType, String partitionDefaultValue, SnapshotManager snapshotManager, ManifestList.Factory manifestListFactory) {
        this.partitionType = partitionType;
        this.partitionDefaultValue = partitionDefaultValue;
        this.snapshotManager = snapshotManager;
        this.manifestListFactory = manifestListFactory;
    }

    public ManifestsReader onlyReadRealBuckets() {
        this.onlyReadRealBuckets = true;
        return this;
    }

    public ManifestsReader withBucket(int bucket) {
        this.specifiedBucket = bucket;
        return this;
    }

    public ManifestsReader withLevel(int level) {
        this.specifiedLevel = level;
        return this;
    }

    public ManifestsReader withPartitionFilter(Predicate predicate) {
        this.partitionFilter = PartitionPredicate.fromPredicate(this.partitionType, predicate);
        return this;
    }

    public ManifestsReader withPartitionFilter(List<BinaryRow> partitions) {
        this.partitionFilter = PartitionPredicate.fromMultiple(this.partitionType, partitions);
        return this;
    }

    public ManifestsReader withPartitionsFilter(List<Map<String, String>> partitions) {
        return this.withPartitionFilter(PartitionPredicate.createBinaryPartitions(partitions, this.partitionType, this.partitionDefaultValue));
    }

    public ManifestsReader withPartitionFilter(PartitionPredicate predicate) {
        this.partitionFilter = predicate;
        return this;
    }

    @Nullable
    public PartitionPredicate partitionFilter() {
        return this.partitionFilter;
    }

    public Result read(@Nullable Snapshot specifiedSnapshot, ScanMode scanMode) {
        Snapshot snapshot = specifiedSnapshot == null ? this.snapshotManager.latestSnapshot() : specifiedSnapshot;
        List<Object> manifests = snapshot == null ? Collections.emptyList() : this.readManifests(snapshot, scanMode);
        List<ManifestFileMeta> filtered = manifests.stream().filter(this::filterManifestFileMeta).collect(Collectors.toList());
        return new Result(snapshot, manifests, filtered);
    }

    private List<ManifestFileMeta> readManifests(Snapshot snapshot, ScanMode scanMode) {
        ManifestList manifestList = this.manifestListFactory.create();
        switch (scanMode) {
            case ALL: {
                return manifestList.readDataManifests(snapshot);
            }
            case DELTA: {
                return manifestList.readDeltaManifests(snapshot);
            }
            case CHANGELOG: {
                if (snapshot.version() <= 1) {
                    throw new UnsupportedOperationException("Unsupported snapshot version: " + snapshot.version());
                }
                return manifestList.readChangelogManifests(snapshot);
            }
        }
        throw new UnsupportedOperationException("Unknown scan kind " + scanMode.name());
    }

    private boolean filterManifestFileMeta(ManifestFileMeta manifest) {
        Integer minBucket = manifest.minBucket();
        Integer maxBucket = manifest.maxBucket();
        if (minBucket != null && maxBucket != null) {
            if (this.onlyReadRealBuckets && maxBucket < 0) {
                return false;
            }
            if (this.specifiedBucket != null && (this.specifiedBucket < minBucket || this.specifiedBucket > maxBucket)) {
                return false;
            }
        }
        Integer minLevel = manifest.minLevel();
        Integer maxLevel = manifest.maxLevel();
        if (minLevel != null && maxLevel != null && this.specifiedLevel != null && (this.specifiedLevel < minLevel || this.specifiedLevel > maxLevel)) {
            return false;
        }
        if (this.partitionFilter == null) {
            return true;
        }
        SimpleStats stats = manifest.partitionStats();
        return this.partitionFilter == null || this.partitionFilter.test(manifest.numAddedFiles() + manifest.numDeletedFiles(), stats.minValues(), stats.maxValues(), stats.nullCounts());
    }

    public static Result emptyResult() {
        return new Result(null, Collections.emptyList(), Collections.emptyList());
    }

    public static final class Result {
        public final Snapshot snapshot;
        public final List<ManifestFileMeta> allManifests;
        public final List<ManifestFileMeta> filteredManifests;

        public Result(Snapshot snapshot, List<ManifestFileMeta> allManifests, List<ManifestFileMeta> filteredManifests) {
            this.snapshot = snapshot;
            this.allManifests = allManifests;
            this.filteredManifests = filteredManifests;
        }
    }
}

