/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.commands;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.Snapshot;
import org.apache.paimon.codegen.CodeGenUtils;
import org.apache.paimon.codegen.Projection;
import org.apache.paimon.crosspartition.IndexBootstrap;
import org.apache.paimon.crosspartition.KeyPartOrRow;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.serializer.InternalRowSerializer;
import org.apache.paimon.data.serializer.InternalSerializers;
import org.apache.paimon.deletionvectors.DeletionVector;
import org.apache.paimon.deletionvectors.append.AppendDeletionFileMaintainer;
import org.apache.paimon.index.BucketAssigner;
import org.apache.paimon.index.IndexFileHandler;
import org.apache.paimon.index.SimpleHashBucketAssigner;
import org.apache.paimon.io.CompactIncrement;
import org.apache.paimon.io.DataIncrement;
import org.apache.paimon.io.IndexIncrement;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.manifest.IndexManifestEntry;
import org.apache.paimon.options.Options;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.spark.SparkRow;
import org.apache.paimon.spark.SparkTableWrite;
import org.apache.paimon.spark.SparkTypeUtils;
import org.apache.paimon.spark.commands.BucketExpression$;
import org.apache.paimon.spark.commands.BucketProcessor;
import org.apache.paimon.spark.commands.CommonBucketProcessor;
import org.apache.paimon.spark.commands.DynamicBucketProcessor;
import org.apache.paimon.spark.commands.EncoderSerDeGroup;
import org.apache.paimon.spark.commands.GlobalDynamicBucketProcessor;
import org.apache.paimon.spark.commands.PaimonSparkWriter$;
import org.apache.paimon.spark.commands.PaimonSparkWriter$ModPartitioner$;
import org.apache.paimon.spark.commands.SparkDeletionVectors;
import org.apache.paimon.spark.schema.SparkSystemColumns$;
import org.apache.paimon.spark.util.OptionUtils$;
import org.apache.paimon.spark.util.SparkRowUtils$;
import org.apache.paimon.table.BucketMode;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.sink.BatchTableCommit;
import org.apache.paimon.table.sink.BatchWriteBuilder;
import org.apache.paimon.table.sink.CommitMessage;
import org.apache.paimon.table.sink.CommitMessageImpl;
import org.apache.paimon.table.sink.CommitMessageSerializer;
import org.apache.paimon.table.sink.RowPartitionKeyExtractor;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.CloseableIterator;
import org.apache.paimon.utils.InternalRowPartitionComputer;
import org.apache.paimon.utils.PartitionPathUtils;
import org.apache.paimon.utils.PartitionStatisticsReporter;
import org.apache.paimon.utils.SerializationUtils;
import org.apache.spark.Partitioner;
import org.apache.spark.TaskContext$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r\ra\u0001\u0002\u001f>\u0001\"C\u0001\"\u0016\u0001\u0003\u0016\u0004%\tA\u0016\u0005\t9\u0002\u0011\t\u0012)A\u0005/\")Q\f\u0001C\u0001=\"A!\r\u0001EC\u0002\u0013%1\r\u0003\u0005k\u0001!\u0015\r\u0011\"\u0003l\u0011!\u0011\b\u0001#b\u0001\n\u0013\u0019\b\u0002C<\u0001\u0011\u000b\u0007I\u0011\u0002=\t\u0013}\u0004\u0001R1A\u0005\n\u0005\u0005\u0001\"CA\f\u0001\t\u0007I\u0011AA\r\u0011!\t\t\u0003\u0001Q\u0001\n\u0005m\u0001bBA\u0012\u0001\u0011\u0005\u0011Q\u0005\u0005\b\u0003O\u0001A\u0011AA\u0015\u0011\u001d\ty\u0007\u0001C\u0001\u0003cBq!!\"\u0001\t\u0003\t9\tC\u0004\u0002\u001c\u0002!I!!(\t\u000f\u0005%\u0006\u0001\"\u0001\u0002,\"9\u0011\u0011\u0017\u0001\u0005\n\u0005M\u0006bBAy\u0001\u0011%\u00111\u001f\u0005\b\u0005\u000f\u0001A\u0011\u0002B\u0005\u0011\u001d\u0011y\u0001\u0001C\u0005\u0005#1aA!\u0007\u0001\t\nm\u0001B\u0003B\u0013+\tU\r\u0011\"\u0001\u0003(!Q!\u0011F\u000b\u0003\u0012\u0003\u0006I!!:\t\ru+B\u0011\u0001B\u0016\u0011\u001d\u0011\u0019$\u0006C!\u0005OAqA!\u000e\u0016\t\u0003\u00129\u0004C\u0005\u0003DU\t\t\u0011\"\u0001\u0003F!I!\u0011J\u000b\u0012\u0002\u0013\u0005!1\n\u0005\n\u0005C*\u0012\u0011!C!\u0005GB\u0011B!\u001e\u0016\u0003\u0003%\tAa\n\t\u0013\t]T#!A\u0005\u0002\te\u0004\"\u0003B@+\u0005\u0005I\u0011\tBA\u0011%\u0011y)FA\u0001\n\u0003\u0011\t\nC\u0005\u0003\u001cV\t\t\u0011\"\u0011\u0003\u001e\"I!qT\u000b\u0002\u0002\u0013\u0005#\u0011\u0015\u0005\n\u0005G+\u0012\u0011!C!\u0005K;\u0011B!+\u0001\u0003\u0003EIAa+\u0007\u0013\te\u0001!!A\t\n\t5\u0006BB/'\t\u0003\u0011Y\fC\u0005\u0003 \u001a\n\t\u0011\"\u0012\u0003\"\"I!Q\u0018\u0014\u0002\u0002\u0013\u0005%q\u0018\u0005\n\u0005\u00074\u0013\u0011!CA\u0005\u000bD\u0011Ba\u0011\u0001\u0003\u0003%\tA!5\t\u0013\t%\u0003!%A\u0005\u0002\tU\u0007\"\u0003B1\u0001\u0005\u0005I\u0011\tB2\u0011%\u0011)\bAA\u0001\n\u0003\u00119\u0003C\u0005\u0003x\u0001\t\t\u0011\"\u0001\u0003Z\"I!q\u0010\u0001\u0002\u0002\u0013\u0005#\u0011\u0011\u0005\n\u0005\u001f\u0003\u0011\u0011!C\u0001\u0005;D\u0011Ba'\u0001\u0003\u0003%\tE!(\t\u0013\t}\u0005!!A\u0005B\t\u0005\u0006\"\u0003BR\u0001\u0005\u0005I\u0011\tBq\u000f%\u0011)/PA\u0001\u0012\u0003\u00119O\u0002\u0005={\u0005\u0005\t\u0012\u0001Bu\u0011\u0019if\u0007\"\u0001\u0003n\"I!q\u0014\u001c\u0002\u0002\u0013\u0015#\u0011\u0015\u0005\n\u0005{3\u0014\u0011!CA\u0005_D\u0011Ba17\u0003\u0003%\tIa=\t\u0013\teh'!A\u0005\n\tm(!\u0005)bS6|gn\u00159be.<&/\u001b;fe*\u0011ahP\u0001\tG>lW.\u00198eg*\u0011\u0001)Q\u0001\u0006gB\f'o\u001b\u0006\u0003\u0005\u000e\u000ba\u0001]1j[>t'B\u0001#F\u0003\u0019\t\u0007/Y2iK*\ta)A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u0013>\u0013\u0006C\u0001&N\u001b\u0005Y%\"\u0001'\u0002\u000bM\u001c\u0017\r\\1\n\u00059[%AB!osJ+g\r\u0005\u0002K!&\u0011\u0011k\u0013\u0002\b!J|G-^2u!\tQ5+\u0003\u0002U\u0017\na1+\u001a:jC2L'0\u00192mK\u0006)A/\u00192mKV\tq\u000b\u0005\u0002Y56\t\u0011L\u0003\u0002V\u0003&\u00111,\u0017\u0002\u000f\r&dWm\u0015;pe\u0016$\u0016M\u00197f\u0003\u0019!\u0018M\u00197fA\u00051A(\u001b8jiz\"\"aX1\u0011\u0005\u0001\u0004Q\"A\u001f\t\u000bU\u001b\u0001\u0019A,\u0002\u0017Q\f'\r\\3TG\",W.Y\u000b\u0002IB\u0011Q\r[\u0007\u0002M*\u0011q-Q\u0001\u0007g\u000eDW-\\1\n\u0005%4'a\u0003+bE2,7k\u00195f[\u0006\fqA]8x)f\u0004X-F\u0001m!\ti\u0007/D\u0001o\u0015\ty\u0017)A\u0003usB,7/\u0003\u0002r]\n9!k\\<UsB,\u0017A\u00032vG.,G/T8eKV\tA\u000f\u0005\u0002Yk&\u0011a/\u0017\u0002\u000b\u0005V\u001c7.\u001a;N_\u0012,\u0017a\u00017pOV\t\u0011\u0010\u0005\u0002{{6\t1P\u0003\u0002}\u000b\u0006)1\u000f\u001c45U&\u0011ap\u001f\u0002\u0007\u0019><w-\u001a:\u0002\u0015M,'/[1mSj,'/\u0006\u0002\u0002\u0004A!\u0011QAA\u0006\u001b\t\t9AC\u0002\u0002\ne\u000bAa]5oW&!\u0011QBA\u0004\u0005]\u0019u.\\7ji6+7o]1hKN+'/[1mSj,'\u000fK\u0002\t\u0003#\u00012ASA\n\u0013\r\t)b\u0013\u0002\niJ\fgn]5f]R\fAb\u001e:ji\u0016\u0014U/\u001b7eKJ,\"!a\u0007\u0011\t\u0005\u0015\u0011QD\u0005\u0005\u0003?\t9AA\tCCR\u001c\u0007n\u0016:ji\u0016\u0014U/\u001b7eKJ\fQb\u001e:ji\u0016\u0014U/\u001b7eKJ\u0004\u0013!C<sSR,wJ\u001c7z)\u0005y\u0016!B<sSR,G\u0003BA\u0016\u0003\u0013\u0002b!!\f\u0002>\u0005\rc\u0002BA\u0018\u0003sqA!!\r\u000285\u0011\u00111\u0007\u0006\u0004\u0003k9\u0015A\u0002\u001fs_>$h(C\u0001M\u0013\r\tYdS\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ty$!\u0011\u0003\u0007M+\u0017OC\u0002\u0002<-\u0003B!!\u0002\u0002F%!\u0011qIA\u0004\u00055\u0019u.\\7ji6+7o]1hK\"9\u00111\n\u0007A\u0002\u00055\u0013\u0001\u00023bi\u0006\u0004B!a\u0014\u0002j9!\u0011\u0011KA3\u001d\u0011\t\u0019&a\u0018\u000f\t\u0005U\u0013Q\f\b\u0005\u0003/\nYF\u0004\u0003\u00022\u0005e\u0013\"\u0001$\n\u0005\u0011+\u0015B\u0001!D\u0013\u0011\t\t'a\u0019\u0002\u0007M\fHN\u0003\u0002A\u0007&!\u00111HA4\u0015\u0011\t\t'a\u0019\n\t\u0005-\u0014Q\u000e\u0002\n\t\u0006$\u0018M\u0012:b[\u0016TA!a\u000f\u0002h\u00051\u0002/\u001a:tSN$H)\u001a7fi&|gNV3di>\u00148\u000f\u0006\u0003\u0002,\u0005M\u0004bBA;\u001b\u0001\u0007\u0011qO\u0001\u0010I\u0016dW\r^5p]Z+7\r^8sgB1\u0011\u0011PA>\u0003\u007fj!!a\u001a\n\t\u0005u\u0014q\r\u0002\b\t\u0006$\u0018m]3u!\r\u0001\u0017\u0011Q\u0005\u0004\u0003\u0007k$\u0001F*qCJ\\G)\u001a7fi&|gNV3di>\u00148/\u0001\u0015ck&dGmQ8n[&$X*Z:tC\u001e,gI]8n\u0013:$W\r_'b]&4Wm\u001d;F]R\u0014\u0018\u0010\u0006\u0003\u0002,\u0005%\u0005bBAF\u001d\u0001\u0007\u0011QR\u0001\u0015S:$W\r_'b]&4Wm\u001d;F]R\u0014\u0018.Z:\u0011\r\u00055\u0012QHAH!\u0011\t\t*a&\u000e\u0005\u0005M%bAAK\u0003\u0006AQ.\u00198jM\u0016\u001cH/\u0003\u0003\u0002\u001a\u0006M%AE%oI\u0016DX*\u00198jM\u0016\u001cH/\u00128uef\f1B]3q_J$Hk\u001c%ngR!\u0011qTAS!\rQ\u0015\u0011U\u0005\u0004\u0003G[%\u0001B+oSRDq!a*\u0010\u0001\u0004\tY#\u0001\u0005nKN\u001c\u0018mZ3t\u0003\u0019\u0019w.\\7jiR!\u0011qTAW\u0011\u001d\ty\u000b\u0005a\u0001\u0003W\tabY8n[&$X*Z:tC\u001e,7/\u0001\u0011c_>$8\u000f\u001e:ba\u0006sGMU3qCJ$\u0018\u000e^5p]\nK8*Z=ICNDGCCA[\u0003?\f\t/a;\u0002pB1\u0011qWA_\u0003\u0003l!!!/\u000b\t\u0005m\u00161M\u0001\u0004e\u0012$\u0017\u0002BA`\u0003s\u00131A\u0015#E!\u001dQ\u00151YAd\u0003'L1!!2L\u0005\u0019!V\u000f\u001d7feA!\u0011\u0011ZAh\u001b\t\tYMC\u0002\u0002N\u0006\u000bab\u0019:pgN\u0004\u0018M\u001d;ji&|g.\u0003\u0003\u0002R\u0006-'\u0001D&fsB\u000b'\u000f^(s%><\b#\u0002&\u0002V\u0006e\u0017bAAl\u0017\n)\u0011I\u001d:bsB\u0019!*a7\n\u0007\u0005u7J\u0001\u0003CsR,\u0007bBA&#\u0001\u0007\u0011Q\n\u0005\b\u0003G\f\u0002\u0019AAs\u0003-\u0001\u0018M]1mY\u0016d\u0017n]7\u0011\u0007)\u000b9/C\u0002\u0002j.\u00131!\u00138u\u0011\u001d\ti/\u0005a\u0001\u0003K\fQB]8x\u0017&tGmQ8m\u0013\u0012D\b\"\u00026\u0012\u0001\u0004a\u0017!\b:fa\u0006\u0014H/\u001b;j_:\u0014\u0015pS3z!\u0006\u0014H/\u001b;j_:D\u0015m\u001d5\u0015\u0015\u00055\u0013Q_A\u0000\u0005\u0003\u0011\u0019\u0001C\u0004\u0002xJ\u0001\r!!?\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\t\u0005e\u00141`\u0005\u0005\u0003{\f9G\u0001\u0007Ta\u0006\u00148nU3tg&|g\u000eC\u0004\u0002LI\u0001\r!!\u0014\t\u000f\u0005\r(\u00031\u0001\u0002f\"9!Q\u0001\nA\u0002\u0005\u0015\u0018\u0001\u00048v[\u0006\u001b8/[4oKJ\u001c\u0018\u0001\t:fa\u0006\u0014H/\u001b;j_:\u0014\u0015\u0010U1si&$\u0018n\u001c8t\u0003:$')^2lKR$B!!\u0014\u0003\f!9!QB\nA\u0002\u00055\u0013A\u00013g\u0003a!Wm]3sS\u0006d\u0017N_3D_6l\u0017\u000e^'fgN\fw-\u001a\u000b\u0007\u0003\u0007\u0012\u0019B!\u0006\t\r}$\u0002\u0019AA\u0002\u0011\u001d\u00119\u0002\u0006a\u0001\u0003'\fQAY=uKN\u0014a\"T8e!\u0006\u0014H/\u001b;j_:,'oE\u0003\u0016\u0005;y%\u000b\u0005\u0003\u0003 \t\u0005RBAA2\u0013\u0011\u0011\u0019#a\u0019\u0003\u0017A\u000b'\u000f^5uS>tWM]\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001cXCAAs\u0003-\u0001\u0018M\u001d;ji&|gn\u001d\u0011\u0015\t\t5\"\u0011\u0007\t\u0004\u0005_)R\"\u0001\u0001\t\u000f\t\u0015\u0002\u00041\u0001\u0002f\u0006ia.^7QCJ$\u0018\u000e^5p]N\fAbZ3u!\u0006\u0014H/\u001b;j_:$B!!:\u0003:!9!1\b\u000eA\u0002\tu\u0012aA6fsB\u0019!Ja\u0010\n\u0007\t\u00053JA\u0002B]f\fAaY8qsR!!Q\u0006B$\u0011%\u0011)c\u0007I\u0001\u0002\u0004\t)/\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t5#\u0006BAs\u0005\u001fZ#A!\u0015\u0011\t\tM#QL\u0007\u0003\u0005+RAAa\u0016\u0003Z\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00057Z\u0015AC1o]>$\u0018\r^5p]&!!q\fB+\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\t\u0015\u0004\u0003\u0002B4\u0005cj!A!\u001b\u000b\t\t-$QN\u0001\u0005Y\u0006twM\u0003\u0002\u0003p\u0005!!.\u0019<b\u0013\u0011\u0011\u0019H!\u001b\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$BA!\u0010\u0003|!I!QP\u0010\u0002\u0002\u0003\u0007\u0011Q]\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t\r\u0005C\u0002BC\u0005\u0017\u0013i$\u0004\u0002\u0003\b*\u0019!\u0011R&\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003\u000e\n\u001d%\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BAa%\u0003\u001aB\u0019!J!&\n\u0007\t]5JA\u0004C_>dW-\u00198\t\u0013\tu\u0014%!AA\u0002\tu\u0012\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005\u0015\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\t\u0015\u0014AB3rk\u0006d7\u000f\u0006\u0003\u0003\u0014\n\u001d\u0006\"\u0003B?I\u0005\u0005\t\u0019\u0001B\u001f\u00039iu\u000e\u001a)beRLG/[8oKJ\u00042Aa\f''\u00111#q\u0016*\u0011\u0011\tE&qWAs\u0005[i!Aa-\u000b\u0007\tU6*A\u0004sk:$\u0018.\\3\n\t\te&1\u0017\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\fDC\u0001BV\u0003\u0015\t\u0007\u000f\u001d7z)\u0011\u0011iC!1\t\u000f\t\u0015\u0012\u00061\u0001\u0002f\u00069QO\\1qa2LH\u0003\u0002Bd\u0005\u001b\u0004RA\u0013Be\u0003KL1Aa3L\u0005\u0019y\u0005\u000f^5p]\"I!q\u001a\u0016\u0002\u0002\u0003\u0007!QF\u0001\u0004q\u0012\u0002DcA0\u0003T\"9Qk\u000bI\u0001\u0002\u00049VC\u0001BlU\r9&q\n\u000b\u0005\u0005{\u0011Y\u000eC\u0005\u0003~=\n\t\u00111\u0001\u0002fR!!1\u0013Bp\u0011%\u0011i(MA\u0001\u0002\u0004\u0011i\u0004\u0006\u0003\u0003\u0014\n\r\b\"\u0003B?i\u0005\u0005\t\u0019\u0001B\u001f\u0003E\u0001\u0016-[7p]N\u0003\u0018M]6Xe&$XM\u001d\t\u0003AZ\u001aBA\u000eBv%B1!\u0011\u0017B\\/~#\"Aa:\u0015\u0007}\u0013\t\u0010C\u0003Vs\u0001\u0007q\u000b\u0006\u0003\u0003v\n]\b\u0003\u0002&\u0003J^C\u0001Ba4;\u0003\u0003\u0005\raX\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003~B!!q\rB\u0000\u0013\u0011\u0019\tA!\u001b\u0003\r=\u0013'.Z2u\u0001")
public class PaimonSparkWriter
implements Product,
scala.Serializable {
    private TableSchema tableSchema;
    private RowType rowType;
    private BucketMode bucketMode;
    private Logger log;
    private transient CommitMessageSerializer serializer;
    private volatile PaimonSparkWriter$ModPartitioner$ ModPartitioner$module;
    private final FileStoreTable table;
    private final BatchWriteBuilder writeBuilder;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<FileStoreTable> unapply(PaimonSparkWriter paimonSparkWriter) {
        return PaimonSparkWriter$.MODULE$.unapply(paimonSparkWriter);
    }

    public static PaimonSparkWriter apply(FileStoreTable fileStoreTable) {
        return PaimonSparkWriter$.MODULE$.apply(fileStoreTable);
    }

    public static <A> Function1<FileStoreTable, A> andThen(Function1<PaimonSparkWriter, A> function1) {
        return PaimonSparkWriter$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, PaimonSparkWriter> compose(Function1<A, FileStoreTable> function1) {
        return PaimonSparkWriter$.MODULE$.compose(function1);
    }

    private PaimonSparkWriter$ModPartitioner$ ModPartitioner() {
        if (this.ModPartitioner$module == null) {
            this.ModPartitioner$lzycompute$1();
        }
        return this.ModPartitioner$module;
    }

    public FileStoreTable table() {
        return this.table;
    }

    private TableSchema tableSchema$lzycompute() {
        PaimonSparkWriter paimonSparkWriter = this;
        synchronized (paimonSparkWriter) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.tableSchema = this.table().schema();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.tableSchema;
    }

    private TableSchema tableSchema() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.tableSchema$lzycompute() : this.tableSchema;
    }

    private RowType rowType$lzycompute() {
        PaimonSparkWriter paimonSparkWriter = this;
        synchronized (paimonSparkWriter) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.rowType = this.table().rowType();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.rowType;
    }

    private RowType rowType() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.rowType$lzycompute() : this.rowType;
    }

    private BucketMode bucketMode$lzycompute() {
        PaimonSparkWriter paimonSparkWriter = this;
        synchronized (paimonSparkWriter) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.bucketMode = this.table().bucketMode();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.bucketMode;
    }

    private BucketMode bucketMode() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.bucketMode$lzycompute() : this.bucketMode;
    }

    private Logger log$lzycompute() {
        PaimonSparkWriter paimonSparkWriter = this;
        synchronized (paimonSparkWriter) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.log = LoggerFactory.getLogger(PaimonSparkWriter.class);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.log;
    }

    private Logger log() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.log$lzycompute() : this.log;
    }

    private CommitMessageSerializer serializer$lzycompute() {
        PaimonSparkWriter paimonSparkWriter = this;
        synchronized (paimonSparkWriter) {
            if (!this.bitmap$trans$0) {
                this.serializer = new CommitMessageSerializer();
                this.bitmap$trans$0 = true;
            }
        }
        return this.serializer;
    }

    private CommitMessageSerializer serializer() {
        return !this.bitmap$trans$0 ? this.serializer$lzycompute() : this.serializer;
    }

    public BatchWriteBuilder writeBuilder() {
        return this.writeBuilder;
    }

    public PaimonSparkWriter writeOnly() {
        return new PaimonSparkWriter((FileStoreTable)this.table().copy((Map)Collections.singletonMap(CoreOptions.WRITE_ONLY.key(), "true")));
    }

    public Seq<CommitMessage> write(Dataset<Row> data) {
        Dataset dataset;
        SparkSession sparkSession = data.sparkSession();
        BucketMode bucketMode = this.bucketMode();
        Dataset dataset2 = ((Object)((Object)BucketMode.BUCKET_UNAWARE)).equals((Object)bucketMode) ? data : (((Object)((Object)BucketMode.CROSS_PARTITION)).equals((Object)bucketMode) && !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])data.schema().fieldNames())).contains((Object)SparkSystemColumns$.MODULE$.ROW_KIND_COL()) ? data.withColumn(SparkSystemColumns$.MODULE$.ROW_KIND_COL(), functions$.MODULE$.lit((Object)BoxesRunTime.boxToByte((byte)RowKind.INSERT.toByteValue()))).withColumn(SparkSystemColumns$.MODULE$.BUCKET_COL(), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)-1))) : data.withColumn(SparkSystemColumns$.MODULE$.BUCKET_COL(), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)-1))));
        Dataset withInitBucketCol = dataset2;
        int rowKindColIdx = SparkRowUtils$.MODULE$.getFieldIndex(withInitBucketCol.schema(), SparkSystemColumns$.MODULE$.ROW_KIND_COL());
        int bucketColIdx = SparkRowUtils$.MODULE$.getFieldIndex(withInitBucketCol.schema(), SparkSystemColumns$.MODULE$.BUCKET_COL());
        EncoderSerDeGroup encoderGroupWithBucketCol = new EncoderSerDeGroup(withInitBucketCol.schema());
        BucketMode bucketMode2 = this.bucketMode();
        if (((Object)((Object)BucketMode.CROSS_PARTITION)).equals((Object)bucketMode2)) {
            RowType rowType = (RowType)SparkTypeUtils.toPaimonType((DataType)withInitBucketCol.schema());
            int assignerParallelism = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)this.table().coreOptions().dynamicBucketAssignerParallelism()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$1))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> PaimonSparkWriter.sparkParallelism$1(sparkSession)));
            RDD<Tuple2<KeyPartOrRow, byte[]>> bootstrapped = this.bootstrapAndRepartitionByKeyHash((Dataset<Row>)withInitBucketCol, assignerParallelism, rowKindColIdx, rowType);
            GlobalDynamicBucketProcessor globalDynamicBucketProcessor = new GlobalDynamicBucketProcessor(this.table(), rowType, Predef$.MODULE$.int2Integer(assignerParallelism), encoderGroupWithBucketCol);
            Dataset<Row> repartitioned = this.repartitionByPartitionsAndBucket((Dataset<Row>)sparkSession.createDataFrame(bootstrapped.mapPartitions((Function1 & Serializable & scala.Serializable)rowIterator -> globalDynamicBucketProcessor.processPartition((Iterator<Tuple2<KeyPartOrRow, byte[]>>)rowIterator), bootstrapped.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Row.class)), withInitBucketCol.schema()));
            dataset = this.writeWithBucket$1(repartitioned, bucketColIdx, sparkSession, rowKindColIdx);
        } else if (((Object)((Object)BucketMode.HASH_DYNAMIC)).equals((Object)bucketMode2)) {
            int assignerParallelism = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)this.table().coreOptions().dynamicBucketAssignerParallelism()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$2))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> PaimonSparkWriter.sparkParallelism$1(sparkSession)));
            int numAssigners = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)this.table().coreOptions().dynamicBucketInitialBuckets()).map((Function1 & Serializable & scala.Serializable)initialBuckets -> BoxesRunTime.boxToInteger((int)PaimonSparkWriter.$anonfun$write$13(assignerParallelism, initialBuckets))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> assignerParallelism));
            dataset = this.table().snapshotManager().latestSnapshot() == null ? this.writeWithBucketAssigner$1(this.partitionByKey$1(sparkSession, withInitBucketCol, assignerParallelism, numAssigners), (Function0 & Serializable & scala.Serializable)() -> {
                RowPartitionKeyExtractor extractor = new RowPartitionKeyExtractor(this.table().schema());
                SimpleHashBucketAssigner assigner = new SimpleHashBucketAssigner(numAssigners, TaskContext$.MODULE$.getPartitionId(), this.table().coreOptions().dynamicBucketTargetRowNum(), Predef$.MODULE$.Integer2int(this.table().coreOptions().dynamicBucketMaxBuckets()));
                return (Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToInteger((int)PaimonSparkWriter.$anonfun$write$16(this, assigner, extractor, row));
            }, sparkSession, rowKindColIdx) : this.writeWithBucketProcessor$1(this.partitionByKey$1(sparkSession, withInitBucketCol, assignerParallelism, numAssigners), new DynamicBucketProcessor(this.table(), bucketColIdx, assignerParallelism, numAssigners, encoderGroupWithBucketCol), encoderGroupWithBucketCol, bucketColIdx, sparkSession, rowKindColIdx);
        } else if (((Object)((Object)BucketMode.BUCKET_UNAWARE)).equals((Object)bucketMode2)) {
            dataset = this.writeWithoutBucket$1(data, sparkSession, rowKindColIdx);
        } else if (((Object)((Object)BucketMode.HASH_FIXED)).equals((Object)bucketMode2)) {
            Dataset dataset3;
            if (this.table().bucketSpec().getNumBuckets() == -2) {
                dataset3 = this.writeWithoutBucket$1(data, sparkSession, rowKindColIdx);
            } else if (!OptionUtils$.MODULE$.paimonExtensionEnabled()) {
                dataset3 = this.writeWithBucketProcessor$1(withInitBucketCol, new CommonBucketProcessor(this.table(), bucketColIdx, encoderGroupWithBucketCol), encoderGroupWithBucketCol, bucketColIdx, sparkSession, rowKindColIdx);
            } else {
                int bucketNumber = this.table().coreOptions().bucket();
                Seq bucketKeyCol = ((SeqLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.tableSchema().bucketKeys()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)PaimonSparkWriter.$anonfun$write$17(this, x$3)), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x -> functions$.MODULE$.col(data.schema().fieldNames()[BoxesRunTime.unboxToInt((Object)x)]), Buffer$.MODULE$.canBuildFrom())).toSeq();
                Seq args2 = (Seq)((TraversableLike)new .colon.colon((Object)functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)bucketNumber)), (List)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)bucketKeyCol, Seq$.MODULE$.canBuildFrom());
                Dataset<Row> repartitioned = this.repartitionByPartitionsAndBucket((Dataset<Row>)data.withColumn(SparkSystemColumns$.MODULE$.BUCKET_COL(), functions$.MODULE$.call_udf(BucketExpression$.MODULE$.FIXED_BUCKET(), args2)));
                dataset3 = this.writeWithBucket$1(repartitioned, bucketColIdx, sparkSession, rowKindColIdx);
            }
            dataset = dataset3;
        } else {
            throw new UnsupportedOperationException(new StringBuilder(28).append("Spark doesn't support ").append((Object)this.bucketMode()).append(" mode.").toString());
        }
        Dataset written = dataset;
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])written.collect())).map((Function1 & Serializable & scala.Serializable)x$4 -> this.deserializeCommitMessage(this.serializer(), (byte[])x$4), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(CommitMessage.class))))).toSeq();
    }

    public Seq<CommitMessage> persistDeletionVectors(Dataset<SparkDeletionVectors> deletionVectors) {
        SparkSession sparkSession = deletionVectors.sparkSession();
        Snapshot snapshot = this.table().snapshotManager().latestSnapshot();
        Dataset serializedCommits = deletionVectors.groupByKey((Function1 & Serializable & scala.Serializable)x$5 -> x$5.partitionAndBucket(), sparkSession.implicits().newStringEncoder()).mapGroups((Function2 & Serializable & scala.Serializable)(x$6, iter) -> {
            IndexFileHandler indexHandler = this.table().store().newIndexFileHandler();
            ObjectRef dvIndexFileMaintainer = ObjectRef.create(null);
            while (iter.hasNext()) {
                SparkDeletionVectors sdv = (SparkDeletionVectors)iter.next();
                if ((AppendDeletionFileMaintainer)dvIndexFileMaintainer.elem == null) {
                    BinaryRow partition = SerializationUtils.deserializeBinaryRow(sdv.partition());
                    BucketMode bucketMode = this.bucketMode();
                    BucketMode bucketMode2 = BucketMode.BUCKET_UNAWARE;
                    Object object = !(bucketMode != null ? !((Object)((Object)bucketMode)).equals((Object)bucketMode2) : bucketMode2 != null) ? AppendDeletionFileMaintainer.forUnawareAppend(indexHandler, snapshot, partition) : (dvIndexFileMaintainer.elem = AppendDeletionFileMaintainer.forBucketedAppend(indexHandler, snapshot, partition, sdv.bucket()));
                }
                if ((AppendDeletionFileMaintainer)dvIndexFileMaintainer.elem == null) {
                    throw new RuntimeException("can't create the dv maintainer.");
                }
                sdv.dataFileAndDeletionVector().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    PaimonSparkWriter.$anonfun$persistDeletionVectors$3(dvIndexFileMaintainer, x0$1);
                    return BoxedUnit.UNIT;
                });
            }
            java.util.List<IndexManifestEntry> indexEntries = ((AppendDeletionFileMaintainer)dvIndexFileMaintainer.elem).persist();
            Tuple2 tuple2 = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(indexEntries).asScala()).partition((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)PaimonSparkWriter.$anonfun$persistDeletionVectors$4(x$7)));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Buffer added = (Buffer)tuple2._1();
            Buffer deleted = (Buffer)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)added, (Object)deleted);
            Tuple2 tuple23 = tuple22;
            Buffer added2 = (Buffer)tuple23._1();
            Buffer deleted2 = (Buffer)tuple23._2();
            CommitMessageImpl commitMessage = new CommitMessageImpl(((AppendDeletionFileMaintainer)dvIndexFileMaintainer.elem).getPartition(), ((AppendDeletionFileMaintainer)dvIndexFileMaintainer.elem).getBucket(), null, DataIncrement.emptyIncrement(), CompactIncrement.emptyIncrement(), new IndexIncrement((java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)added2.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.indexFile(), Buffer$.MODULE$.canBuildFrom())).asJava(), (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)deleted2.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.indexFile(), Buffer$.MODULE$.canBuildFrom())).asJava()));
            CommitMessageSerializer serializer = new CommitMessageSerializer();
            return serializer.serialize(commitMessage);
        }, sparkSession.implicits().newByteArrayEncoder());
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])serializedCommits.collect())).map((Function1 & Serializable & scala.Serializable)x$11 -> this.deserializeCommitMessage(this.serializer(), (byte[])x$11), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public Seq<CommitMessage> buildCommitMessageFromIndexManifestEntry(Seq<IndexManifestEntry> indexManifestEntries) {
        return ((TraversableOnce)indexManifestEntries.groupBy((Function1 & Serializable & scala.Serializable)entry -> new Tuple2((Object)entry.partition(), (Object)BoxesRunTime.boxToInteger((int)entry.bucket()))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Tuple2 tuple22 = (Tuple2)tuple2._1();
            Seq entries = (Seq)tuple2._2();
            if (tuple22 == null) throw new MatchError((Object)tuple2);
            BinaryRow partition = (BinaryRow)tuple22._1();
            int bucket = tuple22._2$mcI$sp();
            Tuple2 tuple23 = entries.partition((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)PaimonSparkWriter.$anonfun$buildCommitMessageFromIndexManifestEntry$3(x$12)));
            if (tuple23 == null) throw new MatchError((Object)tuple23);
            Seq added = (Seq)tuple23._1();
            Seq removed = (Seq)tuple23._2();
            Tuple2 tuple24 = new Tuple2((Object)added, (Object)removed);
            Tuple2 tuple25 = tuple24;
            Seq added2 = (Seq)tuple25._1();
            Seq removed2 = (Seq)tuple25._2();
            return new CommitMessageImpl(partition, bucket, null, DataIncrement.emptyIncrement(), CompactIncrement.emptyIncrement(), new IndexIncrement((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)added2.map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.indexFile(), Seq$.MODULE$.canBuildFrom())).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)removed2.map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.indexFile(), Seq$.MODULE$.canBuildFrom())).asJava()));
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    private void reportToHms(Seq<CommitMessage> messages) {
        CoreOptions options = this.table().coreOptions();
        Options config = options.toConfiguration();
        if (config.get(CoreOptions.PARTITION_IDLE_TIME_TO_REPORT_STATISTIC).toMillis() <= 0L || this.table().partitionKeys().isEmpty() || !options.partitionedTableInMetastore() || this.table().catalogEnvironment().partitionHandler() == null) {
            return;
        }
        InternalRowPartitionComputer partitionComputer = new InternalRowPartitionComputer(options.partitionDefaultName(), this.table().schema().logicalPartitionType(), (String[])this.table().partitionKeys().toArray((Object[])new String[0]), options.legacyPartitionName());
        PartitionStatisticsReporter hmsReporter = new PartitionStatisticsReporter(this.table(), this.table().catalogEnvironment().partitionHandler());
        Seq partitions = (Seq)((SeqLike)messages.map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.partition(), Seq$.MODULE$.canBuildFrom())).distinct();
        long currentTime = System.currentTimeMillis();
        try {
            try {
                partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                    PaimonSparkWriter.$anonfun$reportToHms$2(partitionComputer, hmsReporter, currentTime, partition);
                    return BoxedUnit.UNIT;
                });
            }
            catch (Throwable e) {
                this.log().warn("Failed to report to hms", e);
            }
        }
        finally {
            hmsReporter.close();
        }
    }

    public void commit(Seq<CommitMessage> commitMessages) {
        try (BatchTableCommit tableCommit = this.writeBuilder().newCommit();){
            try {
                tableCommit.commit((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)commitMessages.toList()).asJava());
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        this.reportToHms(commitMessages);
    }

    private RDD<Tuple2<KeyPartOrRow, byte[]>> bootstrapAndRepartitionByKeyHash(Dataset<Row> data, int parallelism, int rowKindColIdx, RowType rowType) {
        int numSparkPartitions = data.rdd().getNumPartitions();
        java.util.List<String> primaryKeys = this.table().schema().primaryKeys();
        RowType bootstrapType = IndexBootstrap.bootstrapType(this.table().schema());
        return RDD$.MODULE$.rddToPairRDDFunctions(data.rdd().mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            int sparkPartitionId = TaskContext$.MODULE$.getPartitionId();
            Projection keyPartProject = CodeGenUtils.newProjection(bootstrapType, primaryKeys);
            Projection rowProject = CodeGenUtils.newProjection(rowType, primaryKeys);
            InternalRowSerializer bootstrapSer = InternalSerializers.create(bootstrapType);
            InternalRowSerializer rowSer = InternalSerializers.create(rowType);
            CloseableIterator<InternalRow> bootstrapIterator = new IndexBootstrap(this.table()).bootstrap(numSparkPartitions, sparkPartitionId).toCloseableIterator();
            TaskContext$.MODULE$.get().addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$17 -> {
                bootstrapIterator.close();
                return BoxedUnit.UNIT;
            });
            return ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(bootstrapIterator).asScala()).map((Function1 & Serializable & scala.Serializable)row -> {
                byte[] bytes = SerializationUtils.serializeBinaryRow(bootstrapSer.toBinaryRow((InternalRow)row));
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)Math.abs(keyPartProject.apply((InternalRow)row).hashCode())), (Object)new Tuple2((Object)KeyPartOrRow.KEY_PART, (Object)bytes));
            }).$plus$plus((Function0 & Serializable & scala.Serializable)() -> iter.map((Function1 & Serializable & scala.Serializable)r -> {
                SparkRow sparkRow = new SparkRow(rowType, (Row)r, SparkRowUtils$.MODULE$.getRowKind((Row)r, rowKindColIdx));
                byte[] bytes = SerializationUtils.serializeBinaryRow(rowSer.toBinaryRow(sparkRow));
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)Math.abs(rowProject.apply(sparkRow).hashCode())), (Object)new Tuple2((Object)KeyPartOrRow.ROW, (Object)bytes));
            }));
        }, data.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).partitionBy((Partitioner)new ModPartitioner(this, parallelism)).map((Function1 & Serializable & scala.Serializable)x$18 -> (Tuple2)x$18._2(), ClassTag$.MODULE$.apply(Tuple2.class));
    }

    private Dataset<Row> repartitionByKeyPartitionHash(SparkSession sparkSession, Dataset<Row> data, int parallelism, int numAssigners) {
        return sparkSession.createDataFrame(RDD$.MODULE$.rddToPairRDDFunctions(data.rdd().mapPartitions((Function1 & Serializable & scala.Serializable)iterator2 -> {
            RowPartitionKeyExtractor rowPartitionKeyExtractor = new RowPartitionKeyExtractor(this.tableSchema());
            return iterator2.map((Function1 & Serializable & scala.Serializable)row -> {
                SparkRow sparkRow = new SparkRow(this.rowType(), (Row)row);
                int partitionHash = rowPartitionKeyExtractor.partition(sparkRow).hashCode();
                int keyHash = rowPartitionKeyExtractor.trimmedPrimaryKey(sparkRow).hashCode();
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)BucketAssigner.computeHashKey(partitionHash, keyHash, parallelism, numAssigners)), row);
            });
        }, data.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Row.class), (Ordering)Ordering.Int$.MODULE$).partitionBy((Partitioner)new ModPartitioner(this, parallelism)).map((Function1 & Serializable & scala.Serializable)x$19 -> (Row)x$19._2(), ClassTag$.MODULE$.apply(Row.class)), data.schema());
    }

    private Dataset<Row> repartitionByPartitionsAndBucket(Dataset<Row> df) {
        StructType inputSchema = df.schema();
        Seq partitionCols = ((SeqLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.tableSchema().partitionKeys()).asScala()).map((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToInteger((int)PaimonSparkWriter.$anonfun$repartitionByPartitionsAndBucket$1(this, x$20)), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x -> functions$.MODULE$.col(inputSchema.fieldNames()[BoxesRunTime.unboxToInt((Object)x)]), Buffer$.MODULE$.canBuildFrom())).toSeq();
        return df.repartition((Seq)partitionCols.$plus$plus((GenTraversableOnce)new .colon.colon((Object)functions$.MODULE$.col(SparkSystemColumns$.MODULE$.BUCKET_COL()), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom()));
    }

    private CommitMessage deserializeCommitMessage(CommitMessageSerializer serializer, byte[] bytes) {
        CommitMessage commitMessage;
        try {
            commitMessage = serializer.deserialize(serializer.getVersion(), bytes);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to deserialize CommitMessage's object", e);
        }
        return commitMessage;
    }

    public PaimonSparkWriter copy(FileStoreTable table) {
        return new PaimonSparkWriter(table);
    }

    public FileStoreTable copy$default$1() {
        return this.table();
    }

    public String productPrefix() {
        return "PaimonSparkWriter";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return this.table();
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof PaimonSparkWriter;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof PaimonSparkWriter)) return false;
        boolean bl = true;
        if (!bl) return false;
        PaimonSparkWriter paimonSparkWriter = (PaimonSparkWriter)x$1;
        FileStoreTable fileStoreTable = this.table();
        FileStoreTable fileStoreTable2 = paimonSparkWriter.table();
        if (fileStoreTable == null) {
            if (fileStoreTable2 != null) {
                return false;
            }
        } else if (!fileStoreTable.equals(fileStoreTable2)) return false;
        if (!paimonSparkWriter.canEqual(this)) return false;
        return true;
    }

    private final void ModPartitioner$lzycompute$1() {
        PaimonSparkWriter paimonSparkWriter = this;
        synchronized (paimonSparkWriter) {
            if (this.ModPartitioner$module == null) {
                this.ModPartitioner$module = new PaimonSparkWriter$ModPartitioner$(this);
            }
        }
    }

    private final SparkTableWrite newWrite$1(int rowKindColIdx$1) {
        return new SparkTableWrite(this.writeBuilder(), this.rowType(), rowKindColIdx$1);
    }

    private static final int sparkParallelism$1(SparkSession sparkSession$1) {
        int defaultParallelism = sparkSession$1.sparkContext().defaultParallelism();
        int numShufflePartitions = sparkSession$1.sessionState().conf().numShufflePartitions();
        return Math.max(defaultParallelism, numShufflePartitions);
    }

    private final Dataset writeWithoutBucket$1(Dataset dataFrame, SparkSession sparkSession$1, int rowKindColIdx$1) {
        return dataFrame.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            Iterator<byte[]> iterator2;
            try (SparkTableWrite write = this.newWrite$1(rowKindColIdx$1);){
                iter.foreach((Function1 & Serializable & scala.Serializable)row -> {
                    write.write(row);
                    return BoxedUnit.UNIT;
                });
                iterator2 = write.finish();
            }
            return iterator2;
        }, sparkSession$1.implicits().newByteArrayEncoder());
    }

    private final Dataset writeWithBucket$1(Dataset dataFrame, int bucketColIdx$1, SparkSession sparkSession$1, int rowKindColIdx$1) {
        return dataFrame.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            Iterator<byte[]> iterator2;
            try (SparkTableWrite write = this.newWrite$1(rowKindColIdx$1);){
                iter.foreach((Function1 & Serializable & scala.Serializable)row -> {
                    write.write(row, row.getInt(bucketColIdx$1));
                    return BoxedUnit.UNIT;
                });
                iterator2 = write.finish();
            }
            return iterator2;
        }, sparkSession$1.implicits().newByteArrayEncoder());
    }

    private final Dataset writeWithBucketProcessor$1(Dataset dataFrame, BucketProcessor processor, EncoderSerDeGroup encoderGroupWithBucketCol$1, int bucketColIdx$1, SparkSession sparkSession$1, int rowKindColIdx$1) {
        Dataset<Row> repartitioned = this.repartitionByPartitionsAndBucket((Dataset<Row>)dataFrame.mapPartitions((Function1 & Serializable & scala.Serializable)rowIterator -> processor.processPartition(rowIterator), encoderGroupWithBucketCol$1.encoder()).toDF());
        return this.writeWithBucket$1(repartitioned, bucketColIdx$1, sparkSession$1, rowKindColIdx$1);
    }

    private final Dataset writeWithBucketAssigner$1(Dataset dataFrame, Function0 funcFactory, SparkSession sparkSession$1, int rowKindColIdx$1) {
        return dataFrame.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            Iterator<byte[]> iterator2;
            Function1 assigner = (Function1)funcFactory.apply();
            try (SparkTableWrite write = this.newWrite$1(rowKindColIdx$1);){
                iter.foreach((Function1 & Serializable & scala.Serializable)row -> {
                    write.write(row, BoxesRunTime.unboxToInt((Object)assigner.apply((Object)row)));
                    return BoxedUnit.UNIT;
                });
                iterator2 = write.finish();
            }
            return iterator2;
        }, sparkSession$1.implicits().newByteArrayEncoder());
    }

    public static final /* synthetic */ int $anonfun$write$13(int assignerParallelism$1, Integer initialBuckets) {
        return Math.min(Predef$.MODULE$.Integer2int(initialBuckets), assignerParallelism$1);
    }

    private final Dataset partitionByKey$1(SparkSession sparkSession$1, Dataset withInitBucketCol$1, int assignerParallelism$1, int numAssigners$1) {
        return this.repartitionByKeyPartitionHash(sparkSession$1, (Dataset<Row>)withInitBucketCol$1, assignerParallelism$1, numAssigners$1);
    }

    public static final /* synthetic */ int $anonfun$write$16(PaimonSparkWriter $this, SimpleHashBucketAssigner assigner$2, RowPartitionKeyExtractor extractor$1, Row row) {
        SparkRow sparkRow = new SparkRow($this.rowType(), row);
        return assigner$2.assign(extractor$1.partition(sparkRow), extractor$1.trimmedPrimaryKey(sparkRow).hashCode());
    }

    public static final /* synthetic */ int $anonfun$write$17(PaimonSparkWriter $this, String x$3) {
        return $this.tableSchema().fieldNames().indexOf(x$3);
    }

    public static final /* synthetic */ void $anonfun$persistDeletionVectors$3(ObjectRef dvIndexFileMaintainer$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String dataFileName = (String)tuple2._1();
        byte[] dv = (byte[])tuple2._2();
        ((AppendDeletionFileMaintainer)dvIndexFileMaintainer$1.elem).notifyNewDeletionVector(dataFileName, DeletionVector.deserializeFromBytes(dv));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$persistDeletionVectors$4(IndexManifestEntry x$7) {
        FileKind fileKind = x$7.kind();
        FileKind fileKind2 = FileKind.ADD;
        return !(fileKind != null ? !((Object)((Object)fileKind)).equals((Object)fileKind2) : fileKind2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$buildCommitMessageFromIndexManifestEntry$3(IndexManifestEntry x$12) {
        FileKind fileKind = x$12.kind();
        FileKind fileKind2 = FileKind.ADD;
        return !(fileKind != null ? !((Object)((Object)fileKind)).equals((Object)fileKind2) : fileKind2 != null);
    }

    public static final /* synthetic */ void $anonfun$reportToHms$2(InternalRowPartitionComputer partitionComputer$1, PartitionStatisticsReporter hmsReporter$1, long currentTime$1, BinaryRow partition) {
        String partitionPath = PartitionPathUtils.generatePartitionPath(partitionComputer$1.generatePartValues(partition));
        hmsReporter$1.report(partitionPath, currentTime$1);
    }

    public static final /* synthetic */ int $anonfun$repartitionByPartitionsAndBucket$1(PaimonSparkWriter $this, String x$20) {
        return $this.tableSchema().fieldNames().indexOf(x$20);
    }

    public PaimonSparkWriter(FileStoreTable table) {
        this.table = table;
        Product.$init$((Product)this);
        this.writeBuilder = table.newBatchWriteBuilder();
    }

    private class ModPartitioner
    extends Partitioner
    implements Product {
        private final int partitions;
        public final /* synthetic */ PaimonSparkWriter $outer;

        public int partitions() {
            return this.partitions;
        }

        public int numPartitions() {
            return this.partitions();
        }

        public int getPartition(Object key) {
            return BoxesRunTime.unboxToInt((Object)key) % this.numPartitions();
        }

        public ModPartitioner copy(int partitions) {
            return new ModPartitioner(this.org$apache$paimon$spark$commands$PaimonSparkWriter$ModPartitioner$$$outer(), partitions);
        }

        public int copy$default$1() {
            return this.partitions();
        }

        public String productPrefix() {
            return "ModPartitioner";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return BoxesRunTime.boxToInteger((int)this.partitions());
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ModPartitioner;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.partitions());
            return Statics.finalizeHash((int)n, (int)1);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ModPartitioner)) return false;
            if (((ModPartitioner)((Object)object)).org$apache$paimon$spark$commands$PaimonSparkWriter$ModPartitioner$$$outer() != this.org$apache$paimon$spark$commands$PaimonSparkWriter$ModPartitioner$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ModPartitioner modPartitioner = (ModPartitioner)((Object)x$1);
            if (this.partitions() != modPartitioner.partitions()) return false;
            if (!modPartitioner.canEqual((Object)this)) return false;
            return true;
        }

        public /* synthetic */ PaimonSparkWriter org$apache$paimon$spark$commands$PaimonSparkWriter$ModPartitioner$$$outer() {
            return this.$outer;
        }

        public ModPartitioner(PaimonSparkWriter $outer, int partitions) {
            this.partitions = partitions;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

