/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.procedure;

import java.io.Serializable;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.operation.CleanOrphanFilesResult;
import org.apache.paimon.spark.procedure.SparkOrphanFilesClean;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.Table;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.internal.SQLConf;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;

public final class SparkOrphanFilesClean$
implements SQLConfHelper,
scala.Serializable {
    public static SparkOrphanFilesClean$ MODULE$;

    static {
        new SparkOrphanFilesClean$();
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public CleanOrphanFilesResult executeDatabaseOrphanFiles(Catalog catalog, String databaseName, String tableName2, long olderThanMillis, Integer parallelismOpt, boolean dryRun) {
        CleanOrphanFilesResult cleanOrphanFilesResult;
        Seq seq;
        int parallelism;
        SparkSession spark = SparkSession$.MODULE$.active();
        int n = parallelism = parallelismOpt == null ? Math.max(spark.sparkContext().defaultParallelism(), this.conf().numShufflePartitions()) : parallelismOpt;
        if (tableName2 == null || "*".equals(tableName2)) {
            seq = (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(catalog.listTables(databaseName)).asScala();
        } else {
            String string = tableName2;
            seq = Nil$.MODULE$.$colon$colon((Object)string);
        }
        Seq tableNames = seq;
        Seq tables = (Seq)tableNames.map((Function1 & Serializable & scala.Serializable)tableName -> {
            Identifier identifier = new Identifier(databaseName, (String)tableName);
            Table table = catalog.getTable(identifier);
            Predef$.MODULE$.assert(table instanceof FileStoreTable, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(78).append("Only FileStoreTable supports remove-orphan-files action. The table type is '").append(table.getClass().getName()).append("'.").toString());
            return (FileStoreTable)table;
        }, Seq$.MODULE$.canBuildFrom());
        if (tables.isEmpty()) {
            return new CleanOrphanFilesResult(0L, 0L);
        }
        Tuple2 tuple2 = ((GenericTraversableTemplate)tables.map((Function1 & Serializable & scala.Serializable)table -> new SparkOrphanFilesClean((FileStoreTable)table, olderThanMillis, parallelism, dryRun, spark).doOrphanClean(), Seq$.MODULE$.canBuildFrom())).unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq deleted = (Seq)tuple2._1();
        Seq waitToRelease = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)deleted, (Object)waitToRelease);
        Tuple2 tuple23 = tuple22;
        Seq deleted2 = (Seq)tuple23._1();
        Seq waitToRelease2 = (Seq)tuple23._2();
        try {
            Row result = (Row)((Dataset)deleted2.reduce((Function2 & Serializable & scala.Serializable)(l, r) -> l.union(r))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"deletedFilesCount", "deletedFilesLenInBytes"})).agg(functions$.MODULE$.sum("deletedFilesCount"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.sum("deletedFilesLenInBytes")})).head();
            Predef$.MODULE$.assert(result.schema().size() == 2, (Function0 & Serializable & scala.Serializable)() -> result.schema());
            cleanOrphanFilesResult = result.isNullAt(0) ? new CleanOrphanFilesResult(0L, 0L) : new CleanOrphanFilesResult(result.getLong(0), result.getLong(1));
        }
        finally {
            waitToRelease2.foreach((Function1 & Serializable & scala.Serializable)x$11 -> x$11.unpersist());
        }
        return cleanOrphanFilesResult;
    }

    public SparkOrphanFilesClean apply(FileStoreTable specifiedTable, long specifiedOlderThanMillis, int parallelism, boolean dryRunPara, SparkSession spark) {
        return new SparkOrphanFilesClean(specifiedTable, specifiedOlderThanMillis, parallelism, dryRunPara, spark);
    }

    public Option<Tuple5<FileStoreTable, Object, Object, Object, SparkSession>> unapply(SparkOrphanFilesClean x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple5((Object)x$0.specifiedTable(), (Object)BoxesRunTime.boxToLong((long)x$0.specifiedOlderThanMillis()), (Object)BoxesRunTime.boxToInteger((int)x$0.parallelism()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.dryRunPara()), (Object)x$0.spark()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private SparkOrphanFilesClean$() {
        MODULE$ = this;
        SQLConfHelper.$init$((SQLConfHelper)this);
    }
}

