/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.time.Duration;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class Pool<T> {
    private final ArrayBlockingQueue<T> pool;
    private final Recycler<T> recycler;
    private final int poolCapacity;
    private int poolSize;

    public Pool(int poolCapacity) {
        this.pool = new ArrayBlockingQueue(poolCapacity);
        this.recycler = this::addBack;
        this.poolCapacity = poolCapacity;
        this.poolSize = 0;
    }

    public Recycler<T> recycler() {
        return this.recycler;
    }

    public synchronized void add(T object) {
        if (this.poolSize >= this.poolCapacity) {
            throw new IllegalStateException("No space left in pool");
        }
        ++this.poolSize;
        this.addBack(object);
    }

    public T pollEntry() throws InterruptedException {
        return this.pool.take();
    }

    public T pollEntry(Duration timeout2) throws InterruptedException {
        return this.pool.poll(timeout2.toMillis(), TimeUnit.MILLISECONDS);
    }

    @Nullable
    public T tryPollEntry() {
        return this.pool.poll();
    }

    void addBack(T object) {
        this.pool.add(object);
    }

    @FunctionalInterface
    public static interface Recycler<T> {
        public void recycle(T var1);
    }
}

