/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.catalyst.plans.logical;

import org.apache.paimon.CoreOptions;
import org.apache.paimon.spark.SparkTable;
import org.apache.paimon.spark.catalyst.plans.logical.IncrementalBetweenTimestamp;
import org.apache.paimon.spark.catalyst.plans.logical.IncrementalQuery;
import org.apache.paimon.spark.catalyst.plans.logical.IncrementalToAutoTag;
import org.apache.paimon.spark.catalyst.plans.logical.PaimonTableValueFunction;
import org.apache.paimon.table.DataTable;
import org.apache.paimon.table.source.snapshot.TimeTravelUtil;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.PaimonUtils$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.FunctionIdentifier$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistryBase$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionInfo;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.connector.catalog.CatalogManager;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation$;
import org.apache.spark.sql.internal.SessionState;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;

public final class PaimonTableValuedFunctions$ {
    public static PaimonTableValuedFunctions$ MODULE$;
    private final String INCREMENTAL_QUERY;
    private final String INCREMENTAL_BETWEEN_TIMESTAMP;
    private final String INCREMENTAL_TO_AUTO_TAG;
    private final Seq<String> supportedFnNames;

    static {
        new PaimonTableValuedFunctions$();
    }

    public String INCREMENTAL_QUERY() {
        return this.INCREMENTAL_QUERY;
    }

    public String INCREMENTAL_BETWEEN_TIMESTAMP() {
        return this.INCREMENTAL_BETWEEN_TIMESTAMP;
    }

    public String INCREMENTAL_TO_AUTO_TAG() {
        return this.INCREMENTAL_TO_AUTO_TAG;
    }

    public Seq<String> supportedFnNames() {
        return this.supportedFnNames;
    }

    public Tuple3<FunctionIdentifier, ExpressionInfo, Function1<Seq<Expression>, LogicalPlan>> getTableValueFunctionInjection(String fnName) {
        Tuple2 tuple2;
        String string = fnName;
        String string2 = this.INCREMENTAL_QUERY();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            tuple2 = FunctionRegistryBase$.MODULE$.build(fnName, (Option)None$.MODULE$, ClassTag$.MODULE$.apply(IncrementalQuery.class));
        } else {
            String string4 = this.INCREMENTAL_BETWEEN_TIMESTAMP();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                tuple2 = FunctionRegistryBase$.MODULE$.build(fnName, (Option)None$.MODULE$, ClassTag$.MODULE$.apply(IncrementalBetweenTimestamp.class));
            } else {
                String string6 = this.INCREMENTAL_TO_AUTO_TAG();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    tuple2 = FunctionRegistryBase$.MODULE$.build(fnName, (Option)None$.MODULE$, ClassTag$.MODULE$.apply(IncrementalToAutoTag.class));
                } else {
                    throw new Exception(new StringBuilder(50).append("Function ").append(fnName).append(" isn't a supported table valued function.").toString());
                }
            }
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        ExpressionInfo info = (ExpressionInfo)tuple22._1();
        Function1 builder = (Function1)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)info, (Object)builder);
        Tuple2 tuple24 = tuple23;
        ExpressionInfo info2 = (ExpressionInfo)tuple24._1();
        Function1 builder2 = (Function1)tuple24._2();
        FunctionIdentifier ident = FunctionIdentifier$.MODULE$.apply(fnName);
        return new Tuple3((Object)ident, (Object)info2, (Object)builder2);
    }

    public LogicalPlan resolvePaimonTableValuedFunction(SparkSession spark, PaimonTableValueFunction tvf) {
        LogicalPlan logicalPlan;
        Some some;
        Tuple2 snapshotIdPair;
        Tuple3 tuple3;
        Seq args2 = tvf.expressions();
        SessionState sessionState = spark.sessionState();
        CatalogManager catalogManager = sessionState.catalogManager();
        Expression qual$1 = (Expression)args2.head();
        InternalRow x$1 = qual$1.eval$default$1();
        String identifier = qual$1.eval(x$1).toString();
        Seq seq = sessionState.sqlParser().parseMultipartIdentifier(identifier);
        Some some2 = Seq$.MODULE$.unapplySeq(seq);
        if (!some2.isEmpty() && some2.get() != null && ((SeqLike)some2.get()).lengthCompare(1) == 0) {
            String table = (String)((SeqLike)some2.get()).apply(0);
            tuple3 = new Tuple3((Object)catalogManager.currentCatalog().name(), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])catalogManager.currentNamespace())).head(), (Object)table);
        } else {
            Some some3 = Seq$.MODULE$.unapplySeq(seq);
            if (!some3.isEmpty() && some3.get() != null && ((SeqLike)some3.get()).lengthCompare(2) == 0) {
                String db = (String)((SeqLike)some3.get()).apply(0);
                String table = (String)((SeqLike)some3.get()).apply(1);
                tuple3 = new Tuple3((Object)catalogManager.currentCatalog().name(), (Object)db, (Object)table);
            } else {
                Some some4 = Seq$.MODULE$.unapplySeq(seq);
                if (!some4.isEmpty() && some4.get() != null && ((SeqLike)some4.get()).lengthCompare(3) == 0) {
                    String catalog = (String)((SeqLike)some4.get()).apply(0);
                    String db = (String)((SeqLike)some4.get()).apply(1);
                    String table = (String)((SeqLike)some4.get()).apply(2);
                    tuple3 = new Tuple3((Object)catalog, (Object)db, (Object)table);
                } else {
                    throw new RuntimeException(new StringBuilder(26).append("Invalid table identifier: ").append(identifier).toString());
                }
            }
        }
        Tuple3 tuple32 = tuple3;
        if (tuple32 == null) {
            throw new MatchError((Object)tuple32);
        }
        String catalogName = (String)tuple32._1();
        String dbName = (String)tuple32._2();
        String tableName = (String)tuple32._3();
        Tuple3 tuple33 = new Tuple3((Object)catalogName, (Object)dbName, (Object)tableName);
        Tuple3 tuple34 = tuple33;
        String catalogName2 = (String)tuple34._1();
        String dbName2 = (String)tuple34._2();
        String tableName2 = (String)tuple34._3();
        TableCatalog sparkCatalog = (TableCatalog)catalogManager.catalog(catalogName2);
        Identifier ident = Identifier.of((String[])((String[])((Object[])new String[]{dbName2})), (String)tableName2);
        Table sparkTable = sparkCatalog.loadTable(ident);
        scala.collection.immutable.Map<String, String> options = tvf.parseArgs((Seq<Expression>)((Seq)args2.tail()));
        Option<Tuple2<Object, Object>> option = this.usingSparkIncrementQuery(tvf, sparkTable, options);
        if (option instanceof Some && (snapshotIdPair = (Tuple2)(some = (Some)option).value()) != null) {
            Tuple2 tuple2 = snapshotIdPair;
            logicalPlan = this.sparkIncrementQuery(spark, sparkTable, sparkCatalog, ident, options, (Tuple2<Object, Object>)tuple2);
        } else {
            logicalPlan = DataSourceV2Relation$.MODULE$.create(sparkTable, (Option)new Some((Object)sparkCatalog), (Option)new Some((Object)ident), new CaseInsensitiveStringMap((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(options).asJava()));
        }
        return logicalPlan;
    }

    private Option<Tuple2<Object, Object>> usingSparkIncrementQuery(PaimonTableValueFunction tvf, Table sparkTable, scala.collection.immutable.Map<String, String> options) {
        None$ none$;
        boolean bl;
        String string = tvf.fnName();
        String string2 = this.INCREMENTAL_QUERY();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            bl = true;
        } else {
            String string4 = this.INCREMENTAL_TO_AUTO_TAG();
            String string5 = string;
            bl = !(string4 != null ? !string4.equals(string5) : string5 != null);
        }
        if (bl) {
            None$ none$2;
            SparkTable sparkTable2;
            org.apache.paimon.table.Table fileStoreTable;
            Table table = sparkTable;
            if (table instanceof SparkTable && (fileStoreTable = (sparkTable2 = (SparkTable)table).table()) instanceof DataTable) {
                Some some;
                DataTable dataTable = (DataTable)fileStoreTable;
                try {
                    ((DataTable)dataTable.copy((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(options).asJava())).newScan().plan();
                    some = None$.MODULE$;
                }
                catch (TimeTravelUtil.InconsistentTagBucketException e) {
                    some = new Some((Object)new Tuple2.mcJJ.sp(e.startSnapshotId(), e.endSnapshotId()));
                }
                none$2 = some;
            } else {
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private LogicalPlan sparkIncrementQuery(SparkSession spark, Table sparkTable, TableCatalog sparkCatalog, Identifier ident, scala.collection.immutable.Map<String, String> options, Tuple2<Object, Object> snapshotIdPair) {
        scala.collection.immutable.Map filteredOptions = (scala.collection.immutable.Map)options.$minus((Object)CoreOptions.INCREMENTAL_BETWEEN.key()).$minus((Object)CoreOptions.INCREMENTAL_TO_AUTO_TAG.key());
        return PaimonTableValuedFunctions$.datasetOfSnapshot$1(snapshotIdPair._2$mcJ$sp(), filteredOptions, spark, sparkTable, sparkCatalog, ident).except(PaimonTableValuedFunctions$.datasetOfSnapshot$1(snapshotIdPair._1$mcJ$sp(), filteredOptions, spark, sparkTable, sparkCatalog, ident)).queryExecution().logical();
    }

    private static final Dataset datasetOfSnapshot$1(long snapshotId, scala.collection.immutable.Map filteredOptions$1, SparkSession spark$1, Table sparkTable$1, TableCatalog sparkCatalog$1, Identifier ident$1) {
        scala.collection.immutable.Map updatedOptions = filteredOptions$1.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)CoreOptions.SCAN_VERSION.key()), (Object)Long.toString(snapshotId)));
        return PaimonUtils$.MODULE$.createDataset(spark$1, (LogicalPlan)DataSourceV2Relation$.MODULE$.create(sparkTable$1, (Option)new Some((Object)sparkCatalog$1), (Option)new Some((Object)ident$1), new CaseInsensitiveStringMap((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)updatedOptions).asJava())));
    }

    private PaimonTableValuedFunctions$() {
        MODULE$ = this;
        this.INCREMENTAL_QUERY = "paimon_incremental_query";
        this.INCREMENTAL_BETWEEN_TIMESTAMP = "paimon_incremental_between_timestamp";
        this.INCREMENTAL_TO_AUTO_TAG = "paimon_incremental_to_auto_tag";
        this.supportedFnNames = (Seq)new .colon.colon((Object)this.INCREMENTAL_QUERY(), (List)new .colon.colon((Object)this.INCREMENTAL_BETWEEN_TIMESTAMP(), (List)new .colon.colon((Object)this.INCREMENTAL_TO_AUTO_TAG(), (List)Nil$.MODULE$)));
    }
}

