/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.procedure;

import java.util.List;
import java.util.Map;
import org.apache.paimon.FileStore;
import org.apache.paimon.operation.PartitionExpire;
import org.apache.paimon.spark.procedure.BaseProcedure;
import org.apache.paimon.spark.procedure.ProcedureBuilder;
import org.apache.paimon.spark.procedure.ProcedureParameter;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.ProcedureUtils;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;

public class ExpirePartitionsProcedure
extends BaseProcedure {
    private static final ProcedureParameter[] PARAMETERS = new ProcedureParameter[]{ProcedureParameter.required("table", DataTypes.StringType), ProcedureParameter.optional("expiration_time", DataTypes.StringType), ProcedureParameter.optional("timestamp_formatter", DataTypes.StringType), ProcedureParameter.optional("timestamp_pattern", DataTypes.StringType), ProcedureParameter.optional("expire_strategy", DataTypes.StringType), ProcedureParameter.optional("max_expires", DataTypes.IntegerType), ProcedureParameter.optional("options", DataTypes.StringType)};
    private static final StructType OUTPUT_TYPE = new StructType(new StructField[]{new StructField("expired_partitions", DataTypes.StringType, true, Metadata.empty())});

    protected ExpirePartitionsProcedure(TableCatalog tableCatalog) {
        super(tableCatalog);
    }

    @Override
    public ProcedureParameter[] parameters() {
        return PARAMETERS;
    }

    @Override
    public StructType outputType() {
        return OUTPUT_TYPE;
    }

    @Override
    public InternalRow[] call(InternalRow args2) {
        Identifier tableIdent = this.toIdentifier(args2.getString(0), PARAMETERS[0].name());
        String expirationTime = args2.isNullAt(1) ? null : args2.getString(1);
        String timestampFormatter = args2.isNullAt(2) ? null : args2.getString(2);
        String timestampPattern = args2.isNullAt(3) ? null : args2.getString(3);
        String expireStrategy = args2.isNullAt(4) ? null : args2.getString(4);
        Integer maxExpires = args2.isNullAt(5) ? null : Integer.valueOf(args2.getInt(5));
        String options = args2.isNullAt(6) ? null : args2.getString(6);
        return this.modifyPaimonTable(tableIdent, table -> {
            InternalRow[] internalRowArray;
            Map<String, String> dynamicOptions = ProcedureUtils.fillInPartitionOptions(expireStrategy, timestampFormatter, timestampPattern, expirationTime, maxExpires, options);
            table = table.copy(dynamicOptions);
            FileStoreTable fileStoreTable = (FileStoreTable)table;
            FileStore<?> fileStore = fileStoreTable.store();
            PartitionExpire partitionExpire = fileStore.newPartitionExpire("", fileStoreTable);
            Preconditions.checkNotNull(partitionExpire, "Both the partition expiration time and partition field can not be null.");
            List<Map<String, String>> expired = partitionExpire.expire(Long.MAX_VALUE);
            if (expired == null || expired.isEmpty()) {
                InternalRow[] internalRowArray2 = new InternalRow[1];
                internalRowArray = internalRowArray2;
                internalRowArray2[0] = this.newInternalRow(UTF8String.fromString((String)"No expired partitions."));
            } else {
                internalRowArray = (InternalRow[])expired.stream().map(x -> {
                    String r = x.toString();
                    return this.newInternalRow(UTF8String.fromString((String)r.substring(1, r.length() - 1)));
                }).toArray(InternalRow[]::new);
            }
            return internalRowArray;
        });
    }

    public static ProcedureBuilder builder() {
        return new BaseProcedure.Builder<ExpirePartitionsProcedure>(){

            @Override
            public ExpirePartitionsProcedure doBuild() {
                return new ExpirePartitionsProcedure(this.tableCatalog());
            }
        };
    }

    @Override
    public String description() {
        return "ExpirePartitionsProcedure";
    }
}

