/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.memory.MemorySegmentUtils;
import org.apache.paimon.utils.IOUtils;
import org.apache.paimon.utils.Preconditions;

public abstract class BinarySection
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int MAX_FIX_PART_DATA_SIZE = 7;
    public static final long HIGHEST_FIRST_BIT = Long.MIN_VALUE;
    public static final long HIGHEST_SECOND_TO_EIGHTH_BIT = 0x7F00000000000000L;
    protected transient MemorySegment[] segments;
    protected transient int offset;
    protected transient int sizeInBytes;

    public BinarySection() {
    }

    public BinarySection(MemorySegment[] segments, int offset, int sizeInBytes) {
        Preconditions.checkArgument(segments != null);
        this.segments = segments;
        this.offset = offset;
        this.sizeInBytes = sizeInBytes;
    }

    public final void pointTo(MemorySegment segment, int offset, int sizeInBytes) {
        this.pointTo(new MemorySegment[]{segment}, offset, sizeInBytes);
    }

    public void pointTo(MemorySegment[] segments, int offset, int sizeInBytes) {
        Preconditions.checkArgument(segments != null);
        this.segments = segments;
        this.offset = offset;
        this.sizeInBytes = sizeInBytes;
    }

    public MemorySegment[] getSegments() {
        return this.segments;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    public byte[] toBytes() {
        return MemorySegmentUtils.getBytes(this.segments, this.offset, this.sizeInBytes);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        byte[] bytes = this.toBytes();
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] bytes = new byte[in.readInt()];
        IOUtils.readFully((InputStream)in, bytes);
        this.pointTo(MemorySegment.wrap(bytes), 0, bytes.length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinarySection that = (BinarySection)o;
        return this.sizeInBytes == that.sizeInBytes && MemorySegmentUtils.equals(this.segments, this.offset, that.segments, that.offset, this.sizeInBytes);
    }

    public int hashCode() {
        return MemorySegmentUtils.hash(this.segments, this.offset, this.sizeInBytes);
    }
}

