/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.iceberg.manifest;

import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.format.FileFormat;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.iceberg.IcebergOptions;
import org.apache.paimon.iceberg.IcebergPathFactory;
import org.apache.paimon.iceberg.manifest.IcebergManifestFileMeta;
import org.apache.paimon.iceberg.manifest.IcebergManifestFileMetaSerializer;
import org.apache.paimon.options.Options;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.ObjectsFile;
import org.apache.paimon.utils.PathFactory;

public class IcebergManifestList
extends ObjectsFile<IcebergManifestFileMeta> {
    public IcebergManifestList(FileIO fileIO, FileFormat fileFormat, RowType manifestType, String compression, PathFactory pathFactory) {
        super(fileIO, new IcebergManifestFileMetaSerializer(manifestType), manifestType, fileFormat.createReaderFactory(manifestType), fileFormat.createWriterFactory(manifestType), compression, pathFactory, null);
    }

    @VisibleForTesting
    public String compression() {
        return this.compression;
    }

    public static IcebergManifestList create(FileStoreTable table, IcebergPathFactory pathFactory) {
        Options avroOptions = Options.fromMap(table.options());
        avroOptions.set("avro.row-name-mapping", "org.apache.paimon.avro.generated.record:manifest_file,manifest_file_partitions:r508");
        FileFormat fileFormat = FileFormat.fromIdentifier("avro", avroOptions);
        RowType manifestType = IcebergManifestFileMeta.schema(avroOptions.get(IcebergOptions.MANIFEST_LEGACY_VERSION));
        return new IcebergManifestList(table.fileIO(), fileFormat, manifestType, avroOptions.get(IcebergOptions.MANIFEST_COMPRESSION), pathFactory.manifestListFactory());
    }
}

