/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.manifest;

import java.util.function.Function;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataFileMetaSerializer;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.utils.SerializationUtils;
import org.apache.paimon.utils.VersionedObjectSerializer;

public class ManifestEntrySerializer
extends VersionedObjectSerializer<ManifestEntry> {
    private static final long serialVersionUID = 1L;
    private final DataFileMetaSerializer dataFileMetaSerializer = new DataFileMetaSerializer();

    public ManifestEntrySerializer() {
        super(ManifestEntry.SCHEMA);
    }

    @Override
    public int getVersion() {
        return 2;
    }

    @Override
    public InternalRow convertTo(ManifestEntry entry) {
        GenericRow row = new GenericRow(5);
        row.setField(0, entry.kind().toByteValue());
        row.setField(1, SerializationUtils.serializeBinaryRow(entry.partition()));
        row.setField(2, entry.bucket());
        row.setField(3, entry.totalBuckets());
        row.setField(4, this.dataFileMetaSerializer.toRow(entry.file()));
        return row;
    }

    @Override
    public ManifestEntry convertFrom(int version, InternalRow row) {
        if (version != 2) {
            if (version == 1) {
                throw new IllegalArgumentException(String.format("The current version %s is not compatible with the version %s, please recreate the table.", this.getVersion(), version));
            }
            throw new IllegalArgumentException("Unsupported version: " + version);
        }
        return new ManifestEntry(FileKind.fromByteValue(row.getByte(0)), SerializationUtils.deserializeBinaryRow(row.getBinary(1)), row.getInt(2), row.getInt(3), this.dataFileMetaSerializer.fromRow(row.getRow(4, this.dataFileMetaSerializer.numFields())));
    }

    public static Function<InternalRow, FileKind> kindGetter() {
        return row -> FileKind.fromByteValue(row.getByte(1));
    }

    public static Function<InternalRow, BinaryRow> partitionGetter() {
        return row -> SerializationUtils.deserializeBinaryRow(row.getBinary(2));
    }

    public static Function<InternalRow, Integer> bucketGetter() {
        return row -> row.getInt(3);
    }

    public static Function<InternalRow, Integer> totalBucketGetter() {
        return row -> row.getInt(4);
    }

    public static Function<InternalRow, String> fileNameGetter() {
        return row -> row.getRow(5, DataFileMeta.SCHEMA.getFieldCount()).getString(0).toString();
    }

    public static Function<InternalRow, Integer> levelGetter() {
        return row -> row.getRow(5, DataFileMeta.SCHEMA.getFieldCount()).getInt(10);
    }
}

