/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.memory;

import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.memory.MemorySegmentPool;

public class ArraySegmentPool
implements MemorySegmentPool {
    private final Queue<MemorySegment> segments;
    private final int pageSize;

    public ArraySegmentPool(List<MemorySegment> segments) {
        this.segments = new LinkedList<MemorySegment>(segments);
        this.pageSize = segments.get(0).size();
    }

    @Override
    public int pageSize() {
        return this.pageSize;
    }

    @Override
    public void returnAll(List<MemorySegment> memory) {
        this.segments.addAll(memory);
    }

    @Override
    public int freePages() {
        return this.segments.size();
    }

    @Override
    public MemorySegment nextSegment() {
        return this.segments.poll();
    }
}

