/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark;

import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.data.variant.Variant;
import org.apache.paimon.spark.util.SparkRowUtils$;
import org.apache.paimon.spark.util.shim.TypeUtils$;
import org.apache.paimon.types.RowKind;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.DateTimeUtils;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.paimon.shims.SparkShimLoader;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType;
import org.apache.spark.sql.types.TimestampType;

public class SparkInternalRowWrapper
implements org.apache.paimon.data.InternalRow,
Serializable {
    private transient InternalRow internalRow;
    private final int length;
    private final int rowKindIdx;
    private final StructType structType;

    public SparkInternalRowWrapper(InternalRow internalRow, int rowKindIdx, StructType structType, int length) {
        this.internalRow = internalRow;
        this.rowKindIdx = rowKindIdx;
        this.length = length;
        this.structType = structType;
    }

    public SparkInternalRowWrapper(int rowKindIdx, StructType structType, int length) {
        this.rowKindIdx = rowKindIdx;
        this.length = length;
        this.structType = structType;
    }

    public SparkInternalRowWrapper replace(InternalRow internalRow) {
        this.internalRow = internalRow;
        return this;
    }

    @Override
    public int getFieldCount() {
        return this.length;
    }

    @Override
    public RowKind getRowKind() {
        return SparkRowUtils$.MODULE$.getRowKind(this.internalRow, this.rowKindIdx);
    }

    @Override
    public void setRowKind(RowKind kind) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isNullAt(int pos) {
        return this.internalRow.isNullAt(pos);
    }

    @Override
    public boolean getBoolean(int pos) {
        return this.internalRow.getBoolean(pos);
    }

    @Override
    public byte getByte(int pos) {
        return this.internalRow.getByte(pos);
    }

    @Override
    public short getShort(int pos) {
        return this.internalRow.getShort(pos);
    }

    @Override
    public int getInt(int pos) {
        return this.internalRow.getInt(pos);
    }

    @Override
    public long getLong(int pos) {
        return this.internalRow.getLong(pos);
    }

    @Override
    public float getFloat(int pos) {
        return this.internalRow.getFloat(pos);
    }

    @Override
    public double getDouble(int pos) {
        return this.internalRow.getDouble(pos);
    }

    @Override
    public BinaryString getString(int pos) {
        return BinaryString.fromBytes(this.internalRow.getUTF8String(pos).getBytes());
    }

    @Override
    public org.apache.paimon.data.Decimal getDecimal(int pos, int precision, int scale) {
        Decimal decimal = this.internalRow.getDecimal(pos, precision, scale);
        BigDecimal bigDecimal = decimal.toJavaBigDecimal();
        return org.apache.paimon.data.Decimal.fromBigDecimal(bigDecimal, precision, scale);
    }

    @Override
    public Timestamp getTimestamp(int pos, int precision) {
        return SparkInternalRowWrapper.convertToTimestamp(this.structType.fields()[pos].dataType(), this.internalRow.getLong(pos));
    }

    @Override
    public byte[] getBinary(int pos) {
        return this.internalRow.getBinary(pos);
    }

    @Override
    public Variant getVariant(int pos) {
        return SparkShimLoader.shim().toPaimonVariant(this.internalRow, pos);
    }

    @Override
    public InternalArray getArray(int pos) {
        return new SparkInternalArray(this.internalRow.getArray(pos), ((ArrayType)this.structType.fields()[pos].dataType()).elementType());
    }

    @Override
    public InternalMap getMap(int pos) {
        MapType mapType = (MapType)this.structType.fields()[pos].dataType();
        return new SparkInternalMap(this.internalRow.getMap(pos), mapType.keyType(), mapType.valueType());
    }

    @Override
    public org.apache.paimon.data.InternalRow getRow(int pos, int numFields) {
        return new SparkInternalRowWrapper(this.internalRow.getStruct(pos, numFields), -1, (StructType)this.structType.fields()[pos].dataType(), numFields);
    }

    private static Timestamp convertToTimestamp(DataType dataType, long micros) {
        if (dataType instanceof TimestampType) {
            if (TypeUtils$.MODULE$.treatPaimonTimestampTypeAsSparkTimestampType()) {
                return Timestamp.fromSQLTimestamp(DateTimeUtils.toJavaTimestamp((long)micros));
            }
            return Timestamp.fromMicros(micros);
        }
        if (dataType instanceof TimestampNTZType) {
            return Timestamp.fromMicros(micros);
        }
        throw new UnsupportedOperationException("Unsupported data type:" + dataType);
    }

    public static class SparkInternalMap
    implements InternalMap {
        private final MapData mapData;
        private final DataType keyType;
        private final DataType valueType;

        public SparkInternalMap(MapData mapData, DataType keyType, DataType valueType) {
            this.mapData = mapData;
            this.keyType = keyType;
            this.valueType = valueType;
        }

        @Override
        public int size() {
            return this.mapData.numElements();
        }

        @Override
        public InternalArray keyArray() {
            return new SparkInternalArray(this.mapData.keyArray(), this.keyType);
        }

        @Override
        public InternalArray valueArray() {
            return new SparkInternalArray(this.mapData.valueArray(), this.valueType);
        }
    }

    public static class SparkInternalArray
    implements InternalArray {
        private final ArrayData arrayData;
        private final DataType elementType;

        public SparkInternalArray(ArrayData arrayData, DataType elementType) {
            this.arrayData = arrayData;
            this.elementType = elementType;
        }

        @Override
        public int size() {
            return this.arrayData.numElements();
        }

        @Override
        public boolean[] toBooleanArray() {
            return this.arrayData.toBooleanArray();
        }

        @Override
        public byte[] toByteArray() {
            return this.arrayData.toByteArray();
        }

        @Override
        public short[] toShortArray() {
            return this.arrayData.toShortArray();
        }

        @Override
        public int[] toIntArray() {
            return this.arrayData.toIntArray();
        }

        @Override
        public long[] toLongArray() {
            return this.arrayData.toLongArray();
        }

        @Override
        public float[] toFloatArray() {
            return this.arrayData.toFloatArray();
        }

        @Override
        public double[] toDoubleArray() {
            return this.arrayData.toDoubleArray();
        }

        @Override
        public boolean isNullAt(int pos) {
            return this.arrayData.isNullAt(pos);
        }

        @Override
        public boolean getBoolean(int pos) {
            return this.arrayData.getBoolean(pos);
        }

        @Override
        public byte getByte(int pos) {
            return this.arrayData.getByte(pos);
        }

        @Override
        public short getShort(int pos) {
            return this.arrayData.getShort(pos);
        }

        @Override
        public int getInt(int pos) {
            return this.arrayData.getInt(pos);
        }

        @Override
        public long getLong(int pos) {
            return this.arrayData.getLong(pos);
        }

        @Override
        public float getFloat(int pos) {
            return this.arrayData.getFloat(pos);
        }

        @Override
        public double getDouble(int pos) {
            return this.arrayData.getDouble(pos);
        }

        @Override
        public BinaryString getString(int pos) {
            return BinaryString.fromBytes(this.arrayData.getUTF8String(pos).getBytes());
        }

        @Override
        public org.apache.paimon.data.Decimal getDecimal(int pos, int precision, int scale) {
            Decimal decimal = this.arrayData.getDecimal(pos, precision, scale);
            return org.apache.paimon.data.Decimal.fromBigDecimal(decimal.toJavaBigDecimal(), precision, scale);
        }

        @Override
        public Timestamp getTimestamp(int pos, int precision) {
            return SparkInternalRowWrapper.convertToTimestamp(this.elementType, this.arrayData.getLong(pos));
        }

        @Override
        public byte[] getBinary(int pos) {
            return this.arrayData.getBinary(pos);
        }

        @Override
        public Variant getVariant(int pos) {
            return SparkShimLoader.shim().toPaimonVariant(this.arrayData, pos);
        }

        @Override
        public InternalArray getArray(int pos) {
            return new SparkInternalArray(this.arrayData.getArray(pos), ((ArrayType)this.elementType).elementType());
        }

        @Override
        public InternalMap getMap(int pos) {
            MapType mapType = (MapType)this.elementType;
            return new SparkInternalMap(this.arrayData.getMap(pos), mapType.keyType(), mapType.valueType());
        }

        @Override
        public org.apache.paimon.data.InternalRow getRow(int pos, int numFields) {
            return new SparkInternalRowWrapper(this.arrayData.getStruct(pos, numFields), -1, (StructType)this.elementType, numFields);
        }
    }
}

