/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark;

import java.io.Serializable;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.spark.PaimonPartitionManagement;
import org.apache.paimon.spark.PaimonScanBuilder;
import org.apache.paimon.spark.PaimonSplitScanBuilder;
import org.apache.paimon.spark.SparkSource$;
import org.apache.paimon.spark.SparkTable$;
import org.apache.paimon.spark.SparkTypeUtils;
import org.apache.paimon.spark.catalog.functions.BucketFunction$;
import org.apache.paimon.spark.schema.PaimonMetadataColumn$;
import org.apache.paimon.spark.util.OptionUtils$;
import org.apache.paimon.spark.write.PaimonV2WriteBuilder;
import org.apache.paimon.spark.write.PaimonWriteBuilder;
import org.apache.paimon.table.BucketMode;
import org.apache.paimon.table.DataTable;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.KnownSplitsTable;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.StringUtils;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.Column;
import org.apache.spark.sql.connector.catalog.MetadataColumn;
import org.apache.spark.sql.connector.catalog.SupportsMetadataColumns;
import org.apache.spark.sql.connector.catalog.SupportsRead;
import org.apache.spark.sql.connector.catalog.SupportsWrite;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.expressions.Expressions;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.connector.write.LogicalWriteInfo;
import org.apache.spark.sql.connector.write.WriteBuilder;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005}h\u0001\u0002\u0011\"\u0001*B\u0001\u0002\u0016\u0001\u0003\u0016\u0004%\t!\u0016\u0005\t5\u0002\u0011\t\u0012)A\u0005-\")1\f\u0001C\u00019\"Aq\f\u0001EC\u0002\u0013%\u0001\rC\u0003e\u0001\u0011%\u0001\rC\u0003f\u0001\u0011\u0005Q\u000bC\u0003g\u0001\u0011\u0005s\r\u0003\u0005t\u0001!\u0015\r\u0011\"\u0011u\u0011\u0015Y\b\u0001\"\u0011}\u0011\u001d\ti\u0001\u0001C!\u0003\u001fAq!!\b\u0001\t\u0003\ny\u0002C\u0004\u0002.\u0001!\t%a\f\t\u000f\u0005e\u0002\u0001\"\u0011\u0002<!9\u0011q\u000b\u0001\u0005B\u0005e\u0003BBA9\u0001\u0011\u0005s\rC\u0005\u0002t\u0001\t\t\u0011\"\u0001\u0002v!I\u0011\u0011\u0010\u0001\u0012\u0002\u0013\u0005\u00111\u0010\u0005\n\u0003#\u0003\u0011\u0011!C!\u0003'C\u0011\"!'\u0001\u0003\u0003%\t!a'\t\u0013\u0005\r\u0006!!A\u0005\u0002\u0005\u0015\u0006\"CAY\u0001\u0005\u0005I\u0011IAZ\u0011%\t\t\rAA\u0001\n\u0003\t\u0019\rC\u0005\u0002H\u0002\t\t\u0011\"\u0011\u0002J\"I\u00111\u001a\u0001\u0002\u0002\u0013\u0005\u0013QZ\u0004\n\u0003#\f\u0013\u0011!E\u0001\u0003'4\u0001\u0002I\u0011\u0002\u0002#\u0005\u0011Q\u001b\u0005\u00077j!\t!a9\t\u0013\u0005E$$!A\u0005F\u0005\u0015\b\"CAt5\u0005\u0005I\u0011QAu\u0011%\tiOGA\u0001\n\u0003\u000by\u000fC\u0005\u0002|j\t\t\u0011\"\u0003\u0002~\nQ1\u000b]1sWR\u000b'\r\\3\u000b\u0005\t\u001a\u0013!B:qCJ\\'B\u0001\u0013&\u0003\u0019\u0001\u0018-[7p]*\u0011aeJ\u0001\u0007CB\f7\r[3\u000b\u0003!\n1a\u001c:h\u0007\u0001\u0019\u0012\u0002A\u00164}\u0005#uiS)\u0011\u00051\nT\"A\u0017\u000b\u00059z\u0013\u0001\u00027b]\u001eT\u0011\u0001M\u0001\u0005U\u00064\u0018-\u0003\u00023[\t1qJ\u00196fGR\u0004\"\u0001\u000e\u001f\u000e\u0003UR!AN\u001c\u0002\u000f\r\fG/\u00197pO*\u0011\u0001(O\u0001\nG>tg.Z2u_JT!AO\u001e\u0002\u0007M\fHN\u0003\u0002#K%\u0011Q(\u000e\u0002\u0006)\u0006\u0014G.\u001a\t\u0003i}J!\u0001Q\u001b\u0003\u0019M+\b\u000f]8siN\u0014V-\u00193\u0011\u0005Q\u0012\u0015BA\"6\u00055\u0019V\u000f\u001d9peR\u001cxK]5uKB\u0011A'R\u0005\u0003\rV\u0012qcU;qa>\u0014Ho]'fi\u0006$\u0017\r^1D_2,XN\\:\u0011\u0005!KU\"A\u0011\n\u0005)\u000b#!\u0007)bS6|g\u000eU1si&$\u0018n\u001c8NC:\fw-Z7f]R\u0004\"\u0001T(\u000e\u00035S\u0011AT\u0001\u0006g\u000e\fG.Y\u0005\u0003!6\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002M%&\u00111+\u0014\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0006i\u0006\u0014G.Z\u000b\u0002-B\u0011q+W\u0007\u00021*\u0011AkI\u0005\u0003{a\u000ba\u0001^1cY\u0016\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002^=B\u0011\u0001\n\u0001\u0005\u0006)\u000e\u0001\rAV\u0001\u000bkN,gKM,sSR,W#A1\u0011\u00051\u0013\u0017BA2N\u0005\u001d\u0011un\u001c7fC:\fqb];qa>\u0014Ho\u001d,3/JLG/Z\u0001\tO\u0016$H+\u00192mK\u0006!a.Y7f)\u0005A\u0007CA5q\u001d\tQg\u000e\u0005\u0002l\u001b6\tAN\u0003\u0002nS\u00051AH]8pizJ!a\\'\u0002\rA\u0013X\rZ3g\u0013\t\t(O\u0001\u0004TiJLgn\u001a\u0006\u0003_6\u000baa]2iK6\fW#A;\u0011\u0005YLX\"A<\u000b\u0005aL\u0014!\u0002;za\u0016\u001c\u0018B\u0001>x\u0005)\u0019FO];diRK\b/Z\u0001\ra\u0006\u0014H/\u001b;j_:Lgn\u001a\u000b\u0002{B!AJ`A\u0001\u0013\tyXJA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0002\u0004\u0005%QBAA\u0003\u0015\r\t9aN\u0001\fKb\u0004(/Z:tS>t7/\u0003\u0003\u0002\f\u0005\u0015!!\u0003+sC:\u001chm\u001c:n\u0003)\u0001(o\u001c9feRLWm\u001d\u000b\u0003\u0003#\u0001b!a\u0005\u0002\u001a!DWBAA\u000b\u0015\r\t9bL\u0001\u0005kRLG.\u0003\u0003\u0002\u001c\u0005U!aA'ba\u0006a1-\u00199bE&d\u0017\u000e^5fgR\u0011\u0011\u0011\u0005\t\u0007\u0003'\t\u0019#a\n\n\t\u0005\u0015\u0012Q\u0003\u0002\u0004'\u0016$\bc\u0001\u001b\u0002*%\u0019\u00111F\u001b\u0003\u001fQ\u000b'\r\\3DCB\f'-\u001b7jif\fq\"\\3uC\u0012\fG/Y\"pYVlgn\u001d\u000b\u0003\u0003c\u0001B\u0001\u0014@\u00024A\u0019A'!\u000e\n\u0007\u0005]RG\u0001\bNKR\fG-\u0019;b\u0007>dW/\u001c8\u0002\u001d9,woU2b]\n+\u0018\u000e\u001c3feR!\u0011QHA%!\u0011\ty$!\u0012\u000e\u0005\u0005\u0005#bAA\"o\u0005!!/Z1e\u0013\u0011\t9%!\u0011\u0003\u0017M\u001b\u0017M\u001c\"vS2$WM\u001d\u0005\b\u0003\u0017j\u0001\u0019AA'\u0003\u001dy\u0007\u000f^5p]N\u0004B!a\u0014\u0002T5\u0011\u0011\u0011\u000b\u0006\u0004\u0003/I\u0014\u0002BA+\u0003#\u0012\u0001dQ1tK&s7/\u001a8tSRLg/Z*ue&tw-T1q\u0003=qWm^,sSR,')^5mI\u0016\u0014H\u0003BA.\u0003O\u0002B!!\u0018\u0002d5\u0011\u0011q\f\u0006\u0004\u0003C:\u0014!B<sSR,\u0017\u0002BA3\u0003?\u0012Ab\u0016:ji\u0016\u0014U/\u001b7eKJDq!!\u001b\u000f\u0001\u0004\tY'\u0001\u0003j]\u001a|\u0007\u0003BA/\u0003[JA!a\u001c\u0002`\t\u0001Bj\\4jG\u0006dwK]5uK&sgm\\\u0001\ti>\u001cFO]5oO\u0006!1m\u001c9z)\ri\u0016q\u000f\u0005\b)B\u0001\n\u00111\u0001W\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!! +\u0007Y\u000byh\u000b\u0002\u0002\u0002B!\u00111QAG\u001b\t\t)I\u0003\u0003\u0002\b\u0006%\u0015!C;oG\",7m[3e\u0015\r\tY)T\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAH\u0003\u000b\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u0013\t\u0004Y\u0005]\u0015BA9.\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ti\nE\u0002M\u0003?K1!!)N\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t9+!,\u0011\u00071\u000bI+C\u0002\u0002,6\u00131!\u00118z\u0011%\ty\u000bFA\u0001\u0002\u0004\ti*A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003k\u0003b!a.\u0002>\u0006\u001dVBAA]\u0015\r\tY,T\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA`\u0003s\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019\u0011-!2\t\u0013\u0005=f#!AA\u0002\u0005\u001d\u0016\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005u\u0015AB3rk\u0006d7\u000fF\u0002b\u0003\u001fD\u0011\"a,\u0019\u0003\u0003\u0005\r!a*\u0002\u0015M\u0003\u0018M]6UC\ndW\r\u0005\u0002I5M!!$a6R!\u0019\tI.a8W;6\u0011\u00111\u001c\u0006\u0004\u0003;l\u0015a\u0002:v]RLW.Z\u0005\u0005\u0003C\fYNA\tBEN$(/Y2u\rVt7\r^5p]F\"\"!a5\u0015\u0005\u0005U\u0015!B1qa2LHcA/\u0002l\")A+\ba\u0001-\u00069QO\\1qa2LH\u0003BAy\u0003o\u0004B\u0001TAz-&\u0019\u0011Q_'\u0003\r=\u0003H/[8o\u0011!\tIPHA\u0001\u0002\u0004i\u0016a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\u0005Y\u0003")
public class SparkTable
implements Table,
SupportsRead,
SupportsWrite,
SupportsMetadataColumns,
PaimonPartitionManagement,
Product,
scala.Serializable {
    private boolean useV2Write;
    private StructType schema;
    private final org.apache.paimon.table.Table table;
    private RowType partitionRowType;
    private StructType partitionSchema;
    private volatile byte bitmap$0;

    public static Option<org.apache.paimon.table.Table> unapply(SparkTable sparkTable) {
        return SparkTable$.MODULE$.unapply(sparkTable);
    }

    public static SparkTable apply(org.apache.paimon.table.Table table) {
        return SparkTable$.MODULE$.apply(table);
    }

    public static <A> Function1<org.apache.paimon.table.Table, A> andThen(Function1<SparkTable, A> function1) {
        return SparkTable$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, SparkTable> compose(Function1<A, org.apache.paimon.table.Table> function1) {
        return SparkTable$.MODULE$.compose(function1);
    }

    @Override
    public boolean dropPartitions(InternalRow[] rows) {
        return PaimonPartitionManagement.dropPartitions$(this, rows);
    }

    @Override
    public void replacePartitionMetadata(InternalRow ident, Map<String, String> properties) {
        PaimonPartitionManagement.replacePartitionMetadata$(this, ident, properties);
    }

    @Override
    public Map<String, String> loadPartitionMetadata(InternalRow ident) {
        return PaimonPartitionManagement.loadPartitionMetadata$(this, ident);
    }

    @Override
    public InternalRow[] listPartitionIdentifiers(String[] partitionCols, InternalRow internalRow) {
        return PaimonPartitionManagement.listPartitionIdentifiers$(this, partitionCols, internalRow);
    }

    @Override
    public void createPartitions(InternalRow[] rows, Map<String, String>[] maps) {
        PaimonPartitionManagement.createPartitions$(this, rows, maps);
    }

    public boolean canRenameConflictingMetadataColumns() {
        return super.canRenameConflictingMetadataColumns();
    }

    public Column[] columns() {
        return super.columns();
    }

    private RowType partitionRowType$lzycompute() {
        SparkTable sparkTable = this;
        synchronized (sparkTable) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.partitionRowType = PaimonPartitionManagement.partitionRowType$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.partitionRowType;
    }

    @Override
    public RowType partitionRowType() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.partitionRowType$lzycompute();
        }
        return this.partitionRowType;
    }

    private StructType partitionSchema$lzycompute() {
        SparkTable sparkTable = this;
        synchronized (sparkTable) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.partitionSchema = PaimonPartitionManagement.partitionSchema$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.partitionSchema;
    }

    @Override
    public StructType partitionSchema() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.partitionSchema$lzycompute();
        }
        return this.partitionSchema;
    }

    public org.apache.paimon.table.Table table() {
        return this.table;
    }

    private boolean useV2Write$lzycompute() {
        SparkTable sparkTable = this;
        synchronized (sparkTable) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                boolean v2WriteConfigured = OptionUtils$.MODULE$.useV2Write();
                this.useV2Write = v2WriteConfigured && this.supportsV2Write();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.useV2Write;
    }

    private boolean useV2Write() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.useV2Write$lzycompute();
        }
        return this.useV2Write;
    }

    private boolean supportsV2Write() {
        org.apache.paimon.table.Table table = this.table();
        if (table instanceof FileStoreTable) {
            FileStoreTable fileStoreTable = (FileStoreTable)table;
            BucketMode bucketMode = fileStoreTable.bucketMode();
            if (((Object)((Object)BucketMode.HASH_FIXED)).equals((Object)bucketMode)) {
                return BucketFunction$.MODULE$.supportsTable(fileStoreTable);
            }
            return ((Object)((Object)BucketMode.BUCKET_UNAWARE)).equals((Object)bucketMode) ? true : ((Object)((Object)BucketMode.POSTPONE_MODE)).equals((Object)bucketMode);
        }
        return false;
    }

    public org.apache.paimon.table.Table getTable() {
        return this.table();
    }

    public String name() {
        return this.table().fullName();
    }

    private StructType schema$lzycompute() {
        SparkTable sparkTable = this;
        synchronized (sparkTable) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.schema = SparkTypeUtils.fromPaimonRowType(this.table().rowType());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.schema;
    }

    public StructType schema() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.schema$lzycompute();
        }
        return this.schema;
    }

    public Transform[] partitioning() {
        return (Transform[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.table().partitionKeys()).asScala()).map((Function1 & Serializable & scala.Serializable)p -> Expressions.identity((String)StringUtils.quote(p)), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Transform.class));
    }

    public Map<String, String> properties() {
        org.apache.paimon.table.Table table = this.table();
        if (table instanceof DataTable) {
            DataTable dataTable = (DataTable)table;
            HashMap<String, String> properties = new HashMap<String, String>(dataTable.coreOptions().toMap());
            Object object = !this.table().primaryKeys().isEmpty() ? properties.put(CoreOptions.PRIMARY_KEY.key(), String.join((CharSequence)",", this.table().primaryKeys())) : BoxedUnit.UNIT;
            properties.put("provider", SparkSource$.MODULE$.NAME());
            Object object2 = this.table().comment().isPresent() ? properties.put("comment", this.table().comment().get()) : BoxedUnit.UNIT;
            Object object3 = properties.containsKey(CoreOptions.PATH.key()) ? properties.put("location", properties.get(CoreOptions.PATH.key())) : BoxedUnit.UNIT;
            return properties;
        }
        return Collections.emptyMap();
    }

    public Set<TableCapability> capabilities() {
        boolean bl;
        EnumSet<TableCapability> capabilities = EnumSet.of(TableCapability.BATCH_READ, TableCapability.OVERWRITE_BY_FILTER, TableCapability.OVERWRITE_DYNAMIC, TableCapability.MICRO_BATCH_READ);
        if (this.useV2Write()) {
            bl = capabilities.add(TableCapability.BATCH_WRITE);
        } else {
            capabilities.add(TableCapability.ACCEPT_ANY_SCHEMA);
            bl = capabilities.add(TableCapability.V1_BATCH_WRITE);
        }
        return capabilities;
    }

    public MetadataColumn[] metadataColumns() {
        StructType partitionType = SparkTypeUtils.toSparkPartitionType(this.table());
        return (MetadataColumn[])((Object[])new MetadataColumn[]{PaimonMetadataColumn$.MODULE$.FILE_PATH(), PaimonMetadataColumn$.MODULE$.ROW_INDEX(), (MetadataColumn)PaimonMetadataColumn$.MODULE$.PARTITION().apply((Object)partitionType), PaimonMetadataColumn$.MODULE$.BUCKET()});
    }

    public ScanBuilder newScanBuilder(CaseInsensitiveStringMap options) {
        org.apache.paimon.table.Table table = this.table();
        if (table instanceof KnownSplitsTable) {
            KnownSplitsTable knownSplitsTable = (KnownSplitsTable)table;
            return new PaimonSplitScanBuilder(knownSplitsTable);
        }
        return new PaimonScanBuilder(this.table().copy(options.asCaseSensitiveMap()));
    }

    public WriteBuilder newWriteBuilder(LogicalWriteInfo info) {
        org.apache.paimon.table.Table table = this.table();
        if (table instanceof FileStoreTable) {
            FileStoreTable fileStoreTable = (FileStoreTable)table;
            Options options = Options.fromMap((Map<String, String>)info.options());
            if (this.useV2Write()) {
                return new PaimonV2WriteBuilder(fileStoreTable, info.schema());
            }
            return new PaimonWriteBuilder(fileStoreTable, options);
        }
        throw new RuntimeException("Only FileStoreTable can be written.");
    }

    public String toString() {
        return new StringBuilder(2).append(this.table().getClass().getSimpleName()).append("[").append(this.table().fullName()).append("]").toString();
    }

    public SparkTable copy(org.apache.paimon.table.Table table) {
        return new SparkTable(table);
    }

    public org.apache.paimon.table.Table copy$default$1() {
        return this.table();
    }

    public String productPrefix() {
        return "SparkTable";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.table();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SparkTable;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SparkTable)) return false;
        boolean bl = true;
        if (!bl) return false;
        SparkTable sparkTable = (SparkTable)x$1;
        org.apache.paimon.table.Table table = this.table();
        org.apache.paimon.table.Table table2 = sparkTable.table();
        if (table == null) {
            if (table2 != null) {
                return false;
            }
        } else if (!table.equals(table2)) return false;
        if (!sparkTable.canEqual(this)) return false;
        return true;
    }

    public SparkTable(org.apache.paimon.table.Table table) {
        this.table = table;
        PaimonPartitionManagement.$init$(this);
        Product.$init$((Product)this);
    }
}

