/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.procedure;

import java.util.List;
import java.util.Map;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.function.FunctionImpl;
import org.apache.paimon.shade.guava30.com.google.common.collect.Maps;
import org.apache.paimon.spark.catalog.WithPaimonCatalog;
import org.apache.paimon.spark.procedure.BaseProcedure;
import org.apache.paimon.spark.procedure.ProcedureBuilder;
import org.apache.paimon.spark.procedure.ProcedureParameter;
import org.apache.paimon.spark.utils.CatalogUtils;
import org.apache.paimon.types.DataField;
import org.apache.paimon.utils.ParameterUtils;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class CreateFunctionProcedure
extends BaseProcedure {
    private static final ProcedureParameter[] PARAMETERS = new ProcedureParameter[]{ProcedureParameter.required("function", DataTypes.StringType), ProcedureParameter.required("inputParams", DataTypes.StringType), ProcedureParameter.required("returnParams", DataTypes.StringType), ProcedureParameter.optional("deterministic", DataTypes.BooleanType), ProcedureParameter.optional("comment", DataTypes.StringType), ProcedureParameter.optional("options", DataTypes.StringType)};
    private static final StructType OUTPUT_TYPE = new StructType(new StructField[]{new StructField("result", DataTypes.BooleanType, true, Metadata.empty())});

    protected CreateFunctionProcedure(TableCatalog tableCatalog) {
        super(tableCatalog);
    }

    @Override
    public ProcedureParameter[] parameters() {
        return PARAMETERS;
    }

    @Override
    public StructType outputType() {
        return OUTPUT_TYPE;
    }

    @Override
    public InternalRow[] call(InternalRow args2) {
        Catalog paimonCatalog = ((WithPaimonCatalog)this.tableCatalog()).paimonCatalog();
        Identifier ident = this.toIdentifier(args2.getString(0), PARAMETERS[0].name());
        org.apache.paimon.catalog.Identifier function = CatalogUtils.toIdentifier(ident);
        List<DataField> inputParams = CreateFunctionProcedure.getDataFieldsFromArguments(1, args2);
        List<DataField> returnParams = CreateFunctionProcedure.getDataFieldsFromArguments(2, args2);
        boolean deterministic = args2.isNullAt(3) ? true : args2.getBoolean(3);
        String comment = args2.isNullAt(4) ? null : args2.getString(4);
        String properties = args2.isNullAt(5) ? null : args2.getString(5);
        Map<String, String> options = ParameterUtils.parseCommaSeparatedKeyValues(properties);
        try {
            FunctionImpl functionImpl = new FunctionImpl(function, inputParams, returnParams, deterministic, Maps.newHashMap(), comment, options);
            paimonCatalog.createFunction(function, functionImpl, false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new InternalRow[]{this.newInternalRow(true)};
    }

    public static ProcedureBuilder builder() {
        return new BaseProcedure.Builder<CreateFunctionProcedure>(){

            @Override
            public CreateFunctionProcedure doBuild() {
                return new CreateFunctionProcedure(this.tableCatalog());
            }
        };
    }

    @Override
    public String description() {
        return "CreateFunctionProcedure";
    }

    public static List<DataField> getDataFieldsFromArguments(int position, InternalRow args2) {
        String data = args2.isNullAt(position) ? null : args2.getString(position);
        return ParameterUtils.parseDataFieldArray(data);
    }
}

