/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.casting;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.data.variant.Variant;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.DefaultValueUtils;

public class DefaultValueRow
implements InternalRow {
    private InternalRow row;
    private final InternalRow defaultValueRow;

    private DefaultValueRow(InternalRow defaultValueRow) {
        this.defaultValueRow = defaultValueRow;
    }

    public DefaultValueRow replaceRow(InternalRow row) {
        this.row = row;
        return this;
    }

    public InternalRow defaultValueRow() {
        return this.defaultValueRow;
    }

    @Override
    public int getFieldCount() {
        return this.row.getFieldCount();
    }

    @Override
    public RowKind getRowKind() {
        return this.row.getRowKind();
    }

    @Override
    public void setRowKind(RowKind kind) {
        this.row.setRowKind(kind);
    }

    @Override
    public boolean isNullAt(int pos) {
        return this.row.isNullAt(pos) && this.defaultValueRow.isNullAt(pos);
    }

    @Override
    public boolean getBoolean(int pos) {
        if (!this.row.isNullAt(pos)) {
            return this.row.getBoolean(pos);
        }
        return this.defaultValueRow.getBoolean(pos);
    }

    @Override
    public byte getByte(int pos) {
        if (!this.row.isNullAt(pos)) {
            return this.row.getByte(pos);
        }
        return this.defaultValueRow.getByte(pos);
    }

    @Override
    public short getShort(int pos) {
        if (!this.row.isNullAt(pos)) {
            return this.row.getShort(pos);
        }
        return this.defaultValueRow.getShort(pos);
    }

    @Override
    public int getInt(int pos) {
        if (!this.row.isNullAt(pos)) {
            return this.row.getInt(pos);
        }
        return this.defaultValueRow.getInt(pos);
    }

    @Override
    public long getLong(int pos) {
        if (!this.row.isNullAt(pos)) {
            return this.row.getLong(pos);
        }
        return this.defaultValueRow.getLong(pos);
    }

    @Override
    public float getFloat(int pos) {
        if (!this.row.isNullAt(pos)) {
            return this.row.getFloat(pos);
        }
        return this.defaultValueRow.getFloat(pos);
    }

    @Override
    public double getDouble(int pos) {
        if (!this.row.isNullAt(pos)) {
            return this.row.getDouble(pos);
        }
        return this.defaultValueRow.getDouble(pos);
    }

    @Override
    public BinaryString getString(int pos) {
        if (!this.row.isNullAt(pos)) {
            return this.row.getString(pos);
        }
        return this.defaultValueRow.getString(pos);
    }

    @Override
    public Decimal getDecimal(int pos, int precision, int scale) {
        if (!this.row.isNullAt(pos)) {
            return this.row.getDecimal(pos, precision, scale);
        }
        return this.defaultValueRow.getDecimal(pos, precision, scale);
    }

    @Override
    public Timestamp getTimestamp(int pos, int precision) {
        if (!this.row.isNullAt(pos)) {
            return this.row.getTimestamp(pos, precision);
        }
        return this.defaultValueRow.getTimestamp(pos, precision);
    }

    @Override
    public byte[] getBinary(int pos) {
        if (!this.row.isNullAt(pos)) {
            return this.row.getBinary(pos);
        }
        return this.defaultValueRow.getBinary(pos);
    }

    @Override
    public InternalArray getArray(int pos) {
        if (!this.row.isNullAt(pos)) {
            return this.row.getArray(pos);
        }
        return this.defaultValueRow.getArray(pos);
    }

    @Override
    public InternalMap getMap(int pos) {
        if (!this.row.isNullAt(pos)) {
            return this.row.getMap(pos);
        }
        return this.defaultValueRow.getMap(pos);
    }

    @Override
    public InternalRow getRow(int pos, int numFields) {
        if (!this.row.isNullAt(pos)) {
            return this.row.getRow(pos, numFields);
        }
        return this.defaultValueRow.getRow(pos, numFields);
    }

    @Override
    public Variant getVariant(int pos) {
        if (!this.row.isNullAt(pos)) {
            return this.row.getVariant(pos);
        }
        return this.defaultValueRow.getVariant(pos);
    }

    public static DefaultValueRow from(InternalRow defaultValueRow) {
        return new DefaultValueRow(defaultValueRow);
    }

    @Nullable
    public static DefaultValueRow create(RowType rowType) {
        List<DataField> fields = rowType.getFields();
        GenericRow row = new GenericRow(fields.size());
        boolean containsDefaultValue = false;
        for (int i = 0; i < fields.size(); ++i) {
            DataField dataField = fields.get(i);
            String defaultValueStr = dataField.defaultValue();
            if (defaultValueStr == null) continue;
            containsDefaultValue = true;
            Object defaultValue = DefaultValueUtils.convertDefaultValue(dataField.type(), defaultValueStr);
            row.setField(i, defaultValue);
        }
        if (!containsDefaultValue) {
            return null;
        }
        return DefaultValueRow.from(row);
    }
}

