/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.deletionvectors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.paimon.deletionvectors.DeletionFileWriter;
import org.apache.paimon.deletionvectors.DeletionVector;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.index.IndexFileMeta;
import org.apache.paimon.index.IndexPathFactory;
import org.apache.paimon.options.MemorySize;

public class DeletionVectorIndexFileWriter {
    private final IndexPathFactory indexPathFactory;
    private final FileIO fileIO;
    private final long targetSizeInBytes;

    public DeletionVectorIndexFileWriter(FileIO fileIO, IndexPathFactory pathFactory, MemorySize targetSizePerIndexFile) {
        this.indexPathFactory = pathFactory;
        this.fileIO = fileIO;
        this.targetSizeInBytes = targetSizePerIndexFile.getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexFileMeta writeSingleFile(Map<String, DeletionVector> input) throws IOException {
        try (DeletionFileWriter writer = new DeletionFileWriter(this.indexPathFactory, this.fileIO);){
            for (Map.Entry<String, DeletionVector> entry : input.entrySet()) {
                writer.write(entry.getKey(), entry.getValue());
            }
        }
        return writer.result();
    }

    public List<IndexFileMeta> writeWithRolling(Map<String, DeletionVector> input) throws IOException {
        if (input.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IndexFileMeta> result = new ArrayList<IndexFileMeta>();
        Iterator<Map.Entry<String, DeletionVector>> iterator = input.entrySet().iterator();
        while (iterator.hasNext()) {
            result.add(this.tryWriter(iterator));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexFileMeta tryWriter(Iterator<Map.Entry<String, DeletionVector>> iterator) throws IOException {
        try (DeletionFileWriter writer = new DeletionFileWriter(this.indexPathFactory, this.fileIO);){
            while (iterator.hasNext()) {
                Map.Entry<String, DeletionVector> entry = iterator.next();
                writer.write(entry.getKey(), entry.getValue());
                if (writer.getPos() <= this.targetSizeInBytes) continue;
                break;
            }
        }
        return writer.result();
    }
}

