/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.rest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.paimon.PagedList;
import org.apache.paimon.Snapshot;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.function.Function;
import org.apache.paimon.function.FunctionChange;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.partition.Partition;
import org.apache.paimon.partition.PartitionStatistics;
import org.apache.paimon.rest.HttpClient;
import org.apache.paimon.rest.RESTCatalogOptions;
import org.apache.paimon.rest.RESTFunctionValidator;
import org.apache.paimon.rest.RESTUtil;
import org.apache.paimon.rest.ResourcePaths;
import org.apache.paimon.rest.auth.AuthProvider;
import org.apache.paimon.rest.auth.AuthProviderFactory;
import org.apache.paimon.rest.auth.RESTAuthFunction;
import org.apache.paimon.rest.exceptions.NoSuchResourceException;
import org.apache.paimon.rest.requests.AlterDatabaseRequest;
import org.apache.paimon.rest.requests.AlterFunctionRequest;
import org.apache.paimon.rest.requests.AlterTableRequest;
import org.apache.paimon.rest.requests.AlterViewRequest;
import org.apache.paimon.rest.requests.AuthTableQueryRequest;
import org.apache.paimon.rest.requests.CommitTableRequest;
import org.apache.paimon.rest.requests.CreateBranchRequest;
import org.apache.paimon.rest.requests.CreateDatabaseRequest;
import org.apache.paimon.rest.requests.CreateFunctionRequest;
import org.apache.paimon.rest.requests.CreateTableRequest;
import org.apache.paimon.rest.requests.CreateViewRequest;
import org.apache.paimon.rest.requests.ForwardBranchRequest;
import org.apache.paimon.rest.requests.MarkDonePartitionsRequest;
import org.apache.paimon.rest.requests.RegisterTableRequest;
import org.apache.paimon.rest.requests.RenameTableRequest;
import org.apache.paimon.rest.requests.RollbackTableRequest;
import org.apache.paimon.rest.responses.AlterDatabaseResponse;
import org.apache.paimon.rest.responses.AuthTableQueryResponse;
import org.apache.paimon.rest.responses.CommitTableResponse;
import org.apache.paimon.rest.responses.ConfigResponse;
import org.apache.paimon.rest.responses.GetDatabaseResponse;
import org.apache.paimon.rest.responses.GetFunctionResponse;
import org.apache.paimon.rest.responses.GetTableResponse;
import org.apache.paimon.rest.responses.GetTableSnapshotResponse;
import org.apache.paimon.rest.responses.GetTableTokenResponse;
import org.apache.paimon.rest.responses.GetVersionSnapshotResponse;
import org.apache.paimon.rest.responses.GetViewResponse;
import org.apache.paimon.rest.responses.ListBranchesResponse;
import org.apache.paimon.rest.responses.ListDatabasesResponse;
import org.apache.paimon.rest.responses.ListFunctionDetailsResponse;
import org.apache.paimon.rest.responses.ListFunctionsGloballyResponse;
import org.apache.paimon.rest.responses.ListFunctionsResponse;
import org.apache.paimon.rest.responses.ListPartitionsResponse;
import org.apache.paimon.rest.responses.ListSnapshotsResponse;
import org.apache.paimon.rest.responses.ListTableDetailsResponse;
import org.apache.paimon.rest.responses.ListTablesGloballyResponse;
import org.apache.paimon.rest.responses.ListTablesResponse;
import org.apache.paimon.rest.responses.ListViewDetailsResponse;
import org.apache.paimon.rest.responses.ListViewsGloballyResponse;
import org.apache.paimon.rest.responses.ListViewsResponse;
import org.apache.paimon.rest.responses.PagedResponse;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaChange;
import org.apache.paimon.shade.guava30.com.google.common.collect.ImmutableMap;
import org.apache.paimon.shade.guava30.com.google.common.collect.Maps;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.paimon.table.Instant;
import org.apache.paimon.table.TableSnapshot;
import org.apache.paimon.utils.JsonSerdeUtil;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.StringUtils;
import org.apache.paimon.view.ViewChange;
import org.apache.paimon.view.ViewSchema;

@Public
public class RESTApi {
    public static final String HEADER_PREFIX = "header.";
    public static final String MAX_RESULTS = "maxResults";
    public static final String PAGE_TOKEN = "pageToken";
    public static final String DATABASE_NAME_PATTERN = "databaseNamePattern";
    public static final String TABLE_NAME_PATTERN = "tableNamePattern";
    public static final String TABLE_TYPE = "tableType";
    public static final String VIEW_NAME_PATTERN = "viewNamePattern";
    public static final String FUNCTION_NAME_PATTERN = "functionNamePattern";
    public static final String PARTITION_NAME_PATTERN = "partitionNamePattern";
    public static final long TOKEN_EXPIRATION_SAFE_TIME_MILLIS = 3600000L;
    public static final ObjectMapper OBJECT_MAPPER = JsonSerdeUtil.OBJECT_MAPPER_INSTANCE;
    private final HttpClient client;
    private final RESTAuthFunction restAuthFunction;
    private final Options options;
    private final ResourcePaths resourcePaths;

    public RESTApi(Options options) {
        this(options, true);
    }

    public RESTApi(Options options, boolean configRequired) {
        this.client = new HttpClient(options.get(RESTCatalogOptions.URI));
        AuthProvider authProvider = AuthProviderFactory.createAuthProvider(options);
        Map<String, String> baseHeaders = RESTUtil.extractPrefixMap(options, HEADER_PREFIX);
        if (configRequired) {
            String warehouse = options.get(CatalogOptions.WAREHOUSE);
            ImmutableMap<String, String> queryParams = StringUtils.isNotEmpty(warehouse) ? ImmutableMap.of(CatalogOptions.WAREHOUSE.key(), RESTUtil.encodeString(warehouse)) : ImmutableMap.of();
            options = new Options(this.client.get(ResourcePaths.config(), queryParams, ConfigResponse.class, new RESTAuthFunction(Collections.emptyMap(), authProvider)).merge(options.toMap()));
            baseHeaders.putAll(RESTUtil.extractPrefixMap(options, HEADER_PREFIX));
        }
        this.restAuthFunction = new RESTAuthFunction(baseHeaders, authProvider);
        this.options = options;
        this.resourcePaths = ResourcePaths.forCatalogProperties(options);
    }

    public Options options() {
        return this.options;
    }

    public List<String> listDatabases() {
        return this.listDataFromPageApi(queryParams -> this.client.get(this.resourcePaths.databases(), (Map<String, String>)queryParams, ListDatabasesResponse.class, this.restAuthFunction));
    }

    public PagedList<String> listDatabasesPaged(@Nullable Integer maxResults, @Nullable String pageToken, @Nullable String databaseNamePattern) {
        ListDatabasesResponse response = this.client.get(this.resourcePaths.databases(), this.buildPagedQueryParams(maxResults, pageToken, Pair.of(DATABASE_NAME_PATTERN, databaseNamePattern)), ListDatabasesResponse.class, this.restAuthFunction);
        List<String> databases = response.getDatabases();
        if (databases == null) {
            return new PagedList<String>(Collections.emptyList(), null);
        }
        return new PagedList<String>(databases, response.getNextPageToken());
    }

    public void createDatabase(String name, Map<String, String> properties) {
        CreateDatabaseRequest request = new CreateDatabaseRequest(name, properties);
        this.client.post(this.resourcePaths.databases(), request, this.restAuthFunction);
    }

    public GetDatabaseResponse getDatabase(String name) {
        return this.client.get(this.resourcePaths.database(name), GetDatabaseResponse.class, this.restAuthFunction);
    }

    public void dropDatabase(String name) {
        this.client.delete(this.resourcePaths.database(name), this.restAuthFunction);
    }

    public void alterDatabase(String name, List<String> removals, Map<String, String> updates) {
        this.client.post(this.resourcePaths.database(name), new AlterDatabaseRequest(removals, updates), AlterDatabaseResponse.class, this.restAuthFunction);
    }

    public List<String> listTables(String databaseName) {
        return this.listDataFromPageApi(queryParams -> this.client.get(this.resourcePaths.tables(databaseName), (Map<String, String>)queryParams, ListTablesResponse.class, this.restAuthFunction));
    }

    public PagedList<String> listTablesPaged(String databaseName, @Nullable Integer maxResults, @Nullable String pageToken, @Nullable String tableNamePattern, @Nullable String tableType) {
        ListTablesResponse response = this.client.get(this.resourcePaths.tables(databaseName), this.buildPagedQueryParams(maxResults, pageToken, Pair.of(TABLE_NAME_PATTERN, tableNamePattern), Pair.of(TABLE_TYPE, tableType)), ListTablesResponse.class, this.restAuthFunction);
        List<String> tables = response.getTables();
        if (tables == null) {
            return new PagedList<String>(Collections.emptyList(), null);
        }
        return new PagedList<String>(tables, response.getNextPageToken());
    }

    public PagedList<GetTableResponse> listTableDetailsPaged(String databaseName, @Nullable Integer maxResults, @Nullable String pageToken, @Nullable String tableNamePattern, @Nullable String tableType) {
        ListTableDetailsResponse response = this.client.get(this.resourcePaths.tableDetails(databaseName), this.buildPagedQueryParams(maxResults, pageToken, Pair.of(TABLE_NAME_PATTERN, tableNamePattern), Pair.of(TABLE_TYPE, tableType)), ListTableDetailsResponse.class, this.restAuthFunction);
        List<GetTableResponse> tables = response.getTableDetails();
        if (tables == null) {
            return new PagedList<GetTableResponse>(Collections.emptyList(), null);
        }
        return new PagedList<GetTableResponse>(tables, response.getNextPageToken());
    }

    public PagedList<Identifier> listTablesPagedGlobally(@Nullable String databaseNamePattern, @Nullable String tableNamePattern, @Nullable Integer maxResults, @Nullable String pageToken) {
        ListTablesGloballyResponse response = this.client.get(this.resourcePaths.tables(), this.buildPagedQueryParams(maxResults, pageToken, Pair.of(DATABASE_NAME_PATTERN, databaseNamePattern), Pair.of(TABLE_NAME_PATTERN, tableNamePattern)), ListTablesGloballyResponse.class, this.restAuthFunction);
        List<Identifier> tables = response.getTables();
        if (tables == null) {
            return new PagedList<Identifier>(Collections.emptyList(), null);
        }
        return new PagedList<Identifier>(tables, response.getNextPageToken());
    }

    public GetTableResponse getTable(Identifier identifier) {
        return this.client.get(this.resourcePaths.table(identifier.getDatabaseName(), identifier.getObjectName()), GetTableResponse.class, this.restAuthFunction);
    }

    public TableSnapshot loadSnapshot(Identifier identifier) {
        GetTableSnapshotResponse response = this.client.get(this.resourcePaths.tableSnapshot(identifier.getDatabaseName(), identifier.getObjectName()), GetTableSnapshotResponse.class, this.restAuthFunction);
        return response.getSnapshot();
    }

    public Snapshot loadSnapshot(Identifier identifier, String version) {
        GetVersionSnapshotResponse response = this.client.get(this.resourcePaths.tableSnapshot(identifier.getDatabaseName(), identifier.getObjectName(), version), GetVersionSnapshotResponse.class, this.restAuthFunction);
        return response.getSnapshot();
    }

    public PagedList<Snapshot> listSnapshotsPaged(Identifier identifier, @Nullable Integer maxResults, @Nullable String pageToken) {
        ListSnapshotsResponse response = this.client.get(this.resourcePaths.snapshots(identifier.getDatabaseName(), identifier.getObjectName()), this.buildPagedQueryParams(maxResults, pageToken, new Pair[0]), ListSnapshotsResponse.class, this.restAuthFunction);
        List<Snapshot> snapshots = response.getSnapshots();
        if (snapshots == null) {
            return new PagedList<Snapshot>(Collections.emptyList(), null);
        }
        return new PagedList<Snapshot>(snapshots, response.getNextPageToken());
    }

    public boolean commitSnapshot(Identifier identifier, @Nullable String tableUuid, Snapshot snapshot, List<PartitionStatistics> statistics) {
        CommitTableRequest request = new CommitTableRequest(tableUuid, snapshot, statistics);
        CommitTableResponse response = this.client.post(this.resourcePaths.commitTable(identifier.getDatabaseName(), identifier.getObjectName()), request, CommitTableResponse.class, this.restAuthFunction);
        return response.isSuccess();
    }

    public void rollbackTo(Identifier identifier, Instant instant) {
        RollbackTableRequest request = new RollbackTableRequest(instant);
        this.client.post(this.resourcePaths.rollbackTable(identifier.getDatabaseName(), identifier.getObjectName()), request, this.restAuthFunction);
    }

    public void createTable(Identifier identifier, Schema schema) {
        CreateTableRequest request = new CreateTableRequest(identifier, schema);
        this.client.post(this.resourcePaths.tables(identifier.getDatabaseName()), request, this.restAuthFunction);
    }

    public void renameTable(Identifier fromTable, Identifier toTable) {
        RenameTableRequest request = new RenameTableRequest(fromTable, toTable);
        this.client.post(this.resourcePaths.renameTable(), request, this.restAuthFunction);
    }

    public void alterTable(Identifier identifier, List<SchemaChange> changes) {
        AlterTableRequest request = new AlterTableRequest(changes);
        this.client.post(this.resourcePaths.table(identifier.getDatabaseName(), identifier.getObjectName()), request, this.restAuthFunction);
    }

    public List<String> authTableQuery(Identifier identifier, @Nullable List<String> select) {
        AuthTableQueryRequest request = new AuthTableQueryRequest(select);
        AuthTableQueryResponse response = this.client.post(this.resourcePaths.authTable(identifier.getDatabaseName(), identifier.getObjectName()), request, AuthTableQueryResponse.class, this.restAuthFunction);
        return response.filter();
    }

    public void dropTable(Identifier identifier) {
        this.client.delete(this.resourcePaths.table(identifier.getDatabaseName(), identifier.getObjectName()), this.restAuthFunction);
    }

    public void registerTable(Identifier identifier, String path) {
        this.client.post(this.resourcePaths.registerTable(identifier.getDatabaseName()), new RegisterTableRequest(identifier, path), this.restAuthFunction);
    }

    public void markDonePartitions(Identifier identifier, List<Map<String, String>> partitions) {
        MarkDonePartitionsRequest request = new MarkDonePartitionsRequest(partitions);
        this.client.post(this.resourcePaths.markDonePartitions(identifier.getDatabaseName(), identifier.getObjectName()), request, this.restAuthFunction);
    }

    public List<Partition> listPartitions(Identifier identifier) {
        return this.listDataFromPageApi(queryParams -> this.client.get(this.resourcePaths.partitions(identifier.getDatabaseName(), identifier.getObjectName()), (Map<String, String>)queryParams, ListPartitionsResponse.class, this.restAuthFunction));
    }

    public PagedList<Partition> listPartitionsPaged(Identifier identifier, @Nullable Integer maxResults, @Nullable String pageToken, @Nullable String partitionNamePattern) {
        ListPartitionsResponse response = this.client.get(this.resourcePaths.partitions(identifier.getDatabaseName(), identifier.getObjectName()), this.buildPagedQueryParams(maxResults, pageToken, Pair.of(PARTITION_NAME_PATTERN, partitionNamePattern)), ListPartitionsResponse.class, this.restAuthFunction);
        List<Partition> partitions = response.getPartitions();
        if (partitions == null) {
            return new PagedList<Partition>(Collections.emptyList(), null);
        }
        return new PagedList<Partition>(partitions, response.getNextPageToken());
    }

    public void createBranch(Identifier identifier, String branch, @Nullable String fromTag) {
        CreateBranchRequest request = new CreateBranchRequest(branch, fromTag);
        this.client.post(this.resourcePaths.branches(identifier.getDatabaseName(), identifier.getObjectName()), request, this.restAuthFunction);
    }

    public void dropBranch(Identifier identifier, String branch) {
        this.client.delete(this.resourcePaths.branch(identifier.getDatabaseName(), identifier.getObjectName(), branch), this.restAuthFunction);
    }

    public void fastForward(Identifier identifier, String branch) {
        ForwardBranchRequest request = new ForwardBranchRequest();
        this.client.post(this.resourcePaths.forwardBranch(identifier.getDatabaseName(), identifier.getObjectName(), branch), request, this.restAuthFunction);
    }

    public List<String> listBranches(Identifier identifier) {
        ListBranchesResponse response = this.client.get(this.resourcePaths.branches(identifier.getDatabaseName(), identifier.getObjectName()), ListBranchesResponse.class, this.restAuthFunction);
        if (response.branches() == null) {
            return Collections.emptyList();
        }
        return response.branches();
    }

    public List<String> listFunctions(String databaseName) {
        return this.listDataFromPageApi(queryParams -> this.client.get(this.resourcePaths.functions(databaseName), (Map<String, String>)queryParams, ListFunctionsResponse.class, this.restAuthFunction));
    }

    public PagedList<String> listFunctionsPaged(String databaseName, @Nullable Integer maxResults, @Nullable String pageToken, @Nullable String functionNamePattern) {
        ListFunctionsResponse response = this.client.get(this.resourcePaths.functions(databaseName), this.buildPagedQueryParams(maxResults, pageToken, Pair.of(FUNCTION_NAME_PATTERN, functionNamePattern)), ListFunctionsResponse.class, this.restAuthFunction);
        List<String> functions2 = response.functions();
        if (functions2 == null) {
            return new PagedList<String>(Collections.emptyList(), null);
        }
        return new PagedList<String>(functions2, response.getNextPageToken());
    }

    public PagedList<GetFunctionResponse> listFunctionDetailsPaged(String databaseName, @Nullable Integer maxResults, @Nullable String pageToken, @Nullable String functionNamePattern) {
        ListFunctionDetailsResponse response = this.client.get(this.resourcePaths.functionDetails(databaseName), this.buildPagedQueryParams(maxResults, pageToken, Pair.of(FUNCTION_NAME_PATTERN, functionNamePattern)), ListFunctionDetailsResponse.class, this.restAuthFunction);
        List<GetFunctionResponse> functionDetails = response.data();
        if (functionDetails == null) {
            return new PagedList<GetFunctionResponse>(Collections.emptyList(), null);
        }
        return new PagedList<GetFunctionResponse>(functionDetails, response.getNextPageToken());
    }

    public PagedList<Identifier> listFunctionsPagedGlobally(@Nullable String databaseNamePattern, @Nullable String functionNamePattern, @Nullable Integer maxResults, @Nullable String pageToken) {
        ListFunctionsGloballyResponse response = this.client.get(this.resourcePaths.functions(), this.buildPagedQueryParams(maxResults, pageToken, Pair.of(DATABASE_NAME_PATTERN, databaseNamePattern), Pair.of(FUNCTION_NAME_PATTERN, functionNamePattern)), ListFunctionsGloballyResponse.class, this.restAuthFunction);
        List<Identifier> functions2 = response.data();
        if (functions2 == null) {
            return new PagedList<Identifier>(Collections.emptyList(), null);
        }
        return new PagedList<Identifier>(functions2, response.getNextPageToken());
    }

    public GetFunctionResponse getFunction(Identifier identifier) {
        if (!RESTFunctionValidator.isValidFunctionName(identifier.getObjectName())) {
            throw new NoSuchResourceException("FUNCTION", identifier.getObjectName(), "Invalid function name: " + identifier.getObjectName(), new Object[0]);
        }
        return this.client.get(this.resourcePaths.function(identifier.getDatabaseName(), identifier.getObjectName()), GetFunctionResponse.class, this.restAuthFunction);
    }

    public void createFunction(Identifier identifier, Function function) {
        RESTFunctionValidator.checkFunctionName(identifier.getObjectName());
        this.client.post(this.resourcePaths.functions(identifier.getDatabaseName()), new CreateFunctionRequest(function), this.restAuthFunction);
    }

    public void dropFunction(Identifier identifier) {
        RESTFunctionValidator.checkFunctionName(identifier.getObjectName());
        this.client.delete(this.resourcePaths.function(identifier.getDatabaseName(), identifier.getObjectName()), this.restAuthFunction);
    }

    public void alterFunction(Identifier identifier, List<FunctionChange> changes) {
        RESTFunctionValidator.checkFunctionName(identifier.getObjectName());
        this.client.post(this.resourcePaths.function(identifier.getDatabaseName(), identifier.getObjectName()), new AlterFunctionRequest(changes), this.restAuthFunction);
    }

    public GetViewResponse getView(Identifier identifier) {
        return this.client.get(this.resourcePaths.view(identifier.getDatabaseName(), identifier.getObjectName()), GetViewResponse.class, this.restAuthFunction);
    }

    public void dropView(Identifier identifier) {
        this.client.delete(this.resourcePaths.view(identifier.getDatabaseName(), identifier.getObjectName()), this.restAuthFunction);
    }

    public void createView(Identifier identifier, ViewSchema schema) {
        CreateViewRequest request = new CreateViewRequest(identifier, schema);
        this.client.post(this.resourcePaths.views(identifier.getDatabaseName()), request, this.restAuthFunction);
    }

    public List<String> listViews(String databaseName) {
        return this.listDataFromPageApi(queryParams -> this.client.get(this.resourcePaths.views(databaseName), (Map<String, String>)queryParams, ListViewsResponse.class, this.restAuthFunction));
    }

    public PagedList<String> listViewsPaged(String databaseName, @Nullable Integer maxResults, @Nullable String pageToken, @Nullable String viewNamePattern) {
        ListViewsResponse response = this.client.get(this.resourcePaths.views(databaseName), this.buildPagedQueryParams(maxResults, pageToken, Pair.of(VIEW_NAME_PATTERN, viewNamePattern)), ListViewsResponse.class, this.restAuthFunction);
        List<String> views = response.getViews();
        if (views == null) {
            return new PagedList<String>(Collections.emptyList(), null);
        }
        return new PagedList<String>(views, response.getNextPageToken());
    }

    public PagedList<GetViewResponse> listViewDetailsPaged(String databaseName, @Nullable Integer maxResults, @Nullable String pageToken, @Nullable String viewNamePattern) {
        ListViewDetailsResponse response = this.client.get(this.resourcePaths.viewDetails(databaseName), this.buildPagedQueryParams(maxResults, pageToken, Pair.of(VIEW_NAME_PATTERN, viewNamePattern)), ListViewDetailsResponse.class, this.restAuthFunction);
        List<GetViewResponse> views = response.getViewDetails();
        if (views == null) {
            return new PagedList<GetViewResponse>(Collections.emptyList(), null);
        }
        return new PagedList<GetViewResponse>(views, response.getNextPageToken());
    }

    public PagedList<Identifier> listViewsPagedGlobally(@Nullable String databaseNamePattern, @Nullable String viewNamePattern, @Nullable Integer maxResults, @Nullable String pageToken) {
        ListViewsGloballyResponse response = this.client.get(this.resourcePaths.views(), this.buildPagedQueryParams(maxResults, pageToken, Pair.of(DATABASE_NAME_PATTERN, databaseNamePattern), Pair.of(VIEW_NAME_PATTERN, viewNamePattern)), ListViewsGloballyResponse.class, this.restAuthFunction);
        List<Identifier> views = response.getViews();
        if (views == null) {
            return new PagedList<Identifier>(Collections.emptyList(), null);
        }
        return new PagedList<Identifier>(views, response.getNextPageToken());
    }

    public void renameView(Identifier fromView, Identifier toView) {
        RenameTableRequest request = new RenameTableRequest(fromView, toView);
        this.client.post(this.resourcePaths.renameView(), request, this.restAuthFunction);
    }

    public void alterView(Identifier identifier, List<ViewChange> viewChanges) {
        AlterViewRequest request = new AlterViewRequest(viewChanges);
        this.client.post(this.resourcePaths.view(identifier.getDatabaseName(), identifier.getObjectName()), request, this.restAuthFunction);
    }

    public GetTableTokenResponse loadTableToken(Identifier identifier) {
        return this.client.get(this.resourcePaths.tableToken(identifier.getDatabaseName(), identifier.getObjectName()), GetTableTokenResponse.class, this.restAuthFunction);
    }

    public static <T> T fromJson(String json, Class<T> clazz) throws JsonProcessingException {
        return OBJECT_MAPPER.readValue(json, clazz);
    }

    public static <T> String toJson(T t) throws JsonProcessingException {
        return OBJECT_MAPPER.writeValueAsString(t);
    }

    @VisibleForTesting
    <T> List<T> listDataFromPageApi(java.util.function.Function<Map<String, String>, PagedResponse<T>> pageApi) {
        PagedResponse<T> response;
        ArrayList<T> results = new ArrayList<T>();
        HashMap<String, String> queryParams = Maps.newHashMap();
        String pageToken = null;
        do {
            if (pageToken != null) {
                queryParams.put(PAGE_TOKEN, pageToken);
            }
            response = pageApi.apply(queryParams);
            pageToken = response.getNextPageToken();
            if (response.data() == null) continue;
            results.addAll(response.data());
        } while (pageToken != null && response.data() != null && !response.data().isEmpty() && StringUtils.isNotEmpty(pageToken));
        return results;
    }

    @SafeVarargs
    private final Map<String, String> buildPagedQueryParams(@Nullable Integer maxResults, @Nullable String pageToken, Pair<String, String> ... namePatternPairs) {
        HashMap<String, String> queryParams = Maps.newHashMap();
        if (Objects.nonNull(maxResults) && maxResults > 0) {
            queryParams.put(MAX_RESULTS, maxResults.toString());
        }
        if (Objects.nonNull(pageToken)) {
            queryParams.put(PAGE_TOKEN, pageToken);
        }
        for (Pair<String, String> namePatternPair : namePatternPairs) {
            String namePatternKey = namePatternPair.getKey();
            String namePatternValue = namePatternPair.getValue();
            if (!StringUtils.isNotEmpty(namePatternKey) || !StringUtils.isNotEmpty(namePatternValue)) continue;
            queryParams.put(namePatternKey, namePatternValue);
        }
        return queryParams;
    }

    @VisibleForTesting
    RESTAuthFunction authFunction() {
        return this.restAuthFunction;
    }
}

