/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.rest.requests;

import java.util.List;
import java.util.Map;
import org.apache.paimon.function.Function;
import org.apache.paimon.function.FunctionDefinition;
import org.apache.paimon.rest.RESTRequest;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonGetter;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.paimon.types.DataField;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CreateFunctionRequest
implements RESTRequest {
    private static final String FIELD_NAME = "name";
    private static final String FIELD_INPUT_PARAMETERS = "inputParams";
    private static final String FIELD_RETURN_PARAMETERS = "returnParams";
    private static final String FIELD_DEFINITIONS = "definitions";
    private static final String FIELD_DETERMINISTIC = "deterministic";
    private static final String FIELD_COMMENT = "comment";
    private static final String FIELD_OPTIONS = "options";
    @JsonProperty(value="name")
    private final String functionName;
    @JsonProperty(value="inputParams")
    private final List<DataField> inputParams;
    @JsonProperty(value="returnParams")
    private final List<DataField> returnParams;
    @JsonProperty(value="deterministic")
    private final boolean deterministic;
    @JsonProperty(value="definitions")
    private final Map<String, FunctionDefinition> definitions;
    @JsonProperty(value="comment")
    private final String comment;
    @JsonProperty(value="options")
    private final Map<String, String> options;

    @JsonCreator
    public CreateFunctionRequest(@JsonProperty(value="name") String functionName, @JsonProperty(value="inputParams") List<DataField> inputParams, @JsonProperty(value="returnParams") List<DataField> returnParams, @JsonProperty(value="deterministic") boolean deterministic, @JsonProperty(value="definitions") Map<String, FunctionDefinition> definitions, @JsonProperty(value="comment") String comment, @JsonProperty(value="options") Map<String, String> options) {
        this.functionName = functionName;
        this.inputParams = inputParams;
        this.returnParams = returnParams;
        this.deterministic = deterministic;
        this.definitions = definitions;
        this.comment = comment;
        this.options = options;
    }

    public CreateFunctionRequest(Function function) {
        this.functionName = function.name();
        this.inputParams = function.inputParams().orElse(null);
        this.returnParams = function.returnParams().orElse(null);
        this.deterministic = function.isDeterministic();
        this.definitions = function.definitions();
        this.comment = function.comment();
        this.options = function.options();
    }

    @JsonGetter(value="name")
    public String name() {
        return this.functionName;
    }

    @JsonGetter(value="inputParams")
    public List<DataField> inputParams() {
        return this.inputParams;
    }

    @JsonGetter(value="returnParams")
    public List<DataField> returnParams() {
        return this.returnParams;
    }

    @JsonGetter(value="deterministic")
    public boolean isDeterministic() {
        return this.deterministic;
    }

    @JsonGetter(value="definitions")
    public Map<String, FunctionDefinition> definitions() {
        return this.definitions;
    }

    public FunctionDefinition definition(String dialect) {
        return this.definitions.get(dialect);
    }

    @JsonGetter(value="comment")
    public String comment() {
        return this.comment;
    }

    @JsonGetter(value="options")
    public Map<String, String> options() {
        return this.options;
    }
}

