/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.paimon.spark.util.shim.TypeUtils;
import org.apache.paimon.table.Table;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.BinaryType;
import org.apache.paimon.types.BooleanType;
import org.apache.paimon.types.CharType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeDefaultVisitor;
import org.apache.paimon.types.DoubleType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.LocalZonedTimestampType;
import org.apache.paimon.types.MultisetType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.SmallIntType;
import org.apache.paimon.types.TimeType;
import org.apache.paimon.types.TinyIntType;
import org.apache.paimon.types.VarBinaryType;
import org.apache.paimon.types.VarCharType;
import org.apache.paimon.types.VariantType;
import org.apache.spark.sql.paimon.shims.SparkShimLoader;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.VarcharType;

public class SparkTypeUtils {
    public static final String CURRENT_DEFAULT_COLUMN_METADATA_KEY = "CURRENT_DEFAULT";

    private SparkTypeUtils() {
    }

    public static RowType toPartitionType(Table table) {
        int[] projections = table.rowType().getFieldIndices(table.partitionKeys());
        ArrayList<DataField> partitionTypes = new ArrayList<DataField>();
        for (int i : projections) {
            partitionTypes.add(table.rowType().getFields().get(i));
        }
        return new RowType(false, partitionTypes);
    }

    public static StructType toSparkPartitionType(Table table) {
        return (StructType)SparkTypeUtils.fromPaimonType(SparkTypeUtils.toPartitionType(table));
    }

    public static StructType fromPaimonRowType(RowType type) {
        return (StructType)SparkTypeUtils.fromPaimonType(type);
    }

    public static org.apache.spark.sql.types.DataType fromPaimonType(DataType type) {
        return type.accept(PaimonToSparkTypeVisitor.INSTANCE);
    }

    public static RowType toPaimonRowType(StructType type) {
        return (RowType)SparkTypeUtils.toPaimonType((org.apache.spark.sql.types.DataType)type);
    }

    public static DataType toPaimonType(org.apache.spark.sql.types.DataType dataType) {
        return SparkToPaimonTypeVisitor.visit(dataType);
    }

    public static RowType prunePaimonRowType(StructType requiredStructType, RowType rowType) {
        return (RowType)SparkTypeUtils.prunePaimonType((org.apache.spark.sql.types.DataType)requiredStructType, rowType);
    }

    private static DataType prunePaimonType(org.apache.spark.sql.types.DataType sparkDataType, DataType paimonDataType) {
        if (sparkDataType instanceof StructType) {
            StructType s = (StructType)sparkDataType;
            RowType p = (RowType)paimonDataType;
            ArrayList<DataField> newFields = new ArrayList<DataField>();
            for (StructField field : s.fields()) {
                DataField f = p.getField(field.name());
                newFields.add(f.newType(SparkTypeUtils.prunePaimonType(field.dataType(), f.type())));
            }
            return p.copy(newFields);
        }
        if (sparkDataType instanceof MapType) {
            MapType s = (MapType)sparkDataType;
            org.apache.paimon.types.MapType p = (org.apache.paimon.types.MapType)paimonDataType;
            return p.newKeyValueType(SparkTypeUtils.prunePaimonType(s.keyType(), p.getKeyType()), SparkTypeUtils.prunePaimonType(s.valueType(), p.getValueType()));
        }
        if (sparkDataType instanceof org.apache.spark.sql.types.ArrayType) {
            org.apache.spark.sql.types.ArrayType s = (org.apache.spark.sql.types.ArrayType)sparkDataType;
            ArrayType r = (ArrayType)paimonDataType;
            return r.newElementType(SparkTypeUtils.prunePaimonType(s.elementType(), r.getElementType()));
        }
        return paimonDataType;
    }

    private static class SparkToPaimonTypeVisitor {
        private SparkToPaimonTypeVisitor() {
        }

        static DataType visit(org.apache.spark.sql.types.DataType type) {
            AtomicInteger atomicInteger = new AtomicInteger(-1);
            return SparkToPaimonTypeVisitor.visit(type, new SparkToPaimonTypeVisitor(), atomicInteger);
        }

        static DataType visit(org.apache.spark.sql.types.DataType type, SparkToPaimonTypeVisitor visitor, AtomicInteger atomicInteger) {
            if (type instanceof StructType) {
                StructField[] fields = ((StructType)type).fields();
                ArrayList<DataType> fieldResults = new ArrayList<DataType>(fields.length);
                for (StructField field : fields) {
                    fieldResults.add(SparkToPaimonTypeVisitor.visit(field.dataType(), visitor, atomicInteger));
                }
                return visitor.struct((StructType)type, fieldResults, atomicInteger);
            }
            if (type instanceof MapType) {
                return visitor.map((MapType)type, SparkToPaimonTypeVisitor.visit(((MapType)type).keyType(), visitor, atomicInteger), SparkToPaimonTypeVisitor.visit(((MapType)type).valueType(), visitor, atomicInteger));
            }
            if (type instanceof org.apache.spark.sql.types.ArrayType) {
                return visitor.array((org.apache.spark.sql.types.ArrayType)type, SparkToPaimonTypeVisitor.visit(((org.apache.spark.sql.types.ArrayType)type).elementType(), visitor, atomicInteger));
            }
            if (type instanceof UserDefinedType) {
                throw new UnsupportedOperationException("User-defined types are not supported");
            }
            return visitor.atomic(type);
        }

        public DataType struct(StructType struct, List<DataType> fieldResults, AtomicInteger atomicInteger) {
            StructField[] fields = struct.fields();
            ArrayList<DataField> newFields = new ArrayList<DataField>(fields.length);
            for (int i = 0; i < fields.length; ++i) {
                StructField field = fields[i];
                DataType fieldType = fieldResults.get(i).copy(field.nullable());
                String comment = (String)field.getComment().getOrElse(() -> null);
                String defaultValue = null;
                if (field.metadata().contains(SparkTypeUtils.CURRENT_DEFAULT_COLUMN_METADATA_KEY)) {
                    defaultValue = field.metadata().getString(SparkTypeUtils.CURRENT_DEFAULT_COLUMN_METADATA_KEY);
                }
                newFields.add(new DataField(atomicInteger.incrementAndGet(), field.name(), fieldType, comment, defaultValue));
            }
            return new RowType(newFields);
        }

        public DataType array(org.apache.spark.sql.types.ArrayType array, DataType elementResult) {
            return new ArrayType(elementResult.copy(array.containsNull()));
        }

        public DataType map(MapType map, DataType keyResult, DataType valueResult) {
            return new org.apache.paimon.types.MapType(keyResult.copy(false), valueResult.copy(map.valueContainsNull()));
        }

        public DataType atomic(org.apache.spark.sql.types.DataType atomic) {
            if (atomic instanceof org.apache.spark.sql.types.BooleanType) {
                return new BooleanType();
            }
            if (atomic instanceof ByteType) {
                return new TinyIntType();
            }
            if (atomic instanceof ShortType) {
                return new SmallIntType();
            }
            if (atomic instanceof IntegerType) {
                return new IntType();
            }
            if (atomic instanceof LongType) {
                return new BigIntType();
            }
            if (atomic instanceof FloatType) {
                return new org.apache.paimon.types.FloatType();
            }
            if (atomic instanceof org.apache.spark.sql.types.DoubleType) {
                return new DoubleType();
            }
            if (atomic instanceof VarcharType) {
                return new VarCharType(((VarcharType)atomic).length());
            }
            if (atomic instanceof org.apache.spark.sql.types.CharType) {
                return new CharType(((org.apache.spark.sql.types.CharType)atomic).length());
            }
            if (atomic instanceof StringType) {
                return new VarCharType(Integer.MAX_VALUE);
            }
            if (atomic instanceof DateType) {
                return new org.apache.paimon.types.DateType();
            }
            if (atomic instanceof TimestampType) {
                if (TypeUtils.treatPaimonTimestampTypeAsSparkTimestampType()) {
                    return new org.apache.paimon.types.TimestampType();
                }
                return new LocalZonedTimestampType();
            }
            if (atomic instanceof DecimalType) {
                return new org.apache.paimon.types.DecimalType(((DecimalType)atomic).precision(), ((DecimalType)atomic).scale());
            }
            if (atomic instanceof org.apache.spark.sql.types.BinaryType) {
                return new VarBinaryType(Integer.MAX_VALUE);
            }
            if (atomic instanceof TimestampNTZType) {
                return new org.apache.paimon.types.TimestampType();
            }
            if (SparkShimLoader.shim().isSparkVariantType(atomic)) {
                return new VariantType();
            }
            throw new UnsupportedOperationException("Not a supported type: " + atomic.catalogString());
        }
    }

    private static class PaimonToSparkTypeVisitor
    extends DataTypeDefaultVisitor<org.apache.spark.sql.types.DataType> {
        private static final PaimonToSparkTypeVisitor INSTANCE = new PaimonToSparkTypeVisitor();

        private PaimonToSparkTypeVisitor() {
        }

        @Override
        public org.apache.spark.sql.types.DataType visit(CharType charType) {
            return new org.apache.spark.sql.types.CharType(charType.getLength());
        }

        @Override
        public org.apache.spark.sql.types.DataType visit(VarCharType varCharType) {
            if (varCharType.getLength() == Integer.MAX_VALUE) {
                return DataTypes.StringType;
            }
            return new VarcharType(varCharType.getLength());
        }

        @Override
        public org.apache.spark.sql.types.DataType visit(BooleanType booleanType) {
            return DataTypes.BooleanType;
        }

        @Override
        public org.apache.spark.sql.types.DataType visit(BinaryType binaryType) {
            return DataTypes.BinaryType;
        }

        @Override
        public org.apache.spark.sql.types.DataType visit(VarBinaryType varBinaryType) {
            return DataTypes.BinaryType;
        }

        @Override
        public org.apache.spark.sql.types.DataType visit(org.apache.paimon.types.DecimalType decimalType) {
            return DataTypes.createDecimalType((int)decimalType.getPrecision(), (int)decimalType.getScale());
        }

        @Override
        public org.apache.spark.sql.types.DataType visit(TinyIntType tinyIntType) {
            return DataTypes.ByteType;
        }

        @Override
        public org.apache.spark.sql.types.DataType visit(SmallIntType smallIntType) {
            return DataTypes.ShortType;
        }

        @Override
        public org.apache.spark.sql.types.DataType visit(IntType intType) {
            return DataTypes.IntegerType;
        }

        @Override
        public org.apache.spark.sql.types.DataType visit(BigIntType bigIntType) {
            return DataTypes.LongType;
        }

        @Override
        public org.apache.spark.sql.types.DataType visit(org.apache.paimon.types.FloatType floatType) {
            return DataTypes.FloatType;
        }

        @Override
        public org.apache.spark.sql.types.DataType visit(DoubleType doubleType) {
            return DataTypes.DoubleType;
        }

        @Override
        public org.apache.spark.sql.types.DataType visit(org.apache.paimon.types.DateType dateType) {
            return DataTypes.DateType;
        }

        @Override
        public org.apache.spark.sql.types.DataType visit(TimeType timeType) {
            return DataTypes.IntegerType;
        }

        @Override
        public org.apache.spark.sql.types.DataType visit(org.apache.paimon.types.TimestampType timestampType) {
            if (TypeUtils.treatPaimonTimestampTypeAsSparkTimestampType()) {
                return DataTypes.TimestampType;
            }
            return DataTypes.TimestampNTZType;
        }

        @Override
        public org.apache.spark.sql.types.DataType visit(LocalZonedTimestampType localZonedTimestampType) {
            return DataTypes.TimestampType;
        }

        @Override
        public org.apache.spark.sql.types.DataType visit(VariantType variantType) {
            return SparkShimLoader.shim().SparkVariantType();
        }

        @Override
        public org.apache.spark.sql.types.DataType visit(ArrayType arrayType) {
            DataType elementType = arrayType.getElementType();
            return DataTypes.createArrayType((org.apache.spark.sql.types.DataType)elementType.accept(this), (boolean)elementType.isNullable());
        }

        @Override
        public org.apache.spark.sql.types.DataType visit(MultisetType multisetType) {
            return DataTypes.createMapType((org.apache.spark.sql.types.DataType)multisetType.getElementType().accept(this), (org.apache.spark.sql.types.DataType)DataTypes.IntegerType, (boolean)false);
        }

        @Override
        public org.apache.spark.sql.types.DataType visit(org.apache.paimon.types.MapType mapType) {
            return DataTypes.createMapType((org.apache.spark.sql.types.DataType)mapType.getKeyType().accept(this), (org.apache.spark.sql.types.DataType)mapType.getValueType().accept(this), (boolean)mapType.getValueType().isNullable());
        }

        @Override
        public org.apache.spark.sql.types.DataType visit(RowType rowType) {
            ArrayList<StructField> fields = new ArrayList<StructField>(rowType.getFieldCount());
            for (DataField field : rowType.getFields()) {
                MetadataBuilder metadataBuilder = new MetadataBuilder();
                if (field.defaultValue() != null) {
                    metadataBuilder.putString(SparkTypeUtils.CURRENT_DEFAULT_COLUMN_METADATA_KEY, field.defaultValue());
                }
                StructField structField = DataTypes.createStructField((String)field.name(), (org.apache.spark.sql.types.DataType)field.type().accept(this), (boolean)field.type().isNullable(), (Metadata)metadataBuilder.build());
                structField = Optional.ofNullable(field.description()).map(arg_0 -> ((StructField)structField).withComment(arg_0)).orElse(structField);
                fields.add(structField);
            }
            return DataTypes.createStructType(fields);
        }

        @Override
        protected org.apache.spark.sql.types.DataType defaultMethod(DataType dataType) {
            throw new UnsupportedOperationException("Unsupported type: " + dataType);
        }
    }
}

