/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.catalog;

import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.paimon.spark.SparkProcedures;
import org.apache.paimon.spark.SparkSource;
import org.apache.paimon.spark.analysis.NoSuchProcedureException;
import org.apache.paimon.spark.catalog.ProcedureCatalog;
import org.apache.paimon.spark.catalog.WithPaimonCatalog;
import org.apache.paimon.spark.procedure.Procedure;
import org.apache.paimon.spark.procedure.ProcedureBuilder;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.SupportsNamespaces;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableCatalogCapability;

public abstract class SparkBaseCatalog
implements TableCatalog,
SupportsNamespaces,
ProcedureCatalog,
WithPaimonCatalog {
    protected String catalogName;

    public String name() {
        return this.catalogName;
    }

    public Set<TableCatalogCapability> capabilities() {
        return Collections.singleton(TableCatalogCapability.SUPPORT_COLUMN_DEFAULT_VALUE);
    }

    @Override
    public Procedure loadProcedure(Identifier identifier) throws NoSuchProcedureException {
        ProcedureBuilder builder;
        if (SparkBaseCatalog.isSystemNamespace(identifier.namespace()) && (builder = SparkProcedures.newBuilder(identifier.name())) != null) {
            return builder.withTableCatalog(this).build();
        }
        throw new NoSuchProcedureException(identifier);
    }

    public static boolean usePaimon(@Nullable String provider) {
        return provider == null || SparkSource.NAME().equalsIgnoreCase(provider);
    }

    public static boolean isSystemNamespace(String[] namespace) {
        return namespace.length == 1 && namespace[0].equalsIgnoreCase("sys");
    }
}

