/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.procedure;

import java.util.List;
import java.util.Map;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.function.FunctionImpl;
import org.apache.paimon.shade.guava30.com.google.common.collect.Maps;
import org.apache.paimon.spark.catalog.WithPaimonCatalog;
import org.apache.paimon.spark.procedure.BaseProcedure;
import org.apache.paimon.spark.procedure.ProcedureBuilder;
import org.apache.paimon.spark.procedure.ProcedureParameter;
import org.apache.paimon.spark.utils.CatalogUtils;
import org.apache.paimon.types.DataField;
import org.apache.paimon.utils.ParameterUtils;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class CreateFunctionProcedure
extends BaseProcedure {
    private static final ProcedureParameter[] PARAMETERS = new ProcedureParameter[]{ProcedureParameter.required("function", DataTypes.StringType), ProcedureParameter.required("inputParams", DataTypes.StringType), ProcedureParameter.required("returnParams", DataTypes.StringType), ProcedureParameter.optional("deterministic", DataTypes.BooleanType), ProcedureParameter.optional("comment", DataTypes.StringType), ProcedureParameter.optional("options", DataTypes.StringType)};
    private static final StructType OUTPUT_TYPE = new StructType(new StructField[]{new StructField("result", DataTypes.BooleanType, true, Metadata.empty())});

    protected CreateFunctionProcedure(TableCatalog tableCatalog) {
        super(tableCatalog);
    }

    @Override
    public ProcedureParameter[] parameters() {
        return PARAMETERS;
    }

    @Override
    public StructType outputType() {
        return OUTPUT_TYPE;
    }

    @Override
    public InternalRow[] call(InternalRow args) {
        Catalog paimonCatalog = ((WithPaimonCatalog)this.tableCatalog()).paimonCatalog();
        Identifier ident = this.toIdentifier(args.getString(0), PARAMETERS[0].name());
        org.apache.paimon.catalog.Identifier function = CatalogUtils.toIdentifier(ident);
        List<DataField> inputParams = CreateFunctionProcedure.getDataFieldsFromArguments(1, args);
        List<DataField> returnParams = CreateFunctionProcedure.getDataFieldsFromArguments(2, args);
        boolean deterministic = args.isNullAt(3) ? true : args.getBoolean(3);
        String comment = args.isNullAt(4) ? null : args.getString(4);
        String properties = args.isNullAt(5) ? null : args.getString(5);
        Map<String, String> options = ParameterUtils.parseCommaSeparatedKeyValues(properties);
        try {
            FunctionImpl functionImpl = new FunctionImpl(function, inputParams, returnParams, deterministic, Maps.newHashMap(), comment, options);
            paimonCatalog.createFunction(function, functionImpl, false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new InternalRow[]{this.newInternalRow(true)};
    }

    public static ProcedureBuilder builder() {
        return new BaseProcedure.Builder<CreateFunctionProcedure>(){

            @Override
            public CreateFunctionProcedure doBuild() {
                return new CreateFunctionProcedure(this.tableCatalog());
            }
        };
    }

    @Override
    public String description() {
        return "CreateFunctionProcedure";
    }

    public static List<DataField> getDataFieldsFromArguments(int position, InternalRow args) {
        String data = args.isNullAt(position) ? null : args.getString(position);
        return ParameterUtils.parseDataFieldArray(data);
    }
}

