/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.procedure;

import java.util.Locale;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.operation.CleanOrphanFilesResult;
import org.apache.paimon.operation.LocalOrphanFilesClean;
import org.apache.paimon.operation.OrphanFilesClean;
import org.apache.paimon.spark.catalog.WithPaimonCatalog;
import org.apache.paimon.spark.procedure.BaseProcedure;
import org.apache.paimon.spark.procedure.ProcedureBuilder;
import org.apache.paimon.spark.procedure.ProcedureParameter;
import org.apache.paimon.spark.procedure.SparkOrphanFilesClean;
import org.apache.paimon.utils.Preconditions;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveOrphanFilesProcedure
extends BaseProcedure {
    private static final Logger LOG = LoggerFactory.getLogger((String)RemoveOrphanFilesProcedure.class.getName());
    private static final ProcedureParameter[] PARAMETERS = new ProcedureParameter[]{ProcedureParameter.required("table", DataTypes.StringType), ProcedureParameter.optional("older_than", DataTypes.StringType), ProcedureParameter.optional("dry_run", DataTypes.BooleanType), ProcedureParameter.optional("parallelism", DataTypes.IntegerType), ProcedureParameter.optional("mode", DataTypes.StringType)};
    private static final StructType OUTPUT_TYPE = new StructType(new StructField[]{new StructField("deletedFileCount", DataTypes.LongType, true, Metadata.empty()), new StructField("deletedFileTotalLenInBytes", DataTypes.LongType, true, Metadata.empty())});

    private RemoveOrphanFilesProcedure(TableCatalog tableCatalog) {
        super(tableCatalog);
    }

    @Override
    public ProcedureParameter[] parameters() {
        return PARAMETERS;
    }

    @Override
    public StructType outputType() {
        return OUTPUT_TYPE;
    }

    @Override
    public InternalRow[] call(InternalRow args) {
        String tableId = args.getString(0);
        String olderThan = args.isNullAt(1) ? null : args.getString(1);
        boolean dryRun = !args.isNullAt(2) && args.getBoolean(2);
        Integer parallelism = args.isNullAt(3) ? null : Integer.valueOf(args.getInt(3));
        Preconditions.checkArgument(tableId != null && !tableId.isEmpty(), "Cannot handle an empty tableId for argument %s", tableId);
        Identifier identifier = tableId.endsWith(".*") ? Identifier.fromString(tableId) : Identifier.fromString(this.toIdentifier(args.getString(0), PARAMETERS[0].name()).toString());
        LOG.info("identifier is {}.", (Object)identifier);
        Catalog catalog = ((WithPaimonCatalog)this.tableCatalog()).paimonCatalog();
        String mode = args.isNullAt(4) ? "DISTRIBUTED" : args.getString(4);
        try {
            CleanOrphanFilesResult cleanOrphanFilesResult;
            switch (mode.toUpperCase(Locale.ROOT)) {
                case "LOCAL": {
                    cleanOrphanFilesResult = LocalOrphanFilesClean.executeDatabaseOrphanFiles(catalog, identifier.getDatabaseName(), identifier.getTableName(), OrphanFilesClean.olderThanMillis(olderThan), parallelism, dryRun);
                    break;
                }
                case "DISTRIBUTED": {
                    cleanOrphanFilesResult = SparkOrphanFilesClean.executeDatabaseOrphanFiles(catalog, identifier.getDatabaseName(), identifier.getTableName(), OrphanFilesClean.olderThanMillis(olderThan), parallelism, dryRun);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown mode: " + mode + ". Only 'DISTRIBUTED' and 'LOCAL' are supported.");
                }
            }
            return new InternalRow[]{this.newInternalRow(cleanOrphanFilesResult.getDeletedFileCount(), cleanOrphanFilesResult.getDeletedFileTotalLenInBytes())};
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ProcedureBuilder builder() {
        return new BaseProcedure.Builder<RemoveOrphanFilesProcedure>(){

            @Override
            public RemoveOrphanFilesProcedure doBuild() {
                return new RemoveOrphanFilesProcedure(this.tableCatalog());
            }
        };
    }

    @Override
    public String description() {
        return "RemoveOrphanFilesProcedure";
    }
}

