/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark;

import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.util.stream.Collectors;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.local.LocalFileIO;
import org.apache.paimon.hive.TestHiveMetastore;
import org.apache.paimon.spark.SparkCatalog;
import org.apache.paimon.spark.SparkGenericCatalog;
import org.apache.paimon.table.FileStoreTableFactory;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class SparkCatalogWithHiveTest {
    private static TestHiveMetastore testHiveMetastore;
    private static final int PORT = 9087;

    @BeforeAll
    public static void startMetastore() {
        testHiveMetastore = new TestHiveMetastore();
        testHiveMetastore.start(9087);
    }

    @AfterAll
    public static void closeMetastore() throws Exception {
        testHiveMetastore.stop();
    }

    @Test
    public void testCreateFormatTable(@TempDir Path tempDir) {
        org.apache.paimon.fs.Path warehousePath = new org.apache.paimon.fs.Path("file:" + tempDir.toString());
        SparkSession spark = SparkSession.builder().config("spark.sql.warehouse.dir", warehousePath.toString()).config("spark.sql.catalogImplementation", "hive").config("hive.metastore.uris", "thrift://localhost:9087").config("spark.sql.catalog.spark_catalog", SparkCatalog.class.getName()).config("spark.sql.catalog.spark_catalog.metastore", "hive").config("spark.sql.catalog.spark_catalog.hive.metastore.uris", "thrift://localhost:9087").config("spark.sql.catalog.spark_catalog.format-table.enabled", "true").config("spark.sql.catalog.spark_catalog.warehouse", warehousePath.toString()).master("local[2]").getOrCreate();
        spark.sql("CREATE DATABASE IF NOT EXISTS my_db1");
        spark.sql("USE spark_catalog.my_db1");
        spark.sql("CREATE TABLE IF NOT EXISTS table_orc (a INT, bb INT, c STRING) USING orc");
        Assertions.assertThat(spark.sql("SHOW TABLES").collectAsList().stream().map(s -> s.get(1)).map(Object::toString)).containsExactlyInAnyOrder((Object[])new String[]{"table_orc"});
        Assertions.assertThat((long)spark.sql("EXPLAIN EXTENDED SELECT * from table_orc").collectAsList().stream().map(s -> s.get(0)).map(Object::toString).filter(s -> s.contains("OrcScan")).count()).isGreaterThan(0L);
        spark.sql("CREATE TABLE IF NOT EXISTS table_csv (a INT, bb INT, c STRING) USING csv OPTIONS ('field-delimiter' ',')");
        spark.sql("INSERT INTO table_csv VALUES (1, 1, '1'), (2, 2, '2')").collect();
        Assertions.assertThat((String)spark.sql("DESCRIBE FORMATTED table_csv").collectAsList().toString()).contains(new CharSequence[]{"sep=,"});
        Assertions.assertThat(spark.sql("SELECT * FROM table_csv").collectAsList().stream().map(Row::toString).collect(Collectors.toList())).containsExactlyInAnyOrder((Object[])new String[]{"[1,1,1]", "[2,2,2]"});
        spark.close();
    }

    @Test
    public void testSpecifyHiveConfDir(@TempDir Path tempDir) {
        org.apache.paimon.fs.Path warehousePath = new org.apache.paimon.fs.Path("file:" + tempDir.toString());
        SparkSession spark = SparkSession.builder().config("spark.sql.catalog.spark_catalog.hive-conf-dir", "nonExistentPath").config("spark.sql.warehouse.dir", warehousePath.toString()).config("spark.sql.catalogImplementation", "hive").config("spark.sql.catalog.spark_catalog", SparkGenericCatalog.class.getName()).master("local[2]").getOrCreate();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> spark.sql("CREATE DATABASE my_db")).rootCause().isInstanceOf(FileNotFoundException.class)).hasMessageContaining("nonExistentPath");
        spark.close();
    }

    @Test
    public void testCreateExternalTable(@TempDir Path tempDir) {
        org.apache.paimon.fs.Path warehousePath = new org.apache.paimon.fs.Path("file:" + tempDir.toString());
        SparkSession spark = SparkSession.builder().config("spark.sql.warehouse.dir", warehousePath.toString()).config("spark.sql.catalogImplementation", "hive").config("hive.metastore.uris", "thrift://localhost:9087").config("spark.sql.catalog.spark_catalog", SparkCatalog.class.getName()).config("spark.sql.catalog.spark_catalog.metastore", "hive").config("spark.sql.catalog.spark_catalog.hive.metastore.uris", "thrift://localhost:9087").config("spark.sql.catalog.spark_catalog.warehouse", warehousePath.toString()).master("local[2]").getOrCreate();
        spark.sql("CREATE DATABASE IF NOT EXISTS test_db");
        spark.sql("USE spark_catalog.test_db");
        spark.sql("CREATE EXTERNAL TABLE t1 (a INT, bb INT, c STRING)");
        spark.sql("DROP TABLE t1");
        Assertions.assertThatCode(() -> FileStoreTableFactory.create((FileIO)LocalFileIO.create(), (org.apache.paimon.fs.Path)new org.apache.paimon.fs.Path(warehousePath, String.format("%s.db/%s", "test_db", "t1")))).doesNotThrowAnyException();
        spark.close();
    }
}

