/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.catalog.CatalogFactory;
import org.apache.paimon.catalog.FileSystemCatalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.fileindex.FileIndexFormat;
import org.apache.paimon.fileindex.FileIndexReader;
import org.apache.paimon.fileindex.FileIndexResult;
import org.apache.paimon.fileindex.bitmap.BitmapIndexResult;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.SeekableInputStream;
import org.apache.paimon.fs.local.LocalFileIO;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataFilePathFactory;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.predicate.FieldRef;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.spark.SparkCatalog;
import org.apache.paimon.spark.SparkWriteITCase;
import org.apache.paimon.spark.extensions.PaimonSparkSessionExtensions;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.ReadBuilder;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.RoaringBitmap32;
import org.apache.spark.sql.SparkSession;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.io.TempDir;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class SparkFileIndexITCase
extends SparkWriteITCase {
    protected FileIO fileIO = LocalFileIO.create();
    protected FileSystemCatalog fileSystemCatalog;

    @Override
    @BeforeAll
    public void startMetastoreAndSpark(@TempDir java.nio.file.Path tempDir) {
        warehousePath = new Path("file:///" + tempDir.toString());
        this.spark = SparkSession.builder().master("local[1]").config("spark.sql.extensions", PaimonSparkSessionExtensions.class.getName()).getOrCreate();
        this.spark.conf().set("spark.sql.catalog.paimon", SparkCatalog.class.getName());
        this.spark.conf().set("spark.sql.catalog.paimon.warehouse", warehousePath.toString());
        this.spark.conf().set("spark.sql.shuffle.partitions", 1L);
        this.spark.conf().set("spark.default.parallelism", 1L);
        this.spark.sql("CREATE DATABASE paimon.db");
        this.spark.sql("USE paimon.db");
        Options options = new Options();
        options.set(CatalogOptions.WAREHOUSE, (Object)this.spark.conf().get("spark.sql.catalog.paimon.warehouse"));
        options.set(CatalogOptions.CACHE_ENABLED, (Object)false);
        this.fileSystemCatalog = (FileSystemCatalog)CatalogFactory.createCatalog((CatalogContext)CatalogContext.create((Options)options));
    }

    @Test
    public void testReadWriteTableWithBitmapIndex() throws Catalog.TableNotExistException {
        this.spark.sql("CREATE TABLE T(a int) TBLPROPERTIES ('file-index.bitmap.columns'='a','file-index.in-manifest-threshold'='1B');");
        this.spark.sql("INSERT INTO T VALUES (0),(1),(2),(3),(4),(5);");
        List rows1 = this.spark.sql("SELECT a FROM T where a>3;").collectAsList();
        Assertions.assertThat((String)rows1.toString()).isEqualTo("[[4], [5]]");
        List rows2 = this.spark.sql("SELECT a FROM T where a=3;").collectAsList();
        Assertions.assertThat((String)rows2.toString()).isEqualTo("[[3]]");
        this.foreachIndexReader(fileIndexReader -> {
            FileIndexResult fileIndexResult = fileIndexReader.visitEqual(new FieldRef(0, "", (DataType)new IntType()), (Object)3);
            assert (fileIndexResult instanceof BitmapIndexResult);
            RoaringBitmap32 roaringBitmap32 = (RoaringBitmap32)((BitmapIndexResult)fileIndexResult).get();
            assert (roaringBitmap32.equals((Object)RoaringBitmap32.bitmapOf((int[])new int[]{3})));
        });
    }

    @Test
    public void testReadWriteTableWithBitSliceIndex() throws Catalog.TableNotExistException {
        this.spark.sql("CREATE TABLE T(a int) TBLPROPERTIES ('file-index.bsi.columns'='a','file-index.in-manifest-threshold'='1B');");
        this.spark.sql("INSERT INTO T VALUES (0),(1),(2),(3),(4),(5);");
        List rows = this.spark.sql("SELECT a FROM T where a>=3;").collectAsList();
        Assertions.assertThat((String)rows.toString()).isEqualTo("[[3], [4], [5]]");
        this.foreachIndexReader(fileIndexReader -> {
            FileIndexResult fileIndexResult = fileIndexReader.visitGreaterOrEqual(new FieldRef(0, "", (DataType)new IntType()), (Object)3);
            Assertions.assertThat((Object)fileIndexResult).isInstanceOf(BitmapIndexResult.class);
            RoaringBitmap32 roaringBitmap32 = (RoaringBitmap32)((BitmapIndexResult)fileIndexResult).get();
            Assertions.assertThat((Object)roaringBitmap32).isEqualTo((Object)RoaringBitmap32.bitmapOf((int[])new int[]{3, 4, 5}));
        });
    }

    protected void foreachIndexReader(Consumer<FileIndexReader> consumer) throws Catalog.TableNotExistException {
        Path tableRoot = this.fileSystemCatalog.getTableLocation(Identifier.create((String)"db", (String)"T"));
        SchemaManager schemaManager = new SchemaManager(this.fileIO, tableRoot);
        FileStorePathFactory pathFactory = new FileStorePathFactory(tableRoot, RowType.of(), new CoreOptions(new Options()).partitionDefaultName(), (String)CoreOptions.FILE_FORMAT.defaultValue(), (String)CoreOptions.DATA_FILE_PREFIX.defaultValue(), (String)CoreOptions.CHANGELOG_FILE_PREFIX.defaultValue(), ((Boolean)CoreOptions.PARTITION_GENERATE_LEGCY_NAME.defaultValue()).booleanValue(), ((Boolean)CoreOptions.FILE_SUFFIX_INCLUDE_COMPRESSION.defaultValue()).booleanValue(), (String)CoreOptions.FILE_COMPRESSION.defaultValue(), null);
        Table table = this.fileSystemCatalog.getTable(Identifier.create((String)"db", (String)"T"));
        ReadBuilder readBuilder = table.newReadBuilder();
        List splits = readBuilder.newScan().plan().splits();
        for (Split split : splits) {
            DataSplit dataSplit = (DataSplit)split;
            DataFilePathFactory dataFilePathFactory = pathFactory.createDataFilePathFactory(dataSplit.partition(), dataSplit.bucket());
            for (DataFileMeta dataFileMeta : dataSplit.dataFiles()) {
                TableSchema tableSchema = schemaManager.schema(dataFileMeta.schemaId());
                List indexFiles = dataFileMeta.extraFiles().stream().filter(name -> name.endsWith(".index")).collect(Collectors.toList());
                assert (indexFiles.size() == 1);
                try {
                    FileIndexFormat.Reader reader = FileIndexFormat.createReader((SeekableInputStream)this.fileIO.newInputStream(dataFilePathFactory.toAlignedPath((String)indexFiles.get(0), dataFileMeta)), (RowType)tableSchema.logicalRowType());
                    Throwable throwable = null;
                    try {
                        Optional fileIndexReader = reader.readColumnIndex("a").stream().findFirst();
                        assert (fileIndexReader.isPresent());
                        consumer.accept((FileIndexReader)fileIndexReader.get());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        reader.close();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

