/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.procedure;

import java.io.Serializable;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import org.apache.paimon.spark.PaimonSparkTestBase;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.assertj.core.api.Assertions;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001=2Aa\u0001\u0003\u0001\u001f!)A\u0003\u0001C\u0001+!)\u0001\u0004\u0001C\u00053\t9R\t\u001f9je\u0016$\u0016mZ:Qe>\u001cW\rZ;sKR+7\u000f\u001e\u0006\u0003\u000b\u0019\t\u0011\u0002\u001d:pG\u0016$WO]3\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\u0001\u0018-[7p]*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E\u0011R\"\u0001\u0004\n\u0005M1!a\u0005)bS6|gn\u00159be.$Vm\u001d;CCN,\u0017A\u0002\u001fj]&$h\bF\u0001\u0017!\t9\u0002!D\u0001\u0005\u00039\u0019\u0007.Z2l':\f\u0007o\u001d5piN$BA\u0007\u0011)[A\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t!QK\\5u\u0011\u0015\t#\u00011\u0001#\u0003\t\u0019X\u000e\u0005\u0002$M5\tAE\u0003\u0002&\u0011\u0005)Q\u000f^5mg&\u0011q\u0005\n\u0002\u0010':\f\u0007o\u001d5pi6\u000bg.Y4fe\")\u0011F\u0001a\u0001U\u0005AQ-\u0019:mS\u0016\u001cH\u000f\u0005\u0002\u001cW%\u0011A\u0006\b\u0002\u0004\u0013:$\b\"\u0002\u0018\u0003\u0001\u0004Q\u0013A\u00027bi\u0016\u001cH\u000f")
public class ExpireTagsProcedureTest
extends PaimonSparkTestBase {
    private void checkSnapshots(SnapshotManager sm, int earliest, int latest) {
        Assertions.assertThat((long)sm.snapshotCount()).isEqualTo((long)(latest - earliest + 1));
        Assertions.assertThat((Long)sm.earliestSnapshotId()).isEqualTo((long)earliest);
        Assertions.assertThat((Long)sm.latestSnapshotId()).isEqualTo((long)latest);
    }

    public static final /* synthetic */ Dataset $anonfun$new$2(ExpireTagsProcedureTest $this, int i) {
        return $this.spark().sql(new StringBuilder(26).append("INSERT INTO T VALUES(").append(i).append(", '").append(i).append("')").toString());
    }

    public static final /* synthetic */ Dataset $anonfun$new$8(ExpireTagsProcedureTest $this, int i) {
        return $this.spark().sql(new StringBuilder(26).append("INSERT INTO T VALUES(").append(i).append(", '").append(i).append("')").toString());
    }

    public ExpireTagsProcedureTest() {
        this.test("Paimon procedure: expire tags that reached its timeRetained", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (id STRING, name STRING)\n                 |USING PAIMON\n                 |")).stripMargin());
            FileStoreTable table = this.loadTable("T");
            SnapshotManager snapshotManager = table.snapshotManager();
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 5).foreach((Function1 & Serializable & scala.Serializable)i -> ExpireTagsProcedureTest.$anonfun$new$2(this, BoxesRunTime.unboxToInt((Object)i)));
            this.checkSnapshots(snapshotManager, 1, 5);
            this.spark().sql("CALL paimon.sys.create_tag(table => 'test.T', tag => 'tag-1', snapshot => 1)");
            this.spark().sql("CALL paimon.sys.create_tag(table => 'test.T', tag => 'tag-2', snapshot => 2, time_retained => '1h')");
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"No expired tags."}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("CALL paimon.sys.expire_tags(table => 'test.T')"), (Seq)Nil$.MODULE$.$colon$colon((Object)row));
            this.spark().sql("CALL paimon.sys.create_tag(table => 'test.T', tag => 'tag-3', snapshot => 3, time_retained => '1s')");
            this.spark().sql("CALL paimon.sys.create_tag(table => 'test.T', tag => 'tag-4', snapshot => 4, time_retained => '1s')");
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4)}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("select count(tag_name) from `T$tags`"), (Seq)Nil$.MODULE$.$colon$colon((Object)row2));
            Thread.sleep(2000L);
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"tag-3"}));
            Row row4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"tag-4"}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("CALL paimon.sys.expire_tags(table => 'test.T')"), (Seq)Nil$.MODULE$.$colon$colon((Object)row4).$colon$colon((Object)row3));
            Row row5 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"tag-1"}));
            Row row6 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"tag-2"}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("select tag_name from `T$tags`"), (Seq)Nil$.MODULE$.$colon$colon((Object)row6).$colon$colon((Object)row5));
        }, new Position("ExpireTagsProcedureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 30));
        this.test("Paimon procedure: expire tags that createTime less than specified older_than", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (id STRING, name STRING)\n                 |USING PAIMON\n                 |")).stripMargin());
            FileStoreTable table = this.loadTable("T");
            SnapshotManager snapshotManager = table.snapshotManager();
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 5).foreach((Function1 & Serializable & scala.Serializable)i -> ExpireTagsProcedureTest.$anonfun$new$8(this, BoxesRunTime.unboxToInt((Object)i)));
            this.checkSnapshots(snapshotManager, 1, 5);
            this.spark().sql("CALL paimon.sys.create_tag(table => 'test.T', tag => 'tag-1', snapshot => 1)");
            this.spark().sql("CALL paimon.sys.create_tag(table => 'test.T', tag => 'tag-2', snapshot => 2, time_retained => '1d')");
            this.spark().sql("CALL paimon.sys.create_tag(table => 'test.T', tag => 'tag-3', snapshot => 3, time_retained => '1d')");
            this.spark().sql("CALL paimon.sys.create_tag(table => 'test.T', tag => 'tag-4', snapshot => 4, time_retained => '1d')");
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4)}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("select count(tag_name) from `T$tags`"), (Seq)Nil$.MODULE$.$colon$colon((Object)row));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"No expired tags."}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("CALL paimon.sys.expire_tags(table => 'test.T')"), (Seq)Nil$.MODULE$.$colon$colon((Object)row2));
            LocalDateTime olderThanTime1 = table.tagManager().getOrThrow("tag-2").getTagCreateTime();
            Timestamp timestamp1 = new Timestamp(org.apache.paimon.data.Timestamp.fromLocalDateTime((LocalDateTime)olderThanTime1).getMillisecond());
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"tag-1"}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql(new StringBuilder(64).append("CALL paimon.sys.expire_tags(table => 'test.T', older_than => '").append(timestamp1.toString()).append("')").toString()), (Seq)Nil$.MODULE$.$colon$colon((Object)row3));
            this.spark().sql("CALL paimon.sys.create_tag(table => 'test.T', tag => 'tag-5', snapshot => 5, time_retained => '1s')");
            Thread.sleep(1000L);
            LocalDateTime olderThanTime2 = table.tagManager().getOrThrow("tag-4").getTagCreateTime();
            Timestamp timestamp2 = new Timestamp(org.apache.paimon.data.Timestamp.fromLocalDateTime((LocalDateTime)olderThanTime2).getMillisecond());
            Row row4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"tag-2"}));
            Row row5 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"tag-3"}));
            Row row6 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"tag-5"}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql(new StringBuilder(64).append("CALL paimon.sys.expire_tags(table => 'test.T', older_than => '").append(timestamp2.toString()).append("')").toString()), (Seq)Nil$.MODULE$.$colon$colon((Object)row6).$colon$colon((Object)row5).$colon$colon((Object)row4));
            Row row7 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"tag-4"}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("select tag_name from `T$tags`"), (Seq)Nil$.MODULE$.$colon$colon((Object)row7));
        }, new Position("ExpireTagsProcedureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
    }
}

