/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.procedure;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.concurrent.TimeUnit;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.spark.PaimonSparkTestBase;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.utils.DateTimeUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001!2AAB\u0004\u0001%!)q\u0003\u0001C\u00011!91\u0004\u0001b\u0001\n\u0013a\u0002BB\u0013\u0001A\u0003%Q\u0004C\u0004'\u0001\t\u0007I\u0011\u0002\u000f\t\r\u001d\u0002\u0001\u0015!\u0003\u001e\u0005y\u0011V-\\8wK>\u0013\b\u000f[1o\r&dWm\u001d)s_\u000e,G-\u001e:f)\u0016\u001cHO\u0003\u0002\t\u0013\u0005I\u0001O]8dK\u0012,(/\u001a\u0006\u0003\u0015-\tQa\u001d9be.T!\u0001D\u0007\u0002\rA\f\u0017.\\8o\u0015\tqq\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002!\u0005\u0019qN]4\u0004\u0001M\u0011\u0001a\u0005\t\u0003)Ui\u0011!C\u0005\u0003-%\u00111\u0003U1j[>t7\u000b]1sWR+7\u000f\u001e\"bg\u0016\fa\u0001P5oSRtD#A\r\u0011\u0005i\u0001Q\"A\u0004\u0002\u001b=\u0013\u0006\u000bS!O?\u001aKE*R02+\u0005i\u0002C\u0001\u0010$\u001b\u0005y\"B\u0001\u0011\"\u0003\u0011a\u0017M\\4\u000b\u0003\t\nAA[1wC&\u0011Ae\b\u0002\u0007'R\u0014\u0018N\\4\u0002\u001d=\u0013\u0006\u000bS!O?\u001aKE*R02A\u0005iqJ\u0015)I\u0003:{f)\u0013'F?J\nab\u0014*Q\u0011\u0006suLR%M\u000b~\u0013\u0004\u0005")
public class RemoveOrphanFilesProcedureTest
extends PaimonSparkTestBase {
    private final String ORPHAN_FILE_1;
    private final String ORPHAN_FILE_2;

    private String ORPHAN_FILE_1() {
        return this.ORPHAN_FILE_1;
    }

    private String ORPHAN_FILE_2() {
        return this.ORPHAN_FILE_2;
    }

    public RemoveOrphanFilesProcedureTest() {
        this.ORPHAN_FILE_1 = "bucket-0/orphan_file1";
        this.ORPHAN_FILE_2 = "bucket-0/orphan_file2";
        this.test("Paimon procedure: remove orphan files", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (id STRING, name STRING)\n                 |USING PAIMON\n                 |TBLPROPERTIES ('primary-key'='id')\n                 |")).stripMargin());
            this.spark().sql("INSERT INTO T VALUES ('1', 'a'), ('2', 'b')");
            FileStoreTable table = this.loadTable("T");
            FileIO fileIO = table.fileIO();
            Path tablePath = table.location();
            Path orphanFile1 = new Path(tablePath, this.ORPHAN_FILE_1());
            Path orphanFile2 = new Path(tablePath, this.ORPHAN_FILE_2());
            fileIO.tryToWriteAtomic(orphanFile1, "a");
            Thread.sleep(2000L);
            fileIO.tryToWriteAtomic(orphanFile2, "b");
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0)}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("CALL sys.remove_orphan_files(table => 'T')"), (Seq)Nil$.MODULE$.$colon$colon((Object)row));
            long orphanFile2ModTime = fileIO.getFileStatus(orphanFile2).getModificationTime();
            String older_than1 = DateTimeUtils.formatLocalDateTime((LocalDateTime)DateTimeUtils.toLocalDateTime((long)(orphanFile2ModTime - TimeUnit.SECONDS.toMillis(1L))), (int)3);
            System.out.println(new StringBuilder(24).append("orphanFile2ModTime is : ").append(orphanFile2ModTime).toString());
            System.out.println(new StringBuilder(17).append("older_than1 is : ").append(older_than1).toString());
            System.out.println(new StringBuilder(27).append("in ut Timestamp.now() is : ").append(Timestamp.now()).toString());
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql(new StringBuilder(60).append("CALL sys.remove_orphan_files(table => 'T', older_than => '").append(older_than1).append("')").toString()), (Seq)Nil$.MODULE$.$colon$colon((Object)row2));
            String older_than2 = DateTimeUtils.formatLocalDateTime((LocalDateTime)DateTimeUtils.toLocalDateTime((long)System.currentTimeMillis()), (int)3);
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql(new StringBuilder(60).append("CALL sys.remove_orphan_files(table => 'T', older_than => '").append(older_than2).append("')").toString()), (Seq)Nil$.MODULE$.$colon$colon((Object)row3));
            Row row4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0)}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("CALL sys.remove_orphan_files(table => 'T')"), (Seq)Nil$.MODULE$.$colon$colon((Object)row4));
        }, new Position("RemoveOrphanFilesProcedureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 35));
        this.test("Paimon procedure: dry run remove orphan files", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (id STRING, name STRING)\n                 |USING PAIMON\n                 |TBLPROPERTIES ('primary-key'='id')\n                 |")).stripMargin());
            this.spark().sql("INSERT INTO T VALUES ('1', 'a'), ('2', 'b')");
            FileStoreTable table = this.loadTable("T");
            FileIO fileIO = table.fileIO();
            Path tablePath = table.location();
            Path orphanFile1 = new Path(tablePath, this.ORPHAN_FILE_1());
            Path orphanFile2 = new Path(tablePath, this.ORPHAN_FILE_2());
            fileIO.writeFile(orphanFile1, "a", true);
            Thread.sleep(2000L);
            fileIO.writeFile(orphanFile2, "b", true);
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0)}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("CALL sys.remove_orphan_files(table => 'T')"), (Seq)Nil$.MODULE$.$colon$colon((Object)row));
            String older_than = DateTimeUtils.formatLocalDateTime((LocalDateTime)DateTimeUtils.toLocalDateTime((long)System.currentTimeMillis()), (int)3);
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2)}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql(new StringBuilder(77).append("CALL sys.remove_orphan_files(table => 'T', older_than => '").append(older_than).append("', dry_run => true)").toString()), (Seq)Nil$.MODULE$.$colon$colon((Object)row2));
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0)}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("CALL sys.remove_orphan_files(table => 'T')"), (Seq)Nil$.MODULE$.$colon$colon((Object)row3));
        }, new Position("RemoveOrphanFilesProcedureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        this.test("Paimon procedure: remove database orphan files", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T1 (id STRING, name STRING)\n                 |USING PAIMON\n                 |TBLPROPERTIES ('primary-key'='id')\n                 |")).stripMargin());
            this.spark().sql("INSERT INTO T1 VALUES ('1', 'a'), ('2', 'b')");
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T2 (id STRING, name STRING)\n                 |USING PAIMON\n                 |TBLPROPERTIES ('primary-key'='id')\n                 |")).stripMargin());
            this.spark().sql("INSERT INTO T2 VALUES ('1', 'a'), ('2', 'b')");
            FileStoreTable table1 = this.loadTable("T1");
            FileStoreTable table2 = this.loadTable("T2");
            FileIO fileIO1 = table1.fileIO();
            FileIO fileIO2 = table2.fileIO();
            Path tablePath1 = table1.location();
            Path tablePath2 = table2.location();
            Path orphanFile11 = new Path(tablePath1, this.ORPHAN_FILE_1());
            Path orphanFile12 = new Path(tablePath1, this.ORPHAN_FILE_2());
            Path orphanFile21 = new Path(tablePath2, this.ORPHAN_FILE_1());
            Path orphanFile22 = new Path(tablePath2, this.ORPHAN_FILE_2());
            fileIO1.tryToWriteAtomic(orphanFile11, "a");
            fileIO2.tryToWriteAtomic(orphanFile21, "a");
            Thread.sleep(2000L);
            fileIO1.tryToWriteAtomic(orphanFile12, "b");
            fileIO2.tryToWriteAtomic(orphanFile22, "b");
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0)}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("CALL sys.remove_orphan_files(table => 'test.*')"), (Seq)Nil$.MODULE$.$colon$colon((Object)row));
            long orphanFile12ModTime = fileIO1.getFileStatus(orphanFile12).getModificationTime();
            String older_than1 = DateTimeUtils.formatLocalDateTime((LocalDateTime)DateTimeUtils.toLocalDateTime((long)(orphanFile12ModTime - TimeUnit.SECONDS.toMillis(1L))), (int)3);
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2)}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql(new StringBuilder(65).append("CALL sys.remove_orphan_files(table => 'test.*', older_than => '").append(older_than1).append("')").toString()), (Seq)Nil$.MODULE$.$colon$colon((Object)row2));
            String older_than2 = DateTimeUtils.formatLocalDateTime((LocalDateTime)DateTimeUtils.toLocalDateTime((long)System.currentTimeMillis()), (int)3);
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2)}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql(new StringBuilder(65).append("CALL sys.remove_orphan_files(table => 'test.*', older_than => '").append(older_than2).append("')").toString()), (Seq)Nil$.MODULE$.$colon$colon((Object)row3));
            Row row4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0)}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("CALL sys.remove_orphan_files(table => 'test.*')"), (Seq)Nil$.MODULE$.$colon$colon((Object)row4));
        }, new Position("RemoveOrphanFilesProcedureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
        this.test("Paimon procedure: remove orphan files with mode", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (id STRING, name STRING)\n                 |USING PAIMON\n                 |TBLPROPERTIES ('primary-key'='id')\n                 |")).stripMargin());
            this.spark().sql("INSERT INTO T VALUES ('1', 'a'), ('2', 'b')");
            FileStoreTable table = this.loadTable("T");
            FileIO fileIO = table.fileIO();
            Path tablePath = table.location();
            Path orphanFile1 = new Path(tablePath, this.ORPHAN_FILE_1());
            Path orphanFile2 = new Path(tablePath, this.ORPHAN_FILE_2());
            fileIO.tryToWriteAtomic(orphanFile1, "a");
            Thread.sleep(2000L);
            fileIO.tryToWriteAtomic(orphanFile2, "b");
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0)}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("CALL sys.remove_orphan_files(table => 'T')"), (Seq)Nil$.MODULE$.$colon$colon((Object)row));
            long orphanFile2ModTime = fileIO.getFileStatus(orphanFile2).getModificationTime();
            String older_than1 = DateTimeUtils.formatLocalDateTime((LocalDateTime)DateTimeUtils.toLocalDateTime((long)(orphanFile2ModTime - TimeUnit.SECONDS.toMillis(1L))), (int)3);
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql(new StringBuilder(83).append("CALL sys.remove_orphan_files(table => 'T', older_than => '").append(older_than1).append("', mode => 'diSTributed')").toString()), (Seq)Nil$.MODULE$.$colon$colon((Object)row2));
            String older_than2 = DateTimeUtils.formatLocalDateTime((LocalDateTime)DateTimeUtils.toLocalDateTime((long)System.currentTimeMillis()), (int)3);
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql(new StringBuilder(77).append("CALL sys.remove_orphan_files(table => 'T', older_than => '").append(older_than2).append("', mode => 'local')").toString()), (Seq)Nil$.MODULE$.$colon$colon((Object)row3));
            Row row4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0)}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("CALL sys.remove_orphan_files(table => 'T')"), (Seq)Nil$.MODULE$.$colon$colon((Object)row4));
        }, new Position("RemoveOrphanFilesProcedureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
        this.test("Paimon procedure: remove orphan files with data file path directory", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n           |CREATE TABLE T (id STRING, name STRING)\n           |USING PAIMON\n           |TBLPROPERTIES ('primary-key'='id', 'data-file.path-directory'='data')\n           |")).stripMargin());
            this.sql().apply((Object)"INSERT INTO T VALUES ('1', 'a'), ('2', 'b')");
            FileStoreTable table = this.loadTable("T");
            Path orphanFile = new Path(table.store().pathFactory().dataFilePath(), this.ORPHAN_FILE_1());
            table.fileIO().tryToWriteAtomic(orphanFile, "b");
            Thread.sleep(1000L);
            String older_than = DateTimeUtils.formatLocalDateTime((LocalDateTime)DateTimeUtils.toLocalDateTime((long)System.currentTimeMillis()), (int)3);
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(60).append("CALL sys.remove_orphan_files(table => 'T', older_than => '").append(older_than).append("')").toString()), (Seq)Nil$.MODULE$.$colon$colon((Object)row));
        }, new Position("RemoveOrphanFilesProcedureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 227));
    }
}

