/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.sql;

import java.io.File;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.spark.PaimonSparkTestBase;
import org.apache.paimon.spark.sql.DDLTestBase$;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.source.ReadBuilder;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.spark.SparkException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.types.StructType;
import org.junit.jupiter.api.Assertions;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001]1QAA\u0002\u0002\u00029AQa\u0005\u0001\u0005\u0002Q\u00111\u0002\u0012#M)\u0016\u001cHOQ1tK*\u0011A!B\u0001\u0004gFd'B\u0001\u0004\b\u0003\u0015\u0019\b/\u0019:l\u0015\tA\u0011\"\u0001\u0004qC&lwN\u001c\u0006\u0003\u0015-\ta!\u00199bG\",'\"\u0001\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001y\u0001C\u0001\t\u0012\u001b\u0005)\u0011B\u0001\n\u0006\u0005M\u0001\u0016-[7p]N\u0003\u0018M]6UKN$()Y:f\u0003\u0019a\u0014N\\5u}Q\tQ\u0003\u0005\u0002\u0017\u00015\t1\u0001")
public abstract class DDLTestBase
extends PaimonSparkTestBase {
    public static final /* synthetic */ void $anonfun$new$44(DDLTestBase $this, String format) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)datetimeJava8APIEnabled -> {
            $this.withSparkSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.datetime.java8API.enabled"), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)datetimeJava8APIEnabled)))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTimeZone("Asia/Shanghai", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"paimon_tbl"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                if ($this.gteqSpark3_4()) {
                    $this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(243).append("\n                           |CREATE TABLE paimon_tbl (id int, binary BINARY, ts timestamp, ts_ntz timestamp_ntz)\n                           |USING paimon\n                           |TBLPROPERTIES ('file.format'='").append(format$2).append("')\n                           |").toString())).stripMargin());
                    $this.sql().apply((Object)"INSERT INTO paimon_tbl VALUES (1, binary('b'), timestamp'2024-01-01 00:00:00', timestamp_ntz'2024-01-01 00:00:00')");
                    $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT ts, ts_ntz FROM paimon_tbl"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{datetimeJava8APIEnabled ? Timestamp.valueOf("2024-01-01 00:00:00").toInstant() : Timestamp.valueOf("2024-01-01 00:00:00"), LocalDateTime.parse("2024-01-01T00:00:00")})));
                    $this.withTimeZone("UTC", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        block0: {
                            String string = format$2;
                            String string2 = "orc";
                            if (!(string == null ? string2 != null : !string.equals(string2))) break block0;
                            $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT ts, ts_ntz FROM paimon_tbl"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{datetimeJava8APIEnabled ? Timestamp.valueOf("2023-12-31 16:00:00").toInstant() : Timestamp.valueOf("2023-12-31 16:00:00"), LocalDateTime.parse("2024-01-01T00:00:00")})));
                        }
                    });
                } else {
                    $this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(221).append("\n                           |CREATE TABLE paimon_tbl (id int, binary BINARY, ts timestamp)\n                           |USING paimon\n                           |TBLPROPERTIES ('file.format'='").append(format$2).append("')\n                           |").toString())).stripMargin());
                    $this.sql().apply((Object)"INSERT INTO paimon_tbl VALUES (1, binary('b'), timestamp'2024-01-01 00:00:00')");
                    $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT ts FROM paimon_tbl"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{datetimeJava8APIEnabled ? Timestamp.valueOf("2024-01-01 00:00:00").toInstant() : Timestamp.valueOf("2024-01-01 00:00:00")})));
                    $this.withTimeZone("UTC", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        block0: {
                            String string = format$2;
                            String string2 = "orc";
                            if (!(string == null ? string2 != null : !string.equals(string2))) break block0;
                            $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT ts FROM paimon_tbl"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{datetimeJava8APIEnabled ? Timestamp.valueOf("2024-01-01 00:00:00").toInstant() : Timestamp.valueOf("2024-01-01 00:00:00")})));
                        }
                    });
                }
            })));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$72(DDLTestBase $this, boolean legacyPartName) {
        $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"p_t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(303).append("\n                       |CREATE TABLE p_t (\n                       |    id BIGINT,\n                       |    c1 STRING\n                       |) using paimon\n                       |PARTITIONED BY (day binary)\n                       |tblproperties('partition.legacy-name'='").append(legacyPartName).append("');\n                       |").toString())).stripMargin());
            if (legacyPartName) {
                $this.spark().sql("insert into table p_t values(1, 'a', cast('2021' as binary))");
                $this.intercept((Function0 & Serializable & scala.Serializable)() -> (Row[])$this.spark().sql("SELECT * FROM p_t").collect(), ClassTag$.MODULE$.apply(Exception.class), new Position("DDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 516));
            } else {
                Row[] path;
                $this.spark().sql("insert into table p_t values(1, 'a', cast('2021' as binary))");
                $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql("SELECT * FROM p_t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a", "2021".getBytes()})));
                Row[] $org_scalatest_assert_macro_left = path = (Row[])$this.spark().sql("SELECT __paimon_file_path FROM p_t").collect();
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 523));
                String $org_scalatest_assert_macro_left2 = ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])path)).head()).getString(0);
                String $org_scalatest_assert_macro_right2 = "/day=2021/";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 524));
            }
        });
        $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"p_t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Row[] path;
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(301).append("\n                       |CREATE TABLE p_t (\n                       |    id BIGINT,\n                       |    c1 STRING\n                       |) using paimon\n                       |PARTITIONED BY (day date)\n                       |tblproperties('partition.legacy-name'='").append(legacyPartName).append("');\n                       |").toString())).stripMargin());
            $this.spark().sql("insert into table p_t values(1, 'a', cast('2021-01-01' as date))");
            $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql("SELECT * FROM p_t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a", Date.valueOf("2021-01-01")})));
            Row[] $org_scalatest_assert_macro_left = path = (Row[])$this.spark().sql("SELECT __paimon_file_path FROM p_t").collect();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 542));
            if (legacyPartName) {
                String $org_scalatest_assert_macro_left2 = ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])path)).head()).getString(0);
                String $org_scalatest_assert_macro_right2 = "/day=18628/";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 544));
            } else {
                String $org_scalatest_assert_macro_left3 = ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])path)).head()).getString(0);
                String $org_scalatest_assert_macro_right3 = "/day=2021-01-01/";
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 546));
            }
        });
    }

    public DDLTestBase() {
        this.test("Paimon DDL: create append table with not null", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE T (id INT NOT NULL, name STRING)");
            SparkException e1 = (SparkException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"INSERT INTO T VALUES (1, \"a\"), (2, \"b\"), (null, \"c\")"), ClassTag$.MODULE$.apply(SparkException.class), new Position("DDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
            Assertions.assertTrue((boolean)e1.getMessage().contains("Cannot write null to non-null column"));
            this.sql().apply((Object)"INSERT INTO T VALUES (1, \"a\"), (2, \"b\"), (3, null)");
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DDLTestBase.class.getClassLoader());
            public final class Org_apache_paimon_spark_sql_DDLTestBase$$typecreator6$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_paimon_spark_sql_DDLTestBase$$typecreator6$1(DDLTestBase $outer) {
                }
            }
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM T ORDER BY id"), this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), (Object)"b"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)3), null), (List)Nil$.MODULE$))), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_paimon_spark_sql_DDLTestBase$$typecreator6$1(null)))).toDF());
            StructType schema = this.spark().table("T").schema();
            Assertions.assertEquals((int)schema.size(), (int)2);
            Assertions.assertFalse((boolean)schema.apply("id").nullable());
            Assertions.assertTrue((boolean)schema.apply("name").nullable());
        }), new Position("DDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
        this.test("Paimon DDL: create primary-key table with not null", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n            |CREATE TABLE T (id INT, name STRING, pt STRING)\n            |TBLPROPERTIES ('primary-key' = 'id,pt')\n            |")).stripMargin());
            SparkException e1 = (SparkException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"INSERT INTO T VALUES (1, \"a\", \"pt1\"), (2, \"b\", null)"), ClassTag$.MODULE$.apply(SparkException.class), new Position("DDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
            Assertions.assertTrue((boolean)e1.getMessage().contains("Cannot write null to non-null column"));
            SparkException e2 = (SparkException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"INSERT INTO T VALUES (1, \"a\", \"pt1\"), (null, \"b\", \"pt2\")"), ClassTag$.MODULE$.apply(SparkException.class), new Position("DDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
            Assertions.assertTrue((boolean)e2.getMessage().contains("Cannot write null to non-null column"));
            this.sql().apply((Object)"INSERT INTO T VALUES (1, \"a\", \"pt1\"), (2, \"b\", \"pt1\"), (3, null, \"pt2\")");
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DDLTestBase.class.getClassLoader());
            public final class Org_apache_paimon_spark_sql_DDLTestBase$$typecreator16$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_paimon_spark_sql_DDLTestBase$$typecreator16$1(DDLTestBase $outer) {
                }
            }
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM T ORDER BY id"), this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a", (Object)"pt1"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)"b", (Object)"pt1"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), null, (Object)"pt2"), (List)Nil$.MODULE$))), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_paimon_spark_sql_DDLTestBase$$typecreator16$1(null)))).toDF());
            StructType schema = this.spark().table("T").schema();
            Assertions.assertEquals((int)schema.size(), (int)3);
            Assertions.assertFalse((boolean)schema.apply("id").nullable());
            Assertions.assertTrue((boolean)schema.apply("name").nullable());
            Assertions.assertFalse((boolean)schema.apply("pt").nullable());
        }), new Position("DDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
        this.test("Paimon DDL: write nullable expression to non-null column", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n            |CREATE TABLE T (id INT NOT NULL, ts TIMESTAMP NOT NULL)\n            |")).stripMargin());
            this.sql().apply((Object)"INSERT INTO T SELECT 1, TO_TIMESTAMP('2024-07-01 16:00:00')");
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), Timestamp.valueOf("2024-07-01 16:00:00")}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM T ORDER BY id"), (Seq)Nil$.MODULE$.$colon$colon((Object)row));
        }), new Position("DDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        this.test("Paimon DDL: Create Table As Select", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"source", "t1", "t2"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DDLTestBase.class.getClassLoader());
            public final class Org_apache_paimon_spark_sql_DDLTestBase$$typecreator26$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_paimon_spark_sql_DDLTestBase$$typecreator26$1(DDLTestBase $outer) {
                }
            }
            this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)1L), (Object)"x1", (Object)"2023"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)2L), (Object)"x2", (Object)"2023"), (List)Nil$.MODULE$)), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_paimon_spark_sql_DDLTestBase$$typecreator26$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "pt"})).createOrReplaceTempView("source");
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                  |CREATE TABLE t1 AS SELECT * FROM source\n                  |")).stripMargin());
            FileStoreTable t1 = this.loadTable("t1");
            Assertions.assertTrue((boolean)t1.primaryKeys().isEmpty());
            Assertions.assertTrue((boolean)t1.partitionKeys().isEmpty());
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n          |CREATE TABLE t2\n          |PARTITIONED BY (pt)\n          |TBLPROPERTIES ('bucket' = '5', 'primary-key' = 'a,pt', 'target-file-size' = '128MB')\n          |AS SELECT * FROM source\n          |")).stripMargin());
            FileStoreTable t2 = this.loadTable("t2");
            Assertions.assertEquals((int)2, (int)t2.primaryKeys().size());
            Assertions.assertTrue((boolean)t2.primaryKeys().contains("a"));
            Assertions.assertTrue((boolean)t2.primaryKeys().contains("pt"));
            Assertions.assertEquals((int)1, (int)t2.partitionKeys().size());
            Assertions.assertEquals((Object)"pt", t2.partitionKeys().get(0));
            Assertions.assertEquals((Object)"5", t2.options().get("bucket"));
            Assertions.assertEquals((Object)"128MB", t2.options().get("target-file-size"));
        }), new Position("DDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
        this.test("Paimon DDL: create database with location with filesystem catalog", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dBLocation -> {
            this.withDatabase((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"paimon_db"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String error;
                String $org_scalatest_assert_macro_left = error = ((Throwable)$this.intercept((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql(new StringBuilder(37).append("CREATE DATABASE paimon_db LOCATION '").append(dBLocation.getCanonicalPath()).append("'").toString()), ClassTag$.MODULE$.apply(Exception.class), new Position("DDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141))).getMessage();
                String $org_scalatest_assert_macro_right = "Cannot specify location for a database when using fileSystem catalog.";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
            });
            return BoxedUnit.UNIT;
        }), new Position("DDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
        this.test("Paimon DDL: create other table with paimon SparkCatalog", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"paimon_tbl1", "paimon_tbl2", "parquet_tbl"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String error;
            this.spark().sql("CREATE TABLE paimon_tbl1 (id int) USING paimon");
            this.spark().sql("CREATE TABLE paimon_tbl2 (id int)");
            String $org_scalatest_assert_macro_left = error = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("CREATE TABLE parquet_tbl (id int) USING parquet"), ClassTag$.MODULE$.apply(Exception.class), new Position("DDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154))).getMessage();
            String $org_scalatest_assert_macro_right = "does not support format table";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
        }), new Position("DDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
        this.test("Paimon DDL: create table without using paimon", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"paimon_tbl"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE paimon_tbl (id int)");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.loadTable("paimon_tbl").options().containsKey("provider"), "DDLTestBase.this.loadTable(\"paimon_tbl\").options().containsKey(\"provider\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
        }), new Position("DDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
        this.fileFormats().foreach((Function1 & Serializable & scala.Serializable)format -> {
            this.test(new StringBuilder(64).append("Paimon DDL: create table with char/varchar/string, file.format: ").append(format).toString(), (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"paimon_tbl"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(197).append("\n               |CREATE TABLE paimon_tbl (id int, col_s1 char(9), col_s2 varchar(10), col_s3 string)\n               |USING PAIMON\n               |TBLPROPERTIES ('file.format' = '").append(format).append("')\n               |").toString())).stripMargin());
                $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                       |insert into paimon_tbl values\n                       |(1, 'Wednesday', 'Wednesday', 'Wednesday'),\n                       |(2, 'Friday', 'Friday', 'Friday')\n                       |")).stripMargin());
                Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"col_s1", "char(9)"}));
                Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"col_s2", "varchar(10)"}));
                Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"col_s3", "string"}));
                $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql("DESC paimon_tbl").select("col_name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"data_type"})).where("col_name LIKE 'col_%'").orderBy("col_name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])), (Seq)Nil$.MODULE$.$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row));
                String string = format;
                String string2 = "orc";
                if (!(string != null ? !string.equals(string2) : string2 != null) && !$this.gteqSpark3_4()) {
                    Row row4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Friday"}));
                    $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql("select col_s1 from paimon_tbl where id = 2"), (Seq)Nil$.MODULE$.$colon$colon((Object)row4));
                    $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql("select col_s1 from paimon_tbl where col_s1 = 'Friday'"), (Seq)Nil$.MODULE$);
                } else {
                    Row row5 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Friday   "}));
                    $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql("select col_s1 from paimon_tbl where id = 2"), (Seq)Nil$.MODULE$.$colon$colon((Object)row5));
                    Row row6 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Friday   "}));
                    $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql("select col_s1 from paimon_tbl where col_s1 = 'Friday'"), (Seq)Nil$.MODULE$.$colon$colon((Object)row6));
                }
                Row row7 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Friday"}));
                $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql("select col_s2 from paimon_tbl where col_s2 = 'Friday'"), (Seq)Nil$.MODULE$.$colon$colon((Object)row7));
                Row row8 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Friday"}));
                $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql("select col_s3 from paimon_tbl where col_s3 = 'Friday'"), (Seq)Nil$.MODULE$.$colon$colon((Object)row8));
            }), new Position("DDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
            return BoxedUnit.UNIT;
        });
        this.test("Paimon DDL: write with char", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"paimon_tbl"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                   |CREATE TABLE paimon_tbl (id int, c char(6))\n                   |USING PAIMON\n                   |")).stripMargin());
            this.withSparkSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.legacy.charVarcharAsString"), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.sql().apply((Object)"INSERT INTO paimon_tbl VALUES (1, 'ab')"));
            this.withSparkSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.legacy.charVarcharAsString"), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.sql().apply((Object)"INSERT INTO paimon_tbl VALUES (2, 'ab')"));
            if (this.gteqSpark3_4()) {
                this.withSparkSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.readSideCharPadding"), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"ab    "}));
                    Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"ab    "}));
                    this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("SELECT c FROM paimon_tbl ORDER BY id"), (Seq)Nil$.MODULE$.$colon$colon((Object)row2).$colon$colon((Object)row));
                });
                this.withSparkSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.readSideCharPadding"), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"ab"}));
                    Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"ab    "}));
                    this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("SELECT c FROM paimon_tbl ORDER BY id"), (Seq)Nil$.MODULE$.$colon$colon((Object)row2).$colon$colon((Object)row));
                });
            } else {
                Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"ab"}));
                Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"ab    "}));
                this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("SELECT c FROM paimon_tbl ORDER BY id"), (Seq)Nil$.MODULE$.$colon$colon((Object)row2).$colon$colon((Object)row));
            }
        }), new Position("DDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
        this.test("Paimon DDL: create table with timestamp/timestamp_ntz", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"orc", (List)new .colon.colon((Object)"parquet", (List)new .colon.colon((Object)"avro", (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)format -> {
            DDLTestBase.$anonfun$new$44(this, format);
            return BoxedUnit.UNIT;
        }), new Position("DDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268));
        this.test("Paimon DDL: create table with timestamp/timestamp_ntz using table API", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            Identifier identifier = Identifier.create((String)"test", (String)"paimon_tbl");
            try {
                this.withTimeZone("Asia/Shanghai", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    Schema schema = Schema.newBuilder().column("ts", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE()).column("ts_ntz", (DataType)DataTypes.TIMESTAMP()).build();
                    this.paimonCatalog().createTable(identifier, schema, false);
                    this.sql().apply((Object)"INSERT INTO paimon_tbl VALUES (timestamp'2024-01-01 00:00:00', timestamp_ntz'2024-01-01 00:00:00')");
                    this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT ts, ts_ntz FROM paimon_tbl"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Timestamp.valueOf("2024-01-01 00:00:00"), this.gteqSpark3_4() ? LocalDateTime.parse("2024-01-01T00:00:00") : Timestamp.valueOf("2024-01-01 00:00:00")})));
                    if (this.gteqSpark3_4()) {
                        Table table = this.paimonCatalog().getTable(identifier);
                        ReadBuilder builder = table.newReadBuilder().withProjection((int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}), ClassTag$.MODULE$.Int()));
                        java.util.List splits = builder.newScan().plan().splits();
                        builder.newRead().createReader(splits).forEachRemaining(r -> {
                            Assertions.assertEquals((Object)Timestamp.valueOf("2023-12-31 16:00:00"), (Object)r.getTimestamp(0, 6).toSQLTimestamp());
                            Assertions.assertEquals((Object)Timestamp.valueOf("2024-01-01 00:00:00").toLocalDateTime(), (Object)r.getTimestamp(1, 6).toLocalDateTime());
                        });
                    }
                    this.withTimeZone("UTC", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        block0: {
                            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT ts, ts_ntz FROM paimon_tbl"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.gteqSpark3_4() ? Timestamp.valueOf("2023-12-31 16:00:00") : Timestamp.valueOf("2024-01-01 00:00:00"), this.gteqSpark3_4() ? LocalDateTime.parse("2024-01-01T00:00:00") : Timestamp.valueOf("2024-01-01 00:00:00")})));
                            if (!this.gteqSpark3_4()) break block0;
                            Table table = this.paimonCatalog().getTable(identifier);
                            ReadBuilder builder = table.newReadBuilder().withProjection((int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}), ClassTag$.MODULE$.Int()));
                            java.util.List splits = builder.newScan().plan().splits();
                            builder.newRead().createReader(splits).forEachRemaining(r -> {
                                Assertions.assertEquals((Object)Timestamp.valueOf("2023-12-31 16:00:00"), (Object)r.getTimestamp(0, 6).toSQLTimestamp());
                                Assertions.assertEquals((Object)Timestamp.valueOf("2024-01-01 00:00:00").toLocalDateTime(), (Object)r.getTimestamp(1, 6).toLocalDateTime());
                            });
                        }
                    });
                });
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                this.paimonCatalog().dropTable(identifier, true);
            }
            return boxedUnit;
        }, new Position("DDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 348));
        this.test("Paimon DDL: select table with timestamp and timestamp_ntz with filter", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)datetimeJava8APIEnabled -> {
            this.withSparkSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.datetime.java8API.enabled"), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)datetimeJava8APIEnabled)))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"paimon_tbl"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                if ($this.gteqSpark3_4()) {
                    $this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE paimon_tbl (ts timestamp, ts_ntz timestamp_ntz)\n                     |USING paimon\n                     |")).stripMargin());
                    $this.sql().apply((Object)"INSERT INTO paimon_tbl VALUES (timestamp'2024-01-01 00:00:00', timestamp_ntz'2024-01-01 00:00:00')");
                    $this.sql().apply((Object)"INSERT INTO paimon_tbl VALUES (timestamp'2024-01-02 00:00:00', timestamp_ntz'2024-01-02 00:00:00')");
                    $this.sql().apply((Object)"INSERT INTO paimon_tbl VALUES (timestamp'2024-01-03 00:00:00', timestamp_ntz'2024-01-03 00:00:00')");
                    $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT * FROM paimon_tbl where ts_ntz = timestamp_ntz'2024-01-01 00:00:00'"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{datetimeJava8APIEnabled ? Timestamp.valueOf("2024-01-01 00:00:00").toInstant() : Timestamp.valueOf("2024-01-01 00:00:00"), LocalDateTime.parse("2024-01-01T00:00:00")})));
                    $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT * FROM paimon_tbl where ts > timestamp'2024-01-02 00:00:00'"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{datetimeJava8APIEnabled ? Timestamp.valueOf("2024-01-03 00:00:00").toInstant() : Timestamp.valueOf("2024-01-03 00:00:00"), LocalDateTime.parse("2024-01-03T00:00:00")})));
                } else {
                    $this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE paimon_tbl (ts timestamp)\n                     |USING paimon\n                     |")).stripMargin());
                    $this.sql().apply((Object)"INSERT INTO paimon_tbl VALUES (timestamp'2024-01-01 00:00:00')");
                    $this.sql().apply((Object)"INSERT INTO paimon_tbl VALUES (timestamp'2024-01-02 00:00:00')");
                    $this.sql().apply((Object)"INSERT INTO paimon_tbl VALUES (timestamp'2024-01-03 00:00:00')");
                    $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT * FROM paimon_tbl where ts = timestamp'2024-01-01 00:00:00'"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{datetimeJava8APIEnabled ? Timestamp.valueOf("2024-01-01 00:00:00").toInstant() : Timestamp.valueOf("2024-01-01 00:00:00")})));
                }
            }));
            return BoxedUnit.UNIT;
        }), new Position("DDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 431));
        this.test("Paimon DDL: create table with unsupported partitioned by", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String error;
            String $org_scalatest_assert_macro_left = error = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n             |CREATE TABLE T (id STRING, name STRING, pt STRING)\n             |PARTITIONED BY (substr(pt, 1, 2))\n             |")).stripMargin()), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("DDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 492))).getMessage();
            String $org_scalatest_assert_macro_right = "Unsupported partition transform";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 498));
        }, new Position("DDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 491));
        this.test("Fix partition column generate wrong partition spec", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)legacyPartName -> {
            DDLTestBase.$anonfun$new$72(this, BoxesRunTime.unboxToBoolean((Object)legacyPartName));
            return BoxedUnit.UNIT;
        }), new Position("DDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 501));
        this.test("Paimon DDL: create and drop external / managed table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tbLocation -> {
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"external_tbl", "managed_tbl"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String error;
                String $org_scalatest_assert_macro_left = error = ((Throwable)$this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(59).append("CREATE TABLE external_tbl (id INT) USING paimon LOCATION '").append(tbLocation.getCanonicalPath()).append("'").toString()), ClassTag$.MODULE$.apply(UnsupportedOperationException.class), new Position("DDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 557))).getMessage();
                String $org_scalatest_assert_macro_right = "not support";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 561));
                $this.sql().apply((Object)"CREATE TABLE managed_tbl (id INT) USING paimon");
                FileStoreTable table = $this.loadTable("managed_tbl");
                FileIO fileIO = table.fileIO();
                Path tableLocation = table.location();
                $this.sql().apply((Object)"DROP TABLE managed_tbl");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(fileIO.exists(tableLocation), "fileIO.exists(tableLocation)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 571));
            });
            return BoxedUnit.UNIT;
        }), new Position("DDLTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 552));
    }
}

