/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.sql;

import java.io.File;
import java.io.Serializable;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.hive.HiveMetastoreClient;
import org.apache.paimon.spark.PaimonHiveTestBase;
import org.apache.paimon.table.FileStoreTable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.junit.jupiter.api.Assertions;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001!3Q!\u0003\u0006\u0002\u0002UAQA\u0007\u0001\u0005\u0002mAQA\b\u0001\u0005\u0002}AQ!\r\u0001\u0005\u0002IBQ\u0001\u000e\u0001\u0005\u0002UBQa\u000e\u0001\u0005\u0002aBQA\u000f\u0001\u0005\u0002mBQ\u0001\u0011\u0001\u0005\u0002\u0005CQ\u0001\u0012\u0001\u0005\u0002\u0015\u0013!\u0004\u0012#M/&$\b\u000eS5wK\u000e\u000bG/\u00197pOR+7\u000f\u001e\"bg\u0016T!a\u0003\u0007\u0002\u0007M\fHN\u0003\u0002\u000e\u001d\u0005)1\u000f]1sW*\u0011q\u0002E\u0001\u0007a\u0006LWn\u001c8\u000b\u0005E\u0011\u0012AB1qC\u000eDWMC\u0001\u0014\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0003\u0005\u0002\u001815\tA\"\u0003\u0002\u001a\u0019\t\u0011\u0002+Y5n_:D\u0015N^3UKN$()Y:f\u0003\u0019a\u0014N\\5u}Q\tA\u0004\u0005\u0002\u001e\u00015\t!\"A\bhKR$\u0015\r^1cCN,\u0007K]8q)\r\u0001Sf\f\t\u0003C)r!A\t\u0015\u0011\u0005\r2S\"\u0001\u0013\u000b\u0005\u0015\"\u0012A\u0002\u001fs_>$hHC\u0001(\u0003\u0015\u00198-\u00197b\u0013\tIc%\u0001\u0004Qe\u0016$WMZ\u0005\u0003W1\u0012aa\u0015;sS:<'BA\u0015'\u0011\u0015q#\u00011\u0001!\u0003\u0019!'MT1nK\")\u0001G\u0001a\u0001A\u0005a\u0001O]8qKJ$\u0018PT1nK\u0006\u0019r-\u001a;ECR\f'-Y:f\u0019>\u001c\u0017\r^5p]R\u0011\u0001e\r\u0005\u0006]\r\u0001\r\u0001I\u0001\u0013O\u0016$H)\u0019;bE\u0006\u001cXmQ8n[\u0016tG\u000f\u0006\u0002!m!)a\u0006\u0002a\u0001A\u0005\u0001r-\u001a;ECR\f'-Y:f\u001f^tWM\u001d\u000b\u0003AeBQAL\u0003A\u0002\u0001\n\u0001cZ3u\t\u0006$\u0018MY1tKB\u0013x\u000e]:\u0015\u0005qz\u0004\u0003B\u0011>A\u0001J!A\u0010\u0017\u0003\u00075\u000b\u0007\u000fC\u0003/\r\u0001\u0007\u0001%\u0001\thKR$\u0016M\u00197f\u0019>\u001c\u0017\r^5p]R\u0011\u0001E\u0011\u0005\u0006\u0007\u001e\u0001\r\u0001I\u0001\bi\ndg*Y7f\u0003Y9W\r^!diV\fG\u000eV1cY\u0016dunY1uS>tGc\u0001\u0011G\u000f\")a\u0006\u0003a\u0001A!)1\t\u0003a\u0001A\u0001")
public abstract class DDLWithHiveCatalogTestBase
extends PaimonHiveTestBase {
    public String getDatabaseProp(String dbName, String propertyName) {
        return (String)((Row)this.spark().sql(new StringBuilder(23).append("DESC DATABASE EXTENDED ").append(dbName).toString()).filter(new StringBuilder(15).append("info_name == '").append(propertyName).append("'").toString()).head()).getAs("info_value");
    }

    public String getDatabaseLocation(String dbName) {
        return this.getDatabaseProp(dbName, "Location").split(":")[1];
    }

    public String getDatabaseComment(String dbName) {
        return this.getDatabaseProp(dbName, "Comment");
    }

    public String getDatabaseOwner(String dbName) {
        return this.getDatabaseProp(dbName, "Owner");
    }

    public Map<String, String> getDatabaseProps(String dbName) {
        String dbPropsStr = this.getDatabaseProp(dbName, "Properties");
        Regex pattern = new StringOps(Predef$.MODULE$.augmentString("\\(([^,]+),([^)]+)\\)")).r();
        return pattern.findAllIn((CharSequence)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(dbPropsStr)).drop(1))).dropRight(1)).matchData().map((Function1 & Serializable & scala.Serializable)m -> {
            String key = m.group(1).trim();
            String value = m.group(2).trim();
            return new Tuple2((Object)key, (Object)value);
        }).toMap(Predef$.MODULE$.$conforms());
    }

    public String getTableLocation(String tblName) {
        String tablePropsStr = (String)((Row)this.spark().sql(new StringBuilder(20).append("DESC TABLE EXTENDED ").append(tblName).toString()).filter("col_name == 'Table Properties'").head()).getAs("data_type");
        Map tableProps = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tablePropsStr.substring(1, tablePropsStr.length() - 1).split(","))).map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.split("="), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String[] stringArray = x0$1;
            Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
            if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) != 0) {
                throw new MatchError((Object)stringArray);
            }
            String key = (String)((SeqLike)option.get()).apply(0);
            String value = (String)((SeqLike)option.get()).apply(1);
            Tuple2 tuple2 = new Tuple2((Object)key, (Object)value);
            return tuple2;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        return ((String)tableProps.apply((Object)"path")).split(":")[1];
    }

    public String getActualTableLocation(String dbName, String tblName) {
        return new StringOps(Predef$.MODULE$.augmentString(this.loadTable(dbName, tblName).location().toString())).split(':')[1];
    }

    public static final /* synthetic */ void $anonfun$new$2(DDLWithHiveCatalogTestBase $this, String catalogName) {
        $this.spark().sql(new StringBuilder(4).append("USE ").append(catalogName).toString());
        $this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dBLocation -> {
            $this.withDatabase((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"paimon_db"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String comment = "this is a test comment";
                $this.spark().sql(new StringBuilder(48).append("CREATE DATABASE paimon_db LOCATION '").append(dBLocation.getCanonicalPath()).append("' COMMENT '").append(comment).append("'").toString());
                Assertions.assertEquals((Object)$this.getDatabaseLocation("paimon_db"), (Object)dBLocation.getCanonicalPath());
                Assertions.assertEquals((Object)$this.getDatabaseComment("paimon_db"), (Object)comment);
                $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"paimon_db.paimon_tbl"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                             |CREATE TABLE paimon_db.paimon_tbl (id STRING, name STRING, pt STRING)\n                             |USING PAIMON\n                             |TBLPROPERTIES ('primary-key' = 'id')\n                             |")).stripMargin());
                    Assertions.assertEquals((Object)$this.getTableLocation("paimon_db.paimon_tbl"), (Object)new StringBuilder(11).append(dBLocation.getCanonicalPath()).append("/paimon_tbl").toString());
                    FileStoreTable fileStoreTable = (FileStoreTable)$this.getPaimonScan("SELECT * FROM paimon_db.paimon_tbl").table();
                    Assertions.assertEquals((Object)"paimon_tbl", (Object)fileStoreTable.name());
                    Assertions.assertEquals((Object)"paimon_db.paimon_tbl", (Object)fileStoreTable.fullName());
                });
            });
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$7(DDLWithHiveCatalogTestBase $this, String catalogName) {
        $this.spark().sql(new StringBuilder(4).append("USE ").append(catalogName).toString());
        $this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dBLocation -> {
            $this.withDatabase((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"paimon_db"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String comment = "this is a test comment";
                $this.spark().sql(new StringBuilder(48).append("CREATE DATABASE paimon_db LOCATION '").append(dBLocation.getCanonicalPath()).append("' COMMENT '").append(comment).append("'").toString());
                Assertions.assertEquals((Object)$this.getDatabaseLocation("paimon_db"), (Object)dBLocation.getCanonicalPath());
                Assertions.assertEquals((Object)$this.getDatabaseComment("paimon_db"), (Object)comment);
                $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"paimon_db.paimon_tbl"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                             |CREATE TABLE paimon_db.paimon_tbl (id STRING, name STRING, pt STRING)\n                             |USING PAIMON\n                             |PARTITIONED BY (name, pt)\n                             |TBLPROPERTIES('metastore.partitioned-table' = 'true')\n                             |")).stripMargin());
                    Assertions.assertEquals((Object)$this.getTableLocation("paimon_db.paimon_tbl"), (Object)new StringBuilder(11).append(dBLocation.getCanonicalPath()).append("/paimon_tbl").toString());
                    $this.spark().sql("insert into paimon_db.paimon_tbl select '1', 'n', 'cc'");
                    $this.spark().sql("insert into paimon_db.paimon_tbl select '1', 'n1', 'aa'");
                    $this.spark().sql("insert into paimon_db.paimon_tbl select '1', 'n2', 'bb'");
                    $this.spark().sql("show partitions paimon_db.paimon_tbl");
                    Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"name=n/pt=cc"}));
                    Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"name=n1/pt=aa"}));
                    Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"name=n2/pt=bb"}));
                    $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql("show partitions paimon_db.paimon_tbl"), (Seq)Nil$.MODULE$.$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row));
                    $this.spark().sql("alter table paimon_db.paimon_tbl drop partition (name='n1', `pt`='aa'), partition (name='n2', `pt`='bb')");
                    $this.spark().sql("show partitions paimon_db.paimon_tbl");
                    Row row4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"name=n/pt=cc"}));
                    $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql("show partitions paimon_db.paimon_tbl"), (Seq)Nil$.MODULE$.$colon$colon((Object)row4));
                });
                $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"paimon_db.paimon_tbl2"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                             |CREATE TABLE paimon_db.paimon_tbl2 (id STRING, name STRING, pt STRING)\n                             |USING PAIMON\n                             |PARTITIONED BY (name, pt)\n                             |TBLPROPERTIES('metastore.partitioned-table' = 'false')\n                             |")).stripMargin());
                    Assertions.assertEquals((Object)$this.getTableLocation("paimon_db.paimon_tbl2"), (Object)new StringBuilder(12).append(dBLocation.getCanonicalPath()).append("/paimon_tbl2").toString());
                    $this.spark().sql("insert into paimon_db.paimon_tbl2 select '1', 'n', 'cc'");
                    $this.spark().sql("insert into paimon_db.paimon_tbl2 select '1', 'n1', 'aa'");
                    $this.spark().sql("insert into paimon_db.paimon_tbl2 select '1', 'n2', 'bb'");
                    $this.spark().sql("show partitions paimon_db.paimon_tbl2");
                    Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"name=n/pt=cc"}));
                    Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"name=n1/pt=aa"}));
                    Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"name=n2/pt=bb"}));
                    $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql("show partitions paimon_db.paimon_tbl2"), (Seq)Nil$.MODULE$.$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row));
                    $this.spark().sql("alter table paimon_db.paimon_tbl2 drop partition (name='n1', `pt`='aa'), partition (name='n2', `pt`='bb')");
                    $this.spark().sql("show partitions paimon_db.paimon_tbl2");
                    Row row4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"name=n/pt=cc"}));
                    $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql("show partitions paimon_db.paimon_tbl2"), (Seq)Nil$.MODULE$.$colon$colon((Object)row4));
                });
            });
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$17(DDLWithHiveCatalogTestBase $this, String catalogName) {
        $this.spark().sql(new StringBuilder(4).append("USE ").append(catalogName).toString());
        $this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dBLocation -> {
            $this.withDatabase((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"paimon_db"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String comment = "this is a test comment";
                $this.spark().sql(new StringBuilder(48).append("CREATE DATABASE paimon_db LOCATION '").append(dBLocation.getCanonicalPath()).append("' COMMENT '").append(comment).append("'").toString());
                Assertions.assertEquals((Object)$this.getDatabaseLocation("paimon_db"), (Object)dBLocation.getCanonicalPath());
                Assertions.assertEquals((Object)$this.getDatabaseComment("paimon_db"), (Object)comment);
                $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"paimon_db.paimon_tbl"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                             |CREATE TABLE paimon_db.paimon_tbl (id STRING, name STRING, pt STRING)\n                             |USING PAIMON\n                             |PARTITIONED BY (name, pt)\n                             |TBLPROPERTIES('metastore.partitioned-table' = 'true')\n                             |")).stripMargin());
                    Assertions.assertEquals((Object)$this.getTableLocation("paimon_db.paimon_tbl"), (Object)new StringBuilder(11).append(dBLocation.getCanonicalPath()).append("/paimon_tbl").toString());
                    $this.spark().sql("insert into paimon_db.paimon_tbl select '1', 'n', 'cc'");
                    $this.spark().sql("alter table paimon_db.paimon_tbl add partition(name='cc', `pt`='aa') ");
                });
                $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"paimon_db.paimon_tbl2"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                             |CREATE TABLE paimon_db.paimon_tbl2 (id STRING, name STRING, pt STRING)\n                             |USING PAIMON\n                             |PARTITIONED BY (name, pt)\n                             |TBLPROPERTIES('metastore.partitioned-table' = 'false')\n                             |")).stripMargin());
                    Assertions.assertEquals((Object)$this.getTableLocation("paimon_db.paimon_tbl2"), (Object)new StringBuilder(12).append(dBLocation.getCanonicalPath()).append("/paimon_tbl2").toString());
                    $this.spark().sql("insert into paimon_db.paimon_tbl2 select '1', 'n', 'cc'");
                    $this.spark().sql("alter table paimon_db.paimon_tbl2 add partition(name='cc', `pt`='aa') ");
                });
            });
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$23(DDLWithHiveCatalogTestBase $this, String catalogName) {
        $this.spark().sql(new StringBuilder(4).append("USE ").append(catalogName).toString());
        $this.withDatabase((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"paimon_db"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.spark().sql("CREATE DATABASE paimon_db WITH DBPROPERTIES ('k1' = 'v1', 'k2' = 'v2')");
            Map<String, String> props = $this.getDatabaseProps("paimon_db");
            Assertions.assertEquals((Object)props.apply((Object)"k1"), (Object)"v1");
            Assertions.assertEquals((Object)props.apply((Object)"k2"), (Object)"v2");
            Assertions.assertTrue((boolean)new StringOps(Predef$.MODULE$.augmentString($this.getDatabaseOwner("paimon_db"))).nonEmpty());
        });
    }

    public static final /* synthetic */ void $anonfun$new$26(DDLWithHiveCatalogTestBase $this, String catalogName) {
        $this.spark().sql(new StringBuilder(4).append("USE ").append(catalogName).toString());
        String databaseName = "paimon_db";
        $this.withDatabase((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{databaseName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.spark().sql(new StringBuilder(61).append("CREATE DATABASE ").append(databaseName).append(" WITH DBPROPERTIES ('k1' = 'v1', 'k2' = 'v2')").toString());
            Map<String, String> props = $this.getDatabaseProps(databaseName);
            Assertions.assertEquals((Object)props.apply((Object)"k1"), (Object)"v1");
            Assertions.assertEquals((Object)props.apply((Object)"k2"), (Object)"v2");
            $this.spark().sql(new StringBuilder(61).append("ALTER DATABASE ").append(databaseName).append(" SET DBPROPERTIES ('k1' = 'v11', 'k2' = 'v22')").toString());
            props = $this.getDatabaseProps(databaseName);
            Assertions.assertEquals((Object)props.apply((Object)"k1"), (Object)"v11");
            Assertions.assertEquals((Object)props.apply((Object)"k2"), (Object)"v22");
        });
    }

    public static final /* synthetic */ void $anonfun$new$31(DDLWithHiveCatalogTestBase $this, String databaseName$2, File dBLocation) {
        try {
            $this.spark().sql(new StringBuilder(31).append("ALTER DATABASE ").append(databaseName$2).append(" SET LOCATION '").append(dBLocation.getCanonicalPath()).append("'").toString());
        }
        catch (AnalysisException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("does not support altering database location"));
        }
    }

    public static final /* synthetic */ void $anonfun$new$29(DDLWithHiveCatalogTestBase $this, String catalogName) {
        $this.spark().sql(new StringBuilder(4).append("USE ").append(catalogName).toString());
        String databaseName = "paimon_db";
        $this.withDatabase((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{databaseName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.spark().sql(new StringBuilder(61).append("CREATE DATABASE ").append(databaseName).append(" WITH DBPROPERTIES ('k1' = 'v1', 'k2' = 'v2')").toString());
            $this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dBLocation -> {
                DDLWithHiveCatalogTestBase.$anonfun$new$31($this, databaseName, dBLocation);
                return BoxedUnit.UNIT;
            });
        });
    }

    public static final /* synthetic */ boolean $anonfun$new$43(Object[] eta$0$1$1, Object elem) {
        return new ArrayOps.ofRef(eta$0$1$1).contains(elem);
    }

    private static final boolean containsDir$1(Path root, String[] targets, FileIO fileIO$1) {
        Object[] objectArray = Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileIO$1.listDirectories(root))).map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.getPath().getName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])targets)).forall((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)DDLWithHiveCatalogTestBase.$anonfun$new$43(objectArray, elem)));
    }

    public static final /* synthetic */ void $anonfun$new$40(DDLWithHiveCatalogTestBase $this, String catalogName$1, String dataFilePathDir) {
        String dbName = "default";
        String tblName = "t";
        $this.spark().sql(new StringBuilder(5).append("USE ").append(catalogName$1).append(".").append(dbName).toString());
        $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tblName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(347).append("\n                           |CREATE TABLE ").append(tblName).append(" (id INT, pt INT)\n                           |USING PAIMON\n                           |TBLPROPERTIES (\n                           |").append((Object)(dataFilePathDir.isEmpty() ? "" : new StringBuilder(32).append("'data-file.path-directory' = '").append(dataFilePathDir).append("',").toString())).append("\n                           |'metastore.partitioned-table' = 'true'\n                           |)\n                           |PARTITIONED BY (pt)\n                           |").toString())).stripMargin());
            FileStoreTable table = $this.loadTable(dbName, tblName);
            IMetaStoreClient metastoreClient = ((HiveMetastoreClient)table.catalogEnvironment().metastoreClientFactory().create()).client();
            FileIO fileIO = table.fileIO();
            $this.spark().sql(new StringBuilder(42).append("INSERT INTO ").append(tblName).append(" VALUES (1, 1), (2, 2), (3, 3)").toString());
            $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql(new StringBuilder(16).append("show partitions ").append(tblName).toString()), (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"pt=1"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"pt=2"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"pt=3"})), (List)Nil$.MODULE$))));
            java.util.List $org_scalatest_assert_macro_left = metastoreClient.listPartitions(dbName, tblName, (short)100);
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DDLWithHiveCatalogTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336));
            if (dataFilePathDir.isEmpty()) {
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(DDLWithHiveCatalogTestBase.containsDir$1(table.location(), (String[])((Object[])new String[]{"pt=1", "pt=2", "pt=3"}), fileIO), "containsDir(table.location(), scala.Array.apply[String](\"pt=1\", \"pt=2\", \"pt=3\")((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String])))", Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DDLWithHiveCatalogTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 339));
            } else {
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(DDLWithHiveCatalogTestBase.containsDir$1(table.location(), (String[])((Object[])new String[]{"pt=1", "pt=2", "pt=3"}), fileIO), "containsDir(table.location(), scala.Array.apply[String](\"pt=1\", \"pt=2\", \"pt=3\")((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String])))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DDLWithHiveCatalogTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 341));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(DDLWithHiveCatalogTestBase.containsDir$1(new Path(table.location(), "data"), (String[])((Object[])new String[]{"pt=1", "pt=2", "pt=3"}), fileIO), "containsDir(new org.apache.paimon.fs.Path(table.location(), \"data\"), scala.Array.apply[String](\"pt=1\", \"pt=2\", \"pt=3\")((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String])))", Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DDLWithHiveCatalogTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 342));
            }
            $this.spark().sql(new StringBuilder(34).append("INSERT INTO ").append(tblName).append(" VALUES (4, 3), (5, 4)").toString());
            $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql(new StringBuilder(16).append("show partitions ").append(tblName).toString()), (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"pt=1"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"pt=2"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"pt=3"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"pt=4"})), (List)Nil$.MODULE$)))));
            java.util.List $org_scalatest_assert_macro_left2 = metastoreClient.listPartitions(dbName, tblName, (short)100);
            int $org_scalatest_assert_macro_right2 = 4;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DDLWithHiveCatalogTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 350));
            $this.spark().sql(new StringBuilder(34).append("ALTER TABLE ").append(tblName).append(" DROP PARTITION (pt=1)").toString());
            $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql(new StringBuilder(16).append("show partitions ").append(tblName).toString()), (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"pt=2"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"pt=3"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"pt=4"})), (List)Nil$.MODULE$))));
            java.util.List $org_scalatest_assert_macro_left3 = metastoreClient.listPartitions(dbName, tblName, (short)100);
            int $org_scalatest_assert_macro_right3 = 3;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DDLWithHiveCatalogTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 356));
        });
    }

    public static final /* synthetic */ void $anonfun$new$39(DDLWithHiveCatalogTestBase $this, String catalogName) {
        ((IterableLike)new .colon.colon((Object)"", (List)new .colon.colon((Object)"data", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)dataFilePathDir -> {
            DDLWithHiveCatalogTestBase.$anonfun$new$40($this, catalogName, dataFilePathDir);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$48(DDLWithHiveCatalogTestBase $this, String catalogName) {
        $this.spark().sql(new StringBuilder(4).append("USE ").append(catalogName).toString());
        $this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tbLocation -> {
            $this.withDatabase((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"paimon_db"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.spark().sql("CREATE DATABASE IF NOT EXISTS paimon_db");
                $this.spark().sql("USE paimon_db");
                $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"external_tbl", "managed_tbl"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    String expertTbLocation = tbLocation.getCanonicalPath();
                    $this.spark().sql(new StringBuilder(59).append("CREATE TABLE external_tbl (id INT) USING paimon LOCATION '").append(expertTbLocation).append("'").toString());
                    $this.spark().sql("INSERT INTO external_tbl VALUES (1)");
                    $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql("SELECT * FROM external_tbl"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
                    FileStoreTable table = $this.loadTable("paimon_db", "external_tbl");
                    FileIO fileIO = table.fileIO();
                    Path actualTbLocation = table.location();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(new StringOps(Predef$.MODULE$.augmentString(actualTbLocation.toString())).split(':')[1].equals(expertTbLocation), "scala.Predef.augmentString(actualTbLocation.toString()).split(':').apply(1).equals(expertTbLocation)", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DDLWithHiveCatalogTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 381));
                    $this.spark().sql("DROP TABLE external_tbl");
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(fileIO.exists(actualTbLocation), "fileIO.exists(actualTbLocation)", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DDLWithHiveCatalogTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 385));
                    $this.spark().sql(new StringBuilder(59).append("CREATE TABLE external_tbl (id INT) USING paimon LOCATION '").append(expertTbLocation).append("'").toString());
                    $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql("SELECT * FROM external_tbl"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool($this.getActualTableLocation("paimon_db", "external_tbl").equals(expertTbLocation), "DDLWithHiveCatalogTestBase.this.getActualTableLocation(\"paimon_db\", \"external_tbl\").equals(expertTbLocation)", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DDLWithHiveCatalogTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 391));
                    $this.spark().sql("CREATE TABLE managed_tbl (id INT) USING paimon");
                    Path managedTbLocation = $this.loadTable("paimon_db", "managed_tbl").location();
                    $this.spark().sql("DROP TABLE managed_tbl");
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(fileIO.exists(managedTbLocation), "fileIO.exists(managedTbLocation)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DDLWithHiveCatalogTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 399));
                });
            });
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$55(DDLWithHiveCatalogTestBase $this, String catalogName) {
        $this.spark().sql(new StringBuilder(4).append("USE ").append(catalogName).toString());
        $this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tbLocation -> {
            $this.withDatabase((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"paimon_db"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.spark().sql("CREATE DATABASE paimon_db");
                $this.spark().sql("USE paimon_db");
                $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"external_tbl", "managed_tbl", "external_tbl_renamed", "managed_tbl_renamed"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    String expertTbLocation = tbLocation.getCanonicalPath();
                    $this.spark().sql(new StringBuilder(59).append("CREATE TABLE external_tbl (id INT) USING paimon LOCATION '").append(expertTbLocation).append("'").toString());
                    $this.spark().sql("INSERT INTO external_tbl VALUES (1)");
                    Path actualTbLocation = $this.loadTable("paimon_db", "external_tbl").location();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(new StringOps(Predef$.MODULE$.augmentString(actualTbLocation.toString())).split(':')[1].equals(expertTbLocation), "scala.Predef.augmentString(actualTbLocation.toString()).split(':').apply(1).equals(expertTbLocation)", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DDLWithHiveCatalogTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 426));
                    $this.spark().sql("ALTER TABLE external_tbl RENAME TO external_tbl_renamed");
                    $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql("SELECT * FROM external_tbl_renamed"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool($this.getActualTableLocation("paimon_db", "external_tbl_renamed").equals(expertTbLocation), "DDLWithHiveCatalogTestBase.this.getActualTableLocation(\"paimon_db\", \"external_tbl_renamed\").equals(expertTbLocation)", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DDLWithHiveCatalogTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 431));
                    $this.spark().sql("CREATE TABLE managed_tbl (id INT) USING paimon");
                    $this.spark().sql("INSERT INTO managed_tbl VALUES (1)");
                    Path managedTbLocation = $this.loadTable("paimon_db", "managed_tbl").location();
                    $this.spark().sql("ALTER TABLE managed_tbl RENAME TO managed_tbl_renamed");
                    $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql("SELECT * FROM managed_tbl_renamed"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.getActualTableLocation("paimon_db", "managed_tbl_renamed").equals(managedTbLocation.toString()), "DDLWithHiveCatalogTestBase.this.getActualTableLocation(\"paimon_db\", \"managed_tbl_renamed\").equals(managedTbLocation.toString())", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DDLWithHiveCatalogTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 443));
                });
            });
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$62(DDLWithHiveCatalogTestBase $this, String catalogName) {
        $this.spark().sql(new StringBuilder(4).append("USE ").append(catalogName).toString());
        $this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tbLocation -> {
            $this.withDatabase((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"paimon_db"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.spark().sql("CREATE DATABASE IF NOT EXISTS paimon_db");
                $this.spark().sql("USE paimon_db");
                $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "t2", "t3", "t4", "t5"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    String expertTbLocation = tbLocation.getCanonicalPath();
                    $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(278).append("\n                             |CREATE TABLE t1 (id INT, pt INT) USING paimon\n                             |PARTITIONED BY (pt)\n                             |TBLPROPERTIES('primary-key' = 'id', 'k1' = 'v1')\n                             |LOCATION '").append(expertTbLocation).append("'\n                             |").toString())).stripMargin());
                    $this.spark().sql("INSERT INTO t1 VALUES (1, 1)");
                    $this.spark().sql(new StringBuilder(40).append("CREATE TABLE t2 USING paimon LOCATION '").append(expertTbLocation).append("'").toString());
                    $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql("SELECT * FROM t2"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})));
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool($this.getActualTableLocation("paimon_db", "t2").equals(expertTbLocation), "DDLWithHiveCatalogTestBase.this.getActualTableLocation(\"paimon_db\", \"t2\").equals(expertTbLocation)", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DDLWithHiveCatalogTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 474));
                    $this.intercept((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql(new StringBuilder(55).append("CREATE TABLE t3 (fake_col INT) USING paimon LOCATION '").append(expertTbLocation).append("'").toString()), ClassTag$.MODULE$.apply(Exception.class), new Position("DDLWithHiveCatalogTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 477));
                    $this.spark().sql(new StringBuilder(68).append("CREATE TABLE t4 USING paimon TBLPROPERTIES ('k1' = 'v1') LOCATION '").append(expertTbLocation).append("'").toString());
                    $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql("SELECT * FROM t4"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})));
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool($this.getActualTableLocation("paimon_db", "t4").equals(expertTbLocation), "DDLWithHiveCatalogTestBase.this.getActualTableLocation(\"paimon_db\", \"t4\").equals(expertTbLocation)", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DDLWithHiveCatalogTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 486));
                    $this.intercept((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql(new StringBuilder(68).append("CREATE TABLE t5 USING paimon TBLPROPERTIES ('k2' = 'v2') LOCATION '").append(expertTbLocation).append("'").toString()), ClassTag$.MODULE$.apply(Exception.class), new Position("DDLWithHiveCatalogTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 489));
                });
            });
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$71(DDLWithHiveCatalogTestBase $this, String catalogName) {
        $this.spark().sql(new StringBuilder(4).append("USE ").append(catalogName).toString());
        $this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tbLocation -> {
            $this.withDatabase((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"paimon_db"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.spark().sql("CREATE DATABASE IF NOT EXISTS paimon_db");
                $this.spark().sql("USE paimon_db");
                $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "t2"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    String expertTbLocation = tbLocation.getCanonicalPath();
                    $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(160).append("\n                     |CREATE TABLE t1 (a INT, b INT, c STRUCT<f1: INT, f2: INT, f3: INT>) USING paimon\n                     |LOCATION '").append(expertTbLocation).append("'\n                     |").toString())).stripMargin());
                    $this.spark().sql("INSERT INTO t1 VALUES (1, 1, STRUCT(1, 1, 1))");
                    $this.spark().sql("ALTER TABLE t1 DROP COLUMN b");
                    $this.spark().sql("ALTER TABLE t1 ADD COLUMN b INT");
                    $this.spark().sql("ALTER TABLE t1 DROP COLUMN c.f2");
                    $this.spark().sql("ALTER TABLE t1 ADD COLUMN c.f2 INT");
                    $this.spark().sql("INSERT INTO t1 VALUES (2, STRUCT(1, 1, 1), 1)");
                    $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql("SELECT * FROM t1 ORDER by a"), (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), null})), null})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$)));
                    $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(160).append("\n                     |CREATE TABLE t2 (a INT, c STRUCT<f1: INT, f3: INT, f2: INT>, b INT) USING paimon\n                     |LOCATION '").append(expertTbLocation).append("'\n                     |").toString())).stripMargin());
                    $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql("SELECT * FROM t2 ORDER by a"), (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), null})), null})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$)));
                    $this.intercept((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(166).append("\n                       |CREATE TABLE t3 (a INT, b INT, c STRUCT<f1: INT, f3: INT, f2: INT>) USING paimon\n                       |LOCATION '").append(expertTbLocation).append("'\n                       |").toString())).stripMargin()), ClassTag$.MODULE$.apply(Exception.class), new Position("DDLWithHiveCatalogTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 535));
                    $this.intercept((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(166).append("\n                       |CREATE TABLE t4 (a INT, c STRUCT<f1: INT, f2: INT, f3: INT>, b INT) USING paimon\n                       |LOCATION '").append(expertTbLocation).append("'\n                       |").toString())).stripMargin()), ClassTag$.MODULE$.apply(Exception.class), new Position("DDLWithHiveCatalogTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 543));
                });
            });
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$80(DDLWithHiveCatalogTestBase $this, String catalogName) {
        $this.spark().sql(new StringBuilder(4).append("USE ").append(catalogName).toString());
        $this.withDatabase((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"paimon_db"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.spark().sql("CREATE DATABASE IF NOT EXISTS paimon_db");
            $this.spark().sql("USE paimon_db");
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"external_tbl", "managed_tbl"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.spark().sql("CREATE TABLE managed_tbl (id INT) USING paimon");
                $this.spark().sql("INSERT INTO managed_tbl VALUES (1)");
                $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql("SELECT * FROM managed_tbl"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
                String tablePath = $this.loadTable("paimon_db", "managed_tbl").location().toString();
                $this.spark().sql(new StringBuilder(59).append("CREATE TABLE external_tbl (id INT) USING paimon LOCATION '").append(tablePath).append("'").toString());
                $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql("SELECT * FROM external_tbl"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool($this.loadTable("paimon_db", "external_tbl").location().toString().equals(tablePath), "DDLWithHiveCatalogTestBase.this.loadTable(\"paimon_db\", \"external_tbl\").location().toString().equals(tablePath)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DDLWithHiveCatalogTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 571));
            });
        });
    }

    public static final /* synthetic */ void $anonfun$new$86(DDLWithHiveCatalogTestBase $this, String catalogName) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)caseSensitive -> {
            $this.withSparkSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.caseSensitive"), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)caseSensitive)))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.spark().sql(new StringBuilder(4).append("USE ").append(catalogName$2).toString());
                $this.withDatabase((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"paimon_case_sensitive_DB"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    $this.spark().sql("CREATE DATABASE paimon_case_sensitive_DB");
                    $this.intercept((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql("CREATE DATABASE paimon_case_sensitive_db"), ClassTag$.MODULE$.apply(Exception.class), new Position("DDLWithHiveCatalogTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 589));
                    $this.spark().sql("USE paimon_case_sensitive_DB");
                    $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tT", "tt"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        Object object;
                        $this.spark().sql("CREATE TABLE tT (aA INT) USING paimon");
                        $this.spark().sql("INSERT INTO tT VALUES 1");
                        $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql("SELECT aA FROM tT"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
                        if (caseSensitive) {
                            object = $this.intercept((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql("SELECT aa FROM tT"), ClassTag$.MODULE$.apply(Exception.class), new Position("DDLWithHiveCatalogTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 599));
                        } else {
                            $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql("SELECT aa FROM tT"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
                            object = BoxedUnit.UNIT;
                        }
                        $this.intercept((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql("ALTER TABLE tT RENAME TO tt"), ClassTag$.MODULE$.apply(Exception.class), new Position("DDLWithHiveCatalogTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 606));
                        if (caseSensitive) {
                            $this.spark().sql("ALTER TABLE tT RENAME COLUMN aA TO aa");
                            $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql("SELECT aa FROM tT"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
                            $this.intercept((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql("SELECT aA FROM tT"), ClassTag$.MODULE$.apply(Exception.class), new Position("DDLWithHiveCatalogTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 613));
                        } else {
                            $this.intercept((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql("ALTER TABLE tT RENAME COLUMN aA TO aa"), ClassTag$.MODULE$.apply(Exception.class), new Position("DDLWithHiveCatalogTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 615));
                        }
                    });
                });
            });
            return BoxedUnit.UNIT;
        });
    }

    public DDLWithHiveCatalogTestBase() {
        this.test("Paimon DDL with hive catalog: create database with location and comment", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)this.sparkCatalogName(), (List)new .colon.colon((Object)this.paimonHiveCatalogName(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)catalogName -> {
            DDLWithHiveCatalogTestBase.$anonfun$new$2(this, catalogName);
            return BoxedUnit.UNIT;
        }), new Position("DDLWithHiveCatalogTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 31));
        this.test("Paimon DDL with hive catalog: drop partition for paimon table sparkCatalogName", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)this.paimonHiveCatalogName(), (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)catalogName -> {
            DDLWithHiveCatalogTestBase.$anonfun$new$7(this, catalogName);
            return BoxedUnit.UNIT;
        }), new Position("DDLWithHiveCatalogTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        this.test("Paimon DDL with hive catalog: create partition for paimon table sparkCatalogName", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)this.paimonHiveCatalogName(), (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)catalogName -> {
            DDLWithHiveCatalogTestBase.$anonfun$new$17(this, catalogName);
            return BoxedUnit.UNIT;
        }), new Position("DDLWithHiveCatalogTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
        this.test("Paimon DDL with hive catalog: create database with props", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)this.sparkCatalogName(), (List)new .colon.colon((Object)this.paimonHiveCatalogName(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)catalogName -> {
            DDLWithHiveCatalogTestBase.$anonfun$new$23(this, catalogName);
            return BoxedUnit.UNIT;
        }), new Position("DDLWithHiveCatalogTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
        this.test("Paimon DDL with hive catalog: alter database's properties", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)this.sparkCatalogName(), (List)new .colon.colon((Object)this.paimonHiveCatalogName(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)catalogName -> {
            DDLWithHiveCatalogTestBase.$anonfun$new$26(this, catalogName);
            return BoxedUnit.UNIT;
        }), new Position("DDLWithHiveCatalogTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198));
        this.test("Paimon DDL with hive catalog: alter database location", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)this.sparkCatalogName(), (List)new .colon.colon((Object)this.paimonHiveCatalogName(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)catalogName -> {
            DDLWithHiveCatalogTestBase.$anonfun$new$29(this, catalogName);
            return BoxedUnit.UNIT;
        }), new Position("DDLWithHiveCatalogTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216));
        this.test("Paimon DDL with hive catalog: set default database", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ObjectRef reusedSpark = ObjectRef.create((Object)this.spark());
            ((IterableLike)new .colon.colon((Object)"paimon", (List)new .colon.colon((Object)this.sparkCatalogName(), (List)new .colon.colon((Object)this.paimonHiveCatalogName(), (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)catalogName -> {
                BoxedUnit boxedUnit;
                String dbName = new StringBuilder(11).append((String)catalogName).append("_default_db").toString();
                String tblName = new StringBuilder(4).append(dbName).append("_tbl").toString();
                ((SparkSession)reusedSpark$1.elem).sql(new StringBuilder(4).append("use ").append((String)catalogName).toString());
                ((SparkSession)reusedSpark$1.elem).sql(new StringBuilder(16).append("create database ").append(dbName).toString());
                ((SparkSession)reusedSpark$1.elem).sql(new StringBuilder(4).append("use ").append(dbName).toString());
                ((SparkSession)reusedSpark$1.elem).sql(new StringBuilder(59).append("create table ").append(tblName).append(" (id int, name string, dt string) using paimon").toString());
                ((SparkSession)reusedSpark$1.elem).stop();
                reusedSpark$1.elem = SparkSession$.MODULE$.builder().master("local[2]").config(this.sparkConf()).config("spark.sql.defaultCatalog", catalogName).config(new StringBuilder(34).append("spark.sql.catalog.").append((String)catalogName).append(".defaultDatabase").toString(), dbName).getOrCreate();
                if (catalogName.equals(this.sparkCatalogName()) && !this.gteqSpark3_4()) {
                    this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> ((SparkSession)reusedSpark$1.elem).sql("show tables").select("tableName", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])), (Seq)Nil$.MODULE$);
                    boxedUnit = ((SparkSession)reusedSpark$1.elem).sql(new StringBuilder(4).append("use ").append(dbName).toString());
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tblName}));
                this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> ((SparkSession)reusedSpark$1.elem).sql("show tables").select("tableName", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])), (Seq)Nil$.MODULE$.$colon$colon((Object)row));
                return ((SparkSession)reusedSpark$1.elem).sql(new StringBuilder(11).append("drop table ").append(tblName).toString());
            });
            ((SparkSession)reusedSpark.elem).stop();
            this.reset();
        }, new Position("DDLWithHiveCatalogTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
        this.test("Paimon DDL with hive catalog: drop database cascade which contains paimon table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            if (this.gteqSpark3_3()) {
                ((IterableLike)new .colon.colon((Object)this.sparkCatalogName(), (List)new .colon.colon((Object)this.paimonHiveCatalogName(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)catalogName -> {
                    BoxedUnit boxedUnit;
                    this.spark().sql(new StringBuilder(4).append("USE ").append((String)catalogName).toString());
                    this.spark().sql("CREATE DATABASE paimon_db");
                    this.spark().sql("USE paimon_db");
                    this.spark().sql("CREATE TABLE paimon_tbl (id int, name string, dt string) using paimon");
                    if (catalogName.equals(this.sparkCatalogName())) {
                        this.spark().sql("CREATE TABLE parquet_tbl (id int, name string, dt string) using parquet");
                        boxedUnit = this.spark().sql("CREATE VIEW parquet_tbl_view AS SELECT * FROM parquet_tbl");
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    this.spark().sql("CREATE VIEW paimon_tbl_view AS SELECT * FROM paimon_tbl");
                    this.spark().sql("USE default");
                    return this.spark().sql("DROP DATABASE paimon_db CASCADE");
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        }, new Position("DDLWithHiveCatalogTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
        this.test("Paimon DDL with hive catalog: sync partitions to HMS", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)this.sparkCatalogName(), (List)new .colon.colon((Object)this.paimonHiveCatalogName(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)catalogName -> {
            DDLWithHiveCatalogTestBase.$anonfun$new$39(this, catalogName);
            return BoxedUnit.UNIT;
        }), new Position("DDLWithHiveCatalogTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 297));
        this.test("Paimon DDL with hive catalog: create and drop external / managed table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)this.sparkCatalogName(), (List)new .colon.colon((Object)this.paimonHiveCatalogName(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)catalogName -> {
            DDLWithHiveCatalogTestBase.$anonfun$new$48(this, catalogName);
            return BoxedUnit.UNIT;
        }), new Position("DDLWithHiveCatalogTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 362));
        this.test("Paimon DDL with hive catalog: rename external / managed table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)this.sparkCatalogName(), (List)new .colon.colon((Object)this.paimonHiveCatalogName(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)catalogName -> {
            DDLWithHiveCatalogTestBase.$anonfun$new$55(this, catalogName);
            return BoxedUnit.UNIT;
        }), new Position("DDLWithHiveCatalogTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 406));
        this.test("Paimon DDL with hive catalog: create external table without schema", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)this.sparkCatalogName(), (List)new .colon.colon((Object)this.paimonHiveCatalogName(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)catalogName -> {
            DDLWithHiveCatalogTestBase.$anonfun$new$62(this, catalogName);
            return BoxedUnit.UNIT;
        }), new Position("DDLWithHiveCatalogTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 452));
        this.test("Paimon DDL with hive catalog: create external table with schema evolution", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)this.sparkCatalogName(), (List)new .colon.colon((Object)this.paimonHiveCatalogName(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)catalogName -> {
            DDLWithHiveCatalogTestBase.$anonfun$new$71(this, catalogName);
            return BoxedUnit.UNIT;
        }), new Position("DDLWithHiveCatalogTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 499));
        this.test("Paimon DDL with hive catalog: create external table on managed table location", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)this.sparkCatalogName(), (List)new .colon.colon((Object)this.paimonHiveCatalogName(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)catalogName -> {
            DDLWithHiveCatalogTestBase.$anonfun$new$80(this, catalogName);
            return BoxedUnit.UNIT;
        }), new Position("DDLWithHiveCatalogTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 556));
        this.test("Paimon DDL with hive catalog: case sensitive", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)this.sparkCatalogName(), (List)new .colon.colon((Object)this.paimonHiveCatalogName(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)catalogName -> {
            DDLWithHiveCatalogTestBase.$anonfun$new$86(this, catalogName);
            return BoxedUnit.UNIT;
        }), new Position("DDLWithHiveCatalogTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 577));
    }
}

