/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.sql;

import java.io.Serializable;
import org.apache.paimon.spark.PaimonHiveTestBase;
import org.apache.paimon.spark.catalog.functions.PaimonFunctions;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.connector.catalog.FunctionCatalog;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001]1AAA\u0002\u0001\u001d!)1\u0003\u0001C\u0001)\t\u0011\u0002+Y5n_:4UO\\2uS>tG+Z:u\u0015\t!Q!A\u0002tc2T!AB\u0004\u0002\u000bM\u0004\u0018M]6\u000b\u0005!I\u0011A\u00029bS6|gN\u0003\u0002\u000b\u0017\u00051\u0011\r]1dQ\u0016T\u0011\u0001D\u0001\u0004_J<7\u0001A\n\u0003\u0001=\u0001\"\u0001E\t\u000e\u0003\u0015I!AE\u0003\u0003%A\u000b\u0017.\\8o\u0011&4X\rV3ti\n\u000b7/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0001\"A\u0006\u0001\u000e\u0003\r\u0001")
public class PaimonFunctionTest
extends PaimonHiveTestBase {
    public static final /* synthetic */ boolean $anonfun$new$4(String name$1, Identifier x) {
        return x.name().equals(name$1);
    }

    public PaimonFunctionTest() {
        this.test("Paimon function: list and load functions", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"paimon", (List)new .colon.colon((Object)this.sparkCatalogName(), (List)new .colon.colon((Object)this.paimonHiveCatalogName(), (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)catalogName -> {
            this.sql().apply((Object)new StringBuilder(4).append("use ").append((String)catalogName).toString());
            FunctionCatalog functionCatalog = (FunctionCatalog)this.spark().sessionState().catalogManager().currentCatalog();
            Identifier[] identifiers = functionCatalog.listFunctions((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
            PaimonFunctions.names().forEach(name -> {
                Option identifier = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])identifiers)).find((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)PaimonFunctionTest.$anonfun$new$4(name, x)));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(identifier.isDefined(), "identifier.isDefined", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PaimonFunctionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
                UnboundFunction function = functionCatalog.loadFunction((Identifier)identifier.get());
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(function.name().equals(name), "function.name().equals(name)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PaimonFunctionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
            });
            return this.assertThrows((Function0 & Serializable & scala.Serializable)() -> functionCatalog.loadFunction(Identifier.of((String[])((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class))), (String)"fake_fun")), ClassTag$.MODULE$.apply(Throwable.class), new Position("PaimonFunctionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
        }), new Position("PaimonFunctionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 31));
        this.test("Paimon function: show functions", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"paimon", (List)new .colon.colon((Object)this.sparkCatalogName(), (List)new .colon.colon((Object)this.paimonHiveCatalogName(), (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)catalogName -> {
            this.sql().apply((Object)new StringBuilder(4).append("use ").append((String)catalogName).toString());
            int $org_scalatest_assert_macro_left = ((Row[])((Dataset)this.sql().apply((Object)"show functions")).collect()).length;
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PaimonFunctionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        }), new Position("PaimonFunctionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
        this.test("Paimon function: bucket join with SparkGenericCatalog", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)new StringBuilder(4).append("use ").append(this.sparkCatalogName()).toString());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.gteqSpark3_3(), "PaimonFunctionTest.this.gteqSpark3_3", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PaimonFunctionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "t2"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)"CREATE TABLE t1 (id INT, c STRING) using paimon TBLPROPERTIES ('primary-key' = 'id', 'bucket'='10')");
                this.sql().apply((Object)"INSERT INTO t1 VALUES (1, 'x1'), (2, 'x3'), (3, 'x3'), (4, 'x4'), (5, 'x5')");
                this.sql().apply((Object)"CREATE TABLE t2 (id INT, c STRING) using paimon TBLPROPERTIES ('primary-key' = 'id', 'bucket'='10')");
                this.sql().apply((Object)"INSERT INTO t2 VALUES (1, 'x1'), (2, 'x3'), (3, 'x3'), (4, 'x4'), (5, 'x5')");
                this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM t1 JOIN t2 on t1.id = t2.id order by t1.id"), (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "x1", BoxesRunTime.boxToInteger((int)1), "x1"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "x3", BoxesRunTime.boxToInteger((int)2), "x3"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "x3", BoxesRunTime.boxToInteger((int)3), "x3"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "x4", BoxesRunTime.boxToInteger((int)4), "x4"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "x5", BoxesRunTime.boxToInteger((int)5), "x5"})), (List)Nil$.MODULE$))))));
            });
        }, new Position("PaimonFunctionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        this.test("Paimon function: show and load function with SparkGenericCatalog", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)new StringBuilder(4).append("USE ").append(this.sparkCatalogName()).toString());
            this.sql().apply((Object)new StringBuilder(4).append("USE ").append(this.hiveDbName()).toString());
            this.sql().apply((Object)"CREATE FUNCTION myIntSum AS 'org.apache.paimon.spark.sql.MyIntSum'");
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(36).append("SHOW FUNCTIONS FROM ").append(this.hiveDbName()).append(" LIKE 'myIntSum'").toString()), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"spark_catalog.test_hive.myintsum"})));
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)"CREATE TABLE t (id INT)");
                this.sql().apply((Object)"INSERT INTO t VALUES (1), (2), (3)");
                this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT myIntSum(id) FROM t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6)})));
            });
            this.sql().apply((Object)"DROP FUNCTION myIntSum");
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(36).append("SHOW FUNCTIONS FROM ").append(this.hiveDbName()).append(" LIKE 'myIntSum'").toString()), (Seq)Nil$.MODULE$);
        }, new Position("PaimonFunctionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
    }
}

