/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.sql;

import java.io.Serializable;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.spark.PaimonSparkTestBase;
import org.apache.paimon.spark.sql.PaimonOptionTest$;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.FileStoreTableFactory;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.junit.jupiter.api.Assertions;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001]1AAA\u0002\u0001\u001d!)1\u0003\u0001C\u0001)\t\u0001\u0002+Y5n_:|\u0005\u000f^5p]R+7\u000f\u001e\u0006\u0003\t\u0015\t1a]9m\u0015\t1q!A\u0003ta\u0006\u00148N\u0003\u0002\t\u0013\u00051\u0001/Y5n_:T!AC\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0011aA8sO\u000e\u00011C\u0001\u0001\u0010!\t\u0001\u0012#D\u0001\u0006\u0013\t\u0011RAA\nQC&lwN\\*qCJ\\G+Z:u\u0005\u0006\u001cX-\u0001\u0004=S:LGO\u0010\u000b\u0002+A\u0011a\u0003A\u0007\u0002\u0007\u0001")
public class PaimonOptionTest
extends PaimonSparkTestBase {
    public PaimonOptionTest() {
        this.test("Paimon Option: create table with sql conf", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSparkSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.paimon.scan.snapshot-id"), (Object)"2")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE T (id INT)");
            FileStoreTable table = this.loadTable("T");
            FileStoreTable fileStoreTable = FileStoreTableFactory.create((FileIO)table.fileIO(), (Path)table.location());
            Assertions.assertNull(fileStoreTable.options().get("scan.snapshot-id"));
        }), new Position("PaimonOptionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 31));
        this.test("Paimon Option: create table by dataframe with sql conf", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSparkSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.paimon.scan.snapshot-id"), (Object)"2")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(PaimonOptionTest.class.getClassLoader());
            public final class Org_apache_paimon_spark_sql_PaimonOptionTest$$typecreator6$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_paimon_spark_sql_PaimonOptionTest$$typecreator6$1(PaimonOptionTest $outer) {
                }
            }
            this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)"x1"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"x2"), (List)Nil$.MODULE$)), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_paimon_spark_sql_PaimonOptionTest$$typecreator6$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})).write().format("paimon").mode("append").saveAsTable("T");
            FileStoreTable table = this.loadTable("T");
            FileStoreTable fileStoreTable = FileStoreTableFactory.create((FileIO)table.fileIO(), (Path)table.location());
            Assertions.assertNull(fileStoreTable.options().get("scan.snapshot-id"));
        }), new Position("PaimonOptionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
        this.test("Paimon Option: query table with sql conf", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE T (id INT)");
            this.sql().apply((Object)"INSERT INTO T VALUES 1");
            this.sql().apply((Object)"INSERT INTO T VALUES 2");
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM T ORDER BY id"), (Seq)Nil$.MODULE$.$colon$colon((Object)row2).$colon$colon((Object)row));
            FileStoreTable table = this.loadTable("T");
            this.withSparkSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.paimon.scan.snapshot-id"), (Object)"1")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM T ORDER BY id"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
                this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().read().format("paimon").load(table.location().toString()), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
            });
            this.withSparkSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.paimon.bucket"), (Object)"1")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.assertThrows((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM T ORDER BY id"), ClassTag$.MODULE$.apply(UnsupportedOperationException.class), new Position("PaimonOptionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
                this.assertThrows((Function0 & Serializable & scala.Serializable)() -> this.spark().read().format("paimon").load(table.location().toString()), ClassTag$.MODULE$.apply(UnsupportedOperationException.class), new Position("PaimonOptionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
            });
        }, new Position("PaimonOptionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
        this.test("Paimon Table Options: query one table with sql conf and table options", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE T (id INT)");
            this.sql().apply((Object)"INSERT INTO T VALUES 1");
            this.sql().apply((Object)"INSERT INTO T VALUES 2");
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM T ORDER BY id"), (Seq)Nil$.MODULE$.$colon$colon((Object)row2).$colon$colon((Object)row));
            FileStoreTable table = this.loadTable("T");
            this.withSparkSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.paimon.scan.snapshot-id"), (Object)"1")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM T ORDER BY id"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
                this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().read().format("paimon").load(table.location().toString()), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
            });
            this.withSparkSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.paimon.*.*.T.scan.snapshot-id"), (Object)"1")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM T ORDER BY id"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
                this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().read().format("paimon").load(table.location().toString()), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
            });
            this.withSparkSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.paimon.scan.snapshot-id"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.paimon.*.*.T.scan.snapshot-id"), (Object)"2")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}));
                Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)}));
                this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM T ORDER BY id"), (Seq)Nil$.MODULE$.$colon$colon((Object)row2).$colon$colon((Object)row));
                Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}));
                Row row4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)}));
                this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().read().format("paimon").load(table.location().toString()), (Seq)Nil$.MODULE$.$colon$colon((Object)row4).$colon$colon((Object)row3));
            });
        }, new Position("PaimonOptionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
        this.test("Paimon Table Options: query multiple tables with sql conf and table options", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE T1 (id INT)");
            this.sql().apply((Object)"INSERT INTO T1 VALUES 1");
            this.sql().apply((Object)"INSERT INTO T1 VALUES 2");
            this.sql().apply((Object)"CREATE TABLE T2 (id INT)");
            this.sql().apply((Object)"INSERT INTO T2 VALUES 1");
            this.sql().apply((Object)"INSERT INTO T2 VALUES 2");
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)}));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2)}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM T1 join T2 on T1.id = T2.id ORDER BY T1.id"), (Seq)Nil$.MODULE$.$colon$colon((Object)row2).$colon$colon((Object)row));
            FileStoreTable table1 = this.loadTable("T1");
            FileStoreTable table2 = this.loadTable("T1");
            this.withSparkSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.paimon.scan.snapshot-id"), (Object)"1")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM T1 join T2 on T1.id = T2.id ORDER BY T1.id"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})));
                this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().read().format("paimon").load(table1.location().toString()).join(this.spark().read().format("paimon").load(table2.location().toString()), "id"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
            });
            this.withSparkSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.paimon.*.*.*.scan.snapshot-id"), (Object)"1")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM T1 join T2 on T1.id = T2.id ORDER BY T1.id"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})));
                this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().read().format("paimon").load(table1.location().toString()).join(this.spark().read().format("paimon").load(table2.location().toString()), "id"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
            });
            this.withSparkSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.paimon.scan.snapshot-id"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.paimon.*.*.*.scan.snapshot-id"), (Object)"2")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)}));
                Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2)}));
                this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM T1 join T2 on T1.id = T2.id ORDER BY T1.id"), (Seq)Nil$.MODULE$.$colon$colon((Object)row2).$colon$colon((Object)row));
                Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}));
                Row row4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)}));
                this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().read().format("paimon").load(table1.location().toString()).join(this.spark().read().format("paimon").load(table2.location().toString()), "id"), (Seq)Nil$.MODULE$.$colon$colon((Object)row4).$colon$colon((Object)row3));
            });
            this.withSparkSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.paimon.*.*.T1.scan.snapshot-id"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.paimon.*.*.T2.scan.snapshot-id"), (Object)"1")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM T1 join T2 on T1.id = T2.id ORDER BY T1.id"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})));
                this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().read().format("paimon").load(table1.location().toString()).join(this.spark().read().format("paimon").load(table2.location().toString()), "id"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
            });
            this.withSparkSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.paimon.*.*.T1.scan.snapshot-id"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.paimon.*.*.T2.scan.snapshot-id"), (Object)"2")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM T1 join T2 on T1.id = T2.id ORDER BY T1.id"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})));
                this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().read().format("paimon").load(table1.location().toString()).join(this.spark().read().format("paimon").load(table2.location().toString()), "id"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
            });
            this.withSparkSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.paimon.*.*.T1.scan.snapshot-id"), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.paimon.*.*.T2.scan.snapshot-id"), (Object)"2")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)}));
                Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2)}));
                this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM T1 join T2 on T1.id = T2.id ORDER BY T1.id"), (Seq)Nil$.MODULE$.$colon$colon((Object)row2).$colon$colon((Object)row));
                Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}));
                Row row4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)}));
                this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().read().format("paimon").load(table1.location().toString()).join(this.spark().read().format("paimon").load(table2.location().toString()), "id"), (Seq)Nil$.MODULE$.$colon$colon((Object)row4).$colon$colon((Object)row3));
            });
        }, new Position("PaimonOptionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
    }
}

