/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.sql;

import org.apache.paimon.spark.PaimonSparkTestBase;
import org.apache.paimon.table.FileStoreTable;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001]1QAA\u0002\u0002\u00029AQa\u0005\u0001\u0005\u0002Q\u0011A\u0003U1j[>tG+Y4EI2$Vm\u001d;CCN,'B\u0001\u0003\u0006\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\r\u001d\tQa\u001d9be.T!\u0001C\u0005\u0002\rA\f\u0017.\\8o\u0015\tQ1\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0019\u0005\u0019qN]4\u0004\u0001M\u0011\u0001a\u0004\t\u0003!Ei\u0011!B\u0005\u0003%\u0015\u00111\u0003U1j[>t7\u000b]1sWR+7\u000f\u001e\"bg\u0016\fa\u0001P5oSRtD#A\u000b\u0011\u0005Y\u0001Q\"A\u0002")
public abstract class PaimonTagDdlTestBase
extends PaimonSparkTestBase {
    public PaimonTagDdlTestBase() {
        this.test("Tag ddl: show tags syntax", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("CREATE TABLE T (id INT, name STRING)\n                |USING PAIMON\n                |TBLPROPERTIES ('primary-key'='id')")).stripMargin());
            this.spark().sql("insert into T values(1, 'a')");
            this.spark().sql("alter table T create tag `2024-10-12`");
            this.spark().sql("alter table T create tag `2024-10-11`");
            this.spark().sql("alter table T create tag `2024-10-13`");
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2024-10-11"}));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2024-10-12"}));
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2024-10-13"}));
            this.checkAnswer((Function0 & java.io.Serializable & Serializable)() -> this.spark().sql("show tags T"), (Seq)Nil$.MODULE$.$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row));
        }, new Position("PaimonTagDdlTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 26));
        this.test("Tag ddl: alter table t crete tag syntax", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("CREATE TABLE T (id INT, name STRING)\n                |USING PAIMON\n                |TBLPROPERTIES ('primary-key'='id')")).stripMargin());
            this.spark().sql("insert into T values(1, 'a')");
            this.spark().sql("insert into T values(2, 'b')");
            this.spark().sql("insert into T values(3, 'c')");
            FileStoreTable table = this.loadTable("T");
            this.assertResult(BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToLong((long)table.snapshotManager().snapshotCount()), Prettifier$.MODULE$.default(), new Position("PaimonTagDdlTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
            this.spark().sql("alter table T create tag `tag-1`");
            this.spark().sql("alter table T create tag `tag-2` RETAIN 2 DAYS");
            this.spark().sql("alter table T create tag `tag-3` as of version 1");
            this.spark().sql("alter table T create tag `tag-4` as of version 2 RETAIN 3 HOURS");
            this.assertResult(BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToLong((long)this.spark().sql("show tags T").count()), Prettifier$.MODULE$.default(), new Position("PaimonTagDdlTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"tag-1", BoxesRunTime.boxToInteger((int)3), null}));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"tag-2", BoxesRunTime.boxToInteger((int)3), "PT48H"}));
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"tag-3", BoxesRunTime.boxToInteger((int)1), null}));
            Row row4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"tag-4", BoxesRunTime.boxToInteger((int)2), "PT3H"}));
            this.checkAnswer((Function0 & java.io.Serializable & Serializable)() -> this.spark().sql("select tag_name,snapshot_id,time_retained from `T$tags`"), (Seq)Nil$.MODULE$.$colon$colon((Object)row4).$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row));
            this.spark().sql("alter table T create tag if not exists `tag-1` RETAIN 10 HOURS");
            this.checkAnswer((Function0 & java.io.Serializable & Serializable)() -> this.spark().sql("select tag_name,snapshot_id,time_retained from `T$tags` where tag_name='tag-1'"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"tag-1", BoxesRunTime.boxToInteger((int)3), null})));
        }, new Position("PaimonTagDdlTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
        this.test("Tag ddl: alter table t create or replace tag syntax", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("CREATE TABLE T (id INT, name STRING)\n                |USING PAIMON\n                |TBLPROPERTIES ('primary-key'='id')")).stripMargin());
            this.spark().sql("insert into T values(1, 'a')");
            this.spark().sql("insert into T values(2, 'b')");
            this.assertResult(BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)this.loadTable("T").snapshotManager().snapshotCount()), Prettifier$.MODULE$.default(), new Position("PaimonTagDdlTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
            this.spark().sql("alter table T create tag `tag-1` as of version 1");
            this.spark().sql("alter table T replace tag `tag-1` as of version 2 RETAIN 1 HOURS");
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"tag-1", BoxesRunTime.boxToInteger((int)2), "PT1H"}));
            this.checkAnswer((Function0 & java.io.Serializable & Serializable)() -> this.spark().sql("select tag_name,snapshot_id,time_retained from `T$tags`"), (Seq)Nil$.MODULE$.$colon$colon((Object)row));
            this.spark().sql("alter table T create or replace tag `tag-2` as of version 1");
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"tag-2", BoxesRunTime.boxToInteger((int)1), null}));
            this.checkAnswer((Function0 & java.io.Serializable & Serializable)() -> this.spark().sql("select tag_name,snapshot_id,time_retained from `T$tags` where tag_name = 'tag-2'"), (Seq)Nil$.MODULE$.$colon$colon((Object)row2));
            this.spark().sql("alter table T create or replace tag `tag-2` as of version 2 RETAIN 1 HOURS");
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"tag-2", BoxesRunTime.boxToInteger((int)2), "PT1H"}));
            this.checkAnswer((Function0 & java.io.Serializable & Serializable)() -> this.spark().sql("select tag_name,snapshot_id,time_retained from `T$tags` where tag_name = 'tag-2'"), (Seq)Nil$.MODULE$.$colon$colon((Object)row3));
        }, new Position("PaimonTagDdlTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
        this.test("Tag ddl: alter table t delete tag syntax", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("CREATE TABLE T (id INT, name STRING)\n                |USING PAIMON\n                |TBLPROPERTIES ('primary-key'='id')")).stripMargin());
            this.spark().sql("insert into T values(1, 'a')");
            this.assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)this.loadTable("T").snapshotManager().snapshotCount()), Prettifier$.MODULE$.default(), new Position("PaimonTagDdlTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
            this.spark().sql("alter table T create tag `2024-10-12`");
            this.spark().sql("alter table T create tag `2024-10-15`");
            this.spark().sql("alter table T create tag `2024-10-13`");
            this.spark().sql("alter table T create tag `2024-10-14`");
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2024-10-12"}));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2024-10-13"}));
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2024-10-14"}));
            Row row4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2024-10-15"}));
            this.checkAnswer((Function0 & java.io.Serializable & Serializable)() -> this.spark().sql("show tags T"), (Seq)Nil$.MODULE$.$colon$colon((Object)row4).$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row));
            this.spark().sql("alter table T delete tag `2024-10-12`");
            Row row5 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2024-10-13"}));
            Row row6 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2024-10-14"}));
            Row row7 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2024-10-15"}));
            this.checkAnswer((Function0 & java.io.Serializable & Serializable)() -> this.spark().sql("show tags T"), (Seq)Nil$.MODULE$.$colon$colon((Object)row7).$colon$colon((Object)row6).$colon$colon((Object)row5));
            this.spark().sql("alter table T delete tag `2024-10-13, 2024-10-14`");
            Row row8 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2024-10-15"}));
            this.checkAnswer((Function0 & java.io.Serializable & Serializable)() -> this.spark().sql("show tags T"), (Seq)Nil$.MODULE$.$colon$colon((Object)row8));
            this.spark().sql("alter table T delete tag if EXISTS `2024-10-18`");
            Row row9 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2024-10-15"}));
            this.checkAnswer((Function0 & java.io.Serializable & Serializable)() -> this.spark().sql("show tags T"), (Seq)Nil$.MODULE$.$colon$colon((Object)row9));
        }, new Position("PaimonTagDdlTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        this.test("Tag ddl: alter table t rename tag syntax", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("CREATE TABLE T (id INT, name STRING)\n                |USING PAIMON\n                |TBLPROPERTIES ('primary-key'='id')")).stripMargin());
            this.spark().sql("insert into T values(1, 'a')");
            this.assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)this.loadTable("T").snapshotManager().snapshotCount()), Prettifier$.MODULE$.default(), new Position("PaimonTagDdlTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
            this.spark().sql("alter table T create tag `tag-1`");
            this.checkAnswer((Function0 & java.io.Serializable & Serializable)() -> this.spark().sql("show tags T"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"tag-1"})));
            this.spark().sql("alter table T rename tag `tag-1` to `tag-2`");
            this.checkAnswer((Function0 & java.io.Serializable & Serializable)() -> this.spark().sql("show tags T"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"tag-2"})));
        }, new Position("PaimonTagDdlTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
    }
}

