/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet.newreader;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Timestamp;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.paimon.data.columnar.heap.HeapIntVector;
import org.apache.paimon.data.columnar.writable.WritableBooleanVector;
import org.apache.paimon.data.columnar.writable.WritableByteVector;
import org.apache.paimon.data.columnar.writable.WritableBytesVector;
import org.apache.paimon.data.columnar.writable.WritableColumnVector;
import org.apache.paimon.data.columnar.writable.WritableDoubleVector;
import org.apache.paimon.data.columnar.writable.WritableFloatVector;
import org.apache.paimon.data.columnar.writable.WritableIntVector;
import org.apache.paimon.data.columnar.writable.WritableLongVector;
import org.apache.paimon.data.columnar.writable.WritableShortVector;
import org.apache.paimon.data.columnar.writable.WritableTimestampVector;
import org.apache.paimon.format.parquet.ParquetSchemaConverter;
import org.apache.paimon.format.parquet.newreader.ParquetVectorUpdater;
import org.apache.paimon.format.parquet.newreader.VectorizedValuesReader;
import org.apache.paimon.shade.org.apache.parquet.column.ColumnDescriptor;
import org.apache.paimon.shade.org.apache.parquet.column.Dictionary;
import org.apache.paimon.shade.org.apache.parquet.io.api.Binary;
import org.apache.paimon.shade.org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.paimon.shade.org.apache.parquet.schema.PrimitiveType;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.BinaryType;
import org.apache.paimon.types.BooleanType;
import org.apache.paimon.types.CharType;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeVisitor;
import org.apache.paimon.types.DateType;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.DoubleType;
import org.apache.paimon.types.FloatType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.LocalZonedTimestampType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.MultisetType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.SmallIntType;
import org.apache.paimon.types.TimeType;
import org.apache.paimon.types.TimestampType;
import org.apache.paimon.types.TinyIntType;
import org.apache.paimon.types.VarBinaryType;
import org.apache.paimon.types.VarCharType;
import org.apache.paimon.utils.Preconditions;

public class ParquetVectorUpdaterFactory {
    private final LogicalTypeAnnotation logicalTypeAnnotation;

    ParquetVectorUpdaterFactory(LogicalTypeAnnotation logicalTypeAnnotation) {
        this.logicalTypeAnnotation = logicalTypeAnnotation;
    }

    public ParquetVectorUpdater getUpdater(ColumnDescriptor descriptor, DataType paimonType) {
        return (ParquetVectorUpdater)paimonType.accept(UpdaterFactoryVisitor.INSTANCE).apply(descriptor);
    }

    private static class FixedLenByteArrayToDecimalUpdater
    extends DecimalUpdater<WritableBytesVector> {
        private final int parquetScale;
        private final int arrayLen;

        FixedLenByteArrayToDecimalUpdater(ColumnDescriptor descriptor, DecimalType sparkType) {
            super(sparkType);
            LogicalTypeAnnotation typeAnnotation = descriptor.getPrimitiveType().getLogicalTypeAnnotation();
            this.parquetScale = ((LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)typeAnnotation).getScale();
            this.arrayLen = descriptor.getPrimitiveType().getTypeLength();
        }

        @Override
        public void skipValues(int total, VectorizedValuesReader valuesReader) {
            valuesReader.skipFixedLenByteArray(total, this.arrayLen);
        }

        @Override
        public void readValue(int offset, WritableBytesVector values, VectorizedValuesReader valuesReader) {
            BigInteger value = new BigInteger(valuesReader.readBinary(this.arrayLen).getBytesUnsafe());
            BigDecimal decimal = new BigDecimal(value, this.parquetScale);
            byte[] bytes = decimal.unscaledValue().toByteArray();
            values.putByteArray(offset, bytes, 0, bytes.length);
        }

        @Override
        public void decodeSingleDictionaryId(int offset, WritableBytesVector values, WritableIntVector dictionaryIds, Dictionary dictionary) {
            BigInteger value = new BigInteger(dictionary.decodeToBinary(dictionaryIds.getInt(offset)).getBytesUnsafe());
            BigDecimal decimal = new BigDecimal(value, this.parquetScale);
            byte[] bytes = decimal.unscaledValue().toByteArray();
            values.putByteArray(offset, bytes, 0, bytes.length);
        }
    }

    private static class BinaryToDecimalUpdater
    extends DecimalUpdater<WritableBytesVector> {
        private final int parquetScale;

        BinaryToDecimalUpdater(ColumnDescriptor descriptor, DecimalType sparkType) {
            super(sparkType);
            LogicalTypeAnnotation typeAnnotation = descriptor.getPrimitiveType().getLogicalTypeAnnotation();
            this.parquetScale = ((LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)typeAnnotation).getScale();
        }

        @Override
        public void skipValues(int total, VectorizedValuesReader valuesReader) {
            valuesReader.skipBinary(total);
        }

        @Override
        public void readValue(int offset, WritableBytesVector values, VectorizedValuesReader valuesReader) {
            valuesReader.readBinary(1, values, offset);
            BigInteger value = new BigInteger(values.getBytes(offset).getBytes());
            BigDecimal decimal = new BigDecimal(value, this.parquetScale);
            byte[] bytes = decimal.unscaledValue().toByteArray();
            values.putByteArray(offset, bytes, 0, bytes.length);
        }

        @Override
        public void decodeSingleDictionaryId(int offset, WritableBytesVector values, WritableIntVector dictionaryIds, Dictionary dictionary) {
            BigInteger value = new BigInteger(dictionary.decodeToBinary(dictionaryIds.getInt(offset)).getBytesUnsafe());
            BigDecimal decimal = new BigDecimal(value, this.parquetScale);
            byte[] bytes = decimal.unscaledValue().toByteArray();
            values.putByteArray(offset, bytes, 0, bytes.length);
        }
    }

    private static class LongToDecimalUpdater
    extends DecimalUpdater<WritableLongVector> {
        private final int parquetScale;

        LongToDecimalUpdater(ColumnDescriptor descriptor, DecimalType sparkType) {
            super(sparkType);
            LogicalTypeAnnotation typeAnnotation = descriptor.getPrimitiveType().getLogicalTypeAnnotation();
            this.parquetScale = typeAnnotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation ? ((LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)typeAnnotation).getScale() : 0;
        }

        @Override
        public void skipValues(int total, VectorizedValuesReader valuesReader) {
            valuesReader.skipLongs(total);
        }

        @Override
        public void readValue(int offset, WritableLongVector values, VectorizedValuesReader valuesReader) {
            BigDecimal decimal = BigDecimal.valueOf(valuesReader.readLong(), this.parquetScale);
            values.setLong(offset, decimal.unscaledValue().longValue());
        }

        @Override
        public void decodeSingleDictionaryId(int offset, WritableLongVector values, WritableIntVector dictionaryIds, Dictionary dictionary) {
            BigDecimal decimal = BigDecimal.valueOf(dictionary.decodeToLong(dictionaryIds.getInt(offset)), this.parquetScale);
            values.setLong(offset, decimal.unscaledValue().longValue());
        }
    }

    private static class IntegerToDecimalUpdater
    extends DecimalUpdater<WritableIntVector> {
        private final int parquetScale;

        IntegerToDecimalUpdater(ColumnDescriptor descriptor, DecimalType paimonType) {
            super(paimonType);
            LogicalTypeAnnotation typeAnnotation = descriptor.getPrimitiveType().getLogicalTypeAnnotation();
            this.parquetScale = typeAnnotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation ? ((LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)typeAnnotation).getScale() : 0;
        }

        @Override
        public void skipValues(int total, VectorizedValuesReader valuesReader) {
            valuesReader.skipIntegers(total);
        }

        @Override
        public void readValue(int offset, WritableIntVector values, VectorizedValuesReader valuesReader) {
            BigDecimal decimal = BigDecimal.valueOf(valuesReader.readInteger(), this.parquetScale);
            values.setInt(offset, decimal.unscaledValue().intValue());
        }

        @Override
        public void decodeSingleDictionaryId(int offset, WritableIntVector values, WritableIntVector dictionaryIds, Dictionary dictionary) {
            BigDecimal decimal = BigDecimal.valueOf(dictionary.decodeToInt(dictionaryIds.getInt(offset)), this.parquetScale);
            values.setInt(offset, decimal.unscaledValue().intValue());
        }
    }

    private static abstract class DecimalUpdater<T extends WritableColumnVector>
    implements ParquetVectorUpdater<T> {
        private final DecimalType sparkType;

        DecimalUpdater(DecimalType sparkType) {
            this.sparkType = sparkType;
        }

        @Override
        public void readValues(int total, int offset, T values, VectorizedValuesReader valuesReader) {
            for (int i = 0; i < total; ++i) {
                this.readValue(offset + i, values, valuesReader);
            }
        }

        protected void writeDecimal(int offset, WritableColumnVector values, BigDecimal decimal) {
            BigDecimal scaledDecimal = decimal.setScale(this.sparkType.getScale(), RoundingMode.UNNECESSARY);
            int precision = decimal.precision();
            if (ParquetSchemaConverter.is32BitDecimal(precision)) {
                ((WritableIntVector)values).setInt(offset, scaledDecimal.unscaledValue().intValue());
            } else if (ParquetSchemaConverter.is64BitDecimal(precision)) {
                ((WritableLongVector)values).setLong(offset, scaledDecimal.unscaledValue().longValue());
            } else {
                byte[] bytes = scaledDecimal.unscaledValue().toByteArray();
                ((WritableBytesVector)values).putByteArray(offset, bytes, 0, bytes.length);
            }
        }
    }

    private static class FixedLenByteArrayUpdater
    implements ParquetVectorUpdater<WritableBytesVector> {
        private final int arrayLen;

        FixedLenByteArrayUpdater(int arrayLen) {
            this.arrayLen = arrayLen;
        }

        @Override
        public void readValues(int total, int offset, WritableBytesVector values, VectorizedValuesReader valuesReader) {
            for (int i = 0; i < total; ++i) {
                this.readValue(offset + i, values, valuesReader);
            }
        }

        @Override
        public void skipValues(int total, VectorizedValuesReader valuesReader) {
            valuesReader.skipFixedLenByteArray(total, this.arrayLen);
        }

        @Override
        public void readValue(int offset, WritableBytesVector values, VectorizedValuesReader valuesReader) {
            byte[] bytes = valuesReader.readBinary(this.arrayLen).getBytesUnsafe();
            values.putByteArray(offset, bytes, 0, bytes.length);
        }

        @Override
        public void decodeSingleDictionaryId(int offset, WritableBytesVector values, WritableIntVector dictionaryIds, Dictionary dictionary) {
            Binary v = dictionary.decodeToBinary(dictionaryIds.getInt(offset));
            values.putByteArray(offset, v.getBytesUnsafe(), 0, v.length());
        }
    }

    private static class BinaryUpdater
    implements ParquetVectorUpdater<WritableBytesVector> {
        private BinaryUpdater() {
        }

        @Override
        public void readValues(int total, int offset, WritableBytesVector values, VectorizedValuesReader valuesReader) {
            valuesReader.readBinary(total, values, offset);
        }

        @Override
        public void skipValues(int total, VectorizedValuesReader valuesReader) {
            valuesReader.skipBinary(total);
        }

        @Override
        public void readValue(int offset, WritableBytesVector values, VectorizedValuesReader valuesReader) {
            valuesReader.readBinary(1, values, offset);
        }

        @Override
        public void decodeSingleDictionaryId(int offset, WritableBytesVector values, WritableIntVector dictionaryIds, Dictionary dictionary) {
            Binary v = dictionary.decodeToBinary(dictionaryIds.getInt(offset));
            values.putByteArray(offset, v.getBytesUnsafe(), 0, v.length());
        }
    }

    private static class DoubleUpdater
    implements ParquetVectorUpdater<WritableDoubleVector> {
        private DoubleUpdater() {
        }

        @Override
        public void readValues(int total, int offset, WritableDoubleVector values, VectorizedValuesReader valuesReader) {
            valuesReader.readDoubles(total, values, offset);
        }

        @Override
        public void skipValues(int total, VectorizedValuesReader valuesReader) {
            valuesReader.skipDoubles(total);
        }

        @Override
        public void readValue(int offset, WritableDoubleVector values, VectorizedValuesReader valuesReader) {
            values.setDouble(offset, valuesReader.readDouble());
        }

        @Override
        public void decodeSingleDictionaryId(int offset, WritableDoubleVector values, WritableIntVector dictionaryIds, Dictionary dictionary) {
            values.setDouble(offset, dictionary.decodeToDouble(dictionaryIds.getInt(offset)));
        }
    }

    private static class FloatUpdater
    implements ParquetVectorUpdater<WritableFloatVector> {
        private FloatUpdater() {
        }

        @Override
        public void readValues(int total, int offset, WritableFloatVector values, VectorizedValuesReader valuesReader) {
            valuesReader.readFloats(total, values, offset);
        }

        @Override
        public void skipValues(int total, VectorizedValuesReader valuesReader) {
            valuesReader.skipFloats(total);
        }

        @Override
        public void readValue(int offset, WritableFloatVector values, VectorizedValuesReader valuesReader) {
            values.setFloat(offset, valuesReader.readFloat());
        }

        @Override
        public void decodeSingleDictionaryId(int offset, WritableFloatVector values, WritableIntVector dictionaryIds, Dictionary dictionary) {
            values.setFloat(offset, dictionary.decodeToFloat(dictionaryIds.getInt(offset)));
        }
    }

    private static class TimestampUpdater
    implements ParquetVectorUpdater<WritableTimestampVector> {
        public static final int JULIAN_EPOCH_OFFSET_DAYS = 2440588;
        public static final long MILLIS_IN_DAY = TimeUnit.DAYS.toMillis(1L);
        public static final long NANOS_PER_MILLISECOND = TimeUnit.MILLISECONDS.toNanos(1L);
        public static final long NANOS_PER_SECOND = TimeUnit.SECONDS.toNanos(1L);

        private TimestampUpdater() {
        }

        @Override
        public void readValues(int total, int offset, WritableTimestampVector values, VectorizedValuesReader valuesReader) {
            for (int i = 0; i < total; ++i) {
                values.setTimestamp(offset + i, TimestampUpdater.int96ToTimestamp(true, valuesReader.readLong(), valuesReader.readInteger()));
            }
        }

        @Override
        public void skipValues(int total, VectorizedValuesReader valuesReader) {
            valuesReader.skipBytes(12);
        }

        @Override
        public void readValue(int offset, WritableTimestampVector values, VectorizedValuesReader valuesReader) {
            values.setTimestamp(offset, TimestampUpdater.int96ToTimestamp(true, valuesReader.readLong(), valuesReader.readInteger()));
        }

        @Override
        public void decodeSingleDictionaryId(int offset, WritableTimestampVector values, WritableIntVector dictionaryIds, Dictionary dictionary) {
            values.setTimestamp(offset, TimestampUpdater.decodeInt96ToTimestamp(true, dictionary, dictionaryIds.getInt(offset)));
        }

        public static org.apache.paimon.data.Timestamp decodeInt96ToTimestamp(boolean utcTimestamp, Dictionary dictionary, int id) {
            Binary binary = dictionary.decodeToBinary(id);
            Preconditions.checkArgument(binary.length() == 12, "Timestamp with int96 should be 12 bytes.");
            ByteBuffer buffer = binary.toByteBuffer().order(ByteOrder.LITTLE_ENDIAN);
            return TimestampUpdater.int96ToTimestamp(utcTimestamp, buffer.getLong(), buffer.getInt());
        }

        public static org.apache.paimon.data.Timestamp int96ToTimestamp(boolean utcTimestamp, long nanosOfDay, int julianDay) {
            long millisecond = TimestampUpdater.julianDayToMillis(julianDay) + nanosOfDay / NANOS_PER_MILLISECOND;
            if (utcTimestamp) {
                int nanoOfMillisecond = (int)(nanosOfDay % NANOS_PER_MILLISECOND);
                return org.apache.paimon.data.Timestamp.fromEpochMillis(millisecond, nanoOfMillisecond);
            }
            Timestamp timestamp = new Timestamp(millisecond);
            timestamp.setNanos((int)(nanosOfDay % NANOS_PER_SECOND));
            return org.apache.paimon.data.Timestamp.fromSQLTimestamp(timestamp);
        }

        private static long julianDayToMillis(int julianDay) {
            return (long)(julianDay - 2440588) * MILLIS_IN_DAY;
        }
    }

    private static class LongUpdater
    implements ParquetVectorUpdater<WritableLongVector> {
        private LongUpdater() {
        }

        @Override
        public void readValues(int total, int offset, WritableLongVector values, VectorizedValuesReader valuesReader) {
            valuesReader.readLongs(total, values, offset);
        }

        @Override
        public void skipValues(int total, VectorizedValuesReader valuesReader) {
            valuesReader.skipLongs(total);
        }

        @Override
        public void readValue(int offset, WritableLongVector values, VectorizedValuesReader valuesReader) {
            values.setLong(offset, valuesReader.readLong());
        }

        @Override
        public void decodeSingleDictionaryId(int offset, WritableLongVector values, WritableIntVector dictionaryIds, Dictionary dictionary) {
            values.setLong(offset, dictionary.decodeToLong(dictionaryIds.getInt(offset)));
        }
    }

    private static class ShortUpdater
    implements ParquetVectorUpdater<WritableShortVector> {
        private ShortUpdater() {
        }

        @Override
        public void readValues(int total, int offset, WritableShortVector values, VectorizedValuesReader valuesReader) {
            valuesReader.readShorts(total, values, offset);
        }

        @Override
        public void skipValues(int total, VectorizedValuesReader valuesReader) {
            valuesReader.skipShorts(total);
        }

        @Override
        public void readValue(int offset, WritableShortVector values, VectorizedValuesReader valuesReader) {
            values.setShort(offset, valuesReader.readShort());
        }

        @Override
        public void decodeSingleDictionaryId(int offset, WritableShortVector values, WritableIntVector dictionaryIds, Dictionary dictionary) {
            values.setShort(offset, (short)dictionary.decodeToInt(((HeapIntVector)dictionaryIds).getInt(offset)));
        }
    }

    private static class ByteUpdater
    implements ParquetVectorUpdater<WritableByteVector> {
        private ByteUpdater() {
        }

        @Override
        public void readValues(int total, int offset, WritableByteVector values, VectorizedValuesReader valuesReader) {
            valuesReader.readBytes(total, values, offset);
        }

        @Override
        public void skipValues(int total, VectorizedValuesReader valuesReader) {
            valuesReader.skipBytes(total);
        }

        @Override
        public void readValue(int offset, WritableByteVector values, VectorizedValuesReader valuesReader) {
            values.setByte(offset, valuesReader.readByte());
        }

        @Override
        public void decodeSingleDictionaryId(int offset, WritableByteVector values, WritableIntVector dictionaryIds, Dictionary dictionary) {
            values.setByte(offset, (byte)dictionary.decodeToInt(dictionaryIds.getInt(offset)));
        }
    }

    static class IntegerUpdater
    implements ParquetVectorUpdater<WritableIntVector> {
        IntegerUpdater() {
        }

        @Override
        public void readValues(int total, int offset, WritableIntVector values, VectorizedValuesReader valuesReader) {
            valuesReader.readIntegers(total, values, offset);
        }

        @Override
        public void skipValues(int total, VectorizedValuesReader valuesReader) {
            valuesReader.skipIntegers(total);
        }

        @Override
        public void readValue(int offset, WritableIntVector values, VectorizedValuesReader valuesReader) {
            values.setInt(offset, valuesReader.readInteger());
        }

        @Override
        public void decodeSingleDictionaryId(int offset, WritableIntVector values, WritableIntVector dictionaryIds, Dictionary dictionary) {
            values.setInt(offset, dictionary.decodeToInt(dictionaryIds.getInt(offset)));
        }
    }

    private static class BooleanUpdater
    implements ParquetVectorUpdater<WritableBooleanVector> {
        private BooleanUpdater() {
        }

        @Override
        public void readValues(int total, int offset, WritableBooleanVector values, VectorizedValuesReader valuesReader) {
            valuesReader.readBooleans(total, values, offset);
        }

        @Override
        public void skipValues(int total, VectorizedValuesReader valuesReader) {
            valuesReader.skipBooleans(total);
        }

        @Override
        public void readValue(int offset, WritableBooleanVector values, VectorizedValuesReader valuesReader) {
            values.setBoolean(offset, valuesReader.readBoolean());
        }

        @Override
        public void decodeSingleDictionaryId(int offset, WritableBooleanVector values, WritableIntVector dictionaryIds, Dictionary dictionary) {
            throw new UnsupportedOperationException();
        }
    }

    private static class UpdaterFactoryVisitor
    implements DataTypeVisitor<UpdaterFactory> {
        private static final UpdaterFactoryVisitor INSTANCE = new UpdaterFactoryVisitor();

        private UpdaterFactoryVisitor() {
        }

        @Override
        public UpdaterFactory visit(CharType charType) {
            return c -> new BinaryUpdater();
        }

        @Override
        public UpdaterFactory visit(VarCharType varCharType) {
            return c -> new BinaryUpdater();
        }

        @Override
        public UpdaterFactory visit(BooleanType booleanType) {
            return c -> new BooleanUpdater();
        }

        @Override
        public UpdaterFactory visit(BinaryType binaryType) {
            return c -> {
                if (c.getPrimitiveType().getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY) {
                    return new FixedLenByteArrayUpdater(binaryType.getLength());
                }
                return new BinaryUpdater();
            };
        }

        @Override
        public UpdaterFactory visit(VarBinaryType varBinaryType) {
            return c -> {
                if (c.getPrimitiveType().getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY) {
                    return new FixedLenByteArrayUpdater(c.getPrimitiveType().getTypeLength());
                }
                return new BinaryUpdater();
            };
        }

        @Override
        public UpdaterFactory visit(DecimalType decimalType) {
            return c -> {
                switch (c.getPrimitiveType().getPrimitiveTypeName()) {
                    case INT32: {
                        return new IntegerToDecimalUpdater((ColumnDescriptor)c, decimalType);
                    }
                    case INT64: {
                        return new LongToDecimalUpdater((ColumnDescriptor)c, decimalType);
                    }
                    case BINARY: {
                        return new BinaryToDecimalUpdater((ColumnDescriptor)c, decimalType);
                    }
                    case FIXED_LEN_BYTE_ARRAY: {
                        int precision = decimalType.getPrecision();
                        if (ParquetSchemaConverter.is32BitDecimal(precision)) {
                            return new IntegerToDecimalUpdater((ColumnDescriptor)c, decimalType);
                        }
                        if (ParquetSchemaConverter.is64BitDecimal(precision)) {
                            return new LongToDecimalUpdater((ColumnDescriptor)c, decimalType);
                        }
                        return new FixedLenByteArrayToDecimalUpdater((ColumnDescriptor)c, decimalType);
                    }
                }
                throw new RuntimeException("Unsupported decimal type: " + (Object)((Object)c.getPrimitiveType().getPrimitiveTypeName()));
            };
        }

        @Override
        public UpdaterFactory visit(TinyIntType tinyIntType) {
            return c -> new ByteUpdater();
        }

        @Override
        public UpdaterFactory visit(SmallIntType smallIntType) {
            return c -> new ShortUpdater();
        }

        @Override
        public UpdaterFactory visit(IntType intType) {
            return c -> new IntegerUpdater();
        }

        @Override
        public UpdaterFactory visit(BigIntType bigIntType) {
            return c -> new LongUpdater();
        }

        @Override
        public UpdaterFactory visit(FloatType floatType) {
            return c -> new FloatUpdater();
        }

        @Override
        public UpdaterFactory visit(DoubleType doubleType) {
            return c -> new DoubleUpdater();
        }

        @Override
        public UpdaterFactory visit(DateType dateType) {
            return c -> new IntegerUpdater();
        }

        @Override
        public UpdaterFactory visit(TimeType timeType) {
            return c -> new IntegerUpdater();
        }

        @Override
        public UpdaterFactory visit(TimestampType timestampType) {
            return c -> {
                if (c.getPrimitiveType().getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT64) {
                    return new LongUpdater();
                }
                return new TimestampUpdater();
            };
        }

        @Override
        public UpdaterFactory visit(LocalZonedTimestampType localZonedTimestampType) {
            return c -> {
                if (c.getPrimitiveType().getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT64) {
                    return new LongUpdater();
                }
                return new TimestampUpdater();
            };
        }

        @Override
        public UpdaterFactory visit(ArrayType arrayType) {
            throw new RuntimeException("Array type is not supported");
        }

        @Override
        public UpdaterFactory visit(MultisetType multisetType) {
            throw new RuntimeException("Multiset type is not supported");
        }

        @Override
        public UpdaterFactory visit(MapType mapType) {
            throw new RuntimeException("Map type is not supported");
        }

        @Override
        public UpdaterFactory visit(RowType rowType) {
            throw new RuntimeException("Row type is not supported");
        }
    }

    static interface UpdaterFactory
    extends Function<ColumnDescriptor, ParquetVectorUpdater> {
    }
}

