/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.spark.util.shim.TypeUtils;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DateType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.DateTimeUtils;
import org.apache.spark.sql.Row;
import scala.collection.JavaConverters;
import scala.collection.Map;
import scala.collection.Seq;

public class SparkRow
implements InternalRow,
Serializable {
    private final RowType type;
    private final Row row;
    private final RowKind rowKind;

    public SparkRow(RowType type, Row row) {
        this(type, row, RowKind.INSERT);
    }

    public SparkRow(RowType type, Row row, RowKind rowkind) {
        this.type = type;
        this.row = row;
        this.rowKind = rowkind;
    }

    @Override
    public int getFieldCount() {
        return this.type.getFieldCount();
    }

    @Override
    public RowKind getRowKind() {
        return this.rowKind;
    }

    @Override
    public void setRowKind(RowKind rowKind) {
        throw new UnsupportedOperationException("Spark row does not support modifying rowkind field");
    }

    @Override
    public boolean isNullAt(int i) {
        return this.row.isNullAt(i);
    }

    @Override
    public boolean getBoolean(int i) {
        return this.row.getBoolean(i);
    }

    @Override
    public byte getByte(int i) {
        return this.row.getByte(i);
    }

    @Override
    public short getShort(int i) {
        return this.row.getShort(i);
    }

    @Override
    public int getInt(int i) {
        if (this.type.getTypeAt(i) instanceof DateType) {
            return SparkRow.toPaimonDate(this.row.get(i));
        }
        return this.row.getInt(i);
    }

    @Override
    public long getLong(int i) {
        return this.row.getLong(i);
    }

    @Override
    public float getFloat(int i) {
        return this.row.getFloat(i);
    }

    @Override
    public double getDouble(int i) {
        return this.row.getDouble(i);
    }

    @Override
    public BinaryString getString(int i) {
        return BinaryString.fromString(this.row.getString(i));
    }

    @Override
    public Decimal getDecimal(int i, int precision, int scale) {
        return Decimal.fromBigDecimal(this.row.getDecimal(i), precision, scale);
    }

    @Override
    public org.apache.paimon.data.Timestamp getTimestamp(int i, int precision) {
        return SparkRow.toPaimonTimestamp(this.row.get(i));
    }

    @Override
    public byte[] getBinary(int i) {
        return (byte[])this.row.getAs(i);
    }

    @Override
    public InternalArray getArray(int i) {
        return new PaimonArray(((ArrayType)this.type.getTypeAt(i)).getElementType(), this.row.getList(i));
    }

    @Override
    public InternalMap getMap(int i) {
        return SparkRow.toPaimonMap((MapType)this.type.getTypeAt(i), this.row.getJavaMap(i));
    }

    @Override
    public InternalRow getRow(int i, int i1) {
        return new SparkRow((RowType)this.type.getTypeAt(i), this.row.getStruct(i));
    }

    private static int toPaimonDate(Object object) {
        if (object instanceof Date) {
            return DateTimeUtils.toInternal((Date)object);
        }
        return DateTimeUtils.toInternal((LocalDate)object);
    }

    private static org.apache.paimon.data.Timestamp toPaimonTimestamp(Object object) {
        if (object instanceof Timestamp) {
            Timestamp ts = (Timestamp)object;
            if (TypeUtils.treatPaimonTimestampTypeAsSparkTimestampType()) {
                return org.apache.paimon.data.Timestamp.fromSQLTimestamp(ts);
            }
            return org.apache.paimon.data.Timestamp.fromInstant(ts.toInstant());
        }
        if (object instanceof Instant) {
            Instant instant = (Instant)object;
            if (TypeUtils.treatPaimonTimestampTypeAsSparkTimestampType()) {
                LocalDateTime localDateTime = LocalDateTime.ofInstant((Instant)object, ZoneId.systemDefault());
                return org.apache.paimon.data.Timestamp.fromLocalDateTime(localDateTime);
            }
            return org.apache.paimon.data.Timestamp.fromInstant(instant);
        }
        return org.apache.paimon.data.Timestamp.fromLocalDateTime((LocalDateTime)object);
    }

    private static InternalMap toPaimonMap(MapType mapType, final java.util.Map<Object, Object> map) {
        ArrayList keys = new ArrayList();
        ArrayList values = new ArrayList();
        map.forEach((k, v) -> {
            keys.add(k);
            values.add(v);
        });
        final PaimonArray key = new PaimonArray(mapType.getKeyType(), keys);
        final PaimonArray value = new PaimonArray(mapType.getValueType(), values);
        return new InternalMap(){

            @Override
            public int size() {
                return map.size();
            }

            @Override
            public InternalArray keyArray() {
                return key;
            }

            @Override
            public InternalArray valueArray() {
                return value;
            }
        };
    }

    private static class PaimonArray
    implements InternalArray {
        private final DataType elementType;
        private final List<Object> list;

        private PaimonArray(DataType elementType, List<Object> list) {
            this.list = list;
            this.elementType = elementType;
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public boolean isNullAt(int i) {
            return this.list.get(i) == null;
        }

        private <T> T getAs(int i) {
            return (T)this.list.get(i);
        }

        @Override
        public boolean getBoolean(int i) {
            return (Boolean)this.getAs(i);
        }

        @Override
        public byte getByte(int i) {
            return (Byte)this.getAs(i);
        }

        @Override
        public short getShort(int i) {
            return (Short)this.getAs(i);
        }

        @Override
        public int getInt(int i) {
            if (this.elementType instanceof DateType) {
                return SparkRow.toPaimonDate(this.getAs(i));
            }
            return (Integer)this.getAs(i);
        }

        @Override
        public long getLong(int i) {
            return (Long)this.getAs(i);
        }

        @Override
        public float getFloat(int i) {
            return ((Float)this.getAs(i)).floatValue();
        }

        @Override
        public double getDouble(int i) {
            return (Double)this.getAs(i);
        }

        @Override
        public BinaryString getString(int i) {
            return BinaryString.fromString((String)this.getAs(i));
        }

        @Override
        public Decimal getDecimal(int i, int precision, int scale) {
            return Decimal.fromBigDecimal((BigDecimal)this.getAs(i), precision, scale);
        }

        @Override
        public org.apache.paimon.data.Timestamp getTimestamp(int i, int precision) {
            return SparkRow.toPaimonTimestamp(this.getAs(i));
        }

        @Override
        public byte[] getBinary(int i) {
            return (byte[])this.getAs(i);
        }

        @Override
        public InternalArray getArray(int i) {
            Object o = this.getAs(i);
            List array = o instanceof Seq ? JavaConverters.seqAsJavaList((Seq)((Seq)o)) : (List)o;
            return new PaimonArray(((ArrayType)this.elementType).getElementType(), array);
        }

        @Override
        public InternalMap getMap(int i) {
            Object o = this.getAs(i);
            java.util.Map map = o instanceof Map ? JavaConverters.mapAsJavaMap((Map)((Map)o)) : (java.util.Map)o;
            return SparkRow.toPaimonMap((MapType)this.elementType, map);
        }

        @Override
        public InternalRow getRow(int i, int i1) {
            return new SparkRow((RowType)this.elementType, (Row)this.getAs(i));
        }

        @Override
        public boolean[] toBooleanArray() {
            boolean[] res = new boolean[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                res[i] = this.getBoolean(i);
            }
            return res;
        }

        @Override
        public byte[] toByteArray() {
            byte[] res = new byte[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                res[i] = this.getByte(i);
            }
            return res;
        }

        @Override
        public short[] toShortArray() {
            short[] res = new short[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                res[i] = this.getShort(i);
            }
            return res;
        }

        @Override
        public int[] toIntArray() {
            int[] res = new int[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                res[i] = this.getInt(i);
            }
            return res;
        }

        @Override
        public long[] toLongArray() {
            long[] res = new long[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                res[i] = this.getLong(i);
            }
            return res;
        }

        @Override
        public float[] toFloatArray() {
            float[] res = new float[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                res[i] = this.getFloat(i);
            }
            return res;
        }

        @Override
        public double[] toDoubleArray() {
            double[] res = new double[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                res[i] = this.getDouble(i);
            }
            return res;
        }
    }
}

