/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.procedure;

import java.util.Collections;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.migrate.Migrator;
import org.apache.paimon.spark.catalog.WithPaimonCatalog;
import org.apache.paimon.spark.procedure.BaseProcedure;
import org.apache.paimon.spark.procedure.ProcedureBuilder;
import org.apache.paimon.spark.procedure.ProcedureParameter;
import org.apache.paimon.spark.utils.TableMigrationUtils;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class MigrateFileProcedure
extends BaseProcedure {
    private static final ProcedureParameter[] PARAMETERS = new ProcedureParameter[]{ProcedureParameter.required("source_type", DataTypes.StringType), ProcedureParameter.required("source_table", DataTypes.StringType), ProcedureParameter.required("target_table", DataTypes.StringType), ProcedureParameter.optional("delete_origin", DataTypes.BooleanType), ProcedureParameter.optional("parallelism", DataTypes.IntegerType)};
    private static final StructType OUTPUT_TYPE = new StructType(new StructField[]{new StructField("result", DataTypes.BooleanType, true, Metadata.empty())});

    protected MigrateFileProcedure(TableCatalog tableCatalog) {
        super(tableCatalog);
    }

    @Override
    public ProcedureParameter[] parameters() {
        return PARAMETERS;
    }

    @Override
    public StructType outputType() {
        return OUTPUT_TYPE;
    }

    @Override
    public InternalRow[] call(InternalRow args) {
        String format = args.getString(0);
        String sourceTable = args.getString(1);
        String targetTable = args.getString(2);
        boolean deleteNeed = args.isNullAt(3) ? true : args.getBoolean(3);
        int parallelism = args.isNullAt(4) ? Runtime.getRuntime().availableProcessors() : args.getInt(4);
        Identifier sourceTableId = Identifier.fromString(sourceTable);
        Identifier targetTableId = Identifier.fromString(targetTable);
        Catalog paimonCatalog = ((WithPaimonCatalog)this.tableCatalog()).paimonCatalog();
        try {
            paimonCatalog.getTable(targetTableId);
        }
        catch (Catalog.TableNotExistException e) {
            throw new IllegalArgumentException("Target paimon table does not exist: " + targetTable);
        }
        try {
            Migrator migrator = TableMigrationUtils.getImporter(format, paimonCatalog, sourceTableId.getDatabaseName(), sourceTableId.getObjectName(), targetTableId.getDatabaseName(), targetTableId.getObjectName(), parallelism, Collections.emptyMap());
            migrator.deleteOriginTable(deleteNeed);
            migrator.executeMigrate();
        }
        catch (Exception e) {
            throw new RuntimeException("Call migrate_file error", e);
        }
        return new InternalRow[]{this.newInternalRow(true)};
    }

    public static ProcedureBuilder builder() {
        return new BaseProcedure.Builder<MigrateFileProcedure>(){

            @Override
            public MigrateFileProcedure doBuild() {
                return new MigrateFileProcedure(this.tableCatalog());
            }
        };
    }

    @Override
    public String description() {
        return "MigrateFileProcedure";
    }
}

