/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.procedure;

import org.apache.paimon.consumer.Consumer;
import org.apache.paimon.consumer.ConsumerManager;
import org.apache.paimon.spark.procedure.BaseProcedure;
import org.apache.paimon.spark.procedure.ProcedureBuilder;
import org.apache.paimon.spark.procedure.ProcedureParameter;
import org.apache.paimon.table.FileStoreTable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class ResetConsumerProcedure
extends BaseProcedure {
    private static final ProcedureParameter[] PARAMETERS = new ProcedureParameter[]{ProcedureParameter.required("table", DataTypes.StringType), ProcedureParameter.required("consumerId", DataTypes.StringType), ProcedureParameter.optional("nextSnapshotId", DataTypes.LongType)};
    private static final StructType OUTPUT_TYPE = new StructType(new StructField[]{new StructField("result", DataTypes.BooleanType, true, Metadata.empty())});

    protected ResetConsumerProcedure(TableCatalog tableCatalog) {
        super(tableCatalog);
    }

    @Override
    public ProcedureParameter[] parameters() {
        return PARAMETERS;
    }

    @Override
    public StructType outputType() {
        return OUTPUT_TYPE;
    }

    @Override
    public InternalRow[] call(InternalRow args) {
        Identifier tableIdent = this.toIdentifier(args.getString(0), PARAMETERS[0].name());
        String consumerId = args.getString(1);
        Long nextSnapshotId = args.isNullAt(2) ? null : Long.valueOf(args.getLong(2));
        return this.modifyPaimonTable(tableIdent, table -> {
            FileStoreTable fileStoreTable = (FileStoreTable)table;
            ConsumerManager consumerManager = new ConsumerManager(fileStoreTable.fileIO(), fileStoreTable.location(), fileStoreTable.snapshotManager().branch());
            if (nextSnapshotId == null) {
                consumerManager.deleteConsumer(consumerId);
            } else {
                fileStoreTable.snapshotManager().snapshot(nextSnapshotId);
                consumerManager.resetConsumer(consumerId, new Consumer(nextSnapshotId));
            }
            InternalRow outputRow = this.newInternalRow(true);
            return new InternalRow[]{outputRow};
        });
    }

    public static ProcedureBuilder builder() {
        return new BaseProcedure.Builder<ResetConsumerProcedure>(){

            @Override
            public ResetConsumerProcedure doBuild() {
                return new ResetConsumerProcedure(this.tableCatalog());
            }
        };
    }

    @Override
    public String description() {
        return "ResetConsumerProcedure";
    }
}

