/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.paimon.utils.ThreadPoolUtils;

public class ManifestReadThreadPool {
    private static final String THREAD_NAME = "MANIFEST-READ-THREAD-POOL";
    private static ThreadPoolExecutor executorService = ThreadPoolUtils.createCachedThreadPool(Runtime.getRuntime().availableProcessors(), "MANIFEST-READ-THREAD-POOL");

    public static synchronized ThreadPoolExecutor getExecutorService(@Nullable Integer threadNum) {
        if (threadNum == null || threadNum <= executorService.getMaximumPoolSize()) {
            return executorService;
        }
        executorService = ThreadPoolUtils.createCachedThreadPool(threadNum, THREAD_NAME);
        return executorService;
    }

    public static <T, U> Iterable<T> sequentialBatchedExecute(Function<U, List<T>> processor, List<U> input, @Nullable Integer threadNum) {
        ThreadPoolExecutor executor = ManifestReadThreadPool.getExecutorService(threadNum);
        return ThreadPoolUtils.sequentialBatchedExecute(executor, processor, input, threadNum);
    }

    public static <T, U> Iterator<T> randomlyExecuteSequentialReturn(Function<U, List<T>> processor, List<U> input, @Nullable Integer threadNum) {
        ThreadPoolExecutor executor = ManifestReadThreadPool.getExecutorService(threadNum);
        return ThreadPoolUtils.randomlyExecuteSequentialReturn(executor, processor, input);
    }
}

