/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data.serializer;

import java.io.IOException;
import org.apache.paimon.data.serializer.SerializerSingleton;
import org.apache.paimon.io.DataInputView;
import org.apache.paimon.io.DataOutputView;
import org.apache.paimon.utils.VarLengthIntUtils;

public final class BinarySerializer
extends SerializerSingleton<byte[]> {
    private static final long serialVersionUID = 1L;
    public static final BinarySerializer INSTANCE = new BinarySerializer();

    @Override
    public byte[] copy(byte[] from) {
        byte[] copy = new byte[from.length];
        System.arraycopy(from, 0, copy, 0, from.length);
        return copy;
    }

    @Override
    public void serialize(byte[] record, DataOutputView target) throws IOException {
        VarLengthIntUtils.encodeInt(target, record.length);
        target.write(record);
    }

    @Override
    public byte[] deserialize(DataInputView source2) throws IOException {
        int len = VarLengthIntUtils.decodeInt(source2);
        byte[] result = new byte[len];
        source2.readFully(result);
        return result;
    }
}

