/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.KeyValue;
import org.apache.paimon.codegen.RecordEqualiser;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.FileReaderFactory;
import org.apache.paimon.io.KeyValueFileWriterFactory;
import org.apache.paimon.mergetree.MergeSorter;
import org.apache.paimon.mergetree.SortedRun;
import org.apache.paimon.mergetree.compact.ChangelogMergeTreeRewriter;
import org.apache.paimon.mergetree.compact.ChangelogResult;
import org.apache.paimon.mergetree.compact.FullChangelogMergeFunctionWrapper;
import org.apache.paimon.mergetree.compact.MergeFunctionFactory;
import org.apache.paimon.mergetree.compact.MergeFunctionWrapper;
import org.apache.paimon.utils.FieldsComparator;
import org.apache.paimon.utils.Preconditions;

public class FullChangelogMergeTreeCompactRewriter
extends ChangelogMergeTreeRewriter {
    @Nullable
    private final RecordEqualiser valueEqualiser;

    public FullChangelogMergeTreeCompactRewriter(int maxLevel, CoreOptions.MergeEngine mergeEngine, FileReaderFactory<KeyValue> readerFactory, KeyValueFileWriterFactory writerFactory, Comparator<InternalRow> keyComparator, @Nullable FieldsComparator userDefinedSeqComparator, MergeFunctionFactory<KeyValue> mfFactory, MergeSorter mergeSorter, @Nullable RecordEqualiser valueEqualiser) {
        super(maxLevel, mergeEngine, readerFactory, writerFactory, keyComparator, userDefinedSeqComparator, mfFactory, mergeSorter, true, false);
        this.valueEqualiser = valueEqualiser;
    }

    @Override
    protected boolean rewriteChangelog(int outputLevel, boolean dropDelete, List<List<SortedRun>> sections) {
        boolean changelog;
        boolean bl = changelog = outputLevel == this.maxLevel;
        if (changelog) {
            Preconditions.checkArgument(dropDelete, "Delete records should be dropped from result of full compaction. This is unexpected.");
        }
        return changelog;
    }

    @Override
    protected ChangelogMergeTreeRewriter.UpgradeStrategy upgradeStrategy(int outputLevel, DataFileMeta file) {
        return outputLevel == this.maxLevel ? ChangelogMergeTreeRewriter.UpgradeStrategy.CHANGELOG_NO_REWRITE : ChangelogMergeTreeRewriter.UpgradeStrategy.NO_CHANGELOG_NO_REWRITE;
    }

    @Override
    protected MergeFunctionWrapper<ChangelogResult> createMergeWrapper(int outputLevel) {
        return new FullChangelogMergeFunctionWrapper(this.mfFactory.create(), this.maxLevel, this.valueEqualiser);
    }

    @Override
    public void close() throws IOException {
    }
}

