/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.apache.orc.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.paimon.shade.org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.paimon.shade.org.apache.hadoop.hive.ql.exec.vector.ListColumnVector;
import org.apache.paimon.shade.org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.paimon.shade.org.apache.hadoop.hive.ql.exec.vector.StructColumnVector;
import org.apache.paimon.shade.org.apache.hadoop.hive.ql.exec.vector.UnionColumnVector;
import org.apache.paimon.shade.org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.paimon.shade.org.apache.orc.TypeDescription;
import org.apache.paimon.shade.org.apache.orc.impl.MaskDescriptionImpl;
import org.apache.paimon.shade.org.apache.orc.impl.SchemaEvolution;

public class ParserUtils {
    private static final Pattern INTEGER_PATTERN = Pattern.compile("^[0-9]+$");

    static TypeDescription.Category parseCategory(StringPosition source2) {
        StringBuilder word = new StringBuilder();
        boolean hadSpace = true;
        while (source2.position < source2.length) {
            char ch = source2.value.charAt(source2.position);
            if (Character.isLetter(ch)) {
                word.append(Character.toLowerCase(ch));
                hadSpace = false;
            } else {
                if (ch != ' ') break;
                if (!hadSpace) {
                    hadSpace = true;
                    word.append(ch);
                }
            }
            ++source2.position;
        }
        String catString = word.toString();
        if (hadSpace) {
            catString = catString.trim();
        }
        if (!catString.isEmpty()) {
            for (TypeDescription.Category cat : TypeDescription.Category.values()) {
                if (!cat.getName().equals(catString)) continue;
                return cat;
            }
        }
        throw new IllegalArgumentException("Can't parse category at " + source2);
    }

    static int parseInt(StringPosition source2) {
        char ch;
        int start = source2.position;
        int result = 0;
        while (source2.position < source2.length && Character.isDigit(ch = source2.value.charAt(source2.position))) {
            result = result * 10 + (ch - 48);
            ++source2.position;
        }
        if (source2.position == start) {
            throw new IllegalArgumentException("Missing integer at " + source2);
        }
        return result;
    }

    public static String parseName(StringPosition source2) {
        char ch;
        if (source2.position == source2.length) {
            throw new IllegalArgumentException("Missing name at " + source2);
        }
        int start = source2.position;
        if (source2.value.charAt(source2.position) == '`') {
            ++source2.position;
            StringBuilder buffer = new StringBuilder();
            boolean closed = false;
            while (source2.position < source2.length) {
                char ch2 = source2.value.charAt(source2.position);
                ++source2.position;
                if (ch2 == '`') {
                    if (source2.position < source2.length && source2.value.charAt(source2.position) == '`') {
                        ++source2.position;
                        buffer.append('`');
                        continue;
                    }
                    closed = true;
                    break;
                }
                buffer.append(ch2);
            }
            if (!closed) {
                source2.position = start;
                throw new IllegalArgumentException("Unmatched quote at " + source2);
            }
            if (buffer.length() == 0) {
                throw new IllegalArgumentException("Empty quoted field name at " + source2);
            }
            return buffer.toString();
        }
        while (source2.position < source2.length && (Character.isLetterOrDigit(ch = source2.value.charAt(source2.position)) || ch == '_')) {
            ++source2.position;
        }
        if (source2.position == start) {
            throw new IllegalArgumentException("Missing name at " + source2);
        }
        return source2.value.substring(start, source2.position);
    }

    static void requireChar(StringPosition source2, char required) {
        if (source2.position >= source2.length || source2.value.charAt(source2.position) != required) {
            throw new IllegalArgumentException("Missing required char '" + required + "' at " + source2);
        }
        ++source2.position;
    }

    private static boolean consumeChar(StringPosition source2, char ch) {
        boolean result;
        boolean bl = result = source2.position < source2.length && source2.value.charAt(source2.position) == ch;
        if (result) {
            ++source2.position;
        }
        return result;
    }

    private static void parseUnion(TypeDescription type, StringPosition source2) {
        ParserUtils.requireChar(source2, '<');
        do {
            type.addUnionChild(ParserUtils.parseType(source2));
        } while (ParserUtils.consumeChar(source2, ','));
        ParserUtils.requireChar(source2, '>');
    }

    private static void parseStruct(TypeDescription type, StringPosition source2) {
        ParserUtils.requireChar(source2, '<');
        boolean needComma = false;
        while (!ParserUtils.consumeChar(source2, '>')) {
            if (needComma) {
                ParserUtils.requireChar(source2, ',');
            } else {
                needComma = true;
            }
            String fieldName = ParserUtils.parseName(source2);
            ParserUtils.requireChar(source2, ':');
            type.addField(fieldName, ParserUtils.parseType(source2));
        }
    }

    public static TypeDescription parseType(StringPosition source2) {
        TypeDescription result = new TypeDescription(ParserUtils.parseCategory(source2));
        switch (result.getCategory()) {
            case BINARY: 
            case BOOLEAN: 
            case BYTE: 
            case DATE: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case SHORT: 
            case STRING: 
            case TIMESTAMP: 
            case TIMESTAMP_INSTANT: {
                break;
            }
            case CHAR: 
            case VARCHAR: {
                ParserUtils.requireChar(source2, '(');
                result.withMaxLength(ParserUtils.parseInt(source2));
                ParserUtils.requireChar(source2, ')');
                break;
            }
            case DECIMAL: {
                ParserUtils.requireChar(source2, '(');
                int precision = ParserUtils.parseInt(source2);
                ParserUtils.requireChar(source2, ',');
                result.withScale(ParserUtils.parseInt(source2));
                result.withPrecision(precision);
                ParserUtils.requireChar(source2, ')');
                break;
            }
            case LIST: {
                ParserUtils.requireChar(source2, '<');
                TypeDescription child = ParserUtils.parseType(source2);
                result.addChild(child);
                ParserUtils.requireChar(source2, '>');
                break;
            }
            case MAP: {
                ParserUtils.requireChar(source2, '<');
                TypeDescription keyType = ParserUtils.parseType(source2);
                result.addChild(keyType);
                ParserUtils.requireChar(source2, ',');
                TypeDescription valueType = ParserUtils.parseType(source2);
                result.addChild(valueType);
                ParserUtils.requireChar(source2, '>');
                break;
            }
            case UNION: {
                ParserUtils.parseUnion(result, source2);
                break;
            }
            case STRUCT: {
                ParserUtils.parseStruct(result, source2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type " + (Object)((Object)result.getCategory()) + " at " + source2);
            }
        }
        return result;
    }

    private static List<String> splitName(StringPosition source2) {
        ArrayList<String> result = new ArrayList<String>();
        do {
            result.add(ParserUtils.parseName(source2));
        } while (ParserUtils.consumeChar(source2, '.'));
        return result;
    }

    public static TypeDescription findSubtype(TypeDescription schema, StringPosition source2) {
        return ParserUtils.findSubtype(schema, source2, true);
    }

    public static TypeDescription findSubtype(TypeDescription schema, StringPosition source2, boolean isSchemaEvolutionCaseAware) {
        TypeFinder result = new TypeFinder(ParserUtils.removeAcid(schema));
        ParserUtils.findColumn(result.current, source2, isSchemaEvolutionCaseAware, (TypeVisitor)result);
        return result.current;
    }

    private static TypeDescription removeAcid(TypeDescription schema) {
        return SchemaEvolution.checkAcidSchema(schema) ? SchemaEvolution.getBaseRow(schema) : schema;
    }

    private static int findCaseInsensitive(List<String> list, String goal) {
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).equalsIgnoreCase(goal)) continue;
            return i;
        }
        return -1;
    }

    public static void findSubtype(TypeDescription schema, int goal, TypeVisitor visitor) {
        TypeDescription current = schema;
        int id = schema.getId();
        if (goal < id || goal > schema.getMaximumId()) {
            throw new IllegalArgumentException("Unknown type id " + goal + " in " + current.toJson());
        }
        while (id != goal) {
            List<TypeDescription> children = current.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                TypeDescription child = children.get(i);
                if (goal > child.getMaximumId()) continue;
                current = child;
                visitor.visit(current, i);
                break;
            }
            id = current.getId();
        }
    }

    public static void findColumn(TypeDescription schema, StringPosition source2, boolean isSchemaEvolutionCaseAware, TypeVisitor visitor) {
        ParserUtils.findColumn(schema, ParserUtils.splitName(source2), isSchemaEvolutionCaseAware, visitor);
    }

    public static void findColumn(TypeDescription schema, List<String> names, boolean isSchemaEvolutionCaseAware, TypeVisitor visitor) {
        if (names.size() == 1 && INTEGER_PATTERN.matcher(names.get(0)).matches()) {
            ParserUtils.findSubtype(schema, Integer.parseInt(names.get(0)), visitor);
            return;
        }
        TypeDescription current = schema;
        while (names.size() > 0) {
            int posn;
            String first = names.remove(0);
            switch (current.getCategory()) {
                case STRUCT: {
                    posn = isSchemaEvolutionCaseAware ? current.getFieldNames().indexOf(first) : ParserUtils.findCaseInsensitive(current.getFieldNames(), first);
                    break;
                }
                case LIST: {
                    if (first.equals("_elem")) {
                        posn = 0;
                        break;
                    }
                    posn = -1;
                    break;
                }
                case MAP: {
                    if (first.equals("_key")) {
                        posn = 0;
                        break;
                    }
                    if (first.equals("_value")) {
                        posn = 1;
                        break;
                    }
                    posn = -1;
                    break;
                }
                case UNION: {
                    try {
                        posn = Integer.parseInt(first);
                        if (posn < 0 || posn >= current.getChildren().size()) {
                            throw new NumberFormatException("off end of union");
                        }
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Field " + first + "not found in " + current, e);
                    }
                }
                default: {
                    posn = -1;
                }
            }
            if (posn < 0) {
                throw new IllegalArgumentException("Field " + first + " not found in " + current);
            }
            current = current.getChildren().get(posn);
            visitor.visit(current, posn);
        }
    }

    public static ColumnVector[] findColumnVectors(TypeDescription schema, StringPosition source2, boolean isCaseSensitive, VectorizedRowBatch batch) {
        List<String> names = ParserUtils.splitName(source2);
        TypeDescription schemaToUse = ParserUtils.removeAcid(schema);
        ColumnVector[] columnVectors = SchemaEvolution.checkAcidSchema(schema) ? ((StructColumnVector)batch.cols[batch.cols.length - 1]).fields : batch.cols;
        ColumnFinder result = new ColumnFinder(schemaToUse, columnVectors, names.size());
        ParserUtils.findColumn(schemaToUse, names, isCaseSensitive, (TypeVisitor)result);
        return result.result;
    }

    public static List<TypeDescription> findSubtypeList(TypeDescription schema, StringPosition source2) {
        ArrayList<TypeDescription> result = new ArrayList<TypeDescription>();
        if (source2.hasCharactersLeft()) {
            do {
                result.add(ParserUtils.findSubtype(schema, source2));
            } while (ParserUtils.consumeChar(source2, ','));
        }
        return result;
    }

    public static void parseKeys(StringPosition source2, TypeDescription schema) {
        if (source2.hasCharactersLeft()) {
            do {
                String keyName = ParserUtils.parseName(source2);
                ParserUtils.requireChar(source2, ':');
                for (TypeDescription field : ParserUtils.findSubtypeList(schema, source2)) {
                    String prev = field.getAttributeValue("encrypt");
                    if (prev != null && !prev.equals(keyName)) {
                        throw new IllegalArgumentException("Conflicting encryption keys " + keyName + " and " + prev);
                    }
                    field.setAttribute("encrypt", keyName);
                }
            } while (ParserUtils.consumeChar(source2, ';'));
        }
    }

    public static void parseMasks(StringPosition source2, TypeDescription schema) {
        if (source2.hasCharactersLeft()) {
            do {
                int start = source2.position;
                ParserUtils.parseName(source2);
                while (ParserUtils.consumeChar(source2, ',')) {
                    ParserUtils.parseName(source2);
                }
                String maskString = source2.fromPosition(start);
                ParserUtils.requireChar(source2, ':');
                for (TypeDescription field : ParserUtils.findSubtypeList(schema, source2)) {
                    String prev = field.getAttributeValue("mask");
                    if (prev != null && !prev.equals(maskString)) {
                        throw new IllegalArgumentException("Conflicting encryption masks " + maskString + " and " + prev);
                    }
                    field.setAttribute("mask", maskString);
                }
            } while (ParserUtils.consumeChar(source2, ';'));
        }
    }

    public static MaskDescriptionImpl buildMaskDescription(String value) {
        StringPosition source2 = new StringPosition(value);
        String maskName = ParserUtils.parseName(source2);
        ArrayList<String> params = new ArrayList<String>();
        while (ParserUtils.consumeChar(source2, ',')) {
            params.add(ParserUtils.parseName(source2));
        }
        return new MaskDescriptionImpl(maskName, params.toArray(new String[0]));
    }

    public static class StringPosition {
        final String value;
        int position;
        final int length;

        public StringPosition(String value) {
            this.value = value == null ? "" : value;
            this.position = 0;
            this.length = this.value.length();
        }

        public String toString() {
            return '\'' + this.value.substring(0, this.position) + '^' + this.value.substring(this.position) + '\'';
        }

        public String fromPosition(int start) {
            return this.value.substring(start, this.position);
        }

        public boolean hasCharactersLeft() {
            return this.position != this.length;
        }
    }

    static class ColumnFinder
    implements TypeVisitor {
        private ColumnVector[] top;
        private ColumnVector current = null;
        private final ColumnVector[] result;
        private int resultIdx = 0;

        ColumnFinder(TypeDescription schema, ColumnVector[] columnVectors, int levels) {
            if (schema.getCategory() == TypeDescription.Category.STRUCT) {
                this.top = columnVectors;
                this.result = new ColumnVector[levels];
            } else {
                this.result = new ColumnVector[levels + 1];
                this.current = columnVectors[0];
                this.top = null;
                this.addResult(this.current);
            }
        }

        ColumnFinder(TypeDescription schema, VectorizedRowBatch vectorizedRowBatch, int levels) {
            this(schema, vectorizedRowBatch.cols, levels);
        }

        private void addResult(ColumnVector vector) {
            this.result[this.resultIdx] = vector;
            ++this.resultIdx;
        }

        @Override
        public void visit(TypeDescription type, int posn) {
            if (this.current == null) {
                this.current = this.top[posn];
                this.top = null;
            } else {
                this.current = this.navigate(this.current, posn);
            }
            this.addResult(this.current);
        }

        private ColumnVector navigate(ColumnVector parent, int posn) {
            if (parent instanceof ListColumnVector) {
                return ((ListColumnVector)parent).child;
            }
            if (parent instanceof StructColumnVector) {
                return ((StructColumnVector)parent).fields[posn];
            }
            if (parent instanceof UnionColumnVector) {
                return ((UnionColumnVector)parent).fields[posn];
            }
            if (parent instanceof MapColumnVector) {
                MapColumnVector m = (MapColumnVector)parent;
                return posn == 0 ? m.keys : m.values;
            }
            throw new IllegalArgumentException("Unknown complex column vector " + parent.getClass());
        }
    }

    public static class TypeFinder
    implements TypeVisitor {
        public TypeDescription current;

        public TypeFinder(TypeDescription schema) {
            this.current = schema;
        }

        @Override
        public void visit(TypeDescription type, int posn) {
            this.current = type;
        }
    }

    public static interface TypeVisitor {
        public void visit(TypeDescription var1, int var2);
    }
}

