/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.commands;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.Snapshot;
import org.apache.paimon.codegen.CodeGenUtils;
import org.apache.paimon.codegen.Projection;
import org.apache.paimon.crosspartition.IndexBootstrap;
import org.apache.paimon.crosspartition.KeyPartOrRow;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.serializer.InternalRowSerializer;
import org.apache.paimon.data.serializer.InternalSerializers;
import org.apache.paimon.deletionvectors.DeletionVector;
import org.apache.paimon.deletionvectors.append.BaseAppendDeleteFileMaintainer;
import org.apache.paimon.index.BucketAssigner;
import org.apache.paimon.index.IndexFileHandler;
import org.apache.paimon.index.SimpleHashBucketAssigner;
import org.apache.paimon.io.CompactIncrement;
import org.apache.paimon.io.DataIncrement;
import org.apache.paimon.io.IndexIncrement;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.manifest.IndexManifestEntry;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.spark.SparkRow;
import org.apache.paimon.spark.SparkTableWrite;
import org.apache.paimon.spark.SparkTypeUtils;
import org.apache.paimon.spark.catalog.functions.BucketFunction$;
import org.apache.paimon.spark.commands.BucketExpression$;
import org.apache.paimon.spark.commands.BucketProcessor;
import org.apache.paimon.spark.commands.CommonBucketProcessor;
import org.apache.paimon.spark.commands.DynamicBucketProcessor;
import org.apache.paimon.spark.commands.EncoderSerDeGroup;
import org.apache.paimon.spark.commands.GlobalDynamicBucketProcessor;
import org.apache.paimon.spark.commands.PaimonSparkWriter$;
import org.apache.paimon.spark.commands.PaimonSparkWriter$ModPartitioner$;
import org.apache.paimon.spark.commands.SparkDeletionVector;
import org.apache.paimon.spark.schema.SparkSystemColumns$;
import org.apache.paimon.spark.util.OptionUtils$;
import org.apache.paimon.spark.util.SparkRowUtils$;
import org.apache.paimon.spark.write.WriteHelper;
import org.apache.paimon.table.BucketMode;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.sink.BatchTableCommit;
import org.apache.paimon.table.sink.BatchWriteBuilder;
import org.apache.paimon.table.sink.CommitMessage;
import org.apache.paimon.table.sink.CommitMessageImpl;
import org.apache.paimon.table.sink.CommitMessageSerializer;
import org.apache.paimon.table.sink.RowPartitionKeyExtractor;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.CloseableIterator;
import org.apache.paimon.utils.SerializationUtils;
import org.apache.spark.Partitioner;
import org.apache.spark.TaskContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\teg\u0001B\u001d;\u0001\u0016C\u0001\u0002\u0017\u0001\u0003\u0016\u0004%\t!\u0017\u0005\t?\u0002\u0011\t\u0012)A\u00055\")\u0001\r\u0001C\u0001C\"AQ\r\u0001EC\u0002\u0013%a\r\u0003\u0005n\u0001!\u0015\r\u0011\"\u0003o\u0011!)\b\u0001#b\u0001\n\u00131\b\u0002\u0003>\u0001\u0011\u000b\u0007I\u0011B>\t\u0013\u00055\u0001A1A\u0005\u0002\u0005=\u0001\u0002CA\f\u0001\u0001\u0006I!!\u0005\t\u000f\u0005e\u0001\u0001\"\u0001\u0002\u001c!1q\n\u0001C\u0001\u0003;Aq!a\u0019\u0001\t\u0003\t)\u0007C\u0004\u0002z\u0001!\t!a\u001f\t\u000f\u0005\u001d\u0005\u0001\"\u0003\u0002\n\"9\u0011q\u0019\u0001\u0005\n\u0005%\u0007bBAo\u0001\u0011%\u0011q\u001c\u0005\b\u0003K\u0004A\u0011BAt\r\u0019\ty\u000f\u0001#\u0002r\"Q\u00111 \n\u0003\u0016\u0004%\t!!@\t\u0015\u0005}(C!E!\u0002\u0013\tY\f\u0003\u0004a%\u0011\u0005!\u0011\u0001\u0005\b\u0005\u0013\u0011B\u0011IA\u007f\u0011\u001d\u0011YA\u0005C!\u0005\u001bA\u0011B!\u0007\u0013\u0003\u0003%\tAa\u0007\t\u0013\t}!#%A\u0005\u0002\t\u0005\u0002\"\u0003B\u001c%\u0005\u0005I\u0011\tB\u001d\u0011%\u0011YEEA\u0001\n\u0003\ti\u0010C\u0005\u0003NI\t\t\u0011\"\u0001\u0003P!I!Q\u000b\n\u0002\u0002\u0013\u0005#q\u000b\u0005\n\u0005K\u0012\u0012\u0011!C\u0001\u0005OB\u0011B!\u001d\u0013\u0003\u0003%\tEa\u001d\t\u0013\tU$#!A\u0005B\t]\u0004\"\u0003B=%\u0005\u0005I\u0011\tB>\u000f%\u0011y\bAA\u0001\u0012\u0013\u0011\tIB\u0005\u0002p\u0002\t\t\u0011#\u0003\u0003\u0004\"1\u0001m\tC\u0001\u0005#C\u0011B!\u001e$\u0003\u0003%)Ea\u001e\t\u0013\tM5%!A\u0005\u0002\nU\u0005\"\u0003BMG\u0005\u0005I\u0011\u0011BN\u0011%\u0011I\u0002AA\u0001\n\u0003\u00119\u000bC\u0005\u0003 \u0001\t\n\u0011\"\u0001\u0003,\"I!q\u0007\u0001\u0002\u0002\u0013\u0005#\u0011\b\u0005\n\u0005\u0017\u0002\u0011\u0011!C\u0001\u0003{D\u0011B!\u0014\u0001\u0003\u0003%\tAa,\t\u0013\tU\u0003!!A\u0005B\t]\u0003\"\u0003B3\u0001\u0005\u0005I\u0011\u0001BZ\u0011%\u0011\t\bAA\u0001\n\u0003\u0012\u0019\bC\u0005\u0003v\u0001\t\t\u0011\"\u0011\u0003x!I!\u0011\u0010\u0001\u0002\u0002\u0013\u0005#qW\u0004\n\u0005wS\u0014\u0011!E\u0001\u0005{3\u0001\"\u000f\u001e\u0002\u0002#\u0005!q\u0018\u0005\u0007AN\"\tAa1\t\u0013\tU4'!A\u0005F\t]\u0004\"\u0003BJg\u0005\u0005I\u0011\u0011Bc\u0011%\u0011IjMA\u0001\n\u0003\u0013I\rC\u0005\u0003PN\n\t\u0011\"\u0003\u0003R\n\t\u0002+Y5n_:\u001c\u0006/\u0019:l/JLG/\u001a:\u000b\u0005mb\u0014\u0001C2p[6\fg\u000eZ:\u000b\u0005ur\u0014!B:qCJ\\'BA A\u0003\u0019\u0001\u0018-[7p]*\u0011\u0011IQ\u0001\u0007CB\f7\r[3\u000b\u0003\r\u000b1a\u001c:h\u0007\u0001\u0019R\u0001\u0001$M%V\u0003\"a\u0012&\u000e\u0003!S\u0011!S\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0017\"\u0013a!\u00118z%\u00164\u0007CA'Q\u001b\u0005q%BA(=\u0003\u00159(/\u001b;f\u0013\t\tfJA\u0006Xe&$X\rS3ma\u0016\u0014\bCA$T\u0013\t!\u0006JA\u0004Qe>$Wo\u0019;\u0011\u0005\u001d3\u0016BA,I\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0015!\u0018M\u00197f+\u0005Q\u0006CA.^\u001b\u0005a&B\u0001-?\u0013\tqFL\u0001\bGS2,7\u000b^8sKR\u000b'\r\\3\u0002\rQ\f'\r\\3!\u0003\u0019a\u0014N\\5u}Q\u0011!\r\u001a\t\u0003G\u0002i\u0011A\u000f\u0005\u00061\u000e\u0001\rAW\u0001\fi\u0006\u0014G.Z*dQ\u0016l\u0017-F\u0001h!\tA7.D\u0001j\u0015\tQg(\u0001\u0004tG\",W.Y\u0005\u0003Y&\u00141\u0002V1cY\u0016\u001c6\r[3nC\u00069!o\\<UsB,W#A8\u0011\u0005A\u001cX\"A9\u000b\u0005It\u0014!\u0002;za\u0016\u001c\u0018B\u0001;r\u0005\u001d\u0011vn\u001e+za\u0016\f!BY;dW\u0016$Xj\u001c3f+\u00059\bCA.y\u0013\tIHL\u0001\u0006Ck\u000e\\W\r^'pI\u0016\f!b]3sS\u0006d\u0017N_3s+\u0005a\bcA?\u0002\u00025\taP\u0003\u0002\u00009\u0006!1/\u001b8l\u0013\r\t\u0019A \u0002\u0018\u0007>lW.\u001b;NKN\u001c\u0018mZ3TKJL\u0017\r\\5{KJD3aBA\u0004!\r9\u0015\u0011B\u0005\u0004\u0003\u0017A%!\u0003;sC:\u001c\u0018.\u001a8u\u000319(/\u001b;f\u0005VLG\u000eZ3s+\t\t\t\u0002E\u0002~\u0003'I1!!\u0006\u007f\u0005E\u0011\u0015\r^2i/JLG/\u001a\"vS2$WM]\u0001\u000eoJLG/\u001a\"vS2$WM\u001d\u0011\u0002\u0013]\u0014\u0018\u000e^3P]2LH#\u00012\u0015\t\u0005}\u0011Q\b\t\u0007\u0003C\t\t$a\u000e\u000f\t\u0005\r\u0012Q\u0006\b\u0005\u0003K\tY#\u0004\u0002\u0002()\u0019\u0011\u0011\u0006#\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0015bAA\u0018\u0011\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\u001a\u0003k\u00111aU3r\u0015\r\ty\u0003\u0013\t\u0004{\u0006e\u0012bAA\u001e}\ni1i\\7nSRlUm]:bO\u0016Dq!a\u0010\f\u0001\u0004\t\t%\u0001\u0003eCR\f\u0007\u0003BA\"\u0003;rA!!\u0012\u0002Z9!\u0011qIA*\u001d\u0011\tI%!\u0015\u000f\t\u0005-\u0013q\n\b\u0005\u0003K\ti%C\u0001D\u0013\t\t%)\u0003\u0002>\u0001&!\u0011QKA,\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003{\u0001KA!a\f\u0002\\)!\u0011QKA,\u0013\u0011\ty&!\u0019\u0003\u0013\u0011\u000bG/\u0019$sC6,'\u0002BA\u0018\u00037\na\u0003]3sg&\u001cH\u000fR3mKRLwN\u001c,fGR|'o\u001d\u000b\u0005\u0003?\t9\u0007C\u0004\u0002j1\u0001\r!a\u001b\u0002\u001f\u0011,G.\u001a;j_:4Vm\u0019;peN\u0004b!!\u001c\u0002p\u0005MTBAA.\u0013\u0011\t\t(a\u0017\u0003\u000f\u0011\u000bG/Y:fiB\u00191-!\u001e\n\u0007\u0005]$HA\nTa\u0006\u00148\u000eR3mKRLwN\u001c,fGR|'/\u0001\u0004d_6l\u0017\u000e\u001e\u000b\u0005\u0003{\n\u0019\tE\u0002H\u0003\u007fJ1!!!I\u0005\u0011)f.\u001b;\t\u000f\u0005\u0015U\u00021\u0001\u0002 \u0005q1m\\7nSRlUm]:bO\u0016\u001c\u0018\u0001\t2p_R\u001cHO]1q\u0003:$'+\u001a9beRLG/[8o\u0005f\\U-\u001f%bg\"$\"\"a#\u00026\u0006]\u0016\u0011YAc!\u0019\ti)a%\u0002\u00186\u0011\u0011q\u0012\u0006\u0005\u0003#\u000b9&A\u0002sI\u0012LA!!&\u0002\u0010\n\u0019!\u000b\u0012#\u0011\u000f\u001d\u000bI*!(\u0002*&\u0019\u00111\u0014%\u0003\rQ+\b\u000f\\33!\u0011\ty*!*\u000e\u0005\u0005\u0005&bAAR}\u0005q1M]8tgB\f'\u000f^5uS>t\u0017\u0002BAT\u0003C\u0013AbS3z!\u0006\u0014Ho\u0014:S_^\u0004RaRAV\u0003_K1!!,I\u0005\u0015\t%O]1z!\r9\u0015\u0011W\u0005\u0004\u0003gC%\u0001\u0002\"zi\u0016Dq!a\u0010\u000f\u0001\u0004\t\t\u0005C\u0004\u0002::\u0001\r!a/\u0002\u0017A\f'/\u00197mK2L7/\u001c\t\u0004\u000f\u0006u\u0016bAA`\u0011\n\u0019\u0011J\u001c;\t\u000f\u0005\rg\u00021\u0001\u0002<\u0006i!o\\<LS:$7i\u001c7JIbDQ!\u001c\bA\u0002=\fQD]3qCJ$\u0018\u000e^5p]\nK8*Z=QCJ$\u0018\u000e^5p]\"\u000b7\u000f\u001b\u000b\u000b\u0003\u0003\nY-!6\u0002X\u0006e\u0007bBAg\u001f\u0001\u0007\u0011qZ\u0001\rgB\f'o[*fgNLwN\u001c\t\u0005\u0003[\n\t.\u0003\u0003\u0002T\u0006m#\u0001D*qCJ\\7+Z:tS>t\u0007bBA \u001f\u0001\u0007\u0011\u0011\t\u0005\b\u0003s{\u0001\u0019AA^\u0011\u001d\tYn\u0004a\u0001\u0003w\u000bAB\\;n\u0003N\u001c\u0018n\u001a8feN\f\u0001E]3qCJ$\u0018\u000e^5p]\nK\b+\u0019:uSRLwN\\:B]\u0012\u0014UoY6fiR!\u0011\u0011IAq\u0011\u001d\t\u0019\u000f\u0005a\u0001\u0003\u0003\n!\u0001\u001a4\u00021\u0011,7/\u001a:jC2L'0Z\"p[6LG/T3tg\u0006<W\r\u0006\u0004\u00028\u0005%\u00181\u001e\u0005\u0006uF\u0001\r\u0001 \u0005\b\u0003[\f\u0002\u0019AAU\u0003\u0015\u0011\u0017\u0010^3t\u00059iu\u000e\u001a)beRLG/[8oKJ\u001cRAEAz%V\u0003B!!>\u0002x6\u0011\u0011qK\u0005\u0005\u0003s\f9FA\u0006QCJ$\u0018\u000e^5p]\u0016\u0014\u0018A\u00039beRLG/[8ogV\u0011\u00111X\u0001\fa\u0006\u0014H/\u001b;j_:\u001c\b\u0005\u0006\u0003\u0003\u0004\t\u001d\u0001c\u0001B\u0003%5\t\u0001\u0001C\u0004\u0002|V\u0001\r!a/\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t\u000319W\r\u001e)beRLG/[8o)\u0011\tYLa\u0004\t\u000f\tEq\u00031\u0001\u0003\u0014\u0005\u00191.Z=\u0011\u0007\u001d\u0013)\"C\u0002\u0003\u0018!\u00131!\u00118z\u0003\u0011\u0019w\u000e]=\u0015\t\t\r!Q\u0004\u0005\n\u0003wD\u0002\u0013!a\u0001\u0003w\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003$)\"\u00111\u0018B\u0013W\t\u00119\u0003\u0005\u0003\u0003*\tMRB\u0001B\u0016\u0015\u0011\u0011iCa\f\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u0019\u0011\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tU\"1\u0006\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003<A!!Q\bB$\u001b\t\u0011yD\u0003\u0003\u0003B\t\r\u0013\u0001\u00027b]\u001eT!A!\u0012\u0002\t)\fg/Y\u0005\u0005\u0005\u0013\u0012yD\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011\u0019B!\u0015\t\u0013\tMC$!AA\u0002\u0005m\u0016a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003ZA1!1\fB1\u0005'i!A!\u0018\u000b\u0007\t}\u0003*\u0001\u0006d_2dWm\u0019;j_:LAAa\u0019\u0003^\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u0011IGa\u001c\u0011\u0007\u001d\u0013Y'C\u0002\u0003n!\u0013qAQ8pY\u0016\fg\u000eC\u0005\u0003Ty\t\t\u00111\u0001\u0003\u0014\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002<\u0006AAo\\*ue&tw\r\u0006\u0002\u0003<\u00051Q-];bYN$BA!\u001b\u0003~!I!1K\u0011\u0002\u0002\u0003\u0007!1C\u0001\u000f\u001b>$\u0007+\u0019:uSRLwN\\3s!\r\u0011)aI\n\u0005G\t\u0015U\u000b\u0005\u0005\u0003\b\n5\u00151\u0018B\u0002\u001b\t\u0011IIC\u0002\u0003\f\"\u000bqA];oi&lW-\u0003\u0003\u0003\u0010\n%%!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocQ\u0011!\u0011Q\u0001\u0006CB\u0004H.\u001f\u000b\u0005\u0005\u0007\u00119\nC\u0004\u0002|\u001a\u0002\r!a/\u0002\u000fUt\u0017\r\u001d9msR!!Q\u0014BR!\u00159%qTA^\u0013\r\u0011\t\u000b\u0013\u0002\u0007\u001fB$\u0018n\u001c8\t\u0013\t\u0015v%!AA\u0002\t\r\u0011a\u0001=%aQ\u0019!M!+\t\u000faC\u0003\u0013!a\u00015V\u0011!Q\u0016\u0016\u00045\n\u0015B\u0003\u0002B\n\u0005cC\u0011Ba\u0015-\u0003\u0003\u0005\r!a/\u0015\t\t%$Q\u0017\u0005\n\u0005'r\u0013\u0011!a\u0001\u0005'!BA!\u001b\u0003:\"I!1K\u0019\u0002\u0002\u0003\u0007!1C\u0001\u0012!\u0006LWn\u001c8Ta\u0006\u00148n\u0016:ji\u0016\u0014\bCA24'\u0011\u0019$\u0011Y+\u0011\r\t\u001d%Q\u0012.c)\t\u0011i\fF\u0002c\u0005\u000fDQ\u0001\u0017\u001cA\u0002i#BAa3\u0003NB!qIa([\u0011!\u0011)kNA\u0001\u0002\u0004\u0011\u0017a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa5\u0011\t\tu\"Q[\u0005\u0005\u0005/\u0014yD\u0001\u0004PE*,7\r\u001e")
public class PaimonSparkWriter
implements WriteHelper,
Product,
scala.Serializable {
    private TableSchema tableSchema;
    private RowType rowType;
    private BucketMode bucketMode;
    private transient CommitMessageSerializer serializer;
    private volatile PaimonSparkWriter$ModPartitioner$ ModPartitioner$module;
    private final FileStoreTable table;
    private final BatchWriteBuilder writeBuilder;
    private CoreOptions coreOptions;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<FileStoreTable> unapply(PaimonSparkWriter paimonSparkWriter) {
        return PaimonSparkWriter$.MODULE$.unapply(paimonSparkWriter);
    }

    public static PaimonSparkWriter apply(FileStoreTable fileStoreTable) {
        return PaimonSparkWriter$.MODULE$.apply(fileStoreTable);
    }

    public static <A> Function1<FileStoreTable, A> andThen(Function1<PaimonSparkWriter, A> function1) {
        return PaimonSparkWriter$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, PaimonSparkWriter> compose(Function1<A, FileStoreTable> function1) {
        return PaimonSparkWriter$.MODULE$.compose(function1);
    }

    @Override
    public void postCommit(Seq<CommitMessage> messages) {
        WriteHelper.postCommit$(this, messages);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    private PaimonSparkWriter$ModPartitioner$ ModPartitioner() {
        if (this.ModPartitioner$module == null) {
            this.ModPartitioner$lzycompute$1();
        }
        return this.ModPartitioner$module;
    }

    private CoreOptions coreOptions$lzycompute() {
        PaimonSparkWriter paimonSparkWriter = this;
        synchronized (paimonSparkWriter) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.coreOptions = WriteHelper.coreOptions$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.coreOptions;
    }

    @Override
    public CoreOptions coreOptions() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.coreOptions$lzycompute();
        }
        return this.coreOptions;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public FileStoreTable table() {
        return this.table;
    }

    private TableSchema tableSchema$lzycompute() {
        PaimonSparkWriter paimonSparkWriter = this;
        synchronized (paimonSparkWriter) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.tableSchema = this.table().schema();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.tableSchema;
    }

    private TableSchema tableSchema() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.tableSchema$lzycompute();
        }
        return this.tableSchema;
    }

    private RowType rowType$lzycompute() {
        PaimonSparkWriter paimonSparkWriter = this;
        synchronized (paimonSparkWriter) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.rowType = this.table().rowType();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.rowType;
    }

    private RowType rowType() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.rowType$lzycompute();
        }
        return this.rowType;
    }

    private BucketMode bucketMode$lzycompute() {
        PaimonSparkWriter paimonSparkWriter = this;
        synchronized (paimonSparkWriter) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.bucketMode = this.table().bucketMode();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.bucketMode;
    }

    private BucketMode bucketMode() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.bucketMode$lzycompute();
        }
        return this.bucketMode;
    }

    private CommitMessageSerializer serializer$lzycompute() {
        PaimonSparkWriter paimonSparkWriter = this;
        synchronized (paimonSparkWriter) {
            if (!this.bitmap$trans$0) {
                this.serializer = new CommitMessageSerializer();
                this.bitmap$trans$0 = true;
            }
        }
        return this.serializer;
    }

    private CommitMessageSerializer serializer() {
        if (!this.bitmap$trans$0) {
            return this.serializer$lzycompute();
        }
        return this.serializer;
    }

    public BatchWriteBuilder writeBuilder() {
        return this.writeBuilder;
    }

    public PaimonSparkWriter writeOnly() {
        return new PaimonSparkWriter((FileStoreTable)this.table().copy((Map)Collections.singletonMap(CoreOptions.WRITE_ONLY.key(), "true")));
    }

    public Seq<CommitMessage> write(Dataset<Row> data) {
        Dataset dataset;
        SparkSession sparkSession = data.sparkSession();
        BucketMode bucketMode = this.bucketMode();
        Dataset withInitBucketCol = ((Object)((Object)BucketMode.BUCKET_UNAWARE)).equals((Object)bucketMode) ? data : (((Object)((Object)BucketMode.CROSS_PARTITION)).equals((Object)bucketMode) && !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])data.schema().fieldNames())).contains((Object)SparkSystemColumns$.MODULE$.ROW_KIND_COL()) ? data.withColumn(SparkSystemColumns$.MODULE$.ROW_KIND_COL(), functions$.MODULE$.lit((Object)BoxesRunTime.boxToByte((byte)RowKind.INSERT.toByteValue()))).withColumn(SparkSystemColumns$.MODULE$.BUCKET_COL(), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)-1))) : data.withColumn(SparkSystemColumns$.MODULE$.BUCKET_COL(), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)-1))));
        int rowKindColIdx = SparkRowUtils$.MODULE$.getFieldIndex(withInitBucketCol.schema(), SparkSystemColumns$.MODULE$.ROW_KIND_COL());
        int bucketColIdx = SparkRowUtils$.MODULE$.getFieldIndex(withInitBucketCol.schema(), SparkSystemColumns$.MODULE$.BUCKET_COL());
        EncoderSerDeGroup encoderGroupWithBucketCol = new EncoderSerDeGroup(withInitBucketCol.schema());
        BucketMode bucketMode2 = this.bucketMode();
        if (((Object)((Object)BucketMode.CROSS_PARTITION)).equals((Object)bucketMode2)) {
            RowType rowType = (RowType)SparkTypeUtils.toPaimonType((DataType)withInitBucketCol.schema());
            int assignerParallelism = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)this.coreOptions().dynamicBucketAssignerParallelism()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$1))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> PaimonSparkWriter.sparkParallelism$1(sparkSession)));
            RDD<Tuple2<KeyPartOrRow, byte[]>> bootstrapped = this.bootstrapAndRepartitionByKeyHash((Dataset<Row>)withInitBucketCol, assignerParallelism, rowKindColIdx, rowType);
            GlobalDynamicBucketProcessor globalDynamicBucketProcessor = new GlobalDynamicBucketProcessor(this.table(), rowType, Predef$.MODULE$.int2Integer(assignerParallelism), encoderGroupWithBucketCol);
            Dataset<Row> repartitioned = this.repartitionByPartitionsAndBucket((Dataset<Row>)sparkSession.createDataFrame(bootstrapped.mapPartitions((Function1 & Serializable & scala.Serializable)rowIterator -> globalDynamicBucketProcessor.processPartition((Iterator<Tuple2<KeyPartOrRow, byte[]>>)rowIterator), bootstrapped.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Row.class)), withInitBucketCol.schema()));
            dataset = this.writeWithBucket$1(repartitioned, bucketColIdx, sparkSession, rowKindColIdx);
        } else if (((Object)((Object)BucketMode.HASH_DYNAMIC)).equals((Object)bucketMode2)) {
            int parallelism = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)this.coreOptions().dynamicBucketAssignerParallelism()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$2))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> PaimonSparkWriter.sparkParallelism$1(sparkSession)));
            int assignerParallelism = !BoxesRunTime.equalsNumObject((Number)this.coreOptions().dynamicBucketMaxBuckets(), (Object)BoxesRunTime.boxToInteger((int)-1)) ? Math.min(Predef$.MODULE$.Integer2int(this.coreOptions().dynamicBucketMaxBuckets()), parallelism) : parallelism;
            int numAssigners = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)this.coreOptions().dynamicBucketInitialBuckets()).map((Function1 & Serializable & scala.Serializable)initialBuckets -> BoxesRunTime.boxToInteger((int)PaimonSparkWriter.$anonfun$write$13(assignerParallelism, initialBuckets))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> assignerParallelism));
            dataset = this.table().snapshotManager().latestSnapshotFromFileSystem() == null ? this.writeWithBucketAssigner$1(this.partitionByKey$1(sparkSession, withInitBucketCol, assignerParallelism, numAssigners), (Function0 & Serializable & scala.Serializable)() -> {
                RowPartitionKeyExtractor extractor = new RowPartitionKeyExtractor(this.table().schema());
                SimpleHashBucketAssigner assigner = new SimpleHashBucketAssigner(numAssigners, TaskContext$.MODULE$.getPartitionId(), this.coreOptions().dynamicBucketTargetRowNum(), Predef$.MODULE$.Integer2int(this.coreOptions().dynamicBucketMaxBuckets()));
                return (Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToInteger((int)PaimonSparkWriter.$anonfun$write$16(this, assigner, extractor, row));
            }, sparkSession, rowKindColIdx) : this.writeWithBucketProcessor$1(this.partitionByKey$1(sparkSession, withInitBucketCol, assignerParallelism, numAssigners), new DynamicBucketProcessor(this.table(), bucketColIdx, assignerParallelism, numAssigners, encoderGroupWithBucketCol), encoderGroupWithBucketCol, bucketColIdx, sparkSession, rowKindColIdx);
        } else if (((Object)((Object)BucketMode.BUCKET_UNAWARE)).equals((Object)bucketMode2) ? true : ((Object)((Object)BucketMode.POSTPONE_MODE)).equals((Object)bucketMode2)) {
            dataset = this.writeWithoutBucket$1(data, sparkSession, rowKindColIdx);
        } else if (((Object)((Object)BucketMode.HASH_FIXED)).equals((Object)bucketMode2)) {
            if (OptionUtils$.MODULE$.paimonExtensionEnabled() && BucketFunction$.MODULE$.supportsTable(this.table())) {
                int bucketNumber = this.coreOptions().bucket();
                Seq bucketKeyCol = ((SeqLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.tableSchema().bucketKeys()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)PaimonSparkWriter.$anonfun$write$17(this, x$3)), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x -> functions$.MODULE$.col(data.schema().fieldNames()[BoxesRunTime.unboxToInt((Object)x)]), Buffer$.MODULE$.canBuildFrom())).toSeq();
                Seq args2 = (Seq)((TraversableLike)new .colon.colon((Object)functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)bucketNumber)), (List)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)bucketKeyCol, Seq$.MODULE$.canBuildFrom());
                Dataset<Row> repartitioned = this.repartitionByPartitionsAndBucket((Dataset<Row>)data.withColumn(SparkSystemColumns$.MODULE$.BUCKET_COL(), functions$.MODULE$.call_udf(BucketExpression$.MODULE$.FIXED_BUCKET(), args2)));
                dataset = this.writeWithBucket$1(repartitioned, bucketColIdx, sparkSession, rowKindColIdx);
            } else {
                dataset = this.writeWithBucketProcessor$1(withInitBucketCol, new CommonBucketProcessor(this.table(), bucketColIdx, encoderGroupWithBucketCol), encoderGroupWithBucketCol, bucketColIdx, sparkSession, rowKindColIdx);
            }
        } else {
            throw new UnsupportedOperationException(new StringBuilder(28).append("Spark doesn't support ").append((Object)this.bucketMode()).append(" mode.").toString());
        }
        Dataset written = dataset;
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])written.collect())).map((Function1 & Serializable & scala.Serializable)x$4 -> this.deserializeCommitMessage(this.serializer(), (byte[])x$4), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(CommitMessage.class))))).toSeq();
    }

    public Seq<CommitMessage> persistDeletionVectors(Dataset<SparkDeletionVector> deletionVectors) {
        SparkSession sparkSession = deletionVectors.sparkSession();
        Snapshot snapshot = this.table().snapshotManager().latestSnapshotFromFileSystem();
        Dataset serializedCommits = deletionVectors.groupByKey((Function1 & Serializable & scala.Serializable)x$5 -> x$5.partitionAndBucket(), sparkSession.implicits().newStringEncoder()).mapGroups((Function2 & Serializable & scala.Serializable)(x$6, iter) -> {
            IndexFileHandler indexHandler = this.table().store().newIndexFileHandler();
            BaseAppendDeleteFileMaintainer dvIndexFileMaintainer = null;
            while (iter.hasNext()) {
                SparkDeletionVector sdv = (SparkDeletionVector)iter.next();
                if (dvIndexFileMaintainer == null) {
                    BinaryRow partition = SerializationUtils.deserializeBinaryRow(sdv.partition());
                    BucketMode bucketMode = this.bucketMode();
                    BucketMode bucketMode2 = BucketMode.BUCKET_UNAWARE;
                    BaseAppendDeleteFileMaintainer baseAppendDeleteFileMaintainer = !(bucketMode != null ? !((Object)((Object)bucketMode)).equals((Object)bucketMode2) : bucketMode2 != null) ? BaseAppendDeleteFileMaintainer.forUnawareAppend(indexHandler, snapshot, partition) : (dvIndexFileMaintainer = BaseAppendDeleteFileMaintainer.forBucketedAppend(indexHandler, snapshot, partition, sdv.bucket()));
                }
                if (dvIndexFileMaintainer == null) {
                    throw new RuntimeException("can't create the dv maintainer.");
                }
                dvIndexFileMaintainer.notifyNewDeletionVector(sdv.dataFileName(), DeletionVector.deserializeFromBytes(sdv.deletionVector()));
            }
            java.util.List<IndexManifestEntry> indexEntries = dvIndexFileMaintainer.persist();
            Tuple2 tuple2 = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(indexEntries).asScala()).partition((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)PaimonSparkWriter.$anonfun$persistDeletionVectors$3(x$7)));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Buffer added = (Buffer)tuple2._1();
            Buffer deleted = (Buffer)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)added, (Object)deleted);
            Buffer added2 = (Buffer)tuple22._1();
            Buffer deleted2 = (Buffer)tuple22._2();
            CommitMessageImpl commitMessage = new CommitMessageImpl(dvIndexFileMaintainer.getPartition(), dvIndexFileMaintainer.getBucket(), null, DataIncrement.emptyIncrement(), CompactIncrement.emptyIncrement(), new IndexIncrement((java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)added2.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.indexFile(), Buffer$.MODULE$.canBuildFrom())).asJava(), (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)deleted2.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.indexFile(), Buffer$.MODULE$.canBuildFrom())).asJava()));
            CommitMessageSerializer serializer = new CommitMessageSerializer();
            return serializer.serialize(commitMessage);
        }, sparkSession.implicits().newByteArrayEncoder());
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])serializedCommits.collect())).map((Function1 & Serializable & scala.Serializable)x$11 -> this.deserializeCommitMessage(this.serializer(), (byte[])x$11), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public void commit(Seq<CommitMessage> commitMessages) {
        try (BatchTableCommit tableCommit = this.writeBuilder().newCommit();){
            try {
                tableCommit.commit((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)commitMessages.toList()).asJava());
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        this.postCommit(commitMessages);
    }

    private RDD<Tuple2<KeyPartOrRow, byte[]>> bootstrapAndRepartitionByKeyHash(Dataset<Row> data, int parallelism, int rowKindColIdx, RowType rowType) {
        int numSparkPartitions = data.rdd().getNumPartitions();
        java.util.List<String> primaryKeys = this.table().schema().primaryKeys();
        RowType bootstrapType = IndexBootstrap.bootstrapType(this.table().schema());
        return RDD$.MODULE$.rddToPairRDDFunctions(data.rdd().mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            int sparkPartitionId = TaskContext$.MODULE$.getPartitionId();
            Projection keyPartProject = CodeGenUtils.newProjection(bootstrapType, primaryKeys);
            Projection rowProject = CodeGenUtils.newProjection(rowType, primaryKeys);
            InternalRowSerializer bootstrapSer = InternalSerializers.create(bootstrapType);
            InternalRowSerializer rowSer = InternalSerializers.create(rowType);
            CloseableIterator<InternalRow> bootstrapIterator = new IndexBootstrap(this.table()).bootstrap(numSparkPartitions, sparkPartitionId).toCloseableIterator();
            TaskContext$.MODULE$.get().addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$12 -> {
                bootstrapIterator.close();
                return BoxedUnit.UNIT;
            });
            return ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(bootstrapIterator).asScala()).map((Function1 & Serializable & scala.Serializable)row -> {
                byte[] bytes = SerializationUtils.serializeBinaryRow(bootstrapSer.toBinaryRow((InternalRow)row));
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)keyPartProject.apply((InternalRow)row).hashCode()), (Object)new Tuple2((Object)KeyPartOrRow.KEY_PART, (Object)bytes));
            }).$plus$plus((Function0 & Serializable & scala.Serializable)() -> iter.map((Function1 & Serializable & scala.Serializable)r -> {
                SparkRow sparkRow = new SparkRow(rowType, (Row)r, SparkRowUtils$.MODULE$.getRowKind((Row)r, rowKindColIdx));
                byte[] bytes = SerializationUtils.serializeBinaryRow(rowSer.toBinaryRow(sparkRow));
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)rowProject.apply(sparkRow).hashCode()), (Object)new Tuple2((Object)KeyPartOrRow.ROW, (Object)bytes));
            }));
        }, data.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).partitionBy((Partitioner)new ModPartitioner(this, parallelism)).map((Function1 & Serializable & scala.Serializable)x$13 -> (Tuple2)x$13._2(), ClassTag$.MODULE$.apply(Tuple2.class));
    }

    private Dataset<Row> repartitionByKeyPartitionHash(SparkSession sparkSession, Dataset<Row> data, int parallelism, int numAssigners) {
        return sparkSession.createDataFrame(RDD$.MODULE$.rddToPairRDDFunctions(data.rdd().mapPartitions((Function1 & Serializable & scala.Serializable)iterator2 -> {
            RowPartitionKeyExtractor rowPartitionKeyExtractor = new RowPartitionKeyExtractor(this.tableSchema());
            return iterator2.map((Function1 & Serializable & scala.Serializable)row -> {
                SparkRow sparkRow = new SparkRow(this.rowType(), (Row)row);
                int partitionHash = rowPartitionKeyExtractor.partition(sparkRow).hashCode();
                int keyHash = rowPartitionKeyExtractor.trimmedPrimaryKey(sparkRow).hashCode();
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)BucketAssigner.computeHashKey(partitionHash, keyHash, parallelism, numAssigners)), row);
            });
        }, data.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Row.class), (Ordering)Ordering.Int$.MODULE$).partitionBy((Partitioner)new ModPartitioner(this, parallelism)).map((Function1 & Serializable & scala.Serializable)x$14 -> (Row)x$14._2(), ClassTag$.MODULE$.apply(Row.class)), data.schema());
    }

    private Dataset<Row> repartitionByPartitionsAndBucket(Dataset<Row> df) {
        StructType inputSchema = df.schema();
        Seq partitionCols = ((SeqLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.tableSchema().partitionKeys()).asScala()).map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToInteger((int)PaimonSparkWriter.$anonfun$repartitionByPartitionsAndBucket$1(this, x$15)), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x -> functions$.MODULE$.col(inputSchema.fieldNames()[BoxesRunTime.unboxToInt((Object)x)]), Buffer$.MODULE$.canBuildFrom())).toSeq();
        return df.repartition((Seq)partitionCols.$plus$plus((GenTraversableOnce)new .colon.colon((Object)functions$.MODULE$.col(SparkSystemColumns$.MODULE$.BUCKET_COL()), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom()));
    }

    private CommitMessage deserializeCommitMessage(CommitMessageSerializer serializer, byte[] bytes) {
        CommitMessage commitMessage;
        try {
            commitMessage = serializer.deserialize(serializer.getVersion(), bytes);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to deserialize CommitMessage's object", e);
        }
        return commitMessage;
    }

    public PaimonSparkWriter copy(FileStoreTable table) {
        return new PaimonSparkWriter(table);
    }

    public FileStoreTable copy$default$1() {
        return this.table();
    }

    public String productPrefix() {
        return "PaimonSparkWriter";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.table();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof PaimonSparkWriter;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof PaimonSparkWriter)) return false;
        boolean bl = true;
        if (!bl) return false;
        PaimonSparkWriter paimonSparkWriter = (PaimonSparkWriter)x$1;
        FileStoreTable fileStoreTable = this.table();
        FileStoreTable fileStoreTable2 = paimonSparkWriter.table();
        if (fileStoreTable == null) {
            if (fileStoreTable2 != null) {
                return false;
            }
        } else if (!fileStoreTable.equals(fileStoreTable2)) return false;
        if (!paimonSparkWriter.canEqual(this)) return false;
        return true;
    }

    private final void ModPartitioner$lzycompute$1() {
        PaimonSparkWriter paimonSparkWriter = this;
        synchronized (paimonSparkWriter) {
            if (this.ModPartitioner$module == null) {
                this.ModPartitioner$module = new PaimonSparkWriter$ModPartitioner$(this);
            }
        }
    }

    private final SparkTableWrite newWrite$1(int rowKindColIdx$1) {
        return new SparkTableWrite(this.writeBuilder(), this.rowType(), rowKindColIdx$1);
    }

    private static final int sparkParallelism$1(SparkSession sparkSession$1) {
        int defaultParallelism = sparkSession$1.sparkContext().defaultParallelism();
        int numShufflePartitions = sparkSession$1.sessionState().conf().numShufflePartitions();
        return Math.max(defaultParallelism, numShufflePartitions);
    }

    private final Dataset writeWithoutBucket$1(Dataset dataFrame, SparkSession sparkSession$1, int rowKindColIdx$1) {
        return dataFrame.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            Iterator<byte[]> iterator2;
            try (SparkTableWrite write = this.newWrite$1(rowKindColIdx$1);){
                iter.foreach((Function1 & Serializable & scala.Serializable)row -> {
                    write.write(row);
                    return BoxedUnit.UNIT;
                });
                iterator2 = write.finish();
            }
            return iterator2;
        }, sparkSession$1.implicits().newByteArrayEncoder());
    }

    private final Dataset writeWithBucket$1(Dataset dataFrame, int bucketColIdx$1, SparkSession sparkSession$1, int rowKindColIdx$1) {
        return dataFrame.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            Iterator<byte[]> iterator2;
            try (SparkTableWrite write = this.newWrite$1(rowKindColIdx$1);){
                iter.foreach((Function1 & Serializable & scala.Serializable)row -> {
                    write.write(row, row.getInt(bucketColIdx$1));
                    return BoxedUnit.UNIT;
                });
                iterator2 = write.finish();
            }
            return iterator2;
        }, sparkSession$1.implicits().newByteArrayEncoder());
    }

    private final Dataset writeWithBucketProcessor$1(Dataset dataFrame, BucketProcessor processor, EncoderSerDeGroup encoderGroupWithBucketCol$1, int bucketColIdx$1, SparkSession sparkSession$1, int rowKindColIdx$1) {
        Dataset<Row> repartitioned = this.repartitionByPartitionsAndBucket((Dataset<Row>)dataFrame.mapPartitions((Function1 & Serializable & scala.Serializable)rowIterator -> processor.processPartition(rowIterator), encoderGroupWithBucketCol$1.encoder()).toDF());
        return this.writeWithBucket$1(repartitioned, bucketColIdx$1, sparkSession$1, rowKindColIdx$1);
    }

    private final Dataset writeWithBucketAssigner$1(Dataset dataFrame, Function0 funcFactory, SparkSession sparkSession$1, int rowKindColIdx$1) {
        return dataFrame.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            Iterator<byte[]> iterator2;
            Function1 assigner = (Function1)funcFactory.apply();
            try (SparkTableWrite write = this.newWrite$1(rowKindColIdx$1);){
                iter.foreach((Function1 & Serializable & scala.Serializable)row -> {
                    write.write(row, BoxesRunTime.unboxToInt((Object)assigner.apply((Object)row)));
                    return BoxedUnit.UNIT;
                });
                iterator2 = write.finish();
            }
            return iterator2;
        }, sparkSession$1.implicits().newByteArrayEncoder());
    }

    public static final /* synthetic */ int $anonfun$write$13(int assignerParallelism$1, Integer initialBuckets) {
        return Math.min(Predef$.MODULE$.Integer2int(initialBuckets), assignerParallelism$1);
    }

    private final Dataset partitionByKey$1(SparkSession sparkSession$1, Dataset withInitBucketCol$1, int assignerParallelism$1, int numAssigners$1) {
        return this.repartitionByKeyPartitionHash(sparkSession$1, (Dataset<Row>)withInitBucketCol$1, assignerParallelism$1, numAssigners$1);
    }

    public static final /* synthetic */ int $anonfun$write$16(PaimonSparkWriter $this, SimpleHashBucketAssigner assigner$2, RowPartitionKeyExtractor extractor$1, Row row) {
        SparkRow sparkRow = new SparkRow($this.rowType(), row);
        return assigner$2.assign(extractor$1.partition(sparkRow), extractor$1.trimmedPrimaryKey(sparkRow).hashCode());
    }

    public static final /* synthetic */ int $anonfun$write$17(PaimonSparkWriter $this, String x$3) {
        return $this.tableSchema().fieldNames().indexOf(x$3);
    }

    public static final /* synthetic */ boolean $anonfun$persistDeletionVectors$3(IndexManifestEntry x$7) {
        FileKind fileKind = x$7.kind();
        FileKind fileKind2 = FileKind.ADD;
        return !(fileKind != null ? !((Object)((Object)fileKind)).equals((Object)fileKind2) : fileKind2 != null);
    }

    public static final /* synthetic */ int $anonfun$repartitionByPartitionsAndBucket$1(PaimonSparkWriter $this, String x$15) {
        return $this.tableSchema().fieldNames().indexOf(x$15);
    }

    public PaimonSparkWriter(FileStoreTable table) {
        this.table = table;
        Logging.$init$((Logging)this);
        WriteHelper.$init$(this);
        Product.$init$((Product)this);
        this.writeBuilder = table.newBatchWriteBuilder();
    }

    private class ModPartitioner
    extends Partitioner
    implements Product {
        private final int partitions;
        public final /* synthetic */ PaimonSparkWriter $outer;

        public int partitions() {
            return this.partitions;
        }

        public int numPartitions() {
            return this.partitions();
        }

        public int getPartition(Object key) {
            return Math.abs(BoxesRunTime.unboxToInt((Object)key) % this.numPartitions());
        }

        public ModPartitioner copy(int partitions) {
            return new ModPartitioner(this.org$apache$paimon$spark$commands$PaimonSparkWriter$ModPartitioner$$$outer(), partitions);
        }

        public int copy$default$1() {
            return this.partitions();
        }

        public String productPrefix() {
            return "ModPartitioner";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this.partitions());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ModPartitioner;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.partitions());
            return Statics.finalizeHash((int)n, (int)1);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ModPartitioner)) return false;
            if (((ModPartitioner)((Object)object)).org$apache$paimon$spark$commands$PaimonSparkWriter$ModPartitioner$$$outer() != this.org$apache$paimon$spark$commands$PaimonSparkWriter$ModPartitioner$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ModPartitioner modPartitioner = (ModPartitioner)((Object)x$1);
            if (this.partitions() != modPartitioner.partitions()) return false;
            if (!modPartitioner.canEqual((Object)this)) return false;
            return true;
        }

        public /* synthetic */ PaimonSparkWriter org$apache$paimon$spark$commands$PaimonSparkWriter$ModPartitioner$$$outer() {
            return this.$outer;
        }

        public ModPartitioner(PaimonSparkWriter $outer, int partitions) {
            this.partitions = partitions;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

