/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.arrow.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.parquet.arrow.schema.List3Levels;
import org.apache.parquet.arrow.schema.SchemaMapping;
import org.apache.parquet.schema.DecimalMetadata;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;

public class SchemaConverter {
    public SchemaMapping fromArrow(Schema arrowSchema) {
        List fields = arrowSchema.getFields();
        List<SchemaMapping.TypeMapping> parquetFields = this.fromArrow(fields);
        MessageType parquetType = (MessageType)this.addToBuilder(parquetFields, (Types.GroupBuilder)Types.buildMessage()).named("root");
        return new SchemaMapping(arrowSchema, parquetType, parquetFields);
    }

    private <T> Types.GroupBuilder<T> addToBuilder(List<SchemaMapping.TypeMapping> parquetFields, Types.GroupBuilder<T> builder) {
        for (SchemaMapping.TypeMapping type : parquetFields) {
            builder = (Types.GroupBuilder)builder.addField(type.getParquetType());
        }
        return builder;
    }

    private List<SchemaMapping.TypeMapping> fromArrow(List<Field> fields) {
        ArrayList<SchemaMapping.TypeMapping> result = new ArrayList<SchemaMapping.TypeMapping>(fields.size());
        for (Field field : fields) {
            result.add(this.fromArrow(field));
        }
        return result;
    }

    private SchemaMapping.TypeMapping fromArrow(Field field) {
        return this.fromArrow(field, field.getName());
    }

    private SchemaMapping.TypeMapping fromArrow(final Field field, final String fieldName) {
        final List children = field.getChildren();
        return (SchemaMapping.TypeMapping)field.getType().accept((ArrowType.ArrowTypeVisitor)new ArrowType.ArrowTypeVisitor<SchemaMapping.TypeMapping>(){

            public SchemaMapping.TypeMapping visit(ArrowType.Null type) {
                return this.primitive(PrimitiveType.PrimitiveTypeName.BINARY);
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Struct_ type) {
                List parquetTypes = SchemaConverter.this.fromArrow(children);
                return new SchemaMapping.StructTypeMapping(field, (GroupType)SchemaConverter.this.addToBuilder(parquetTypes, Types.buildGroup((Type.Repetition)Type.Repetition.OPTIONAL)).named(fieldName), (List<SchemaMapping.TypeMapping>)parquetTypes);
            }

            public SchemaMapping.TypeMapping visit(ArrowType.List type) {
                if (children.size() != 1) {
                    throw new IllegalArgumentException("list fields must have exactly one child: " + field);
                }
                SchemaMapping.TypeMapping parquetChild = SchemaConverter.this.fromArrow((Field)children.get(0), "element");
                GroupType list = (GroupType)Types.optionalList().element(parquetChild.getParquetType()).named(fieldName);
                return new SchemaMapping.ListTypeMapping(field, new List3Levels(list), parquetChild);
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Union type) {
                List parquetTypes = SchemaConverter.this.fromArrow(children);
                return new SchemaMapping.UnionTypeMapping(field, (GroupType)SchemaConverter.this.addToBuilder(parquetTypes, Types.buildGroup((Type.Repetition)Type.Repetition.OPTIONAL)).named(fieldName), (List<SchemaMapping.TypeMapping>)parquetTypes);
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Int type) {
                boolean signed = type.getIsSigned();
                switch (type.getBitWidth()) {
                    case 8: {
                        return this.primitive(PrimitiveType.PrimitiveTypeName.INT32, signed ? OriginalType.INT_8 : OriginalType.UINT_8);
                    }
                    case 16: {
                        return this.primitive(PrimitiveType.PrimitiveTypeName.INT32, signed ? OriginalType.INT_16 : OriginalType.UINT_16);
                    }
                    case 32: {
                        return this.primitive(PrimitiveType.PrimitiveTypeName.INT32, signed ? OriginalType.INT_32 : OriginalType.UINT_32);
                    }
                    case 64: {
                        return this.primitive(PrimitiveType.PrimitiveTypeName.INT64, signed ? OriginalType.INT_64 : OriginalType.UINT_64);
                    }
                }
                throw new IllegalArgumentException("Illegal int type: " + field);
            }

            public SchemaMapping.TypeMapping visit(ArrowType.FloatingPoint type) {
                switch (type.getPrecision()) {
                    case 0: {
                        return this.primitive(PrimitiveType.PrimitiveTypeName.FLOAT);
                    }
                    case 1: {
                        return this.primitive(PrimitiveType.PrimitiveTypeName.FLOAT);
                    }
                    case 2: {
                        return this.primitive(PrimitiveType.PrimitiveTypeName.DOUBLE);
                    }
                }
                throw new IllegalArgumentException("Illegal float type: " + field);
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Utf8 type) {
                return this.primitive(PrimitiveType.PrimitiveTypeName.BINARY, OriginalType.UTF8);
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Binary type) {
                return this.primitive(PrimitiveType.PrimitiveTypeName.BINARY);
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Bool type) {
                return this.primitive(PrimitiveType.PrimitiveTypeName.BOOLEAN);
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Decimal type) {
                int precision = type.getPrecision();
                int scale = type.getScale();
                if (1 <= precision && precision <= 9) {
                    return this.decimal(PrimitiveType.PrimitiveTypeName.INT32, precision, scale);
                }
                if (1 <= precision && precision <= 18) {
                    return this.decimal(PrimitiveType.PrimitiveTypeName.INT64, precision, scale);
                }
                return this.decimal(PrimitiveType.PrimitiveTypeName.BINARY, precision, scale);
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Date type) {
                return this.primitive(PrimitiveType.PrimitiveTypeName.INT32, OriginalType.DATE);
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Time type) {
                return this.primitive(PrimitiveType.PrimitiveTypeName.INT32, OriginalType.TIME_MILLIS);
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Timestamp type) {
                return this.primitive(PrimitiveType.PrimitiveTypeName.INT64, OriginalType.TIMESTAMP_MILLIS);
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Interval type) {
                return this.primitiveFLBA(12, OriginalType.INTERVAL);
            }

            private SchemaMapping.TypeMapping mapping(PrimitiveType parquetType) {
                return new SchemaMapping.PrimitiveTypeMapping(field, parquetType);
            }

            private SchemaMapping.TypeMapping decimal(PrimitiveType.PrimitiveTypeName type, int precision, int scale) {
                return this.mapping((PrimitiveType)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)type).as(OriginalType.DECIMAL)).precision(precision)).scale(scale)).named(fieldName));
            }

            private SchemaMapping.TypeMapping primitive(PrimitiveType.PrimitiveTypeName type) {
                return this.mapping((PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)type).named(fieldName));
            }

            private SchemaMapping.TypeMapping primitive(PrimitiveType.PrimitiveTypeName type, OriginalType otype) {
                return this.mapping((PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)type).as(otype)).named(fieldName));
            }

            private SchemaMapping.TypeMapping primitiveFLBA(int length, OriginalType otype) {
                return this.mapping((PrimitiveType)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(length)).as(otype)).named(fieldName));
            }
        });
    }

    public SchemaMapping fromParquet(MessageType parquetSchema) {
        List fields = parquetSchema.getFields();
        List<SchemaMapping.TypeMapping> mappings = this.fromParquet(fields);
        List<Field> arrowFields = this.fields(mappings);
        return new SchemaMapping(new Schema(arrowFields), parquetSchema, mappings);
    }

    private List<Field> fields(List<SchemaMapping.TypeMapping> mappings) {
        ArrayList<Field> result = new ArrayList<Field>(mappings.size());
        for (SchemaMapping.TypeMapping typeMapping : mappings) {
            result.add(typeMapping.getArrowField());
        }
        return result;
    }

    private List<SchemaMapping.TypeMapping> fromParquet(List<Type> fields) {
        ArrayList<SchemaMapping.TypeMapping> result = new ArrayList<SchemaMapping.TypeMapping>(fields.size());
        for (Type type : fields) {
            result.add(this.fromParquet(type));
        }
        return result;
    }

    private SchemaMapping.TypeMapping fromParquet(Type type) {
        return this.fromParquet(type, type.getName(), type.getRepetition());
    }

    private SchemaMapping.TypeMapping fromParquet(Type type, String name, Type.Repetition repetition) {
        if (repetition == Type.Repetition.REPEATED) {
            SchemaMapping.TypeMapping child = this.fromParquet(type, null, Type.Repetition.REQUIRED);
            Field arrowField = new Field(name, false, (ArrowType)new ArrowType.List(), Arrays.asList(child.getArrowField()));
            return new SchemaMapping.RepeatedTypeMapping(arrowField, type, child);
        }
        if (type.isPrimitive()) {
            return this.fromParquetPrimitive(type.asPrimitiveType(), name);
        }
        return this.fromParquetGroup(type.asGroupType(), name);
    }

    private SchemaMapping.TypeMapping fromParquetGroup(GroupType type, String name) {
        OriginalType ot = type.getOriginalType();
        if (ot == null) {
            List<SchemaMapping.TypeMapping> typeMappings = this.fromParquet(type.getFields());
            Field arrowField = new Field(name, type.isRepetition(Type.Repetition.OPTIONAL), (ArrowType)new ArrowType.Struct_(), this.fields(typeMappings));
            return new SchemaMapping.StructTypeMapping(arrowField, type, typeMappings);
        }
        switch (ot) {
            case LIST: {
                List3Levels list3Levels = new List3Levels(type);
                SchemaMapping.TypeMapping child = this.fromParquet(list3Levels.getElement(), null, list3Levels.getElement().getRepetition());
                Field arrowField = new Field(name, type.isRepetition(Type.Repetition.OPTIONAL), (ArrowType)new ArrowType.List(), Arrays.asList(child.getArrowField()));
                return new SchemaMapping.ListTypeMapping(arrowField, list3Levels, child);
            }
        }
        throw new UnsupportedOperationException("Unsupported type " + type);
    }

    private SchemaMapping.TypeMapping fromParquetPrimitive(final PrimitiveType type, final String name) {
        return (SchemaMapping.TypeMapping)type.getPrimitiveTypeName().convert((PrimitiveType.PrimitiveTypeNameConverter)new PrimitiveType.PrimitiveTypeNameConverter<SchemaMapping.TypeMapping, RuntimeException>(){

            private SchemaMapping.TypeMapping field(ArrowType arrowType) {
                Field field = new Field(name, type.isRepetition(Type.Repetition.OPTIONAL), arrowType, null);
                return new SchemaMapping.PrimitiveTypeMapping(field, type);
            }

            public SchemaMapping.TypeMapping convertFLOAT(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws RuntimeException {
                return this.field((ArrowType)new ArrowType.FloatingPoint(1));
            }

            public SchemaMapping.TypeMapping convertDOUBLE(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws RuntimeException {
                return this.field((ArrowType)new ArrowType.FloatingPoint(2));
            }

            public SchemaMapping.TypeMapping convertINT32(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws RuntimeException {
                OriginalType ot = type.getOriginalType();
                if (ot == null) {
                    return this.integer(32, true);
                }
                switch (ot) {
                    case INT_8: {
                        return this.integer(8, true);
                    }
                    case INT_16: {
                        return this.integer(16, true);
                    }
                    case INT_32: {
                        return this.integer(32, true);
                    }
                    case UINT_8: {
                        return this.integer(8, false);
                    }
                    case UINT_16: {
                        return this.integer(16, false);
                    }
                    case UINT_32: {
                        return this.integer(32, false);
                    }
                    case DECIMAL: {
                        return this.decimal(type.getDecimalMetadata());
                    }
                    case DATE: {
                        return this.field((ArrowType)new ArrowType.Date());
                    }
                    case TIMESTAMP_MICROS: {
                        return this.field((ArrowType)new ArrowType.Timestamp(2));
                    }
                    case TIMESTAMP_MILLIS: {
                        return this.field((ArrowType)new ArrowType.Timestamp(1));
                    }
                    case TIME_MILLIS: {
                        return this.field((ArrowType)new ArrowType.Time());
                    }
                }
                throw new IllegalArgumentException("illegal type " + type);
            }

            public SchemaMapping.TypeMapping convertINT64(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws RuntimeException {
                OriginalType ot = type.getOriginalType();
                if (ot == null) {
                    return this.integer(64, true);
                }
                switch (ot) {
                    case INT_8: {
                        return this.integer(8, true);
                    }
                    case INT_16: {
                        return this.integer(16, true);
                    }
                    case INT_32: {
                        return this.integer(32, true);
                    }
                    case INT_64: {
                        return this.integer(64, true);
                    }
                    case UINT_8: {
                        return this.integer(8, false);
                    }
                    case UINT_16: {
                        return this.integer(16, false);
                    }
                    case UINT_32: {
                        return this.integer(32, false);
                    }
                    case UINT_64: {
                        return this.integer(64, false);
                    }
                    case DECIMAL: {
                        return this.decimal(type.getDecimalMetadata());
                    }
                    case DATE: {
                        return this.field((ArrowType)new ArrowType.Date());
                    }
                    case TIMESTAMP_MICROS: {
                        return this.field((ArrowType)new ArrowType.Timestamp(2));
                    }
                    case TIMESTAMP_MILLIS: {
                        return this.field((ArrowType)new ArrowType.Timestamp(1));
                    }
                    case TIME_MILLIS: {
                        return this.field((ArrowType)new ArrowType.Time());
                    }
                }
                throw new IllegalArgumentException("illegal type " + type);
            }

            public SchemaMapping.TypeMapping convertINT96(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws RuntimeException {
                return this.field((ArrowType)new ArrowType.Binary());
            }

            public SchemaMapping.TypeMapping convertFIXED_LEN_BYTE_ARRAY(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws RuntimeException {
                return this.field((ArrowType)new ArrowType.Binary());
            }

            public SchemaMapping.TypeMapping convertBOOLEAN(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws RuntimeException {
                return this.field((ArrowType)new ArrowType.Bool());
            }

            public SchemaMapping.TypeMapping convertBINARY(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws RuntimeException {
                OriginalType ot = type.getOriginalType();
                if (ot == null) {
                    return this.field((ArrowType)new ArrowType.Binary());
                }
                switch (ot) {
                    case UTF8: {
                        return this.field((ArrowType)new ArrowType.Utf8());
                    }
                    case DECIMAL: {
                        return this.decimal(type.getDecimalMetadata());
                    }
                }
                throw new IllegalArgumentException("illegal type " + type);
            }

            private SchemaMapping.TypeMapping decimal(DecimalMetadata decimalMetadata) {
                return this.field((ArrowType)new ArrowType.Decimal(decimalMetadata.getPrecision(), decimalMetadata.getScale()));
            }

            private SchemaMapping.TypeMapping integer(int width, boolean signed) {
                return this.field((ArrowType)new ArrowType.Int(width, signed));
            }
        });
    }

    public SchemaMapping map(Schema arrowSchema, MessageType parquetSchema) {
        List<SchemaMapping.TypeMapping> children = this.map(arrowSchema.getFields(), parquetSchema.getFields());
        return new SchemaMapping(arrowSchema, parquetSchema, children);
    }

    private List<SchemaMapping.TypeMapping> map(List<Field> arrowFields, List<Type> parquetFields) {
        if (arrowFields.size() != parquetFields.size()) {
            throw new IllegalArgumentException("Can not map schemas as sizes differ: " + arrowFields + " != " + parquetFields);
        }
        ArrayList<SchemaMapping.TypeMapping> result = new ArrayList<SchemaMapping.TypeMapping>(arrowFields.size());
        for (int i = 0; i < arrowFields.size(); ++i) {
            Field arrowField = arrowFields.get(i);
            Type parquetField = parquetFields.get(i);
            result.add(this.map(arrowField, parquetField));
        }
        return result;
    }

    private SchemaMapping.TypeMapping map(final Field arrowField, final Type parquetField) {
        return (SchemaMapping.TypeMapping)arrowField.getType().accept((ArrowType.ArrowTypeVisitor)new ArrowType.ArrowTypeVisitor<SchemaMapping.TypeMapping>(){

            public SchemaMapping.TypeMapping visit(ArrowType.Null type) {
                if (!parquetField.isRepetition(Type.Repetition.OPTIONAL)) {
                    throw new IllegalArgumentException("Parquet type can't be null: " + parquetField);
                }
                return this.primitive();
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Struct_ type) {
                if (parquetField.isPrimitive()) {
                    throw new IllegalArgumentException("Parquet type not a group: " + parquetField);
                }
                GroupType groupType = parquetField.asGroupType();
                return new SchemaMapping.StructTypeMapping(arrowField, groupType, (List<SchemaMapping.TypeMapping>)SchemaConverter.this.map(arrowField.getChildren(), groupType.getFields()));
            }

            public SchemaMapping.TypeMapping visit(ArrowType.List type) {
                if (arrowField.getChildren().size() != 1) {
                    throw new IllegalArgumentException("Invalid list type: " + type);
                }
                Field arrowChild = (Field)arrowField.getChildren().get(0);
                if (parquetField.isRepetition(Type.Repetition.REPEATED)) {
                    return new SchemaMapping.RepeatedTypeMapping(arrowField, parquetField, SchemaConverter.this.map(arrowChild, parquetField));
                }
                if (parquetField.isPrimitive()) {
                    throw new IllegalArgumentException("Parquet type not a group: " + parquetField);
                }
                List3Levels list3Levels = new List3Levels(parquetField.asGroupType());
                if (arrowField.getChildren().size() != 1) {
                    throw new IllegalArgumentException("invalid arrow list: " + arrowField);
                }
                return new SchemaMapping.ListTypeMapping(arrowField, list3Levels, SchemaConverter.this.map(arrowChild, list3Levels.getElement()));
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Union type) {
                if (parquetField.isPrimitive()) {
                    throw new IllegalArgumentException("Parquet type not a group: " + parquetField);
                }
                GroupType groupType = parquetField.asGroupType();
                return new SchemaMapping.UnionTypeMapping(arrowField, groupType, (List<SchemaMapping.TypeMapping>)SchemaConverter.this.map(arrowField.getChildren(), groupType.getFields()));
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Int type) {
                return this.primitive();
            }

            public SchemaMapping.TypeMapping visit(ArrowType.FloatingPoint type) {
                return this.primitive();
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Utf8 type) {
                return this.primitive();
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Binary type) {
                return this.primitive();
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Bool type) {
                return this.primitive();
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Decimal type) {
                return this.primitive();
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Date type) {
                return this.primitive();
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Time type) {
                return this.primitive();
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Timestamp type) {
                return this.primitive();
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Interval type) {
                return this.primitive();
            }

            private SchemaMapping.TypeMapping primitive() {
                if (!parquetField.isPrimitive()) {
                    throw new IllegalArgumentException("Can not map schemas as one is primitive and the other is not: " + arrowField + " != " + parquetField);
                }
                return new SchemaMapping.PrimitiveTypeMapping(arrowField, parquetField.asPrimitiveType());
            }
        });
    }
}

